/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle.fs;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import ru.m210projects.Build.filehandle.Cache;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;

public class FileEntry
implements Entry {
    public static final Path DUMMY_PATH = Paths.get(Arrays.toString(new String[0]), new String[0]);
    private final Path path;
    private final String name;
    private final String extension;
    private final boolean isDirectory;
    private final long size;
    private Group parent;
    protected Directory physicalDirectory;

    public FileEntry(Path path) throws IOException {
        this(path, path.getFileName().toString(), Files.size(path));
    }

    public FileEntry(Path path, String name, long size) {
        this.path = path;
        this.name = name;
        this.extension = name.contains(".") ? name.substring(name.lastIndexOf(".") + 1).toUpperCase() : "";
        this.isDirectory = Files.isDirectory(path, new LinkOption[0]);
        this.size = size;
    }

    protected FileEntry(FileEntry entry) {
        this.path = entry.path;
        this.name = entry.name;
        this.extension = entry.extension;
        this.isDirectory = entry.isDirectory;
        this.size = entry.size;
        this.parent = entry.parent;
        this.physicalDirectory = entry.physicalDirectory;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    public Directory getDirectory() {
        if (this.physicalDirectory == null) {
            return Directory.DUMMY_DIRECTORY;
        }
        return this.physicalDirectory.getDirectory(this);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.path.toFile()));
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean exists() {
        try {
            if (this.isDirectory) {
                return true;
            }
            return Files.exists(this.path, new LinkOption[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Directory getParent() {
        if (this.parent instanceof Directory) {
            return (Directory)this.parent;
        }
        return this.physicalDirectory;
    }

    @Override
    public void setParent(Group parent) {
        if (parent == null || parent.equals(Directory.DUMMY_DIRECTORY)) {
            parent = this.physicalDirectory;
        }
        this.parent = parent;
        if (this.physicalDirectory == null && parent instanceof Directory && ((Directory)parent).getPath().equals(this.path.getParent())) {
            this.physicalDirectory = (Directory)parent;
        }
    }

    public boolean delete() {
        try {
            if (Files.deleteIfExists(this.path)) {
                this.physicalDirectory.entries.remove(this.getName().toUpperCase());
                return true;
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Path getRelativePath() {
        try {
            return Cache.getInstance().getGameDirectory().getPath().relativize(this.path);
        }
        catch (Exception e) {
            return this.path;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileEntry)) {
            return false;
        }
        FileEntry fileEntry = (FileEntry)o;
        return this.isDirectory == fileEntry.isDirectory && this.size == fileEntry.size && Objects.equals(this.path, fileEntry.path) && Objects.equals(this.name, fileEntry.name) && Objects.equals(this.extension, fileEntry.extension);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.name, this.extension, this.size, this.isDirectory);
    }

    public String toString() {
        if (this.isDirectory()) {
            return this.name;
        }
        return String.format("%s size=%d", this.name, this.size);
    }
}

