/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle.rff;

import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.EntryInputStream;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.InputStreamProvider;
import ru.m210projects.Build.filehandle.rff.RffInputStream;

public class RffEntry
implements Entry {
    private final InputStreamProvider provider;
    private final int id;
    private final int offset;
    private final int size;
    private final int packedSize;
    private final LocalDateTime date;
    private final int flags;
    private final String name;
    private final String fmt;
    Group parent;

    public RffEntry(InputStreamProvider provider, int id, int offset, int size, int packedSize, LocalDateTime date, int flags, String name, String fmt) {
        this.provider = provider;
        this.id = id;
        this.offset = offset;
        this.size = size;
        this.packedSize = packedSize;
        this.date = date;
        if (id != 0 && !DictFlags.ID.checkBit(flags)) {
            flags |= DictFlags.ID.getBit();
        }
        this.flags = flags;
        this.name = String.format("%s.%s", name.trim(), fmt).toUpperCase();
        this.fmt = fmt.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        EntryInputStream in;
        RffEntry rffEntry = this;
        synchronized (rffEntry) {
            in = new EntryInputStream(RffInputStream.getInputStream(this.provider, this.isEncrypted(), this.offset, 0, 256), this.size);
        }
        return in;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public Group getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Group parent) {
        this.parent = parent;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExtension() {
        return this.fmt;
    }

    public int getId() {
        return this.id;
    }

    public boolean isEncrypted() {
        return (this.flags & DictFlags.ENCRYPTED.getBit()) != 0;
    }

    public boolean isIDUsed() {
        return (this.flags & DictFlags.ID.getBit()) != 0;
    }

    public int getPackedSize() {
        return this.packedSize;
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    int getFlags() {
        return this.flags;
    }

    public String toString() {
        return String.format("%s id=%d, size=%d", this.name, this.id, this.size);
    }

    protected static enum DictFlags {
        ID(1),
        EXTERNAL(2),
        PRELOAD(4),
        PRELOCK(8),
        ENCRYPTED(16);

        private final int bit;

        private DictFlags(int bit) {
            this.bit = bit;
        }

        public int getBit() {
            return this.bit;
        }

        public boolean checkBit(int flags) {
            return (flags & this.bit) != 0;
        }
    }
}

