/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle.rff;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.InputStreamProvider;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.rff.RffEntry;
import ru.m210projects.Build.filehandle.rff.RffInputStream;

public class RffFile
implements Group {
    private static final String RFF_HEADER = "RFF\u001a";
    protected final List<Entry> entryList;
    protected final String name;
    protected final Map<String, Map<String, Integer>> names;
    protected final Map<String, Map<Integer, Integer>> ids;

    public RffFile(String name) {
        this.name = name;
        this.entryList = new ArrayList<Entry>();
        this.names = new HashMap<String, Map<String, Integer>>();
        this.ids = new HashMap<String, Map<Integer, Integer>>();
    }

    public RffFile(String name, InputStreamProvider provider) throws IOException {
        int numFiles;
        long offFat;
        int revision;
        this.name = name;
        try (InputStream is = provider.newInputStream();){
            String header = StreamUtils.readString(is, 4);
            if (header.compareTo(RFF_HEADER) != 0) {
                throw new RuntimeException("RFF header corrupted");
            }
            revision = StreamUtils.readInt(is);
            offFat = StreamUtils.readInt(is);
            numFiles = StreamUtils.readInt(is);
            this.entryList = new ArrayList<Entry>(numFiles);
            this.names = new HashMap<String, Map<String, Integer>>();
            this.ids = new HashMap<String, Map<Integer, Integer>>();
        }
        if (numFiles != 0) {
            int key = this.getCryptoKey(revision, offFat);
            try (InputStream is = RffInputStream.getInputStream(provider, key != -1, offFat, key, numFiles * 48);){
                for (int i = 0; i < numFiles; ++i) {
                    long skipped = is.skip(16L);
                    if (skipped != 16L) {
                        throw new EOFException();
                    }
                    int offset = StreamUtils.readInt(is);
                    int size = StreamUtils.readInt(is);
                    int packedSize = StreamUtils.readInt(is);
                    LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli((long)StreamUtils.readInt(is) * 1000L), ZoneId.of("GMT"));
                    byte flags = StreamUtils.readByte(is);
                    String fmt = StreamUtils.readString(is, 3);
                    String filaName = StreamUtils.readString(is, 8);
                    int id = StreamUtils.readInt(is);
                    RffEntry entry = new RffEntry(provider, id, offset, size, packedSize, date, flags, filaName, fmt);
                    this.addEntry(entry);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("RFF dictionary corrupted");
            }
        }
    }

    @Override
    public synchronized int getSize() {
        return this.entryList.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Entry getEntry(String name) {
        if (name.contains(".")) {
            String[] split = name.split("\\.");
            return this.getEntry(name, split[1]);
        }
        return this.getEntry(name, "");
    }

    @Override
    public synchronized List<Entry> getEntries() {
        return new ArrayList<Entry>(this.entryList);
    }

    public synchronized Entry getEntry(String name, String fmt) {
        int entryIndex;
        Map<String, Integer> entryMap = this.names.get(fmt.toUpperCase());
        if (entryMap != null && (entryIndex = entryMap.getOrDefault(name.toUpperCase(), -1).intValue()) != -1) {
            return this.entryList.get(entryIndex);
        }
        return Directory.DUMMY_ENTRY;
    }

    public synchronized Entry getEntry(int id, String fmt) {
        Integer entryIndex;
        Map<Integer, Integer> entryMap = this.ids.get(fmt.toUpperCase());
        if (entryMap != null && (entryIndex = entryMap.getOrDefault(id, -1)) != -1) {
            return this.entryList.get(entryIndex);
        }
        return Directory.DUMMY_ENTRY;
    }

    public void addEntry(RffEntry entry) {
        Map entryMap;
        String fmt = entry.getExtension();
        entry.parent = this;
        this.entryList.add(entry);
        int entryIndex = this.entryList.size() - 1;
        if (entry.isIDUsed()) {
            entryMap = this.ids.computeIfAbsent(fmt, e -> new HashMap());
            entryMap.put(entry.getId(), entryIndex);
        }
        entryMap = this.names.computeIfAbsent(fmt, e -> new HashMap());
        entryMap.put(entry.getName(), entryIndex);
    }

    private int getCryptoKey(int revision, long offset) {
        int key;
        if ((revision & 0xFFFF) == 768) {
            key = (int)offset;
        } else if ((revision & 0xFFFF) == 769) {
            key = (int)(offset + offset * (long)(revision & 0xFF));
        } else {
            if (revision == 378470704) {
                throw new RuntimeException("RFF alpha version is not supported!");
            }
            throw new RuntimeException(String.format("Unknown RFF version: 0x%x", revision));
        }
        return key;
    }

    public boolean save(Path savePath, int revision) {
        boolean bl;
        block20: {
            OutputStream os = Files.newOutputStream(savePath, new OpenOption[0]);
            try {
                List<Entry> files = this.entryList;
                int offFat = 32;
                int numFiles = this.getSize();
                for (Entry entry : files) {
                    offFat += (int)entry.getSize();
                }
                os.write(RFF_HEADER.getBytes(StandardCharsets.UTF_8));
                os.write(26);
                StreamUtils.writeInt(os, revision);
                StreamUtils.writeInt(os, offFat);
                StreamUtils.writeInt(os, numFiles);
                byte[] dictionary = new byte[48 * numFiles];
                ByteBuffer dictionaryBuffer = ByteBuffer.wrap(dictionary).order(ByteOrder.LITTLE_ENDIAN);
                byte[] tmpBuf = new byte[8192];
                os.write(tmpBuf, 0, 16);
                int entryOffset = 32;
                ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(0);
                for (Entry entry : files) {
                    RffEntry rffEntry = (RffEntry)entry;
                    Arrays.fill(tmpBuf, 0, 16, (byte)0);
                    dictionaryBuffer.put(tmpBuf, 0, 16);
                    dictionaryBuffer.putInt(entryOffset);
                    dictionaryBuffer.putInt((int)entry.getSize());
                    dictionaryBuffer.putInt(rffEntry.getPackedSize());
                    dictionaryBuffer.putInt((int)rffEntry.getDate().toEpochSecond(zoneOffset));
                    dictionaryBuffer.put((byte)rffEntry.getFlags());
                    dictionaryBuffer.put(entry.getExtension().getBytes(StandardCharsets.UTF_8));
                    byte[] name = entry.getName().getBytes(StandardCharsets.UTF_8);
                    System.arraycopy(name, 0, tmpBuf, 0, name.length);
                    dictionaryBuffer.put(tmpBuf, 0, 8);
                    dictionaryBuffer.putInt(rffEntry.getId());
                    entryOffset += (int)entry.getSize();
                    InputStream is = entry.getInputStream();
                    try {
                        boolean encrypted = rffEntry.isEncrypted();
                        while (is.available() != 0) {
                            int len = is.read(tmpBuf);
                            if (encrypted) {
                                for (int i = 0; i < 256; ++i) {
                                    int n = i;
                                    tmpBuf[n] = (byte)(tmpBuf[n] ^ (byte)(i >> 1));
                                }
                                encrypted = false;
                            }
                            os.write(tmpBuf, 0, len);
                        }
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                int key = this.getCryptoKey(revision, offFat);
                if (key != -1) {
                    int i = 0;
                    while (i < dictionary.length) {
                        int n = i++;
                        dictionary[n] = (byte)(dictionary[n] ^ (byte)(key++ >> 1));
                    }
                }
                os.write(dictionary);
                bl = true;
                if (os == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            os.close();
        }
        return bl;
    }
}

