/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle.rff;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.filehandle.InputStreamProvider;

public class RffInputStream
extends BufferedInputStream {
    private long cryptKey;
    private final int cryptLength;
    private int pos = 0;

    public RffInputStream(InputStream is, long cryptKey, int cryptLength) {
        super(is);
        this.cryptKey = cryptKey;
        this.cryptLength = cryptLength;
    }

    @Override
    public synchronized int read() throws IOException {
        int data = super.read();
        if (data != -1) {
            if (this.pos < this.cryptLength) {
                data ^= (int)(this.cryptKey++ >> 1);
            }
            ++this.pos;
            return data & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte @NotNull [] b, int off, int len) throws IOException {
        int n;
        if (b == null) {
            RffInputStream.$$$reportNull$$$0(0);
        }
        if ((n = super.read(b, off, len)) != -1) {
            if (this.pos < this.cryptLength) {
                this.encrypt(b, off, Math.min(this.cryptLength - this.pos, n));
            }
            this.pos += n;
        }
        return n;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long len;
        long result = 0L;
        do {
            len = super.skip(n);
            this.pos += (int)len;
            this.cryptKey += len;
            result += len;
        } while ((n -= len) > 0L);
        return result;
    }

    @Override
    public synchronized int read(byte @NotNull [] b) throws IOException {
        if (b == null) {
            RffInputStream.$$$reportNull$$$0(1);
        }
        return this.read(b, 0, b.length);
    }

    private void encrypt(byte[] buffer, int offs, int size) {
        for (int i = 0; i < size; ++i) {
            int n = offs + i;
            buffer[n] = (byte)(buffer[n] ^ (byte)(this.cryptKey++ >> 1));
        }
    }

    static InputStream getInputStream(InputStreamProvider provider, boolean encrypted, long pos, int cryptKey, int cryptLength) throws IOException {
        InputStream is = provider.newInputStream();
        if (is.skip(pos) != pos) {
            throw new EOFException();
        }
        if (encrypted) {
            return new RffInputStream(is, cryptKey, cryptLength);
        }
        return is;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "ru/m210projects/Build/filehandle/rff/RffInputStream", "read"));
    }
}

