/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import ru.m210projects.Build.net.ISocket;

public class UDPSocket
implements ISocket {
    public DatagramChannel sock;
    public int port;
    private final ByteBuffer buf = ByteBuffer.allocate(256);

    public UDPSocket(int port) throws IOException {
        this.sock = DatagramChannel.open();
        this.sock.configureBlocking(false);
        this.sock.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)256);
        this.sock.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)256);
        this.port = port;
    }

    @Override
    public InetSocketAddress recvfrom(byte[] dabuf, int bufsiz) {
        try {
            this.buf.clear();
            InetSocketAddress recieve = (InetSocketAddress)this.sock.receive(this.buf);
            if (recieve != null) {
                this.buf.rewind();
                this.buf.get(dabuf, 0, bufsiz);
                return recieve;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void sendto(Object address, byte[] dabuf, int bufsiz) {
        this.buf.clear();
        this.buf.put(dabuf, 0, bufsiz);
        this.buf.flip();
        try {
            this.sock.send(this.buf, (InetSocketAddress)address);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dispose() {
        try {
            this.sock.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

