/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.osd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.m210projects.Build.osd.commands.OsdCommand;

public class CommandFinder {
    private int osdTabCommandIndex;
    private List<String> osdTabCommandList;
    private final Map<String, OsdCommand> osdVars;

    public CommandFinder(Map<String, OsdCommand> osdVars) {
        this.osdVars = osdVars;
    }

    public void reset() {
        this.osdTabCommandList = null;
    }

    public String getNextTabCommand() {
        String msg = this.osdTabCommandList.get(this.osdTabCommandIndex++);
        if (this.osdTabCommandIndex >= this.osdTabCommandList.size()) {
            this.osdTabCommandIndex = 0;
        }
        return msg;
    }

    public boolean isListPresent() {
        return this.osdTabCommandList != null;
    }

    public List<String> getCommands(String inputText) {
        if (inputText.isEmpty()) {
            return new ArrayList<String>(1);
        }
        List<String> commands = this.osdVars.keySet().stream().filter(e -> e.startsWith(inputText)).sorted().collect(Collectors.toList());
        if (commands.size() > 1) {
            this.osdTabCommandList = commands;
            this.osdTabCommandIndex = 0;
        }
        return commands;
    }
}

