/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.osd;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ConsoleLogger {
    private final OutputStream out;
    private final Path path;
    private boolean closed;

    public ConsoleLogger(Path path) throws IOException {
        this.path = path;
        this.out = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));
        this.closed = false;
    }

    public void write(String message) {
        if (this.closed) {
            return;
        }
        try {
            this.out.write(String.format("%s\r\n", message).getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (InputStream is = Files.newInputStream(this.path, new OpenOption[0]);){
            byte[] data = new byte[is.available()];
            int len = is.read(data);
            if (len <= 0) return "Can't read the log file";
            String string = new String(data);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "Can't read the log file";
    }

    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.out.close();
            this.closed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

