/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.osd;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.OsdFunc;
import ru.m210projects.Build.osd.OsdString;

public class DefaultOsdFunc
implements OsdFunc {
    protected final Renderer renderer;
    protected final char[] charbuf = new char[1];
    protected int BGTILE = -1;
    protected int BGCTILE = -1;
    protected int PALETTE;
    protected int BORDTILE = -1;
    protected int BITSTH = 57;
    protected int BITSTL = 25;
    protected int BITS = 88;
    protected int BORDERANG = 0;
    protected int SHADE = 50;
    protected final Font font;

    public DefaultOsdFunc(Renderer renderer) {
        this.renderer = renderer;
        this.font = this.getFont();
    }

    protected Font getFont() {
        return new Font();
    }

    protected int calcStartX(int x, int scale) {
        return Pragmas.mulscale(((long)x << 3) + 4L, scale, 16);
    }

    protected int calcStartY(int y) {
        return y * this.font.getSize();
    }

    @Override
    public void drawchar(int x, int y, char ch, int shade, OsdColor color, int scale) {
        x = this.calcStartX(x, scale);
        y = Pragmas.mulscale(this.calcStartY(y), scale, 16);
        this.charbuf[0] = ch;
        this.font.drawText(this.renderer, x, y, this.charbuf, (float)scale / 65536.0f, shade, color.getPal(), TextAlign.Left, Transparent.None, false);
    }

    @Override
    public int drawosdstr(int x, int y, OsdString text, int len, int shade, OsdColor color, int scale) {
        char symb;
        if (text == null || text.getLength() == 0) {
            return 1;
        }
        int chpos = 0;
        int xpos = x;
        int totalRows = text.getLength() / len + 1;
        int row = totalRows - 1;
        int textX = this.calcStartX(x, scale);
        int textY = this.calcStartY(y - row);
        while (chpos < text.getLength() && (symb = text.getCharAt(chpos)) != '\u0000') {
            if (xpos == len) {
                xpos = x;
                textX = this.calcStartX(x, scale);
                textY = this.calcStartY(y - --row);
            }
            this.charbuf[0] = symb;
            int symbWidth = this.font.drawText(this.renderer, textX, Pragmas.mulscale(textY, scale, 16), this.charbuf, (float)scale / 65536.0f, text.getShade(chpos), text.getPal(chpos), TextAlign.Left, Transparent.None, false);
            textX += Pragmas.mulscale(symbWidth, scale, 16);
            ++chpos;
            ++xpos;
        }
        return totalRows;
    }

    @Override
    public void drawstr(int x, int y, String text, int shade, OsdColor color, int scale) {
        this.font.drawText(this.renderer, this.renderer.getWidth() - 4, Pragmas.mulscale(this.calcStartY(y), scale, 16), Strhandler.toCharArray(text), (float)scale / 65536.0f, shade, color.getPal(), TextAlign.Right, Transparent.None, false);
    }

    @Override
    public void drawcursor(int x, int y, boolean overType, int scale) {
        if ((System.currentTimeMillis() & 0x400L) == 0L) {
            int ch = 95;
            if (overType) {
                ch = 35;
            }
            this.charbuf[0] = ch;
            this.font.drawText(this.renderer, this.calcStartX(x, scale), Pragmas.mulscale(this.calcStartY(y), scale, 16), this.charbuf, (float)scale / 65536.0f, 0, OsdColor.DEFAULT.getPal(), TextAlign.Left, Transparent.None, false);
        }
    }

    @Override
    public void drawlogo(int daydim) {
        ArtEntry pic;
        if (this.BGCTILE != -1 && (pic = this.renderer.getTile(this.BGCTILE)) != null) {
            int xsiz = pic.getWidth();
            int ysiz = pic.getHeight();
            if (pic.hasSize()) {
                this.renderer.rotatesprite(this.renderer.getWidth() - xsiz << 15, daydim - ysiz << 16, 65536, 0, this.BGCTILE, this.SHADE - 32, this.PALETTE, this.BITSTL, 0, 0, this.renderer.getWidth(), daydim);
            }
        }
    }

    @Override
    public void clearbg(int col, int row) {
        int x;
        int bits = this.BITSTH;
        int daydim = row * this.font.getSize() + 5;
        ArtEntry pic = this.renderer.getTile(this.BGTILE);
        int xsiz = pic.getWidth();
        int ysiz = pic.getHeight();
        if (!pic.hasSize()) {
            return;
        }
        int tx2 = this.renderer.getWidth() / xsiz;
        int ty2 = daydim / ysiz;
        for (x = tx2; x >= 0; --x) {
            for (int y = ty2; y >= 0; --y) {
                this.renderer.rotatesprite(x * xsiz << 16, y * ysiz << 16, 65536, 0, this.BGTILE, this.SHADE, this.PALETTE, bits, 0, 0, this.renderer.getWidth(), daydim);
            }
        }
        this.drawlogo(daydim);
        if (this.BORDTILE != -1 && (pic = this.renderer.getTile(this.BORDTILE)).hasSize() && (xsiz = pic.getHeight()) > 0) {
            for (x = tx2 = this.renderer.getWidth() / xsiz; x >= 0; --x) {
                this.renderer.rotatesprite(x * xsiz << 16, daydim - 1 << 16, 65536, this.BORDERANG, this.BORDTILE, this.SHADE + 12, this.PALETTE, this.BITS, 0, 0, this.renderer.getWidth(), daydim + 1);
            }
        }
    }

    @Override
    public int getPulseShade(int speed) {
        return EngineUtils.sin((int)((long)speed * System.currentTimeMillis() >> 1)) >> 11;
    }

    @Override
    public void showOsd(boolean isFullscreen) {
    }

    @Override
    public int getcolumnwidth(int osdtextscale) {
        return Pragmas.divscale(this.renderer.getWidth(), osdtextscale, 16) / this.font.getCharInfo(' ').getCellSize() - 3;
    }

    @Override
    public int getrowheight(int osdtextscale) {
        return Pragmas.divscale(this.renderer.getHeight(), osdtextscale, 16) / this.font.getSize();
    }

    @Override
    public boolean textHandler(String text) {
        return false;
    }
}

