/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.osd;

import com.badlogic.gdx.Gdx;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.ConsoleHistory;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.commands.OsdValueRange;

public class OsdCommandPrompt
implements InputListener {
    protected final ConsoleHistory inputHistory;
    private final StringBuilder osdEditBuf;
    protected String osdVersionText;
    protected int osdVersionShade;
    protected OsdColor osdVersionPal = OsdColor.DEFAULT;
    protected OsdColor osdPromptPal = OsdColor.DEFAULT;
    protected int osdPromptShade;
    protected OsdColor osdEditPal = OsdColor.DEFAULT;
    protected int osdEditShade;
    protected int osdEditCursor = 0;
    private boolean osdCaptureInput = false;
    private boolean osdShift = false;
    private boolean osdCtrl = false;
    private boolean osdCapsLock = false;
    private boolean osdOverType = false;
    protected ActionListener actionListener;

    public OsdCommandPrompt(int editLength, int historyDepth) {
        this.inputHistory = new ConsoleHistory(historyDepth);
        this.osdEditBuf = new StringBuilder(editLength);
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    protected void registerDefaultCommands(Console parent) {
        parent.registerCommand(new OsdValueRange("osdpromptshade", "osdpromptshade: sets the shade of the OSD prompt", 0.0f, 7.0f){

            @Override
            public float getValue() {
                return OsdCommandPrompt.this.osdPromptShade;
            }

            @Override
            protected void setCheckedValue(float value) {
                OsdCommandPrompt.this.osdPromptShade = (int)value;
            }
        });
        parent.registerCommand(new OsdValueRange("osdpromptpal", "osdpromptpal: sets the palette of the OSD prompt", 0.0f, 255.0f){

            @Override
            public float getValue() {
                return OsdCommandPrompt.this.osdPromptPal.getPal();
            }

            @Override
            protected void setCheckedValue(float value) {
                OsdCommandPrompt.this.osdPromptPal = OsdColor.findColor((int)value);
            }
        });
        parent.registerCommand(new OsdValueRange("osdeditshade", "osdeditshade: sets the shade of the OSD input text", 0.0f, 7.0f){

            @Override
            public float getValue() {
                return OsdCommandPrompt.this.osdEditShade;
            }

            @Override
            protected void setCheckedValue(float value) {
                OsdCommandPrompt.this.osdEditShade = (int)value;
            }
        });
        parent.registerCommand(new OsdValueRange("osdeditpal", "osdeditpal: sets the palette of the OSD input text", 0.0f, 255.0f){

            @Override
            public float getValue() {
                return OsdCommandPrompt.this.osdEditPal.getPal();
            }

            @Override
            protected void setCheckedValue(float value) {
                OsdCommandPrompt.this.osdEditPal = OsdColor.findColor((int)value);
            }
        });
    }

    public void setCaptureInput(boolean capture) {
        this.osdCaptureInput = capture;
    }

    public void onFirstPosition() {
        this.osdEditCursor = 0;
    }

    public void onLastPosition() {
        this.osdEditCursor = this.osdEditBuf.length();
    }

    public void setVersion(String version, OsdColor pal, int shade) {
        this.osdVersionText = version + " (BuildGdx: " + "25.011" + ")";
        this.osdVersionShade = shade;
        this.osdVersionPal = pal;
    }

    public void onLeft() {
        if (this.osdEditCursor > 0) {
            if (this.isCtrlPressed()) {
                while (this.osdEditCursor > 0 && Character.isSpaceChar(this.osdEditBuf.charAt(this.osdEditCursor - 1))) {
                    --this.osdEditCursor;
                }
                while (this.osdEditCursor > 0 && !Character.isSpaceChar(this.osdEditBuf.charAt(this.osdEditCursor - 1))) {
                    --this.osdEditCursor;
                }
            } else {
                --this.osdEditCursor;
            }
        }
    }

    public void onRight() {
        if (this.osdEditCursor < this.osdEditBuf.length()) {
            if (this.isCtrlPressed()) {
                while (this.osdEditCursor < this.osdEditBuf.length() && !Character.isSpaceChar(this.osdEditBuf.charAt(this.osdEditCursor))) {
                    ++this.osdEditCursor;
                }
                while (this.osdEditCursor < this.osdEditBuf.length() && Character.isSpaceChar(this.osdEditBuf.charAt(this.osdEditCursor))) {
                    ++this.osdEditCursor;
                }
            } else {
                ++this.osdEditCursor;
            }
        }
    }

    public void onDelete() {
        if (this.osdEditCursor == 0 || this.osdEditBuf.length() == 0) {
            return;
        }
        if (this.osdEditCursor <= this.osdEditBuf.length()) {
            this.osdEditBuf.deleteCharAt(--this.osdEditCursor);
        }
    }

    public void handleInput() {
        try {
            while (System.in.available() != 0) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                this.handleInput(reader.readLine());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleInput(String text) {
        this.osdEditBuf.append(text);
        this.onEnter();
    }

    public void onEnter() {
        if (!this.isEmpty()) {
            String input = this.getTextInput();
            this.inputHistory.add(input);
            this.actionListener.onEnter(input);
        }
        this.clear();
    }

    public void historyPrev() {
        if (this.inputHistory.hasPrev()) {
            this.applyHistory(this.inputHistory.prev());
        }
    }

    public void historyNext() {
        String history = this.inputHistory.next();
        if (history.isEmpty()) {
            this.osdEditBuf.setLength(0);
            this.osdEditCursor = 0;
            return;
        }
        this.applyHistory(history);
    }

    private void applyHistory(String history) {
        this.osdEditBuf.setLength(0);
        this.osdEditBuf.append(history);
        this.osdEditCursor = this.osdEditBuf.length();
    }

    public void append(char ch) {
        if (this.osdEditBuf.length() < this.osdEditBuf.capacity()) {
            if (this.osdEditCursor < this.osdEditBuf.length()) {
                if (this.osdOverType) {
                    this.osdEditBuf.deleteCharAt(this.osdEditCursor);
                }
                this.osdEditBuf.insert(this.osdEditCursor, ch);
            } else {
                this.osdEditBuf.append(ch);
            }
            ++this.osdEditCursor;
        }
    }

    public String getTextInput() {
        return this.osdEditBuf.toString();
    }

    public void setTextInput(String text) {
        this.clear();
        this.osdEditBuf.append(text);
        this.onLastPosition();
    }

    public int getCursorPosition() {
        return this.osdEditCursor;
    }

    public boolean isEmpty() {
        return this.osdEditBuf.length() == 0;
    }

    public void clear() {
        this.osdEditBuf.setLength(0);
        this.osdEditCursor = 0;
    }

    public void toggleOverType() {
        this.osdOverType = !this.osdOverType;
    }

    public boolean isOsdOverType() {
        return this.osdOverType;
    }

    public void onResize() {
    }

    public boolean isCaptured() {
        return this.osdCaptureInput;
    }

    public boolean isCapsLockPressed() {
        return this.osdCapsLock;
    }

    public void setCapsLockPressed(boolean osdCapsLock) {
        this.osdCapsLock = osdCapsLock;
    }

    public boolean isShiftPressed() {
        return this.osdShift;
    }

    public void setShiftPressed(boolean osdShift) {
        this.osdShift = osdShift;
    }

    public boolean isCtrlPressed() {
        return this.osdCtrl;
    }

    public void setCtrlPressed(boolean osdCtrl) {
        this.osdCtrl = osdCtrl;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (!this.isCaptured()) {
            return false;
        }
        switch (keycode) {
            case 50: {
                if (!this.isCtrlPressed()) break;
                if (Gdx.app.getClipboard() != null) {
                    String content = Gdx.app.getClipboard().getContents();
                    for (int i = 0; i < content.length(); ++i) {
                        this.keyTyped(content.charAt(i));
                    }
                }
                return true;
            }
            case 66: {
                this.onEnter();
                return true;
            }
            case 67: {
                if (this.isCtrlPressed()) {
                    this.clear();
                } else {
                    this.onDelete();
                }
                return true;
            }
            case 115: {
                this.setCapsLockPressed(!this.isCapsLockPressed());
                return true;
            }
            case 20: {
                this.historyNext();
                return true;
            }
            case 19: {
                this.historyPrev();
                return true;
            }
            case 22: {
                this.onRight();
                return true;
            }
            case 21: {
                this.onLeft();
                return true;
            }
            case 124: {
                this.toggleOverType();
                return true;
            }
            case 123: {
                if (this.isCtrlPressed()) break;
                this.onLastPosition();
                return true;
            }
            case 3: {
                if (this.isCtrlPressed()) break;
                this.onFirstPosition();
                return true;
            }
            case 59: 
            case 60: {
                this.setShiftPressed(true);
                return true;
            }
            case 129: 
            case 130: {
                this.setCtrlPressed(true);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        switch (keycode) {
            case 59: 
            case 60: {
                this.setShiftPressed(false);
                break;
            }
            case 129: 
            case 130: {
                this.setCtrlPressed(false);
            }
        }
        return true;
    }

    @Override
    public boolean keyTyped(char character) {
        if (!this.isCaptured()) {
            return false;
        }
        if (this.isCharacterAllowed(character)) {
            this.append(character);
            return true;
        }
        return false;
    }

    public boolean isCharacterAllowed(char character) {
        return character >= ' ' && character < '\u007f';
    }

    public static interface ActionListener {
        public void onEnter(String var1);
    }
}

