/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.settings;

import java.io.IOException;
import java.io.OutputStream;
import ru.m210projects.Build.Architecture.common.audio.AudioResampler;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.settings.ConfigContext;
import ru.m210projects.Build.settings.Properties;

public class AudioContext
implements ConfigContext {
    private static final String NAME = "SoundSetup";
    protected float soundVolume = 1.0f;
    protected float musicVolume = 1.0f;
    protected boolean noSound = false;
    protected boolean muteMusic = false;
    protected String resampler = AudioResampler.DUMMY_RESAMPLER.getName();
    protected int musicType = 0;
    protected int maxVoices = 16;

    AudioContext init(AudioContext audioContext) {
        if (audioContext != null) {
            this.soundVolume = audioContext.soundVolume;
            this.musicVolume = audioContext.musicVolume;
            this.noSound = audioContext.noSound;
            this.muteMusic = audioContext.muteMusic;
            this.resampler = audioContext.resampler;
            this.musicType = audioContext.musicType;
            this.maxVoices = audioContext.maxVoices;
        }
        return this;
    }

    @Override
    public void load(Properties prop) {
        if (prop.setContext(NAME)) {
            this.noSound = prop.getBooleanValue("NoSound", this.isNoSound());
            this.muteMusic = prop.getBooleanValue("NoMusic", this.isMuteMusic());
            this.musicType = prop.getIntValue("MusicType", this.musicType);
            this.soundVolume = Gameutils.BClipRange(prop.getFloatValue("SoundVolume", this.getSoundVolume()), 0.0f, 1.0f);
            this.musicVolume = Gameutils.BClipRange(prop.getFloatValue("MusicVolume", this.getMusicVolume()), 0.0f, 1.0f);
            this.resampler = prop.getStringValue("Resampler", this.resampler);
            this.maxVoices = Gameutils.BClipRange(prop.getIntValue("MaxVoices", this.getMaxVoices()), 4, 256);
        }
    }

    @Override
    public void save(OutputStream os) throws IOException {
        this.putString(os, ";\r\n");
        this.putString(os, String.format("[%s]\r\n", NAME));
        this.putBoolean(os, "NoSound", this.noSound);
        this.putBoolean(os, "NoMusic", this.muteMusic);
        this.putInteger(os, "MusicType", this.musicType);
        this.putFloat(os, "SoundVolume", this.soundVolume);
        this.putFloat(os, "MusicVolume", this.musicVolume);
        this.putInteger(os, "MaxVoices", this.maxVoices);
        this.putString(os, "Resampler", this.resampler);
        this.putString(os, ";\r\n;\r\n");
    }

    public AudioResampler getResampler() {
        return AudioResampler.DUMMY_RESAMPLER;
    }

    public void setResampler(AudioResampler resampler) {
        this.resampler = resampler.getName();
    }

    public float getSoundVolume() {
        return this.soundVolume;
    }

    public void setSoundVolume(float soundVolume) {
        this.soundVolume = soundVolume;
    }

    public float getMusicVolume() {
        return this.musicVolume;
    }

    public void setMusicVolume(float musicVolume) {
        this.musicVolume = musicVolume;
    }

    public boolean isNoSound() {
        return this.noSound;
    }

    public void setNoSound(boolean noSound) {
        this.noSound = noSound;
    }

    public boolean isMuteMusic() {
        return this.muteMusic;
    }

    public void setMuteMusic(boolean muteMusic) {
        this.muteMusic = muteMusic;
    }

    public int getMaxVoices() {
        return this.maxVoices;
    }

    public boolean setMaxVoices(int maxVoices) {
        this.maxVoices = maxVoices;
        return true;
    }
}

