/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.settings;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.Controllers;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import ru.m210projects.Build.input.GameController;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.keymap.ControllerAxis;
import ru.m210projects.Build.input.keymap.ControllerButton;

public class ControllerMapping {
    private final String controllerName;
    private final Map<Integer, Integer> buttonMap = new HashMap<Integer, Integer>(32);
    private final int[] controllerButtonMap = new int[ControllerButton.values().length];
    private final Map<Integer, ControllerAxis> axisMap = new HashMap<Integer, ControllerAxis>(8);
    private final int[] controllerAxisMap = new int[ControllerAxis.values().length];

    public ControllerMapping(String controllerName) {
        this.controllerName = controllerName;
        Arrays.fill(this.controllerButtonMap, -1);
        Arrays.fill(this.controllerAxisMap, -1);
    }

    private GameController getGameController() {
        for (Controller controller : Controllers.getControllers()) {
            if (!controller.getName().equalsIgnoreCase(this.controllerName) || !(controller instanceof GameController)) continue;
            return (GameController)((Object)controller);
        }
        return null;
    }

    public String getButtonName(ControllerButton button) {
        int id = this.getButtonCode(button);
        if (id != -1) {
            GameController controller = this.getGameController();
            if (controller != null) {
                return controller.getButtonName(id);
            }
            return "Button_" + id;
        }
        return GameKey.UNKNOWN_KEY.getName();
    }

    public String getAxisName(ControllerAxis axis) {
        int id = this.getAxisCode(axis);
        if (id != -1) {
            GameController controller = this.getGameController();
            if (controller != null) {
                return controller.getAxisName(id);
            }
            return "Axis_" + id;
        }
        return GameKey.UNKNOWN_KEY.getName();
    }

    public void putButton(ControllerButton button, int buttonCode) {
        this.removeButton(button);
        this.removeButton(ControllerButton.valueOf(this.getKeyCode(buttonCode)));
        this.buttonMap.put(buttonCode, button.getKeyCode());
        this.controllerButtonMap[button.ordinal()] = buttonCode;
    }

    public void removeButton(ControllerButton button) {
        int id = this.controllerButtonMap[button.ordinal()];
        if (id == -1) {
            return;
        }
        this.buttonMap.remove(id);
        this.controllerButtonMap[button.ordinal()] = -1;
    }

    public void putAxis(ControllerAxis axis, int axisCode) {
        this.removeAxis(axis);
        this.removeAxis(this.getAxis(axisCode));
        this.axisMap.put(axisCode, axis);
        this.controllerAxisMap[axis.ordinal()] = axisCode;
    }

    public void removeAxis(ControllerAxis axis) {
        int axisCode = this.controllerAxisMap[axis.ordinal()];
        if (axisCode == -1) {
            return;
        }
        this.axisMap.remove(axisCode);
        this.controllerAxisMap[axis.ordinal()] = -1;
    }

    public int getButtonCode(ControllerButton button) {
        return this.controllerButtonMap[button.ordinal()];
    }

    public int getAxisCode(ControllerAxis axis) {
        return this.controllerAxisMap[axis.ordinal()];
    }

    public ControllerAxis getAxis(int axisCode) {
        return this.axisMap.getOrDefault(axisCode, ControllerAxis.NULL);
    }

    public ControllerButton getButton(int buttonCode) {
        return ControllerButton.valueOf(this.getKeyCode(buttonCode));
    }

    public int getKeyCode(int buttonCode) {
        return this.buttonMap.getOrDefault(buttonCode, 0);
    }
}

