/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.settings;

import com.badlogic.gdx.Gdx;
import java.io.IOException;
import java.io.OutputStream;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Render.TexFilter;
import ru.m210projects.Build.settings.ConfigContext;
import ru.m210projects.Build.settings.Properties;

public class VideoContext
implements ConfigContext {
    public static final int MINFOV = 60;
    public static final int MAXFOV = 140;
    private static final String NAME = "RenderSetup";
    protected boolean gVSync = false;
    protected int fpslimit = 0;
    protected int paletteGamma = 0;
    protected float gFpsScale = 1.0f;
    protected boolean useVoxels = true;
    protected boolean useHighTiles = true;
    protected boolean useModels = true;
    protected boolean widescreen = true;
    protected boolean gShowFPS = true;
    protected TexFilter glfilter = TexFilter.NONE;
    protected boolean paletteFiltered = false;
    protected boolean softShading = false;
    protected int gFov = 90;
    protected float fgamma = 1.0f;
    protected boolean paletteEmulation = true;
    protected boolean detailMapping = true;
    protected boolean glowMapping = true;
    protected boolean animSmoothing = true;

    @Override
    public void load(Properties prop) {
        if (prop.setContext(NAME)) {
            this.gVSync = prop.getBooleanValue("VSync", this.gVSync);
            this.fpslimit = Math.max(0, prop.getIntValue("FPSLimit", this.fpslimit));
            this.glfilter = TexFilter.valueOf(prop.getIntValue("GLFilterMode", this.glfilter.ordinal()));
            this.paletteFiltered = prop.getBooleanValue("PaletteFiltered", this.paletteFiltered);
            this.softShading = prop.getBooleanValue("SoftShading", this.softShading);
            this.widescreen = prop.getBooleanValue("WideScreen", this.widescreen);
            this.gFov = Gameutils.BClipRange(prop.getIntValue("FieldOfView", this.gFov), 60, 140);
            this.gFpsScale = Gameutils.BClipRange(prop.getFloatValue("FpsScale", this.gFpsScale), 0.3f, 10.0f);
            this.paletteEmulation = prop.getBooleanValue("PaletteEmulation", this.paletteEmulation);
            this.fgamma = Gameutils.BClipRange(prop.getFloatValue("GLGamma", this.fgamma), 0.0f, 1.0f);
            this.paletteGamma = Gameutils.BClipRange(prop.getIntValue("PaletteGamma", this.paletteGamma), 0, 255);
            this.gShowFPS = prop.getBooleanValue("ShowFPS", this.gShowFPS);
            this.useVoxels = prop.getBooleanValue("UseVoxels", this.useVoxels);
            this.useModels = prop.getBooleanValue("UseModels", this.useModels);
            this.useHighTiles = prop.getBooleanValue("UseHighTiles", this.useHighTiles);
            this.detailMapping = prop.getBooleanValue("DetailMapping", this.detailMapping);
            this.glowMapping = prop.getBooleanValue("GlowMapping", this.glowMapping);
            this.animSmoothing = prop.getBooleanValue("AnimSmoothing", this.animSmoothing);
        }
    }

    VideoContext init(VideoContext videoContext) {
        if (videoContext != null) {
            this.gVSync = videoContext.gVSync;
            this.fpslimit = videoContext.fpslimit;
            this.paletteGamma = videoContext.paletteGamma;
            this.gFpsScale = videoContext.gFpsScale;
            this.widescreen = videoContext.widescreen;
            this.gShowFPS = videoContext.gShowFPS;
            this.glfilter = videoContext.glfilter;
            this.paletteFiltered = videoContext.paletteFiltered;
            this.softShading = videoContext.softShading;
            this.gFov = videoContext.gFov;
            this.fgamma = videoContext.fgamma;
            this.paletteEmulation = videoContext.paletteEmulation;
            this.useVoxels = videoContext.useVoxels;
            this.useModels = videoContext.useModels;
            this.useHighTiles = videoContext.useHighTiles;
            this.detailMapping = videoContext.detailMapping;
            this.glowMapping = videoContext.glowMapping;
            this.animSmoothing = videoContext.animSmoothing;
        }
        return this;
    }

    @Override
    public void save(OutputStream outputStream) throws IOException {
        this.putString(outputStream, String.format("[%s]\r\n", NAME));
        this.putBoolean(outputStream, "VSync", this.gVSync);
        this.putInteger(outputStream, "FPSLimit", this.fpslimit);
        this.putInteger(outputStream, "GLFilterMode", this.glfilter.ordinal());
        this.putBoolean(outputStream, "PaletteFiltered", this.paletteFiltered);
        this.putBoolean(outputStream, "SoftShading", this.softShading);
        this.putBoolean(outputStream, "WideScreen", this.widescreen);
        this.putInteger(outputStream, "FieldOfView", this.gFov);
        this.putFloat(outputStream, "FpsScale", this.gFpsScale);
        this.putBoolean(outputStream, "PaletteEmulation", this.paletteEmulation);
        this.putFloat(outputStream, "GLGamma", this.fgamma);
        this.putInteger(outputStream, "PaletteGamma", this.paletteGamma);
        this.putBoolean(outputStream, "ShowFPS", this.gShowFPS);
        this.putBoolean(outputStream, "UseVoxels", this.useVoxels);
        this.putBoolean(outputStream, "UseModels", this.useModels);
        this.putBoolean(outputStream, "UseHighTiles", this.useHighTiles);
        this.putBoolean(outputStream, "SetailMapping", this.detailMapping);
        this.putBoolean(outputStream, "GlowMapping", this.glowMapping);
        this.putBoolean(outputStream, "AnimSmoothing", this.animSmoothing);
        this.putString(outputStream, ";\r\n;\r\n");
    }

    public boolean isgVSync() {
        return this.gVSync;
    }

    public void setgVSync(boolean gVSync) {
        try {
            Gdx.graphics.setVSync(gVSync);
            this.gVSync = gVSync;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getFpslimit() {
        return this.fpslimit;
    }

    public void setFpslimit(int fpslimit) {
        this.fpslimit = fpslimit;
        Gdx.graphics.setForegroundFPS(fpslimit);
    }

    public int getPaletteGamma() {
        return this.paletteGamma;
    }

    public void setPaletteGamma(int paletteGamma) {
        this.paletteGamma = paletteGamma;
    }

    public float getFgamma() {
        return this.fgamma;
    }

    public void setFgamma(float fgamma) {
        this.fgamma = fgamma;
    }

    public float getgFpsScale() {
        return this.gFpsScale;
    }

    public void setgFpsScale(float gFpsScale) {
        this.gFpsScale = gFpsScale;
    }

    public boolean isWidescreen() {
        return this.widescreen;
    }

    public void setWidescreen(boolean widescreen) {
        this.widescreen = widescreen;
    }

    public TexFilter getTextureFilter() {
        return this.glfilter;
    }

    public void setTextureFilter(TexFilter textureFilter) {
        this.glfilter = textureFilter;
    }

    public boolean getPaletteFiltered() {
        return this.paletteFiltered;
    }

    public void setPaletteFiltered(boolean enabled) {
        this.paletteFiltered = enabled;
    }

    public boolean getSmoothShading() {
        return this.softShading;
    }

    public void setSmoothShading(boolean enabled) {
        this.softShading = enabled;
    }

    public boolean isgShowFPS() {
        return this.gShowFPS;
    }

    public void setgShowFPS(boolean gShowFPS) {
        this.gShowFPS = gShowFPS;
    }

    public int getgFov() {
        return this.gFov;
    }

    public void setgFov(int gFov) {
        this.gFov = gFov;
    }

    public boolean isPaletteEmulation() {
        return this.paletteEmulation;
    }

    public void setPaletteEmulation(boolean paletteEmulation) {
        this.paletteEmulation = paletteEmulation;
    }

    public boolean isUseVoxels() {
        return this.useVoxels;
    }

    public void setUseVoxels(boolean useVoxels) {
        this.useVoxels = useVoxels;
    }

    public boolean isUseHighTiles() {
        return this.useHighTiles;
    }

    public void setUseHighTiles(boolean useHighTiles) {
        this.useHighTiles = useHighTiles;
    }

    public boolean isUseModels() {
        return this.useModels;
    }

    public void setUseModels(boolean useModels) {
        this.useModels = useModels;
    }

    public boolean isDetailMapping() {
        return this.detailMapping;
    }

    public void setDetailMapping(boolean detailMapping) {
        this.detailMapping = detailMapping;
    }

    public boolean isGlowMapping() {
        return this.glowMapping;
    }

    public void setGlowMapping(boolean glowMapping) {
        this.glowMapping = glowMapping;
    }

    public boolean isAnimSmoothing() {
        return this.animSmoothing;
    }

    public void setAnimSmoothing(boolean animSmoothing) {
        this.animSmoothing = animSmoothing;
    }
}

