/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Duke3D.Actors;
import ru.m210projects.Duke3D.Animate;
import ru.m210projects.Duke3D.Gameutils;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Player;
import ru.m210projects.Duke3D.Premap;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Spawn;
import ru.m210projects.Duke3D.Types.PlayerStruct;
import ru.m210projects.Duke3D.View;
import ru.m210projects.Duke3D.Weapons;

public class DSector {
    public static int player_dist;
    public static final int[] wallfind;
    private static boolean haltsoundhack;

    public static void moveclouds() {
        if (Main.engine.getTotalClock() > Globals.cloudtotalclock || Main.engine.getTotalClock() < Globals.cloudtotalclock - 7) {
            Globals.cloudtotalclock = Main.engine.getTotalClock() + 6;
            for (int i = 0; i < Globals.numclouds; ++i) {
                int n = i;
                Globals.cloudx[n] = (short)(Globals.cloudx[n] + (short)(ru.m210projects.Build.Gameutils.BCosAngle(ru.m210projects.Build.Gameutils.BClampAngle(Globals.ps[Globals.screenpeek].ang)) / 512.0));
                int n2 = i;
                Globals.cloudy[n2] = (short)(Globals.cloudy[n2] + (short)(ru.m210projects.Build.Gameutils.BSinAngle(ru.m210projects.Build.Gameutils.BClampAngle(Globals.ps[Globals.screenpeek].ang)) / 512.0));
                Sector sec = Main.boardService.getSector(Globals.clouds[i]);
                if (sec == null) continue;
                sec.setCeilingxpanning((short)(Globals.cloudx[i] >> 6));
                sec.setCeilingypanning((short)(Globals.cloudy[i] >> 6));
            }
        }
    }

    public static boolean ceilingspace(int sectnum) {
        Sector sec = Main.boardService.getSector(sectnum);
        if (sec != null && (sec.getCeilingstat() & 1) != 0 && sec.getCeilingpal() == 0) {
            switch (sec.getCeilingpicnum()) {
                case 80: 
                case 84: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean floorspace(int sectnum) {
        Sector sec = Main.boardService.getSector(sectnum);
        if (sec != null && (sec.getFloorstat() & 1) != 0 && sec.getCeilingpal() == 0) {
            switch (sec.getFloorpicnum()) {
                case 80: 
                case 84: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean wallswitchcheck(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return false;
        }
        switch (spr.getPicnum()) {
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 712: 
            case 713: 
            case 860: 
            case 861: 
            case 862: 
            case 863: 
            case 864: 
            case 865: 
            case 1111: 
            case 1112: 
            case 1122: 
            case 1123: 
            case 1142: 
            case 1143: 
            case 1155: 
            case 1156: {
                return true;
            }
        }
        return false;
    }

    public static int callsound(int sn, int whatsprite) {
        if (haltsoundhack) {
            haltsoundhack = false;
            return -1;
        }
        for (ListNode<Sprite> n = Main.boardService.getSectNode(sn); n != null; n = n.getNext()) {
            Sprite sp = n.get();
            if (sp.getPicnum() != 5 || sp.getLotag() >= 1000) continue;
            int i = n.getIndex();
            if (whatsprite == -1) {
                whatsprite = i;
            }
            if (Globals.hittype[i].temp_data[0] == 0) {
                if (sp.getLotag() < 500 && (Globals.currentGame.getCON().soundm[sp.getLotag()] & 0x10) == 0) {
                    Sector sec;
                    if (sp.getLotag() != 0) {
                        Sounds.spritesound(sp.getLotag(), whatsprite);
                        if (sp.getHitag() != 0 && sp.getLotag() != sp.getHitag() && sp.getHitag() < 500) {
                            Sounds.stopsound(sp.getHitag());
                        }
                    }
                    if ((sec = Main.boardService.getSector(sp.getSectnum())) != null && (sec.getLotag() & 0xFF) != 22) {
                        Globals.hittype[i].temp_data[0] = 1;
                    }
                }
            } else if (sp.getHitag() < 500) {
                if (sp.getHitag() != 0) {
                    Sounds.spritesound(sp.getHitag(), whatsprite);
                }
                if ((Globals.currentGame.getCON().soundm[sp.getLotag()] & 1) != 0 || sp.getHitag() != 0 && sp.getHitag() != sp.getLotag()) {
                    Sounds.stopsound(sp.getLotag());
                }
                Globals.hittype[i].temp_data[0] = 0;
            }
            return sp.getLotag();
        }
        return -1;
    }

    public static boolean check_activator_motion(int lotag) {
        for (ListNode<Sprite> n = Main.boardService.getStatNode(8); n != null; n = n.getNext()) {
            Sprite s = n.get();
            if (s.getLotag() != lotag) continue;
            for (int j = Animate.gAnimationCount - 1; j >= 0; --j) {
                if (s.getSectnum() != Animate.gAnimationData[j].sect) continue;
                return true;
            }
            block6: for (ListNode<Sprite> n2 = Main.boardService.getStatNode(3); n2 != null; n2 = n2.getNext()) {
                Sprite sp = n2.get();
                int j = n2.getIndex();
                if (s.getSectnum() != sp.getSectnum()) continue;
                switch (sp.getLotag()) {
                    case 11: 
                    case 30: {
                        if (Globals.hittype[j].temp_data[4] == 0) continue block6;
                        return true;
                    }
                    case 18: 
                    case 20: 
                    case 31: 
                    case 32: {
                        if (Globals.hittype[j].temp_data[0] == 0) continue block6;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isadoorwall(int dapic) {
        switch (dapic) {
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 395: 
            case 447: 
            case 448: 
            case 449: 
            case 717: 
            case 781: 
            case 1102: 
            case 1144: 
            case 1169: 
            case 1178: 
            case 1179: 
            case 4391: {
                return true;
            }
        }
        return false;
    }

    public static boolean isanunderoperator(int lotag) {
        switch (lotag & 0xFF) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public static boolean isanearoperator(int lotag) {
        switch (lotag & 0xFF) {
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    public static int ldist(Sprite s1, Sprite s2) {
        int vx = s1.getX() - s2.getX();
        int vy = s1.getY() - s2.getY();
        return Gameutils.FindDistance2D(vx, vy) + 1;
    }

    public static int dist(Sprite s1, Sprite s2) {
        int vx = s1.getX() - s2.getX();
        int vy = s1.getY() - s2.getY();
        int vz = s1.getZ() - s2.getZ();
        return Gameutils.FindDistance3D(vx, vy, vz >> 4);
    }

    public static int findplayer(Sprite s) {
        if (Globals.ud.multimode < 2) {
            player_dist = Pragmas.klabs(Globals.ps[Mmulti.myconnectindex].oposx - s.getX()) + Pragmas.klabs(Globals.ps[Mmulti.myconnectindex].oposy - s.getY()) + (Pragmas.klabs(Globals.ps[Mmulti.myconnectindex].oposz - s.getZ() + 7168) >> 4);
            return Mmulti.myconnectindex;
        }
        int closest = Integer.MAX_VALUE;
        int closest_player = 0;
        short j = Mmulti.connecthead;
        while (j >= 0) {
            Sprite psp = Main.boardService.getSprite(Globals.ps[j].i);
            int x = Pragmas.klabs(Globals.ps[j].oposx - s.getX()) + Pragmas.klabs(Globals.ps[j].oposy - s.getY()) + (Pragmas.klabs(Globals.ps[j].oposz - s.getZ() + 7168) >> 4);
            if (psp != null && x < closest && psp.getExtra() > 0) {
                closest_player = j;
                closest = x;
            }
            j = Mmulti.connectpoint2[j];
        }
        player_dist = closest;
        return closest_player;
    }

    public static int findotherplayer(int p) {
        int closest = Integer.MAX_VALUE;
        int closest_player = p;
        short j = Mmulti.connecthead;
        while (j >= 0) {
            int x;
            Sprite psp = Main.boardService.getSprite(Globals.ps[j].i);
            if (p != j && psp != null && psp.getExtra() > 0 && (x = Pragmas.klabs(Globals.ps[j].oposx - Globals.ps[p].posx) + Pragmas.klabs(Globals.ps[j].oposy - Globals.ps[p].posy) + (Pragmas.klabs(Globals.ps[j].oposz - Globals.ps[p].posz) >> 4)) < closest) {
                closest_player = j;
                closest = x;
            }
            j = Mmulti.connectpoint2[j];
        }
        player_dist = closest;
        return closest_player;
    }

    public static int checkcursectnums(int sect) {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            Sprite psp = Main.boardService.getSprite(Globals.ps[i].i);
            if (psp != null && psp.getSectnum() == sect) {
                return i;
            }
            i = Mmulti.connectpoint2[i];
        }
        return -1;
    }

    public static void animatecamsprite() {
        if (Globals.camsprite <= 0) {
            return;
        }
        short i = Globals.camsprite;
        if (Globals.hittype[i].temp_data[0] >= 11) {
            Globals.hittype[i].temp_data[0] = 0;
            Sprite spo = Main.boardService.getSprite(i);
            Sprite psp = Main.boardService.getSprite(Globals.ps[Globals.screenpeek].i);
            if (spo != null) {
                if (Globals.ps[Globals.screenpeek].newowner >= 0) {
                    spo.setOwner(Globals.ps[Globals.screenpeek].newowner);
                } else if (psp != null && spo.getOwner() >= 0 && DSector.dist(psp, spo) < 2048) {
                    ArtEntry viewScrEntry = Main.engine.getTile(Globals.TILE_VIEWSCR);
                    if (!(viewScrEntry instanceof DynamicArtEntry) || !viewScrEntry.exists()) {
                        ArtEntry pic = Main.engine.getTile(spo.getPicnum());
                        if (pic.hasSize()) {
                            Main.engine.allocatepermanenttile(Globals.TILE_VIEWSCR, pic.getWidth(), pic.getHeight());
                        } else {
                            Main.engine.allocatepermanenttile(Globals.TILE_VIEWSCR, 96, 96);
                        }
                    } else {
                        Globals.VIEWSCR_Lock = 255;
                    }
                    Premap.xyzmirror(spo.getOwner(), Main.engine.getTileManager().getDynamicTile(Globals.TILE_VIEWSCR));
                }
            }
        } else {
            Globals.hittype[i].temp_data[0] = Globals.hittype[i].temp_data[0] + 1;
        }
    }

    public static void animatewalls() {
        block7: for (int p = 0; p < Globals.numanimwalls; ++p) {
            short i = Globals.animwall[p].wallnum;
            Wall wal = Main.boardService.getWall(i);
            if (wal == null) continue;
            short j = wal.getPicnum();
            switch (j) {
                case 263: 
                case 264: 
                case 265: 
                case 266: 
                case 267: 
                case 271: 
                case 272: 
                case 273: 
                case 274: 
                case 275: 
                case 4120: 
                case 4123: 
                case 4125: 
                case 4127: 
                case 4128: 
                case 4129: {
                    if ((Main.engine.krand() & 0xFF) >= 16) continue block7;
                    Globals.animwall[p].tag = wal.getPicnum();
                    wal.setPicnum(268);
                    continue block7;
                }
                case 268: 
                case 269: 
                case 270: {
                    if (Globals.animwall[p].tag >= 0 && wal.getExtra() != 1289 && wal.getExtra() != 1298) {
                        wal.setPicnum((short)Globals.animwall[p].tag);
                        continue block7;
                    }
                    wal.setPicnum(wal.getPicnum() + 1);
                    if (wal.getPicnum() != 271) continue block7;
                    wal.setPicnum(268);
                    continue block7;
                }
                default: {
                    if ((wal.getCstat() & 0x10) == 0) continue block7;
                    switch (wal.getOverpicnum()) {
                        case 663: 
                        case 664: 
                        case 665: {
                            int t = Globals.animwall[p].tag;
                            if ((wal.getCstat() & 0xFE) == 0) continue block7;
                            wal.setXpanning(wal.getXpanning() - (t >> 10));
                            wal.setYpanning(wal.getYpanning() - (t >> 10));
                            if (wal.getExtra() == 1) {
                                wal.setExtra(0);
                                Globals.animwall[p].tag = 0;
                            } else {
                                Globals.animwall[p].tag += 128;
                            }
                            if (Globals.animwall[p].tag < 2048) {
                                if ((Globals.animwall[p].tag & 0x80) != 0) {
                                    wal.setOverpicnum(663);
                                    continue block7;
                                }
                                wal.setOverpicnum(664);
                                continue block7;
                            }
                            if ((Main.engine.krand() & 0xFF) < 32) {
                                Globals.animwall[p].tag = 128 << (Main.engine.krand() & 3);
                                continue block7;
                            }
                            wal.setOverpicnum(664);
                        }
                    }
                }
            }
        }
    }

    public static boolean activatewarpelevators(int s, int d) {
        Sector sec2;
        Sprite sp;
        ListNode<Sprite> n;
        Sprite spr = Main.boardService.getSprite(s);
        if (spr == null) {
            return false;
        }
        short sn = spr.getSectnum();
        Sector sec = Main.boardService.getSector(sn);
        if (sec == null) {
            return false;
        }
        for (n = Main.boardService.getStatNode(3); n != null && ((sp = n.get()).getLotag() != 17 || sp.getHitag() != spr.getHitag() || (sec2 = Main.boardService.getSector(sp.getSectnum())) == null || Pragmas.klabs(sec.getFloorz() - Globals.hittype[s].temp_data[2]) <= sp.getYvel() && sec2.getHitag() != sec.getHitag() - d); n = n.getNext()) {
        }
        if (n == null) {
            return true;
        }
        if (d == 0) {
            Sounds.spritesound(73, s);
        } else {
            Sounds.spritesound(71, s);
        }
        for (n = Main.boardService.getStatNode(3); n != null; n = n.getNext()) {
            sp = n.get();
            int i = n.getIndex();
            if (sp.getLotag() != 17 || sp.getHitag() != spr.getHitag()) continue;
            Globals.hittype[i].temp_data[0] = d;
            Globals.hittype[i].temp_data[1] = d;
        }
        return false;
    }

    public static void operatesectors(int sn, int ii) {
        Sector ssec = Main.boardService.getSector(sn);
        if (ssec == null) {
            return;
        }
        switch (ssec.getLotag() & 0x3FFF) {
            case 30: {
                short j = ssec.getHitag();
                Sprite s = Main.boardService.getSprite(j);
                if (s == null) break;
                if (Globals.hittype[j].tempang == 0 || Globals.hittype[j].tempang == 256) {
                    DSector.callsound(sn, ii);
                }
                if (s.getExtra() == 1) {
                    s.setExtra(3);
                    break;
                }
                s.setExtra(1);
                break;
            }
            case 31: {
                short j = ssec.getHitag();
                if (Globals.hittype[j].temp_data[4] == 0) {
                    Globals.hittype[j].temp_data[4] = 1;
                }
                DSector.callsound(sn, ii);
                break;
            }
            case 26: {
                int i = Animate.getanimationgoal(ssec, 8);
                if (i == -1) {
                    haltsoundhack = true;
                    ssec.setLotag(ssec.getLotag() & 0xFF00);
                    ssec.setLotag(ssec.getLotag() | 0x16);
                    DSector.operatesectors(sn, ii);
                    ssec.setLotag(ssec.getLotag() & 0xFF00);
                    ssec.setLotag(ssec.getLotag() | 9);
                    DSector.operatesectors(sn, ii);
                    ssec.setLotag(ssec.getLotag() & 0xFF00);
                    ssec.setLotag(ssec.getLotag() | 0x1A);
                }
                return;
            }
            case 9: {
                Wall wal;
                int sp = ssec.getExtra() >> 4;
                int dax = 0;
                int day = 0;
                for (ListNode<Wall> wn = ssec.getWallNode(); wn != null; wn = wn.getNext()) {
                    Wall wal2 = wn.get();
                    dax += wal2.getX();
                    day += wal2.getY();
                }
                int startwall = ssec.getWallptr();
                int endwall = ssec.getEndWall();
                dax /= endwall - startwall + 1;
                day /= endwall - startwall + 1;
                DSector.wallfind[0] = -1;
                DSector.wallfind[1] = -1;
                for (int i = startwall; i <= endwall; ++i) {
                    wal = Main.boardService.getWall(i);
                    if (wal == null || wal.getX() != dax && wal.getY() != day) continue;
                    if (wallfind[0] == -1) {
                        DSector.wallfind[0] = i;
                        continue;
                    }
                    DSector.wallfind[1] = i;
                }
                for (int j = 0; j < 2; ++j) {
                    int day2;
                    int dax2;
                    Wall wal2;
                    int i;
                    wal = Main.boardService.getWall(wallfind[j]);
                    if (wal != null && wal.getX() == dax && wal.getY() == day) {
                        i = wallfind[j] - 1;
                        if (i < startwall) {
                            i = endwall;
                        }
                        if ((wal2 = Main.boardService.getWall(i)) == null) continue;
                        dax2 = (wal2.getX() + wal.getWall2().getX() >> 1) - wal.getX();
                        day2 = (wal2.getY() + wal.getWall2().getY() >> 1) - wal.getY();
                        if (dax2 != 0) {
                            dax2 = wal.getWall2().getWall2().getX();
                            Animate.setanimation(sn, wallfind[j], wal.getX() + (dax2 -= wal.getWall2().getX()), sp, 1);
                            Animate.setanimation(sn, i, wal2.getX() + dax2, sp, 1);
                            Animate.setanimation(sn, wal.getPoint2(), wal.getWall2().getX() + dax2, sp, 1);
                            DSector.callsound(sn, ii);
                            continue;
                        }
                        if (day2 == 0) continue;
                        day2 = wal.getWall2().getWall2().getY();
                        Animate.setanimation(sn, wallfind[j], wal.getY() + (day2 -= wal.getWall2().getY()), sp, 2);
                        Animate.setanimation(sn, i, wal2.getY() + day2, sp, 2);
                        Animate.setanimation(sn, wal.getPoint2(), wal.getWall2().getY() + day2, sp, 2);
                        DSector.callsound(sn, ii);
                        continue;
                    }
                    if (wal == null) continue;
                    i = wallfind[j] - 1;
                    if (i < startwall) {
                        i = endwall;
                    }
                    if ((wal2 = Main.boardService.getWall(i)) == null) continue;
                    dax2 = (wal2.getX() + wal.getWall2().getX() >> 1) - wal.getX();
                    day2 = (wal2.getY() + wal.getWall2().getY() >> 1) - wal.getY();
                    if (dax2 != 0) {
                        Animate.setanimation(sn, wallfind[j], dax, sp, 1);
                        Animate.setanimation(sn, i, dax + dax2, sp, 1);
                        Animate.setanimation(sn, wal.getPoint2(), dax + dax2, sp, 1);
                        DSector.callsound(sn, ii);
                        continue;
                    }
                    if (day2 == 0) continue;
                    Animate.setanimation(sn, wallfind[j], day, sp, 2);
                    Animate.setanimation(sn, i, day + day2, sp, 2);
                    Animate.setanimation(sn, wal.getPoint2(), day + day2, sp, 2);
                    DSector.callsound(sn, ii);
                }
                return;
            }
            case 15: {
                ListNode<Sprite> n;
                Sprite s = Main.boardService.getSprite(ii);
                if (s == null || s.getPicnum() != 1405) {
                    return;
                }
                for (n = Main.boardService.getSectNode(sn); n != null && (n.get().getPicnum() != 1 || n.get().getLotag() != 17); n = n.getNext()) {
                }
                if (n == null) {
                    return;
                }
                int i = n.getIndex();
                if (s.getSectnum() == sn) {
                    if (DSector.activatewarpelevators(i, -1)) {
                        DSector.activatewarpelevators(i, 1);
                    } else if (DSector.activatewarpelevators(i, 1)) {
                        DSector.activatewarpelevators(i, -1);
                    }
                } else if (ssec.getFloorz() > n.get().getZ()) {
                    DSector.activatewarpelevators(i, -1);
                } else {
                    DSector.activatewarpelevators(i, 1);
                }
                return;
            }
            case 16: 
            case 17: {
                int i = Animate.getanimationgoal(ssec, 4);
                if (i == -1) {
                    i = Main.engine.nextsectorneighborz(sn, ssec.getFloorz(), 1, 1);
                    if (i == -1 && (i = Main.engine.nextsectorneighborz(sn, ssec.getFloorz(), 1, -1)) == -1) {
                        return;
                    }
                    Sector sec = Main.boardService.getSector(i);
                    if (sec != null) {
                        int j = sec.getFloorz();
                        Animate.setanimation(sn, sn, j, ssec.getExtra(), 4);
                        DSector.callsound(sn, ii);
                    }
                }
                return;
            }
            case 18: 
            case 19: {
                int i = Animate.getanimationgoal(ssec, 4);
                if (i == -1) {
                    i = Main.engine.nextsectorneighborz(sn, ssec.getFloorz(), 1, -1);
                    if (i == -1) {
                        i = Main.engine.nextsectorneighborz(sn, ssec.getFloorz(), 1, 1);
                    }
                    if (i == -1) {
                        return;
                    }
                    Sector sec = Main.boardService.getSector(i);
                    if (sec != null) {
                        int j = sec.getFloorz();
                        short q = ssec.getExtra();
                        int l = ssec.getCeilingz() - ssec.getFloorz();
                        Animate.setanimation(sn, sn, j, q, 4);
                        Animate.setanimation(sn, sn, j + l, q, 8);
                        DSector.callsound(sn, ii);
                    }
                }
                return;
            }
            case 29: {
                Sector sec;
                int j = 0;
                if ((ssec.getLotag() & 0x8000) != 0) {
                    sec = Main.boardService.getSector(Main.engine.nextsectorneighborz(sn, ssec.getCeilingz(), 1, 1));
                    if (sec != null) {
                        j = sec.getFloorz();
                    }
                } else {
                    sec = Main.boardService.getSector(Main.engine.nextsectorneighborz(sn, ssec.getCeilingz(), -1, -1));
                    if (sec != null) {
                        j = sec.getCeilingz();
                    }
                }
                for (ListNode<Sprite> ni = Main.boardService.getStatNode(3); ni != null; ni = ni.getNext()) {
                    Sector sec2;
                    Sprite sp = ni.get();
                    if (sp.getLotag() != 22 || sp.getHitag() != ssec.getHitag() || (sec2 = Main.boardService.getSector(sp.getSectnum())) == null) continue;
                    sec2.setExtra(-sec2.getExtra());
                    int i = ni.getIndex();
                    Globals.hittype[i].temp_data[0] = sn;
                    Globals.hittype[i].temp_data[1] = 1;
                }
                ssec.setLotag(ssec.getLotag() ^ 0x8000);
                Animate.setanimation(sn, sn, j, ssec.getExtra(), 8);
                DSector.callsound(sn, ii);
                return;
            }
            case 20: {
                boolean REDODOOR;
                int j = 0;
                do {
                    REDODOOR = false;
                    if ((ssec.getLotag() & 0x8000) != 0) {
                        ListNode<Sprite> node;
                        for (node = Main.boardService.getSectNode(sn); node != null; node = node.getNext()) {
                            Sprite sp = node.get();
                            if (sp.getStatnum() != 3 || sp.getLotag() != 9) continue;
                            j = sp.getZ();
                            break;
                        }
                        if (node != null) continue;
                        j = ssec.getFloorz();
                        continue;
                    }
                    j = Main.engine.nextsectorneighborz(sn, ssec.getCeilingz(), -1, -1);
                    Sector sec = Main.boardService.getSector(j);
                    if (sec != null) {
                        j = sec.getCeilingz();
                        continue;
                    }
                    ssec.setLotag(ssec.getLotag() | 0x8000);
                    REDODOOR = true;
                } while (REDODOOR);
                ssec.setLotag(ssec.getLotag() ^ 0x8000);
                Animate.setanimation(sn, sn, j, ssec.getExtra(), 8);
                DSector.callsound(sn, ii);
                return;
            }
            case 21: {
                int i = Animate.getanimationgoal(ssec, 4);
                if (i >= 0) {
                    if (Animate.gAnimationData[i].goal == ssec.getCeilingz()) {
                        Sector sec = Main.boardService.getSector(Main.engine.nextsectorneighborz(sn, ssec.getCeilingz(), 1, 1));
                        if (sec != null) {
                            Animate.gAnimationData[i].goal = sec.getFloorz();
                        }
                    } else {
                        Animate.gAnimationData[i].goal = ssec.getCeilingz();
                    }
                } else {
                    Sector sec;
                    int j = ssec.getCeilingz();
                    if (ssec.getCeilingz() == ssec.getFloorz() && (sec = Main.boardService.getSector(Main.engine.nextsectorneighborz(sn, ssec.getCeilingz(), 1, 1))) != null) {
                        j = sec.getFloorz();
                    }
                    ssec.setLotag(ssec.getLotag() ^ 0x8000);
                    if (Animate.setanimation(sn, sn, j, ssec.getExtra(), 4) >= 0) {
                        DSector.callsound(sn, ii);
                    }
                }
                return;
            }
            case 22: {
                if ((ssec.getLotag() & 0x8000) != 0) {
                    int q = ssec.getCeilingz() + ssec.getFloorz() >> 1;
                    Animate.setanimation(sn, sn, q, ssec.getExtra(), 4);
                    Animate.setanimation(sn, sn, q, ssec.getExtra(), 8);
                } else {
                    int csect;
                    int fsect = Main.engine.nextsectorneighborz(sn, ssec.getFloorz(), 1, 1);
                    Sector sec = Main.boardService.getSector(fsect);
                    if (sec != null) {
                        int q = sec.getFloorz();
                        Animate.setanimation(sn, sn, q, ssec.getExtra(), 4);
                    }
                    if ((sec = Main.boardService.getSector(csect = Main.engine.nextsectorneighborz(sn, ssec.getCeilingz(), -1, -1))) != null) {
                        int q = sec.getCeilingz();
                        Animate.setanimation(sn, sn, q, ssec.getExtra(), 8);
                    }
                }
                ssec.setLotag(ssec.getLotag() ^ 0x8000);
                DSector.callsound(sn, ii);
                return;
            }
            case 23: {
                ListNode<Sprite> ni;
                boolean q = false;
                for (ni = Main.boardService.getStatNode(3); ni != null; ni = ni.getNext()) {
                    Sprite sp = ni.get();
                    int i = ni.getIndex();
                    if (sp.getLotag() == 11 && sp.getSectnum() == sn && Globals.hittype[i].temp_data[4] == 0) break;
                }
                if (ni == null) {
                    return;
                }
                Sprite s = ni.get();
                Sector seci = Main.boardService.getSector(s.getSectnum());
                if (seci == null) {
                    return;
                }
                int l = seci.getLotag() & 0x8000;
                for (ni = Main.boardService.getStatNode(3); ni != null; ni = ni.getNext()) {
                    Sprite sp = ni.get();
                    Sector sec = Main.boardService.getSector(sp.getSectnum());
                    int i = ni.getIndex();
                    if (sec == null || l != (sec.getLotag() & 0x8000) || sp.getLotag() != 11 || s.getHitag() != sp.getHitag() || Globals.hittype[i].temp_data[4] != 0) continue;
                    if ((sec.getLotag() & 0x8000) != 0) {
                        sec.setLotag(sec.getLotag() & Short.MAX_VALUE);
                    } else {
                        sec.setLotag(sec.getLotag() | 0x8000);
                    }
                    Globals.hittype[i].temp_data[4] = 1;
                    Globals.hittype[i].temp_data[3] = -Globals.hittype[i].temp_data[3];
                    if (q) continue;
                    DSector.callsound(sn, i);
                    q = true;
                }
                return;
            }
            case 25: {
                Sprite sp;
                ListNode<Sprite> ni;
                for (ni = Main.boardService.getStatNode(3); ni != null && ((sp = ni.get()).getLotag() != 15 || sp.getSectnum() != sn); ni = ni.getNext()) {
                }
                if (ni == null) {
                    return;
                }
                Sprite spr = ni.get();
                for (ni = Main.boardService.getStatNode(3); ni != null; ni = ni.getNext()) {
                    Sector sec;
                    Sprite sp2 = ni.get();
                    int i = ni.getIndex();
                    if (sp2.getHitag() != spr.getHitag() || sp2.getLotag() != 15 || (sec = Main.boardService.getSector(sp2.getSectnum())) == null) continue;
                    sec.setLotag(sec.getLotag() ^ 0x8000);
                    sp2.setAng(sp2.getAng() + 1024);
                    if (Globals.hittype[i].temp_data[4] != 0) {
                        DSector.callsound(sp2.getSectnum(), i);
                    }
                    DSector.callsound(sp2.getSectnum(), i);
                    Globals.hittype[i].temp_data[4] = (sec.getLotag() & 0x8000) != 0 ? 1 : 2;
                }
                return;
            }
            case 27: {
                for (ListNode<Sprite> ni = Main.boardService.getStatNode(3); ni != null; ni = ni.getNext()) {
                    Sprite sp = ni.get();
                    if ((sp.getLotag() & 0xFF) != 20 || sp.getSectnum() != sn) continue;
                    ssec.setLotag(ssec.getLotag() ^ 0x8000);
                    Globals.hittype[ni.getIndex()].temp_data[0] = (ssec.getLotag() & 0x8000) != 0 ? 1 : 2;
                    DSector.callsound(sn, ii);
                    break;
                }
                return;
            }
            case 28: {
                Sprite sp;
                ListNode<Sprite> ni;
                short j = -1;
                for (ni = Main.boardService.getSectNode(sn); ni != null && ((sp = ni.get()).getStatnum() != 3 || (sp.getLotag() & 0xFF) != 21); ni = ni.getNext()) {
                }
                if (ni != null) {
                    j = ni.get().getHitag();
                }
                for (ni = Main.boardService.getStatNode(3); ni != null; ni = ni.getNext()) {
                    sp = ni.get();
                    int l = ni.getIndex();
                    if ((sp.getLotag() & 0xFF) != 21 || Globals.hittype[l].temp_data[0] != 0 || sp.getHitag() != j) continue;
                    Globals.hittype[l].temp_data[0] = 1;
                }
                DSector.callsound(sn, ii);
            }
        }
    }

    public static void operaterespawns(int low) {
        ListNode<Sprite> ni = Main.boardService.getStatNode(11);
        while (ni != null) {
            ListNode<Sprite> nextni = ni.getNext();
            Sprite sp = ni.get();
            if (sp.getLotag() == low && sp.getPicnum() == 9) {
                if (sp.getHitag() < 0 || sp.getHitag() >= Engine.MAXTILES || Actors.badguypic(sp.getHitag()) && Globals.ud.monsters_off) break;
                int j = Spawn.spawn(ni.getIndex(), 1630);
                Sprite sj = Main.boardService.getSprite(j);
                if (sj != null) {
                    sj.setZ(sj.getZ() - 8192);
                }
                sp.setExtra(54);
            }
            ni = nextni;
        }
    }

    public static void operateactivators(int low, int snum) {
        for (int i = Globals.numcyclers - 1; i >= 0; --i) {
            short[] p = Globals.cyclers[i];
            if (p[4] != low) continue;
            p[5] = (short)(p[5] ^ 1);
            Sector sec = Main.boardService.getSector(p[0]);
            if (sec == null) continue;
            sec.setCeilingshade(p[3]);
            sec.setFloorshade(p[3]);
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                Wall wal = wn.get();
                wal.setShade((byte)p[3]);
            }
        }
        int k = -1;
        ListNode<Sprite> ni = Main.boardService.getStatNode(8);
        block10: while (ni != null) {
            Sprite sp = ni.get();
            Sector sec = Main.boardService.getSector(sp.getSectnum());
            if (sec != null && sp.getLotag() == low) {
                if (sp.getPicnum() == 4) {
                    if ((sec.getLotag() & 0x4000) != 0) {
                        sec.setLotag(sec.getLotag() & 0xBFFF);
                    } else {
                        sec.setLotag(sec.getLotag() | 0x4000);
                    }
                    if (snum >= 0) {
                        if ((sec.getLotag() & 0x4000) != 0) {
                            View.FTA(4, Globals.ps[snum]);
                        } else {
                            View.FTA(8, Globals.ps[snum]);
                        }
                    }
                } else {
                    switch (sp.getHitag()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (sec.getFloorz() == sec.getCeilingz()) break;
                            ni = ni.getNext();
                            continue block10;
                        }
                        case 2: {
                            if (sec.getFloorz() != sec.getCeilingz()) break;
                            ni = ni.getNext();
                            continue block10;
                        }
                    }
                    if (sec.getLotag() < 3) {
                        for (ListNode<Sprite> node = Main.boardService.getSectNode(sp.getSectnum()); node != null; node = node.getNext()) {
                            Sprite jspr = node.get();
                            if (jspr.getStatnum() != 3) continue;
                            switch (jspr.getLotag()) {
                                case 18: 
                                case 31: 
                                case 32: 
                                case 36: {
                                    int j = node.getIndex();
                                    Globals.hittype[j].temp_data[0] = 1 - Globals.hittype[j].temp_data[0];
                                    DSector.callsound(sp.getSectnum(), j);
                                }
                            }
                        }
                    }
                    int i = ni.getIndex();
                    if (k == -1 && (sec.getLotag() & 0xFF) == 22) {
                        k = (short)DSector.callsound(sp.getSectnum(), i);
                    }
                    DSector.operatesectors(sp.getSectnum(), i);
                }
            }
            ni = ni.getNext();
        }
        DSector.operaterespawns(low);
    }

    public static void operatemasterswitches(int low) {
        for (ListNode<Sprite> node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            if (sp.getPicnum() != 8 || sp.getLotag() != low || sp.getYvel() != 0) continue;
            sp.setYvel(1);
        }
    }

    public static void operateforcefields(int s, int low) {
        block3: for (int p = Globals.numanimwalls; p >= 0; --p) {
            short i = Globals.animwall[p].wallnum;
            Wall wal = Main.boardService.getWall(i);
            if (wal == null || low != wal.getLotag() && low != -1) continue;
            switch (wal.getOverpicnum()) {
                case 230: 
                case 663: 
                case 664: 
                case 665: {
                    Globals.animwall[p].tag = 0;
                    if (wal.getCstat() != 0) {
                        wal.setCstat(0);
                        Sprite sp = Main.boardService.getSprite(s);
                        if (sp == null || sp.getPicnum() != 1 || sp.getLotag() != 30) continue block3;
                        wal.setLotag(0);
                        continue block3;
                    }
                    wal.setCstat(85);
                }
            }
        }
    }

    public static boolean checkhitswitch(int snum, int w, int switchtype) {
        short switchpal;
        short picnum;
        int sy;
        int sx;
        short hitag;
        int lotag;
        Sprite s;
        if (w < 0) {
            return false;
        }
        int correctdips = 1;
        int numdips = 0;
        if (switchtype == 1) {
            s = Main.boardService.getSprite(w);
            if (s == null) {
                return false;
            }
            lotag = s.getLotag();
            if (lotag == 0) {
                return false;
            }
            hitag = s.getHitag();
            sx = s.getX();
            sy = s.getY();
            picnum = s.getPicnum();
            switchpal = s.getPal();
        } else {
            Wall wal = Main.boardService.getWall(w);
            if (wal == null) {
                return false;
            }
            lotag = wal.getLotag();
            if (lotag == 0) {
                return false;
            }
            hitag = wal.getHitag();
            sx = wal.getX();
            sy = wal.getY();
            picnum = wal.getPicnum();
            switchpal = wal.getPal();
        }
        switch (picnum) {
            case 162: 
            case 163: 
            case 166: 
            case 167: 
            case 1142: 
            case 1143: {
                break;
            }
            case 5295: {
                if (switchtype == 1) {
                    s = Main.boardService.getSprite(w);
                    if (s != null) {
                        s.setPicnum(s.getPicnum() - 1);
                        Sounds.StopCommentary(Sounds.pCommentary);
                    }
                    return true;
                }
                return false;
            }
            case 5294: {
                if (switchtype == 1) {
                    s = Main.boardService.getSprite(w);
                    if (s != null && Sounds.StartCommentary(lotag, w)) {
                        s.setPicnum(s.getPicnum() + 1);
                    }
                    return true;
                }
                return false;
            }
            case 130: 
            case 170: {
                if (Globals.ps[snum].access_incs == 0) {
                    if (switchpal == 0) {
                        if ((Globals.ps[snum].got_access & 1) != 0) {
                            Globals.ps[snum].access_incs = 1;
                        } else {
                            View.FTA(70, Globals.ps[snum]);
                        }
                    } else if (switchpal == 21) {
                        if ((Globals.ps[snum].got_access & 2) != 0) {
                            Globals.ps[snum].access_incs = 1;
                        } else {
                            View.FTA(71, Globals.ps[snum]);
                        }
                    } else if (switchpal == 23) {
                        if ((Globals.ps[snum].got_access & 4) != 0) {
                            Globals.ps[snum].access_incs = 1;
                        } else {
                            View.FTA(72, Globals.ps[snum]);
                        }
                    }
                    if (Globals.ps[snum].access_incs == 1) {
                        if (switchtype == 0) {
                            Globals.ps[snum].access_wallnum = (short)w;
                        } else {
                            Globals.ps[snum].access_spritenum = (short)w;
                        }
                    }
                    return false;
                }
            }
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 164: 
            case 165: 
            case 168: 
            case 169: 
            case 712: 
            case 713: 
            case 860: 
            case 861: 
            case 862: 
            case 863: 
            case 864: 
            case 865: 
            case 1111: 
            case 1112: 
            case 1122: 
            case 1123: {
                if (!DSector.check_activator_motion(lotag)) break;
                return false;
            }
            default: {
                if (DSector.isadoorwall(picnum)) break;
                return false;
            }
        }
        block30: for (ListNode<Sprite> node = Main.boardService.getStatNode(0); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            if (lotag != sp.getLotag()) continue;
            switch (sp.getPicnum()) {
                case 162: 
                case 166: 
                case 1142: {
                    if (switchtype == 1 && w == node.getIndex()) {
                        sp.setPicnum(sp.getPicnum() + 1);
                    } else if (sp.getHitag() == 0) {
                        ++correctdips;
                    }
                    ++numdips;
                    continue block30;
                }
                case 163: 
                case 167: 
                case 1143: {
                    if (switchtype == 1 && w == node.getIndex()) {
                        sp.setPicnum(sp.getPicnum() - 1);
                    } else if (sp.getHitag() == 1) {
                        ++correctdips;
                    }
                    ++numdips;
                    continue block30;
                }
                case 146: 
                case 147: 
                case 148: 
                case 149: {
                    sp.setPicnum(sp.getPicnum() + 1);
                    if (sp.getPicnum() <= 149) continue block30;
                    sp.setPicnum(146);
                    continue block30;
                }
                case 130: 
                case 132: 
                case 134: 
                case 136: 
                case 138: 
                case 140: 
                case 164: 
                case 168: 
                case 170: 
                case 712: 
                case 860: 
                case 862: 
                case 864: 
                case 1111: 
                case 1122: {
                    sp.setPicnum(sp.getPicnum() + 1);
                    continue block30;
                }
                case 133: 
                case 135: 
                case 137: 
                case 139: 
                case 141: 
                case 165: 
                case 169: 
                case 713: 
                case 861: 
                case 863: 
                case 865: 
                case 1112: 
                case 1123: {
                    sp.setPicnum(sp.getPicnum() - 1);
                }
            }
        }
        block31: for (int i = 0; i < Main.boardService.getWallCount(); ++i) {
            Wall wal = Main.boardService.getWall(i);
            if (wal == null || lotag != wal.getLotag()) continue;
            switch (wal.getPicnum()) {
                case 162: 
                case 166: 
                case 1142: {
                    if (switchtype == 0 && i == w) {
                        wal.setPicnum(wal.getPicnum() + 1);
                    } else if (wal.getHitag() == 0) {
                        ++correctdips;
                    }
                    ++numdips;
                    continue block31;
                }
                case 163: 
                case 167: 
                case 1143: {
                    if (switchtype == 0 && i == w) {
                        wal.setPicnum(wal.getPicnum() - 1);
                    } else if (wal.getHitag() == 1) {
                        ++correctdips;
                    }
                    ++numdips;
                    continue block31;
                }
                case 146: 
                case 147: 
                case 148: 
                case 149: {
                    wal.setPicnum(wal.getPicnum() + 1);
                    if (wal.getPicnum() <= 149) continue block31;
                    wal.setPicnum(146);
                    continue block31;
                }
                case 130: 
                case 132: 
                case 134: 
                case 136: 
                case 138: 
                case 164: 
                case 168: 
                case 170: 
                case 712: 
                case 860: 
                case 862: 
                case 864: 
                case 1111: 
                case 1122: {
                    wal.setPicnum(wal.getPicnum() + 1);
                    continue block31;
                }
                case 133: 
                case 135: 
                case 137: 
                case 139: 
                case 165: 
                case 169: 
                case 713: 
                case 861: 
                case 863: 
                case 865: 
                case 1112: 
                case 1123: {
                    wal.setPicnum(wal.getPicnum() - 1);
                }
            }
        }
        if (lotag == -1) {
            Premap.LeaveMap();
            if (Globals.ud.from_bonus != 0) {
                Globals.ud.level_number = Globals.ud.from_bonus;
                Globals.ud.from_bonus = 0;
            } else {
                ++Globals.ud.level_number;
            }
            return true;
        }
        boolean b = picnum == 162 || picnum == 163 || picnum == 1142 || picnum == 1143 || picnum == 166 || picnum == 167;
        switch (picnum) {
            default: {
                if (!DSector.isadoorwall(picnum)) break;
            }
            case 162: 
            case 163: 
            case 166: 
            case 167: 
            case 1142: 
            case 1143: {
                if (b) {
                    if (picnum == 1142 || picnum == 1143) {
                        if (switchtype == 1) {
                            Sounds.xyzsound(272, w, sx, sy, Globals.ps[snum].posz);
                        } else {
                            Sounds.xyzsound(272, Globals.ps[snum].i, sx, sy, Globals.ps[snum].posz);
                        }
                    } else if (switchtype == 1) {
                        Sounds.xyzsound(76, w, sx, sy, Globals.ps[snum].posz);
                    } else {
                        Sounds.xyzsound(76, Globals.ps[snum].i, sx, sy, Globals.ps[snum].posz);
                    }
                    if (numdips != correctdips) break;
                    Sounds.xyzsound(83, Globals.ps[snum].i, sx, sy, Globals.ps[snum].posz);
                }
            }
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 164: 
            case 165: 
            case 168: 
            case 169: 
            case 170: 
            case 712: 
            case 713: 
            case 860: 
            case 861: 
            case 862: 
            case 863: 
            case 864: 
            case 865: 
            case 1111: 
            case 1112: 
            case 1122: 
            case 1123: {
                if (picnum == 146 || picnum == 147 || picnum == 148 || picnum == 149) {
                    lotag += picnum - 146;
                }
                block32: for (ListNode<Sprite> nx = Main.boardService.getStatNode(3); nx != null; nx = nx.getNext()) {
                    Sprite sp = nx.get();
                    int x = nx.getIndex();
                    if (sp.getHitag() != lotag) continue;
                    switch (sp.getLotag()) {
                        case 12: {
                            Sector sec = Main.boardService.getSector(sp.getSectnum());
                            if (sec != null) {
                                sec.setFloorpal(0);
                            }
                            Globals.hittype[x].temp_data[0] = Globals.hittype[x].temp_data[0] + 1;
                            if (Globals.hittype[x].temp_data[0] != 2) continue block32;
                            Globals.hittype[x].temp_data[0] = Globals.hittype[x].temp_data[0] + 1;
                            continue block32;
                        }
                        case 24: 
                        case 25: 
                        case 34: {
                            Globals.hittype[x].temp_data[4] = Globals.hittype[x].temp_data[4] ^ 1;
                            if (Globals.hittype[x].temp_data[4] != 0) {
                                View.FTA(15, Globals.ps[snum]);
                                continue block32;
                            }
                            View.FTA(2, Globals.ps[snum]);
                            continue block32;
                        }
                        case 21: {
                            View.FTA(2, Globals.ps[Globals.screenpeek]);
                        }
                    }
                }
                DSector.operateactivators(lotag, snum);
                DSector.operateforcefields(Globals.ps[snum].i, lotag);
                DSector.operatemasterswitches(lotag);
                if (b) {
                    return true;
                }
                if (hitag == 0 && !DSector.isadoorwall(picnum)) {
                    if (switchtype == 1) {
                        Sounds.xyzsound(76, w, sx, sy, Globals.ps[snum].posz);
                    } else {
                        Sounds.xyzsound(76, Globals.ps[snum].i, sx, sy, Globals.ps[snum].posz);
                    }
                } else if (hitag != 0 && hitag < 500) {
                    if (switchtype == 1 && (Globals.currentGame.getCON().soundm[hitag] & 4) == 0) {
                        Sounds.xyzsound(hitag, w, sx, sy, Globals.ps[snum].posz);
                    } else {
                        Sounds.spritesound(hitag, Globals.ps[snum].i);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static void activatebysector(int sect, int j) {
        boolean didit = false;
        for (ListNode<Sprite> node = Main.boardService.getSectNode(sect); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            if (sp.getPicnum() != 2) continue;
            DSector.operateactivators(sp.getLotag(), -1);
            didit = true;
        }
        if (!didit) {
            DSector.operatesectors(sect, j);
        }
    }

    public static void checkplayerhurt(PlayerStruct p, int moveHit) {
        if ((moveHit & 0xE0000000) == -1073741824) {
            Sprite hsp = Main.boardService.getSprite(moveHit &= 0x1FFFFFFF);
            if (hsp != null && hsp.getPicnum() == 911 && p.hurt_delay < 8) {
                Sprite psp = Main.boardService.getSprite(p.i);
                if (psp != null) {
                    psp.setExtra(psp.getExtra() - 5);
                }
                p.hurt_delay = (short)16;
                p.pals_time = 32;
                p.pals[0] = 32;
                p.pals[1] = 0;
                p.pals[2] = 0;
                Sounds.spritesound(211, p.i);
            }
            return;
        }
        if ((moveHit & 0xE0000000) != Integer.MIN_VALUE) {
            return;
        }
        Wall hw = Main.boardService.getWall(moveHit &= 0x1FFFFFFF);
        if (hw == null) {
            return;
        }
        Sprite psp = Main.boardService.getSprite(p.i);
        if (psp == null) {
            return;
        }
        if (p.hurt_delay > 0) {
            p.hurt_delay = (short)(p.hurt_delay - 1);
        } else if ((hw.getCstat() & 0x55) != 0) {
            switch (hw.getOverpicnum()) {
                case 663: 
                case 664: 
                case 665: {
                    psp.setExtra(psp.getExtra() - 5);
                    p.hurt_delay = (short)16;
                    p.pals_time = 32;
                    p.pals[0] = 32;
                    p.pals[1] = 0;
                    p.pals[2] = 0;
                    if (Main.IsOriginalDemo()) {
                        p.posxv = -(EngineUtils.cos((int)p.ang & 0x7FF) << 8);
                        p.posyv = -(EngineUtils.sin((int)p.ang & 0x7FF) << 8);
                        Sounds.spritesound(211, p.i);
                        DSector.checkhitwall(p.i, moveHit, p.posx + (EngineUtils.cos((int)p.ang & 0x7FF) >> 9), p.posy + (EngineUtils.sin((int)p.ang & 0x7FF) >> 9), p.posz, -1);
                        break;
                    }
                    p.posxv = (int)(-(ru.m210projects.Build.Gameutils.BCosAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)) * 256.0));
                    p.posyv = (int)(-(ru.m210projects.Build.Gameutils.BSinAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)) * 256.0));
                    Sounds.spritesound(211, p.i);
                    DSector.checkhitwall(p.i, moveHit, (int)((double)p.posx + ru.m210projects.Build.Gameutils.BCosAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)) / 512.0), (int)((double)p.posy + ru.m210projects.Build.Gameutils.BSinAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)) / 512.0), p.posz, -1);
                    break;
                }
                case 230: {
                    p.hurt_delay = (short)26;
                    if (Main.IsOriginalDemo()) {
                        DSector.checkhitwall(p.i, moveHit, p.posx + (EngineUtils.sin((int)p.ang + 512 & 0x7FF) >> 9), p.posy + (EngineUtils.sin((int)p.ang & 0x7FF) >> 9), p.posz, -1);
                        break;
                    }
                    DSector.checkhitwall(p.i, moveHit, (int)((double)p.posx + ru.m210projects.Build.Gameutils.BCosAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)) / 512.0), (int)((double)p.posy + ru.m210projects.Build.Gameutils.BSinAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)) / 512.0), p.posz, -1);
                }
            }
        }
    }

    public static void allignwarpelevators() {
        for (ListNode<Sprite> ni = Main.boardService.getStatNode(3); ni != null; ni = ni.getNext()) {
            Sprite sp = ni.get();
            if (sp.getLotag() != 17 || sp.getShade() <= 16) continue;
            for (ListNode<Sprite> node = Main.boardService.getStatNode(3); node != null; node = node.getNext()) {
                Sprite sp2 = node.get();
                if (sp2.getLotag() != 17 || ni.getIndex() == node.getIndex() || sp.getHitag() != sp2.getHitag()) continue;
                Sector sec = Main.boardService.getSector(sp.getSectnum());
                Sector sec2 = Main.boardService.getSector(sp2.getSectnum());
                if (sec == null || sec2 == null) continue;
                sec2.setFloorz(sec.getFloorz());
                sec2.setCeilingz(sec.getCeilingz());
            }
        }
    }

    public static void breakwall(int newpn, int spr, int dawallnum) {
        Wall wal = Main.boardService.getWall(dawallnum);
        if (wal != null) {
            wal.setPicnum((short)newpn);
            Sounds.spritesound(18, spr);
            Sounds.spritesound(20, spr);
            Spawn.lotsofglass(spr, dawallnum, 10);
        }
    }

    public static void checkhitwall(int spr, int dawallnum, int x, int y, int z, int atwith) {
        Wall wal = Main.boardService.getWall(dawallnum);
        if (wal == null) {
            return;
        }
        if (wal.getOverpicnum() == 560) {
            switch (atwith) {
                case 26: 
                case 981: 
                case 1079: 
                case 1238: 
                case 1247: 
                case 1670: 
                case 2605: {
                    Spawn.lotsofglass(spr, dawallnum, 70);
                    wal.setCstat(wal.getCstat() & 0xFFFFFFEF);
                    wal.setOverpicnum(70);
                    Sounds.spritesound(20, spr);
                    return;
                }
            }
        }
        Sector nsec = Main.boardService.getSector(wal.getNextsector());
        if (((wal.getCstat() & 0x10) != 0 || wal.getOverpicnum() == 230) && nsec != null && nsec.getFloorz() > z && nsec.getFloorz() - nsec.getCeilingz() != 0) {
            switch (wal.getOverpicnum()) {
                case 663: 
                case 664: 
                case 665: {
                    wal.setExtra(1);
                }
                case 230: {
                    Sprite sp;
                    int sn = Main.engine.updatesector(x, y, -1);
                    if (sn < 0) {
                        return;
                    }
                    int i = -1;
                    if (atwith == -1) {
                        i = Spawn.EGS(sn, x, y, z, 1671, -127, 8, 8, 0, 0, 0, spr, 5);
                    } else if (atwith == 2536) {
                        sp = Main.boardService.getSprite(spr);
                        if (sp != null) {
                            i = Spawn.EGS(sn, x, y, z, 1671, -127, 16 + sp.getXrepeat(), 16 + sp.getYrepeat(), 0, 0, 0, spr, 5);
                        }
                    } else {
                        i = Spawn.EGS(sn, x, y, z, 1671, -127, 32, 32, 0, 0, 0, spr, 5);
                    }
                    sp = Main.boardService.getSprite(i);
                    if (sp != null) {
                        sp.setCstat(sp.getCstat() | 0x92);
                        sp.setAng(wal.getWallAngle() - 512);
                        Sounds.spritesound(35, i);
                    }
                    return;
                }
                case 407: {
                    wal.setOverpicnum(411);
                    wal.setCstat(wal.getCstat() & 0xFFBE);
                    Wall nw = Main.boardService.getWall(wal.getNextwall());
                    if (nw != null) {
                        nw.setOverpicnum(411);
                        nw.setCstat(nw.getCstat() & 0xFFBE);
                    }
                    Sounds.spritesound(18, spr);
                    Sounds.spritesound(19, spr);
                    return;
                }
                case 503: {
                    int i;
                    Sprite sp;
                    int sn = Main.engine.updatesector(x, y, -1);
                    if (sn < 0) {
                        return;
                    }
                    wal.setOverpicnum(504);
                    Spawn.lotsofglass(spr, dawallnum, 10);
                    wal.setCstat(0);
                    Wall nw = Main.boardService.getWall(wal.getNextwall());
                    if (nw != null) {
                        nw.setCstat(0);
                    }
                    if ((sp = Main.boardService.getSprite(i = Spawn.EGS(sn, x, y, z, 1, 0, 0, 0, (short)Globals.ps[0].ang, 0, 0, spr, 3))) != null) {
                        sp.setLotag(128);
                        Globals.hittype[i].temp_data[1] = 5;
                        Globals.hittype[i].temp_data[2] = dawallnum;
                        Sounds.spritesound(19, i);
                    }
                    return;
                }
                case 510: {
                    int sn = Main.engine.updatesector(x, y, -1);
                    if (sn < 0) {
                        return;
                    }
                    Spawn.lotsofcolourglass(spr, dawallnum, 80);
                    wal.setCstat(0);
                    Wall nw = Main.boardService.getWall(wal.getNextwall());
                    if (nw != null) {
                        nw.setCstat(0);
                    }
                    Sounds.spritesound(18, spr);
                    Sounds.spritesound(19, spr);
                    return;
                }
            }
        }
        switch (wal.getPicnum()) {
            case 1212: 
            case 1215: {
                DSector.breakwall(wal.getPicnum() + 2, spr, dawallnum);
                Sounds.spritesound(18, spr);
                return;
            }
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 806: 
            case 1289: 
            case 1298: 
            case 3370: 
            case 4120: 
            case 4123: 
            case 4125: 
            case 4127: 
            case 4128: 
            case 4129: {
                Spawn.lotsofglass(spr, dawallnum, 30);
                wal.setPicnum((short)(357 + Main.engine.krand() % 3));
                Sounds.spritesound(20, spr);
                return;
            }
            case 4134: 
            case 4136: 
            case 4138: 
            case 4140: 
            case 4142: {
                DSector.breakwall(wal.getPicnum() + 1, spr, dawallnum);
                return;
            }
            case 4181: {
                DSector.breakwall(4203, spr, dawallnum);
                return;
            }
            case 306: {
                DSector.breakwall(4145, spr, dawallnum);
                return;
            }
            case 293: 
            case 4130: 
            case 4131: 
            case 4132: 
            case 4133: {
                DSector.breakwall(363, spr, dawallnum);
                return;
            }
            case 299: {
                DSector.breakwall(4147, spr, dawallnum);
                return;
            }
            case 307: {
                DSector.breakwall(4144, spr, dawallnum);
                return;
            }
            case 297: {
                DSector.breakwall(362, spr, dawallnum);
                return;
            }
            case 301: {
                DSector.breakwall(360, spr, dawallnum);
                return;
            }
            case 305: {
                DSector.breakwall(361, spr, dawallnum);
                return;
            }
            case 867: {
                wal.setPicnum(888);
                Spawn.lotsofmoney(Main.boardService.getSprite(spr), 1 + (Main.engine.krand() & 7));
                Sounds.spritesound(20, spr);
                break;
            }
            case 120: 
            case 122: 
            case 124: 
            case 701: 
            case 703: 
            case 705: {
                if (Gameutils.rnd(128)) {
                    Sounds.spritesound(20, spr);
                } else {
                    Sounds.spritesound(19, spr);
                }
                Spawn.lotsofglass(spr, dawallnum, 30);
                if (wal.getPicnum() == 703) {
                    wal.setPicnum(704);
                }
                if (wal.getPicnum() == 705) {
                    wal.setPicnum(706);
                }
                if (wal.getPicnum() == 701) {
                    wal.setPicnum(702);
                }
                if (wal.getPicnum() == 124) {
                    wal.setPicnum(125);
                }
                if (wal.getPicnum() == 120) {
                    wal.setPicnum(121);
                }
                if (wal.getPicnum() == 122) {
                    wal.setPicnum(123);
                }
                if (wal.getLotag() == 0) {
                    return;
                }
                short sn = wal.getNextsector();
                Sector sec = Main.boardService.getSector(sn);
                if (sec == null) {
                    return;
                }
                byte darkestwall = 0;
                for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                    Wall wal2 = wn.get();
                    if (wal2 == null || wal2.getShade() <= darkestwall) continue;
                    darkestwall = wal2.getShade();
                }
                int j = Main.engine.krand() & 1;
                for (ListNode<Sprite> ni = Main.boardService.getStatNode(3); ni != null; ni = ni.getNext()) {
                    Sprite sp = ni.get();
                    if (sp.getHitag() != wal.getLotag() || sp.getLotag() != 3) continue;
                    int i = ni.getIndex();
                    Globals.hittype[i].temp_data[2] = j;
                    Globals.hittype[i].temp_data[3] = darkestwall;
                    Globals.hittype[i].temp_data[4] = 1;
                }
                break;
            }
        }
    }

    public static void checkhitceiling(int sn) {
        Sector sec = Main.boardService.getSector(sn);
        if (sec == null) {
            return;
        }
        switch (sec.getCeilingpicnum()) {
            case 120: 
            case 122: 
            case 124: 
            case 701: 
            case 703: 
            case 705: {
                Spawn.ceilingglass(Globals.ps[Mmulti.myconnectindex].i, sn, 10);
                Sounds.spritesound(19, Globals.ps[Globals.screenpeek].i);
                if (sec.getCeilingpicnum() == 703) {
                    sec.setCeilingpicnum(704);
                }
                if (sec.getCeilingpicnum() == 705) {
                    sec.setCeilingpicnum(706);
                }
                if (sec.getCeilingpicnum() == 701) {
                    sec.setCeilingpicnum(702);
                }
                if (sec.getCeilingpicnum() == 124) {
                    sec.setCeilingpicnum(125);
                }
                if (sec.getCeilingpicnum() == 120) {
                    sec.setCeilingpicnum(121);
                }
                if (sec.getCeilingpicnum() == 122) {
                    sec.setCeilingpicnum(123);
                }
                if (sec.getHitag() == 0) {
                    for (ListNode<Sprite> node = Main.boardService.getSectNode(sn); node != null; node = node.getNext()) {
                        Sprite sp = node.get();
                        if (sp.getPicnum() != 1 || sp.getLotag() != 12) continue;
                        for (ListNode<Sprite> n = Main.boardService.getStatNode(3); n != null; n = n.getNext()) {
                            if (n.get().getHitag() != sp.getHitag()) continue;
                            Globals.hittype[n.getIndex()].temp_data[3] = 1;
                        }
                        break;
                    }
                }
                int j = Main.engine.krand() & 1;
                for (ListNode<Sprite> ni = Main.boardService.getStatNode(3); ni != null; ni = ni.getNext()) {
                    Sprite sp = ni.get();
                    if (sp.getHitag() != sec.getHitag() || sp.getLotag() != 3) continue;
                    int i = ni.getIndex();
                    Globals.hittype[i].temp_data[2] = j;
                    Globals.hittype[i].temp_data[4] = 1;
                }
                break;
            }
        }
    }

    public static void checkhitsprite(int i, int sn) {
        Sprite s = Main.boardService.getSprite(i);
        if (s == null) {
            return;
        }
        switch (s.getPicnum()) {
            case 971: 
            case 972: 
            case 973: 
            case 974: 
            case 975: {
                Spawn.spawn(i, 2329);
                Main.engine.deletesprite(i);
                break;
            }
            case 901: 
            case 902: {
                Sprite sp = Main.boardService.getSprite(sn);
                if (sp == null) break;
                if (sp.getPicnum() == 902 || sp.getPicnum() == 901) {
                    sp.setXvel((short)((s.getXvel() >> 1) + (s.getXvel() >> 2)));
                    sp.setAng(sp.getAng() - ((s.getAng() << 1) + 1024));
                    s.setAng((short)(EngineUtils.getAngle(s.getX() - sp.getX(), s.getY() - sp.getY()) - 512));
                    if (Globals.Sound[8].getSoundOwnerCount() >= 2) break;
                    Sounds.spritesound(8, i);
                    break;
                }
                if ((Main.engine.krand() & 3) != 0) {
                    s.setXvel(164);
                    s.setAng(sp.getAng());
                    break;
                }
                Spawn.lotsofglass(i, -1, 3);
                Main.engine.deletesprite(i);
                break;
            }
            case 908: 
            case 910: 
            case 951: 
            case 978: 
            case 990: {
                Sprite sp = Main.boardService.getSprite(sn);
                if (sp == null) break;
                switch (sp.getPicnum()) {
                    case 26: 
                    case 981: 
                    case 1625: 
                    case 1670: 
                    case 2605: {
                        if (Globals.hittype[i].temp_data[0] != 0) break;
                        s.setCstat(s.getCstat() & 0xFFFFFEFE);
                        Globals.hittype[i].temp_data[0] = 1;
                        Spawn.spawn(i, 2270);
                    }
                }
                break;
            }
            case 911: {
                Sprite sp = Main.boardService.getSprite(sn);
                if (sp == null) break;
                switch (sp.getPicnum()) {
                    case 26: 
                    case 981: 
                    case 1625: 
                    case 1670: 
                    case 2605: {
                        for (int k = 0; k < 64; ++k) {
                            int vz = -(Main.engine.krand() & 0xFFF) - (s.getZvel() >> 2);
                            int ve = (Main.engine.krand() & 0x3F) + 64;
                            int va = Main.engine.krand() & 0x7FF;
                            int pn = 2408 + (Main.engine.krand() & 3);
                            int j = Spawn.EGS(s.getSectnum(), s.getX(), s.getY(), s.getZ() - Main.engine.krand() % 12288, pn, -8, 48, 48, va, ve, vz, i, 5);
                            Sprite sj = Main.boardService.getSprite(j);
                            if (sj == null) continue;
                            sj.setPal(8);
                        }
                        if (s.getPicnum() == 911) {
                            s.setPicnum(939);
                        }
                        s.setCstat(s.getCstat() & 0xFFFFFEFE);
                    }
                }
                break;
            }
            case 979: 
            case 4465: {
                for (int k = 0; k < 6; ++k) {
                    int vz = -(Main.engine.krand() & 0xFFF) - (s.getZvel() >> 2);
                    int ve = (Main.engine.krand() & 0x3F) + 64;
                    int va = Main.engine.krand() & 0x7FF;
                    Spawn.EGS(s.getSectnum(), s.getX(), s.getY(), s.getZ() - 2048, 2400 + (Main.engine.krand() & 0xF), -8, 48, 48, va, ve, vz, i, 5);
                }
                Sounds.spritesound(20, i);
                Main.engine.deletesprite(i);
                break;
            }
            case 407: {
                s.setPicnum(411);
                s.setCstat(s.getCstat() & 0xFEFE);
                Sector sec = Main.boardService.getSector(s.getSectnum());
                if (sec != null && sec.getFloorpicnum() == 412) {
                    sec.setFloorpicnum(416);
                }
                Sounds.spritesound(20, i);
                for (int j = 0; j < 16; ++j) {
                    Gameutils.RANDOMSCRAP(s, i);
                }
                break;
            }
            case 563: 
            case 564: 
            case 565: 
            case 566: {
                s.setPicnum(567);
                Spawn.spawn(i, 921);
                break;
            }
            case 516: 
            case 517: 
            case 602: 
            case 607: {
                Sprite sp = Main.boardService.getSprite(sn);
                if (sp == null || sp.getExtra() == Globals.currentGame.getCON().script[Globals.currentGame.getCON().actorscrptr[2595]]) break;
                for (int j = 0; j < 15; ++j) {
                    int vz = -(Main.engine.krand() & 0x1FF) - 256;
                    int ve = (Main.engine.krand() & 0x7F) + 64;
                    int va = Main.engine.krand() & 0x7FF;
                    Sector sec = Main.boardService.getSector(s.getSectnum());
                    if (sec == null) continue;
                    Spawn.EGS(s.getSectnum(), s.getX(), s.getY(), sec.getFloorz() - 3072 - (j << 9), 2400 + (Main.engine.krand() & 0xF), -8, 64, 64, va, ve, vz, i, 5);
                }
                Spawn.spawn(i, 1890);
                Main.engine.deletesprite(i);
                break;
            }
            case 551: 
            case 567: 
            case 716: 
            case 753: 
            case 765: 
            case 768: 
            case 769: 
            case 774: 
            case 779: 
            case 792: 
            case 869: 
            case 954: 
            case 955: 
            case 956: 
            case 957: 
            case 1012: 
            case 1013: 
            case 1014: 
            case 1157: 
            case 1158: 
            case 1159: 
            case 1160: 
            case 1161: 
            case 1162: 
            case 1163: 
            case 1164: 
            case 1165: 
            case 1166: {
                if (s.getPicnum() == 1157) {
                    Spawn.lotsofmoney(s, 4 + (Main.engine.krand() & 3));
                } else if (s.getPicnum() == 753 || s.getPicnum() == 869) {
                    Spawn.lotsofcolourglass(i, -1, 40);
                    Sounds.spritesound(20, i);
                } else if (s.getPicnum() == 765) {
                    Spawn.lotsofglass(i, -1, 40);
                }
                Sounds.spritesound(19, i);
                s.setAng((short)(Main.engine.krand() & 0x7FF));
                Spawn.lotsofglass(i, -1, 8);
                Main.engine.deletesprite(i);
                break;
            }
            case 1358: {
                s.setPicnum(1359);
                Sounds.spritesound(19, i);
                Spawn.lotsofglass(i, -1, 10);
                break;
            }
            case 1359: {
                for (int j = 0; j < 48; ++j) {
                    Weapons.shoot(i, 2296);
                    s.setAng(s.getAng() + 333);
                }
                Sounds.spritesound(20, i);
                Sounds.spritesound(69, i);
            }
            case 1025: {
                Sounds.spritesound(19, i);
                Spawn.lotsofglass(i, -1, 10);
                Main.engine.deletesprite(i);
                break;
            }
            case 969: {
                s.setPicnum(1003);
                Sounds.spritesound(19, i);
                Spawn.lotsofglass(i, -1, 10);
                break;
            }
            case 2590: {
                s.setXrepeat(0);
                Globals.hittype[s.getOwner()].temp_data[0] = 32;
                Globals.hittype[s.getOwner()].temp_data[1] = Globals.hittype[s.getOwner()].temp_data[1] ^ 1;
                Globals.hittype[s.getOwner()].temp_data[2] = Globals.hittype[s.getOwner()].temp_data[2] + 1;
                Spawn.spawn(i, 1890);
                break;
            }
            case 1003: {
                if ((s.getCstat() & 1) == 0) break;
                Sounds.spritesound(19, i);
                s.setZ(s.getZ() + 4096);
                s.setCstat(0);
                Spawn.lotsofglass(i, -1, 5);
                break;
            }
            case 569: {
                s.setPicnum(615);
                s.setCstat(s.getCstat() | (Main.engine.krand() & 1) << 2);
                s.setCstat(s.getCstat() & 0xFFFFFEFE);
                Spawn.spawn(i, 921);
                Sounds.spritesound(19, i);
                break;
            }
            case 571: {
                s.setPicnum(573);
                s.setCstat(s.getCstat() | (Main.engine.krand() & 1) << 2);
                s.setCstat(s.getCstat() & 0xFFFFFEFE);
                Spawn.spawn(i, 921);
                Sounds.spritesound(20, i);
                break;
            }
            case 981: {
                s.setPicnum(950);
                Spawn.spawn(i, 921);
                Sounds.spritesound(20, i);
                break;
            }
            case 595: {
                s.setPicnum(596);
                s.setCstat(s.getCstat() & 0xFEFE);
                Sounds.spritesound(18, i);
                break;
            }
            case 1113: {
                s.setPicnum(1114);
                s.setCstat(s.getCstat() & 0xFEFE);
                Sounds.spritesound(18, i);
                break;
            }
            case 342: 
            case 343: {
                s.setPicnum(341);
                s.setCstat(s.getCstat() & 0xFEFE);
                Sounds.spritesound(18, i);
                break;
            }
            case 4099: {
                s.setPicnum(4100);
                s.setCstat(s.getCstat() & 0xFEFE);
                Sounds.spritesound(18, i);
                break;
            }
            case 616: 
            case 618: 
            case 619: 
            case 994: 
            case 995: 
            case 996: {
                switch (s.getPicnum()) {
                    case 619: {
                        s.setPicnum(617);
                        break;
                    }
                    case 616: {
                        s.setPicnum(633);
                        break;
                    }
                    case 618: {
                        s.setPicnum(700);
                        break;
                    }
                    case 996: {
                        s.setPicnum(997);
                        break;
                    }
                    case 994: {
                        s.setPicnum(1005);
                        break;
                    }
                    case 995: {
                        s.setPicnum(1260);
                    }
                }
                Sprite ssp = Main.boardService.getSprite(Spawn.spawn(i, 1250));
                Sector sec = Main.boardService.getSector(s.getSectnum());
                if (ssp == null || sec == null) break;
                ssp.setZ(sec.getFloorz() - 8192);
                break;
            }
            case 1352: 
            case 1354: 
            case 1355: 
            case 4943: {
                Sounds.spritesound(s.getLotag(), i);
                Spawn.spawn(i, s.getHitag());
            }
            case 1353: {
                Sprite sp = Main.boardService.getSprite(sn);
                if (sp == null) break;
                s.setExtra(s.getExtra() - sp.getExtra());
                if (s.getExtra() > 0) break;
                s.setAng((short)(Main.engine.krand() & 0x7FF));
                Weapons.shoot(i, 2296);
                s.setAng((short)(Main.engine.krand() & 0x7FF));
                Weapons.shoot(i, 2298);
                s.setAng((short)(Main.engine.krand() & 0x7FF));
                Weapons.shoot(i, 2297);
                s.setAng((short)(Main.engine.krand() & 0x7FF));
                Weapons.shoot(i, 2299);
                s.setAng((short)(Main.engine.krand() & 0x7FF));
                Weapons.shoot(i, 2296);
                s.setAng((short)(Main.engine.krand() & 0x7FF));
                Weapons.shoot(i, 2298);
                s.setAng((short)(Main.engine.krand() & 0x7FF));
                Weapons.shoot(i, 2297);
                s.setAng((short)(Main.engine.krand() & 0x7FF));
                Weapons.shoot(i, 2299);
                Spawn.guts(s, 2245, 1, Mmulti.myconnectindex);
                Spawn.guts(s, 2250, 2, Mmulti.myconnectindex);
                Spawn.guts(s, 2255, 3, Mmulti.myconnectindex);
                Spawn.guts(s, 2260, 4, Mmulti.myconnectindex);
                Spawn.guts(s, 2265, 1, Mmulti.myconnectindex);
                Spawn.guts(s, 2255, 6, Mmulti.myconnectindex);
                Sounds.sound(69);
                Main.engine.deletesprite(i);
                break;
            }
            case 556: 
            case 557: {
                s.setPicnum(559);
                s.setCstat(0);
                break;
            }
            case 669: 
            case 678: 
            case 680: 
            case 685: 
            case 686: 
            case 689: 
            case 694: 
            case 695: 
            case 697: 
            case 4444: {
                Sounds.spritesound(20, i);
                for (int j = 0; j < 16; ++j) {
                    Gameutils.RANDOMSCRAP(s, i);
                }
                Main.engine.deletesprite(i);
                break;
            }
            case 1420: {
                i = s.getOwner();
                s = Main.boardService.getSprite(i);
                if (s == null) {
                    return;
                }
            }
            default: {
                Sprite sp;
                if ((s.getCstat() & 0x10) != 0 && s.getHitag() == 0 && s.getLotag() == 0 && s.getStatnum() == 0 || (sp = Main.boardService.getSprite(sn)) == null || sp.getPicnum() != 1641 && sp.getOwner() == i || s.getStatnum() == 4) break;
                if (Actors.badguy(s)) {
                    Sprite sj;
                    int j;
                    if (s.getPicnum() == 5180 && s.getXrepeat() < 48) break;
                    if (sp.getPicnum() == 2605) {
                        sp.setExtra(sp.getExtra() << 1);
                    }
                    if (s.getPicnum() != 1880 && s.getPicnum() != 2360 && s.getPicnum() != 1920 && (s.getPicnum() < 2370 || s.getPicnum() > 2377) && sp.getPicnum() != 1641 && Globals.currentGame.getCON().actortype[s.getPicnum()] == 0) {
                        j = Spawn.spawn(sn, 2286);
                        sj = Main.boardService.getSprite(j);
                        if (sj == null) {
                            return;
                        }
                        if (sp.getPal() == 6) {
                            sj.setPal(6);
                        }
                        sj.setZ(sj.getZ() + 1024);
                        sj.setXvel(16);
                        sj.setXrepeat(24);
                        sj.setYrepeat(24);
                        sj.setAng(sj.getAng() + 32 - (Main.engine.krand() & 0x3F));
                    }
                    if ((sj = Main.boardService.getSprite(j = sp.getOwner())) != null && sj.getPicnum() == 1405 && s.getPicnum() != 2360 && s.getPicnum() != 1880 && Globals.ps[sj.getYvel()].curr_weapon == 2) {
                        Weapons.shoot(i, 2297);
                        Weapons.shoot(i, 2296);
                        Weapons.shoot(i, 2298);
                        Weapons.shoot(i, 2299);
                    }
                    if (s.getPicnum() != 1975 && !Spawn.bossguy(s.getPicnum()) && s.getPicnum() != 1960 && s.getPicnum() != 2360) {
                        if ((s.getCstat() & 0x30) == 0) {
                            s.setAng((short)(sp.getAng() + 1024 & 0x7FF));
                        }
                        s.setXvel((short)(-(sp.getExtra() << 2)));
                        short sectnum = s.getSectnum();
                        if (Main.boardService.isValidSprite(sectnum)) {
                            Main.engine.pushmove(s.getX(), s.getY(), s.getZ(), sectnum, 128, 1024, 1024, 65537);
                            s.setX(Engine.pushmove_x);
                            s.setY(Engine.pushmove_y);
                            s.setZ(Engine.pushmove_z);
                            sectnum = Engine.pushmove_sectnum;
                            if (sectnum != s.getSectnum()) {
                                Main.engine.changespritesect(i, sectnum);
                            }
                        }
                    }
                    if (s.getStatnum() == 2) {
                        Main.engine.changespritestat(i, 1);
                        Globals.hittype[i].timetosleep = 1536;
                    }
                    if ((s.getXrepeat() < 24 || s.getPicnum() == 1550) && sp.getPicnum() == 1646) {
                        return;
                    }
                }
                if (s.getStatnum() != 2) {
                    if (sp.getPicnum() == 1641 && (s.getPicnum() == 1405 && s.getPal() == 1 || Globals.currentGame.getCON().freezerhurtowner == '\u0000' && sp.getOwner() == i)) {
                        return;
                    }
                    int hitpic = sp.getPicnum();
                    Sprite so = Main.boardService.getSprite(sp.getOwner());
                    if (so != null && so.getPicnum() == 1405) {
                        if (s.getPicnum() == 1405 && Globals.ud.coop != 0 && Globals.ud.ffire == 0) {
                            return;
                        }
                        Sprite so2 = Main.boardService.getSprite(s.getOwner());
                        if (so2 != null && hitpic == 5163 && so2.getPicnum() != 5163) {
                            hitpic = 1891;
                        }
                    }
                    Globals.hittype[i].picnum = hitpic;
                    Globals.hittype[i].extra += sp.getExtra();
                    Globals.hittype[i].ang = sp.getAng();
                    Globals.hittype[i].owner = sp.getOwner();
                }
                if (s.getStatnum() != 10) break;
                short p = s.getYvel();
                if (Globals.ps[p].newowner >= 0) {
                    Globals.ps[p].newowner = (short)-1;
                    Globals.ps[p].posx = Globals.ps[p].oposx;
                    Globals.ps[p].posy = Globals.ps[p].oposy;
                    Globals.ps[p].posz = Globals.ps[p].oposz;
                    Globals.ps[p].ang = Globals.ps[p].oang;
                    System.err.println("a?");
                    Globals.ps[p].cursectnum = Main.engine.updatesector(Globals.ps[p].posx, Globals.ps[p].posy, Globals.ps[p].cursectnum);
                    Player.setpal(Globals.ps[p]);
                    for (ListNode<Sprite> node = Main.boardService.getStatNode(1); node != null; node = node.getNext()) {
                        Sprite sp1 = node.get();
                        if (sp1.getPicnum() != 621) continue;
                        sp1.setYvel(0);
                    }
                }
                if (s.getXrepeat() < 24 && sp.getPicnum() == 1646) {
                    return;
                }
                Sprite hso = Main.boardService.getSprite(Globals.hittype[i].owner);
                if (hso == null || hso.getPicnum() == 1405 || Globals.ud.player_skill < 3) break;
                sp.setExtra(sp.getExtra() + (sp.getExtra() >> 1));
                break;
            }
        }
    }

    public static void checksectors(int snum) {
        Sprite psp;
        PlayerStruct p = Globals.ps[snum];
        Sector psec = Main.boardService.getSector(p.cursectnum);
        if (psec != null) {
            switch (psec.getLotag()) {
                case 32767: {
                    psec.setLotag(0);
                    View.FTA(9, p);
                    Globals.ps[Mmulti.connecthead].secret_rooms = (short)(Globals.ps[Mmulti.connecthead].secret_rooms + 1);
                    return;
                }
                case -1: {
                    Premap.LeaveMap();
                    psec.setLotag(0);
                    if (Globals.ud.from_bonus != 0) {
                        Globals.ud.level_number = Globals.ud.from_bonus;
                        Globals.ud.from_bonus = 0;
                    } else {
                        ++Globals.ud.level_number;
                    }
                    return;
                }
                case -2: {
                    psec.setLotag(0);
                    p.timebeforeexit = (short)208;
                    p.customexitsound = psec.getHitag();
                    return;
                }
            }
            if (psec.getLotag() >= 10000 && psec.getLotag() < 16383) {
                if (snum == Globals.screenpeek || Globals.ud.coop == 1) {
                    Sounds.spritesound(psec.getLotag() - 10000, p.i);
                }
                psec.setLotag(0);
            }
        }
        if ((psp = Main.boardService.getSprite(p.i)) == null || psp.getExtra() <= 0) {
            return;
        }
        if (Globals.ud.cashman != 0 && (Globals.sync[snum].bits & 0x20000000) != 0) {
            Spawn.lotsofmoney(psp, 2);
        }
        if (p.newowner >= 0 && (Pragmas.klabs(Globals.sync[snum].svel) > 768 || Pragmas.klabs(Globals.sync[snum].fvel) > 768)) {
            DSector.CLEARCAMERAS(p, -1);
            return;
        }
        if ((Globals.sync[snum].bits & 0x20000000) == 0 && (Globals.sync[snum].bits & Integer.MIN_VALUE) == 0) {
            p.toggle_key_flag = 0;
        } else if (p.toggle_key_flag == 0) {
            Sprite hsp;
            Sector nsec;
            Sector pssec;
            if ((Globals.sync[snum].bits & Integer.MIN_VALUE) != 0) {
                if (p.newowner >= 0) {
                    DSector.CLEARCAMERAS(p, -1);
                }
                return;
            }
            Globals.neartagsprite = -1;
            p.toggle_key_flag = 1;
            int hit = Player.hitawall(p);
            int hitscanwall = Engine.pHitInfo.hitwall;
            Wall hwal = Main.boardService.getWall(hitscanwall);
            if (hit < 1280 && hwal != null && hwal.getOverpicnum() == 560 && hwal.getLotag() > 0 && Globals.Sound[hwal.getLotag()].getSoundOwnerCount() == 0 && snum == Globals.screenpeek) {
                Sounds.spritesound(hwal.getLotag(), p.i);
                return;
            }
            if (hwal != null && (hwal.getCstat() & 0x10) != 0 && hwal.getLotag() != 0) {
                return;
            }
            if (p.newowner >= 0) {
                Gameutils.neartag(p.oposx, p.oposy, p.oposz, psp.getSectnum(), (short)p.oang, 1280, 1);
            } else {
                Gameutils.neartag(p.posx, p.posy, p.posz, psp.getSectnum(), (short)p.oang, 1280, 1);
                if (Globals.neartagsprite == -1 && Globals.neartagwall == -1 && Globals.neartagsector == -1) {
                    Gameutils.neartag(p.posx, p.posy, p.posz + 2048, psp.getSectnum(), (short)p.oang, 1280, 1);
                }
                if (Globals.neartagsprite == -1 && Globals.neartagwall == -1 && Globals.neartagsector == -1) {
                    Gameutils.neartag(p.posx, p.posy, p.posz + 4096, psp.getSectnum(), (short)p.oang, 1280, 1);
                }
                if (Globals.neartagsprite == -1 && Globals.neartagwall == -1 && Globals.neartagsector == -1) {
                    Gameutils.neartag(p.posx, p.posy, p.posz + 4096, psp.getSectnum(), (short)p.oang, 1280, 3);
                    Sprite nsp = Main.boardService.getSprite(Globals.neartagsprite);
                    if (nsp != null) {
                        switch (nsp.getPicnum()) {
                            case 603: 
                            case 753: 
                            case 1294: 
                            case 1312: 
                            case 1317: 
                            case 1321: 
                            case 1323: 
                            case 1325: 
                            case 1334: 
                            case 1336: 
                            case 1395: 
                            case 3450: 
                            case 4864: 
                            case 4866: {
                                return;
                            }
                        }
                    }
                    Globals.neartagsprite = -1;
                    Globals.neartagwall = -1;
                    Globals.neartagsector = -1;
                }
            }
            if (p.newowner == -1 && Globals.neartagsprite == -1 && Globals.neartagsector == -1 && Globals.neartagwall == -1 && (pssec = Main.boardService.getSector(psp.getSectnum())) != null && DSector.isanunderoperator(pssec.getLotag())) {
                Globals.neartagsector = psp.getSectnum();
            }
            if ((nsec = Main.boardService.getSector(Globals.neartagsector)) != null && (nsec.getLotag() & 0x4000) != 0) {
                return;
            }
            if (Globals.neartagsprite == -1 && Globals.neartagwall == -1 && psec != null && psec.getLotag() == 2) {
                int oldz = Player.hitasprite(p.i);
                Globals.neartagsprite = Engine.pHitInfo.hitsprite;
                if (oldz > 1280) {
                    Globals.neartagsprite = -1;
                }
            }
            if ((hsp = Main.boardService.getSprite(Globals.neartagsprite)) != null) {
                if (DSector.checkhitswitch(snum, Globals.neartagsprite, 1)) {
                    return;
                }
                switch (hsp.getPicnum()) {
                    case 569: 
                    case 571: {
                        if (p.last_pissed_time == 0) {
                            if (Globals.ud.lockout == 0) {
                                Sounds.spritesound(28, p.i);
                            }
                            p.last_pissed_time = 5720;
                            p.transporter_hold = (short)58;
                            if (p.holster_weapon == 0) {
                                p.holster_weapon = 1;
                                p.weapon_pos = (short)-1;
                            }
                            if (psp.getExtra() <= Globals.currentGame.getCON().max_player_health - Globals.currentGame.getCON().max_player_health / 10) {
                                psp.setExtra(psp.getExtra() + Globals.currentGame.getCON().max_player_health / 10);
                                p.last_extra = psp.getExtra();
                            } else if (psp.getExtra() < Globals.currentGame.getCON().max_player_health) {
                                psp.setExtra((short)Globals.currentGame.getCON().max_player_health);
                            }
                        } else if (Globals.Sound[79].getSoundOwnerCount() == 0) {
                            Sounds.spritesound(79, p.i);
                        }
                        return;
                    }
                    case 142: {
                        Player.hitawall(p);
                        int j = Engine.pHitInfo.hitwall;
                        Wall hw = Main.boardService.getWall(j);
                        if (hw != null && hw.getOverpicnum() == 0 && Globals.hittype[Globals.neartagsprite].temp_data[0] == 0) {
                            Globals.hittype[Globals.neartagsprite].temp_data[0] = 1;
                            hsp.setOwner(p.i);
                            p.buttonpalette = hsp.getPal();
                            Globals.ud.secretlevel = p.buttonpalette != 0 ? (int)hsp.getLotag() : 0;
                        }
                        return;
                    }
                    case 563: {
                        if (Globals.hittype[Globals.neartagsprite].temp_data[0] != 1) {
                            Globals.hittype[Globals.neartagsprite].temp_data[0] = 1;
                            hsp.setOwner(p.i);
                            if (psp.getExtra() < Globals.currentGame.getCON().max_player_health) {
                                psp.setExtra(psp.getExtra() + 1);
                                Sounds.spritesound(36, p.i);
                            }
                        }
                        return;
                    }
                    case 1069: {
                        Sounds.spritesound(21, p.i);
                        psp.setExtra(psp.getExtra() - (2 + (Main.engine.krand() & 3)));
                        p.pals[0] = 48;
                        p.pals[1] = 48;
                        p.pals[2] = 64;
                        p.pals_time = 32;
                        break;
                    }
                    case 499: 
                    case 502: {
                        for (ListNode<Sprite> node = Main.boardService.getStatNode(1); node != null; node = node.getNext()) {
                            Sprite sp = node.get();
                            if (sp.getPicnum() != 621 || sp.getYvel() != 0 || hsp.getHitag() != sp.getLotag()) continue;
                            sp.setYvel(1);
                            Sounds.spritesound(212, Globals.neartagsprite);
                            hsp.setOwner(node.getIndex());
                            hsp.setYvel(1);
                            Globals.hittype[p.i].tempang = sp.getAng();
                            p.posx = sp.getX();
                            p.posy = sp.getY();
                            p.posz = sp.getZ();
                            p.ang = sp.getAng();
                            int j = p.cursectnum;
                            p.cursectnum = sp.getSectnum();
                            Player.setpal(p);
                            p.cursectnum = (short)j;
                            p.newowner = (short)node.getIndex();
                            return;
                        }
                        DSector.CLEARCAMERAS(p, -1);
                        return;
                    }
                }
            }
            if ((Globals.sync[snum].bits & 0x20000000) == 0) {
                return;
            }
            if (p.newowner >= 0) {
                DSector.CLEARCAMERAS(p, -1);
                return;
            }
            if (Globals.neartagwall == -1 && Globals.neartagsector == -1 && Globals.neartagsprite == -1 && Pragmas.klabs(Player.hits(p.i)) < 512) {
                if ((Main.engine.krand() & 0xFF) < 16) {
                    Sounds.spritesound(207, p.i);
                } else {
                    Sounds.spritesound(209, p.i);
                }
                return;
            }
            Wall nw = Main.boardService.getWall(Globals.neartagwall);
            if (nw != null) {
                if (nw.getLotag() > 0 && DSector.isadoorwall(nw.getPicnum())) {
                    if (hitscanwall == Globals.neartagwall || hitscanwall == -1) {
                        DSector.checkhitswitch(snum, Globals.neartagwall, 0);
                    }
                    return;
                }
                if (p.newowner >= 0) {
                    DSector.CLEARCAMERAS(p, -1);
                    return;
                }
            }
            nsec = Main.boardService.getSector(Globals.neartagsector);
            Sector pssec2 = Main.boardService.getSector(psp.getSectnum());
            if (nsec != null && (nsec.getLotag() & 0x4000) == 0 && DSector.isanearoperator(nsec.getLotag())) {
                for (ListNode<Sprite> node = Main.boardService.getSectNode(Globals.neartagsector); node != null; node = node.getNext()) {
                    Sprite sp = node.get();
                    if (sp.getPicnum() != 2 && sp.getPicnum() != 8) continue;
                    return;
                }
                DSector.operatesectors(Globals.neartagsector, p.i);
            } else if (pssec2 != null && (pssec2.getLotag() & 0x4000) == 0) {
                if (DSector.isanunderoperator(pssec2.getLotag())) {
                    for (ListNode<Sprite> node = Main.boardService.getSectNode(psp.getSectnum()); node != null; node = node.getNext()) {
                        Sprite sp = node.get();
                        if (sp.getPicnum() != 2 && sp.getPicnum() != 8) continue;
                        return;
                    }
                    DSector.operatesectors(psp.getSectnum(), p.i);
                } else {
                    DSector.checkhitswitch(snum, Globals.neartagwall, 0);
                }
            }
        }
    }

    public static void CLEARCAMERAS(PlayerStruct p, int i) {
        if (i < 0) {
            p.posx = p.oposx;
            p.posy = p.oposy;
            p.posz = p.oposz;
            p.ang = p.oang;
            p.newowner = (short)-1;
            p.cursectnum = Main.engine.updatesector(p.posx, p.posy, p.cursectnum);
            Player.setpal(p);
            p.UpdatePlayerLoc();
            for (ListNode<Sprite> node = Main.boardService.getStatNode(1); node != null; node = node.getNext()) {
                Sprite sp = node.get();
                if (sp.getPicnum() != 621) continue;
                sp.setYvel(0);
            }
        } else if (p.newowner >= 0) {
            p.newowner = (short)-1;
        }
    }

    public static void setsectinterpolate(int i) {
        Sprite sp = Main.boardService.getSprite(i);
        if (sp == null) {
            return;
        }
        Sector sec = Main.boardService.getSector(sp.getSectnum());
        if (sec == null) {
            return;
        }
        for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
            Wall w = wn.get();
            Main.game.pInt.setwallinterpolate(wn.getIndex(), w);
            short k = w.getNextwall();
            w = Main.boardService.getWall(k);
            if (w == null) continue;
            Main.game.pInt.setwallinterpolate(k, w);
            Main.game.pInt.setwallinterpolate(w.getPoint2(), w.getWall2());
        }
    }

    static {
        wallfind = new int[2];
    }
}

