/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.OsdFunc;
import ru.m210projects.Duke3D.Factory.DukeEngine;
import ru.m210projects.Duke3D.Factory.DukeMenuHandler;
import ru.m210projects.Duke3D.Factory.DukeNetwork;
import ru.m210projects.Duke3D.Factory.DukeOsdFunc;
import ru.m210projects.Duke3D.Factory.DukePolygdx;
import ru.m210projects.Duke3D.Factory.DukePolymost;
import ru.m210projects.Duke3D.Factory.DukeSliderDrawable;
import ru.m210projects.Duke3D.Factory.DukeSoftware;
import ru.m210projects.Duke3D.Fonts.GameFont;
import ru.m210projects.Duke3D.Fonts.MenuFont;
import ru.m210projects.Duke3D.Fonts.MiniFont;
import ru.m210projects.Duke3D.Main;

public class DukeFactory
extends BuildFactory {
    private final Main app;

    public DukeFactory(Main app) {
        super(app.mainGrp);
        this.app = app;
        OsdColor.DEFAULT.setPal(0);
    }

    @Override
    public Engine engine() throws Exception {
        Main.engine = new DukeEngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new DukeSoftware(this.app.pCfg);
        }
        if (type == Renderer.RenderType.PolyGDX) {
            return new DukePolygdx(this.app.pCfg);
        }
        return new DukePolymost(this.app.pCfg);
    }

    @Override
    public DefScript getBaseDef(Engine engine) {
        return new DefScript(engine);
    }

    @Override
    public OsdFunc getOsdFunc() {
        return new DukeOsdFunc();
    }

    @Override
    public MenuHandler menus() {
        this.app.menu = new DukeMenuHandler(this.app);
        return this.app.menu;
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(5){

            @Override
            protected Font init(int i) {
                if (i == 0) {
                    return new MiniFont();
                }
                if (i == 1) {
                    return new GameFont();
                }
                if (i == 2) {
                    return new MenuFont();
                }
                return EngineUtils.getLargeFont();
            }
        };
    }

    @Override
    public BuildNet net() {
        return new DukeNetwork(this.app);
    }

    @Override
    public SliderDrawable slider() {
        return new DukeSliderDrawable();
    }

    @Override
    public void drawInitScreen() {
        Renderer renderer = Main.game.getRenderer();
        renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, 3281, 0, 0, 10);
    }
}

