/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Factory;

import com.badlogic.gdx.math.Vector2;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Duke3D.Config;
import ru.m210projects.Duke3D.Factory.DukePrompt;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Input;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Types.PlayerStruct;
import ru.m210projects.Duke3D.View;

public class DukeGameProcessor
extends GameProcessor {
    public static final int MAXHORIZ = 127;
    private static final int MAXANGVEL = 127;
    private static final int TURBOTURNTIME = 15;
    private static final int NORMALTURN = 15;
    private static final int PREAMBLETURN = 5;
    private static final int NORMALKEYMOVE = 40;
    private static final int MAXVEL = 90;
    private static final int MAXSVEL = 90;
    private final DukePrompt dukePrompt = new DukePrompt();
    private int turnheldtime;
    private int lastcontroltime;

    public DukeGameProcessor(Main main) {
        super(main);
    }

    public DukePrompt getDukeMessage() {
        return this.dukePrompt;
    }

    @Override
    public void fillInput(BuildNet.NetInput netInput) {
        float k;
        Sector psec;
        this.mouseDelta.x /= 8.0f;
        this.mouseDelta.y /= 4.0f;
        PlayerStruct p = Globals.ps[Mmulti.myconnectindex];
        Input input = (Input)netInput;
        if (this.game.pMenu.gShowMenu || Console.out.isShowing() || Globals.MODE_TYPE) {
            input.fvel = 0;
            input.svel = 0;
            input.avel = 0.0f;
            input.horz = 0.0f;
            input.bits = 0;
            input.fvel = (short)(input.fvel + (short)Globals.fricxv);
            input.svel = (short)(input.svel + (short)Globals.fricyv);
            return;
        }
        if (this.isGameKeyPressed(GameKeys.Send_Message)) {
            Sounds.spritesound(92, Globals.ps[Mmulti.myconnectindex].i);
            Globals.MODE_TYPE = true;
            this.dukePrompt.setCaptureInput(true);
        }
        if (Globals.multiflag == 1) {
            input.bits = 131072;
            input.bits |= Globals.multiwhat << 18;
            input.bits |= Globals.multipos << 19;
            Globals.multiflag = 0;
            return;
        }
        int tics = Main.engine.getTotalClock() - this.lastcontroltime;
        this.lastcontroltime = Main.engine.getTotalClock();
        if (this.isGameKeyJustPressed(GameKeys.Mouse_Aiming)) {
            Main.cfg.setgMouseAim(!Main.cfg.isgMouseAim());
            View.FTA(44 + (Main.cfg.isgMouseAim() ? 1 : 0), p);
        }
        input.bits = (input.bits = (input.bits = (input.bits = (input.bits = (input.bits = (input.bits = (input.bits = this.isGameKeyPressed(GameKeys.Jump) ? 1 : 0) | (this.isGameKeyPressed(GameKeys.Crouch) ? 2 : 0)) | (this.isGameKeyPressed(GameKeys.Weapon_Fire) ? 4 : 0)) | (this.isGameKeyPressed(Config.DukeKeys.Aim_Up) ? 8 : 0)) | (this.isGameKeyPressed(Config.DukeKeys.Aim_Down) ? 16 : 0)) | (this.isGameKeyPressed(GameKeys.Run) ? 32 : 0)) | (this.isGameKeyPressed(Config.DukeKeys.Tilt_Left) ? 64 : 0)) | (this.isGameKeyPressed(Config.DukeKeys.Tilt_Right) ? 128 : 0);
        for (int i = 0; i < 10; ++i) {
            if (!this.isGameKeyJustPressed(Main.cfg.getKeymap()[i + Main.cfg.weaponIndex])) continue;
            input.bits |= i + 1 << 8;
        }
        if (this.isGameKeyJustPressed(GameKeys.Previous_Weapon)) {
            input.bits |= 0xB00;
        }
        if (this.isGameKeyJustPressed(GameKeys.Next_Weapon)) {
            input.bits |= 0xC00;
        }
        if (this.isGameKeyJustPressed(Config.DukeKeys.Last_Weap_Switch)) {
            input.bits |= 0xD00;
        }
        input.bits = (input.bits = (input.bits = (input.bits = (input.bits = (input.bits = (input.bits = (input.bits = (input.bits = (input.bits = (input.bits = (input.bits = (input.bits = input.bits | (this.isGameKeyPressed(Config.DukeKeys.Steroids) ? 4096 : 0)) | (this.isGameKeyPressed(GameKeys.Look_Up) ? 8192 : 0)) | (this.isGameKeyPressed(GameKeys.Look_Down) ? 16384 : 0)) | (this.isGameKeyPressed(Config.DukeKeys.NightVision) ? 32768 : 0)) | (this.isGameKeyPressed(Config.DukeKeys.MedKit) ? 65536 : 0)) | (this.isGameKeyPressed(Config.DukeKeys.Aim_Center) ? 262144 : 0)) | (this.isGameKeyPressed(Config.DukeKeys.Holster_Weapon) ? 524288 : 0)) | (this.isGameKeyPressed(Config.DukeKeys.Inventory_Left) ? 0x100000 : 0)) | (this.isKeyJustPressed(121) ? 0x200000 : 0)) | (this.isGameKeyPressed(Config.DukeKeys.Quick_Kick) ? 0x400000 : 0)) | (Main.cfg.isgMouseAim() ? 0x800000 : 0)) | (this.isGameKeyPressed(Config.DukeKeys.Holo_Duke) ? 0x1000000 : 0)) | (this.isGameKeyPressed(Config.DukeKeys.Jetpack) ? 0x2000000 : 0);
        input.bits |= 0;
        input.bits = input.bits | (this.isGameKeyPressed(Config.DukeKeys.Inventory_Right) ? 0x8000000 : 0);
        input.bits = input.bits | (this.isGameKeyPressed(GameKeys.Turn_Around) ? 0x10000000 : 0);
        input.bits = input.bits | (this.isGameKeyPressed(GameKeys.Open) ? 0x20000000 : 0);
        input.bits = input.bits | (this.isGameKeyPressed(Config.DukeKeys.Inventory_Use) ? 0x40000000 : 0);
        input.bits = input.bits | (this.isKeyJustPressed(111) ? Integer.MIN_VALUE : 0);
        if ((input.bits & 2) != 0) {
            p.crouch_toggle = 0;
        }
        boolean CrouchMode = (psec = Main.boardService.getSector(p.cursectnum)) != null && psec.getLotag() != 2 ? this.isGameKeyJustPressed(Config.DukeKeys.Crouch_toggle) : this.isGameKeyPressed(Config.DukeKeys.Crouch_toggle);
        if (psec != null && psec.getLotag() == 2) {
            p.crouch_toggle = CrouchMode ? (byte)1 : 0;
        } else if (CrouchMode) {
            p.crouch_toggle = (byte)(p.crouch_toggle ^ 1);
        }
        if (p.crouch_toggle == 1) {
            input.bits |= 2;
        }
        boolean running = Globals.ud.auto_run == 0 && (input.bits & 0x20) != 0 || (input.bits & 0x20) == 0 && Globals.ud.auto_run != 0;
        int vel = 0;
        int svel = 0;
        float angvel = 0.0f;
        float horiz = 0.0f;
        int turnamount = 15;
        int keymove = 40;
        if (running) {
            turnamount = 30;
            keymove = 80;
        }
        if (this.isGameKeyPressed(GameKeys.Strafe)) {
            if (this.isGameKeyPressed(GameKeys.Turn_Left)) {
                svel = (short)(svel - (short)(-keymove));
            }
            if (this.isGameKeyPressed(GameKeys.Turn_Right)) {
                svel = (short)(svel - keymove);
            }
            svel = (short)Gameutils.BClipRange((float)svel - 20.0f * this.ctrlGetMouseStrafe(), (float)(-keymove), (float)keymove);
        } else {
            if (this.isGameKeyPressed(GameKeys.Turn_Left)) {
                this.turnheldtime += tics;
                angvel = this.turnheldtime >= 15 ? (angvel -= (float)turnamount) : (angvel -= 5.0f);
            } else if (this.isGameKeyPressed(GameKeys.Turn_Right)) {
                this.turnheldtime += tics;
                angvel = this.turnheldtime >= 15 ? (angvel += (float)turnamount) : (angvel += 5.0f);
            } else {
                this.turnheldtime = 0;
            }
            angvel = Gameutils.BClipRange(angvel + this.ctrlGetMouseTurn(), -1024.0f, 1024.0f);
        }
        if (this.isGameKeyPressed(GameKeys.Strafe_Left)) {
            svel = (short)(svel + keymove);
        }
        if (this.isGameKeyPressed(GameKeys.Strafe_Right)) {
            svel = (short)(svel - keymove);
        }
        if (this.isGameKeyPressed(GameKeys.Move_Forward)) {
            vel = (short)(vel + keymove);
        }
        if (this.isGameKeyPressed(GameKeys.Move_Backward)) {
            vel = (short)(vel - keymove);
        }
        Renderer renderer = this.game.getRenderer();
        int ydim = renderer.getHeight();
        if (Main.cfg.isgMouseAim()) {
            horiz = Gameutils.BClipRange(this.ctrlGetMouseLook(!Main.cfg.isgInvertmouse()), (float)(-(ydim >> 1)), (float)(100 + (ydim >> 1)));
        } else {
            vel = (short)Gameutils.BClipRange((float)vel - this.ctrlGetMouseMove(), (float)(-4 * keymove), (float)(4 * keymove));
        }
        Vector2 stick1 = this.ctrlGetStick(GameProcessor.JoyStick.LOOKING);
        Vector2 stick2 = this.ctrlGetStick(GameProcessor.JoyStick.MOVING);
        float lookx = stick1.x;
        float looky = stick1.y;
        if (looky != 0.0f) {
            k = 8.0f;
            horiz = Gameutils.BClipRange(horiz - k * looky * Main.cfg.getJoyLookSpeed(), (float)(-(ydim >> 1)), (float)(100 + (ydim >> 1)));
        }
        if (lookx != 0.0f) {
            k = 8.0f;
            angvel = Gameutils.BClipRange(angvel + k * lookx * Main.cfg.getJoyTurnSpeed(), -1024.0f, 1024.0f);
        }
        if (stick2.y != 0.0f) {
            vel = (short)Gameutils.BClipRange((float)vel - (float)keymove * stick2.y, (float)(-4 * keymove), (float)(4 * keymove));
        }
        if (stick2.x != 0.0f) {
            svel = (short)Gameutils.BClipRange((float)svel - (float)keymove * stick2.x, (float)(-4 * keymove), (float)(4 * keymove));
        }
        if (vel < -90) {
            vel = -90;
        }
        if (vel > 90) {
            vel = 90;
        }
        if (svel < -90) {
            svel = -90;
        }
        if (svel > 90) {
            svel = 90;
        }
        if (angvel < -127.0f) {
            angvel = -127.0f;
        }
        if (angvel > 127.0f) {
            angvel = 127.0f;
        }
        if (horiz < -127.0f) {
            horiz = -127.0f;
        }
        if (horiz > 127.0f) {
            horiz = 127.0f;
        }
        if (Globals.ud.scrollmode && Globals.ud.overhead_on != 0) {
            Globals.ud.folfvel = vel;
            Globals.ud.folavel = angvel;
            input.fvel = 0;
            input.svel = 0;
            input.avel = 0.0f;
            input.horz = 0.0f;
            return;
        }
        int momx = (int)((double)vel * Gameutils.BCosAngle(Gameutils.BClampAngle(p.ang)) / 512.0);
        int momy = (int)((double)vel * Gameutils.BSinAngle(Gameutils.BClampAngle(p.ang)) / 512.0);
        momx += (int)((double)svel * Gameutils.BSinAngle(Gameutils.BClampAngle(p.ang)) / 512.0);
        momy += (int)((double)svel * Gameutils.BCosAngle(Gameutils.BClampAngle(p.ang + 1024.0f)) / 512.0);
        input.fvel = (short)(momx += Globals.fricxv);
        input.svel = (short)(momy += Globals.fricyv);
        input.avel = angvel;
        input.horz = horiz;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (this.dukePrompt.isCaptured()) {
            if (keycode == 111) {
                this.dukePrompt.setCaptureInput(false);
                this.dukePrompt.clear();
                Globals.MODE_TYPE = false;
            } else {
                this.dukePrompt.keyDown(keycode);
            }
            return true;
        }
        return super.keyDown(keycode);
    }

    @Override
    public boolean keyUp(int i) {
        this.dukePrompt.keyUp(i);
        return super.keyUp(i);
    }

    @Override
    public boolean keyRepeat(int keycode) {
        if (this.dukePrompt.isCaptured()) {
            this.dukePrompt.keyRepeat(keycode);
            return true;
        }
        return super.keyRepeat(keycode);
    }

    @Override
    public boolean keyTyped(char i) {
        if (this.dukePrompt.isCaptured()) {
            this.dukePrompt.keyTyped(i);
            return true;
        }
        return super.keyTyped(i);
    }
}

