/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D;

import com.badlogic.gdx.utils.IntArray;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Script.Scriptfile;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.InitializationException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.filehandle.grp.GrpFile;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Duke3D.Actors;
import ru.m210projects.Duke3D.DSector;
import ru.m210projects.Duke3D.Gameutils;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Player;
import ru.m210projects.Duke3D.Premap;
import ru.m210projects.Duke3D.ResourceHandler;
import ru.m210projects.Duke3D.Screens.DemoScreen;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Spawn;
import ru.m210projects.Duke3D.Types.EpisodeInfo;
import ru.m210projects.Duke3D.Types.GameType;
import ru.m210projects.Duke3D.Types.MapInfo;
import ru.m210projects.Duke3D.Types.Script;
import ru.m210projects.Duke3D.View;
import ru.m210projects.Duke3D.Weapons;
import ru.m210projects.Duke3D.filehandle.EpisodeEntry;
import ru.m210projects.Duke3D.filehandle.UserEntry;

public class Gamedef {
    public static final int[] params = new int[31];
    public static final int MAXSCRIPTSIZE = 20460;
    public static final int face_player = 1;
    public static final int geth = 2;
    public static final int getv = 4;
    public static final int random_angle = 8;
    public static final int face_player_slow = 16;
    public static final int spin = 32;
    public static final int face_player_smart = 64;
    public static final int fleeenemy = 128;
    public static final int jumptoplayer = 257;
    public static final int seekplayer = 512;
    public static final int furthestdir = 1024;
    public static final int dodgebullet = 4096;
    public static final char[][] keyw = new char[][]{"definelevelname".toCharArray(), "actor".toCharArray(), "addammo".toCharArray(), "ifrnd".toCharArray(), "enda".toCharArray(), "ifcansee".toCharArray(), "ifhitweapon".toCharArray(), "action".toCharArray(), "ifpdistl".toCharArray(), "ifpdistg".toCharArray(), "else".toCharArray(), "strength".toCharArray(), "break".toCharArray(), "shoot".toCharArray(), "palfrom".toCharArray(), "sound".toCharArray(), "fall".toCharArray(), "state".toCharArray(), "ends".toCharArray(), "define".toCharArray(), "//".toCharArray(), "ifai".toCharArray(), "killit".toCharArray(), "addweapon".toCharArray(), "ai".toCharArray(), "addphealth".toCharArray(), "ifdead".toCharArray(), "ifsquished".toCharArray(), "sizeto".toCharArray(), "{".toCharArray(), "}".toCharArray(), "spawn".toCharArray(), "move".toCharArray(), "ifwasweapon".toCharArray(), "ifaction".toCharArray(), "ifactioncount".toCharArray(), "resetactioncount".toCharArray(), "debris".toCharArray(), "pstomp".toCharArray(), "/*".toCharArray(), "cstat".toCharArray(), "ifmove".toCharArray(), "resetplayer".toCharArray(), "ifonwater".toCharArray(), "ifinwater".toCharArray(), "ifcanshoottarget".toCharArray(), "ifcount".toCharArray(), "resetcount".toCharArray(), "addinventory".toCharArray(), "ifactornotstayput".toCharArray(), "hitradius".toCharArray(), "ifp".toCharArray(), "count".toCharArray(), "ifactor".toCharArray(), "music".toCharArray(), "include".toCharArray(), "ifstrength".toCharArray(), "definesound".toCharArray(), "guts".toCharArray(), "ifspawnedby".toCharArray(), "gamestartup".toCharArray(), "wackplayer".toCharArray(), "ifgapzl".toCharArray(), "ifhitspace".toCharArray(), "ifoutside".toCharArray(), "ifmultiplayer".toCharArray(), "operate".toCharArray(), "ifinspace".toCharArray(), "debug".toCharArray(), "endofgame".toCharArray(), "ifbulletnear".toCharArray(), "ifrespawn".toCharArray(), "iffloordistl".toCharArray(), "ifceilingdistl".toCharArray(), "spritepal".toCharArray(), "ifpinventory".toCharArray(), "betaname".toCharArray(), "cactor".toCharArray(), "ifphealthl".toCharArray(), "definequote".toCharArray(), "quote".toCharArray(), "ifinouterspace".toCharArray(), "ifnotmoving".toCharArray(), "respawnhitag".toCharArray(), "tip".toCharArray(), "ifspritepal".toCharArray(), "money".toCharArray(), "soundonce".toCharArray(), "addkills".toCharArray(), "stopsound".toCharArray(), "ifawayfromwall".toCharArray(), "ifcanseetarget".toCharArray(), "globalsound".toCharArray(), "lotsofglass".toCharArray(), "ifgotweaponce".toCharArray(), "getlastpal".toCharArray(), "pkick".toCharArray(), "mikesnd".toCharArray(), "useractor".toCharArray(), "sizeat".toCharArray(), "addstrength".toCharArray(), "cstator".toCharArray(), "mail".toCharArray(), "paper".toCharArray(), "tossweapon".toCharArray(), "sleeptime".toCharArray(), "nullop".toCharArray(), "definevolumename".toCharArray(), "defineskillname".toCharArray(), "ifnosounds".toCharArray(), "clipdist".toCharArray(), "ifangdiffl".toCharArray(), "ifplaybackon".toCharArray()};
    public static final int NUMKEYWORDS = keyw.length;
    private static final char[] tempbuf = new char[2048];
    public static final String confilename = "GAME.CON";
    public static int insptr;
    public static int scriptptr;
    public static int error;
    public static int warning;
    public static int killit_flag;
    public static char[] label;
    public static int labelcnt;
    public static final IntArray labelcode;
    public static short checking_ifelse;
    public static short parsing_state;
    public static String last_used_text;
    public static short num_squigilly_brackets;
    public static int last_used_size;
    public static short g_i;
    public static short g_p;
    public static int g_x;
    public static Sprite g_sp;
    public static int[] g_t;
    public static int furthest_x;
    public static int furthest_y;
    private static char[] text;
    private static int textptr;
    private static int parsing_actor;
    private static short line_number;

    public static float getincangle(float a, float na) {
        if (!(Math.abs((a = ru.m210projects.Build.Gameutils.BClampAngle(a)) - (na = ru.m210projects.Build.Gameutils.BClampAngle(na))) < 1024.0f)) {
            if (na > 1024.0f) {
                na -= 2048.0f;
            }
            if (a > 1024.0f) {
                a -= 2048.0f;
            }
            na -= 2048.0f;
            a -= 2048.0f;
        }
        return na - a;
    }

    public static int getincangle(int a, int na) {
        if (Pragmas.klabs((a &= 0x7FF) - (na &= 0x7FF)) >= 1024) {
            if (na > 1024) {
                na -= 2048;
            }
            if (a > 1024) {
                a -= 2048;
            }
            na -= 2048;
            a -= 2048;
        }
        return na - a;
    }

    public static boolean ispecial(char c) {
        if (c == '\n') {
            line_number = (short)(line_number + 1);
            return true;
        }
        return c == ' ' || c == '\r' || c == '\t';
    }

    public static boolean isaltok(char c) {
        return Gamedef.isalnum(c) || c == '{' || c == '}' || c == '/' || c == '*' || c == '-' || c == '_' || c == '.';
    }

    public static boolean isaltok(byte c) {
        return Character.isLetterOrDigit(c) || c == 123 || c == 125 || c == 47 || c == 42 || c == 45 || c == 95 || c == 46;
    }

    public static boolean isalnum(char c) {
        return Character.isLetterOrDigit(c);
    }

    public static void getglobalz(int i) {
        Sprite s = Main.boardService.getSprite(i);
        if (s == null) {
            return;
        }
        Sector sec = Main.boardService.getSector(s.getSectnum());
        if (sec == null) {
            return;
        }
        if (s.getStatnum() == 10 || s.getStatnum() == 6 || s.getStatnum() == 2 || s.getStatnum() == 1 || s.getStatnum() == 4) {
            Sprite hsp;
            int zr = s.getStatnum() == 4 ? 4 : 127;
            Main.engine.getzrange(s.getX(), s.getY(), s.getZ() - 256, s.getSectnum(), zr, 65537);
            Globals.hittype[i].ceilingz = Engine.zr_ceilz;
            Globals.hittype[i].floorz = Engine.zr_florz;
            int lz = Engine.zr_florhit;
            if ((lz & 0xE0000000) == -1073741824 && (hsp = Main.boardService.getSprite(lz &= 0x1FFFFFFF)) != null && (hsp.getCstat() & 0x30) == 0) {
                if (Actors.badguy(hsp) && hsp.getPal() != 1) {
                    if (s.getStatnum() != 4) {
                        Globals.hittype[i].dispicnum = -4;
                        s.setXvel(-256);
                        Actors.ssp(i, 65537);
                    }
                } else if (hsp.getPicnum() == 1405 && Actors.badguy(s)) {
                    Globals.hittype[i].dispicnum = -4;
                    s.setXvel(-256);
                    Actors.ssp(i, 65537);
                } else if (s.getStatnum() == 4 && hsp.getPicnum() == 1405 && s.getOwner() == lz) {
                    Globals.hittype[i].ceilingz = sec.getCeilingz();
                    Globals.hittype[i].floorz = sec.getFloorz();
                }
            }
        } else {
            Globals.hittype[i].ceilingz = sec.getCeilingz();
            Globals.hittype[i].floorz = sec.getFloorz();
        }
    }

    public static void makeitfall(Script con, int i) {
        Sprite s = Main.boardService.getSprite(i);
        if (s == null) {
            return;
        }
        Sector sec = Main.boardService.getSector(s.getSectnum());
        if (sec == null) {
            return;
        }
        int c = DSector.floorspace(s.getSectnum()) ? 0 : (DSector.ceilingspace(s.getSectnum()) || sec.getLotag() == 2 ? con.gc / 6 : con.gc);
        if (s.getStatnum() == 1 || s.getStatnum() == 10 || s.getStatnum() == 2 || s.getStatnum() == 6) {
            Main.engine.getzrange(s.getX(), s.getY(), s.getZ() - 256, s.getSectnum(), 127, 65537);
            Globals.hittype[i].ceilingz = Engine.zr_ceilz;
            Globals.hittype[i].floorz = Engine.zr_florz;
        } else {
            Globals.hittype[i].ceilingz = sec.getCeilingz();
            Globals.hittype[i].floorz = sec.getFloorz();
        }
        if (s.getZ() < Globals.hittype[i].floorz - 256) {
            if (sec.getLotag() == 2 && s.getZvel() > 3122) {
                s.setZvel(3144);
            }
            if (s.getZvel() < 6144) {
                s.setZvel(s.getZvel() + c);
            } else {
                s.setZvel(6144);
            }
            s.setZ(s.getZ() + s.getZvel());
        }
        if (s.getZ() >= Globals.hittype[i].floorz - 256) {
            s.setZ(Globals.hittype[i].floorz - 256);
            s.setZvel(0);
        }
    }

    public static void getlabel() {
        while (!Gamedef.isalnum(text[textptr])) {
            if (text[textptr] == '\n') {
                line_number = (short)(line_number + 1);
            }
            if (text[++textptr] != '\u0000') continue;
            return;
        }
        int len = 0;
        while (!Gamedef.ispecial(text[textptr + ++len])) {
        }
        if (label.length <= (labelcnt << 6) + len) {
            char[] newItems = new char[(labelcnt << 6) + len + 1];
            System.arraycopy(label, 0, newItems, 0, label.length);
            label = newItems;
        }
        System.arraycopy(text, textptr, label, labelcnt << 6, len);
        Gamedef.label[(Gamedef.labelcnt << 6) + len] = '\u0000';
        textptr += len;
    }

    public static int keyword() {
        int temptextptr = textptr;
        while (!Gamedef.isaltok(text[temptextptr])) {
            if (text[++temptextptr] != '\u0000') continue;
            return 0;
        }
        int i = 0;
        while (Gamedef.isaltok(text[temptextptr])) {
            Gamedef.tempbuf[i] = text[temptextptr++];
            ++i;
        }
        Gamedef.tempbuf[i] = '\u0000';
        for (i = 0; i < NUMKEYWORDS; ++i) {
            if (Strhandler.Bstrcmp(tempbuf, keyw[i]) != 0) continue;
            return i;
        }
        return -1;
    }

    public static int transword(Script con) {
        while (!Gamedef.isaltok(text[textptr])) {
            if (text[textptr] == '\n') {
                line_number = (short)(line_number + 1);
            }
            if (text[textptr] == '\u0000') {
                return -1;
            }
            ++textptr;
        }
        int l = 0;
        while (Gamedef.isaltok(text[textptr + l])) {
            Gamedef.tempbuf[l] = text[textptr + l];
            ++l;
        }
        Gamedef.tempbuf[l] = '\u0000';
        for (int i = 0; i < NUMKEYWORDS; ++i) {
            if (Strhandler.Bstrcmp(tempbuf, keyw[i]) != 0) continue;
            con.script[Gamedef.scriptptr] = i;
            textptr += l;
            ++scriptptr;
            return i;
        }
        textptr += l;
        if (tempbuf[0] == '{' && tempbuf[1] != '\u0000') {
            Console.out.println("  * ERROR!(L" + line_number + ") Expecting a SPACE or CR between '{' and '" + new String(tempbuf, 1, l) + "'.", OsdColor.RED);
        } else if (tempbuf[0] == '}' && tempbuf[1] != '\u0000') {
            Console.out.println("  * ERROR!(L" + line_number + ") Expecting a SPACE or CR between '}' and '" + new String(tempbuf, 1, l) + "'.", OsdColor.RED);
        } else if (tempbuf[0] == '/' && tempbuf[1] == '/' && tempbuf[2] != '\u0000') {
            Console.out.println("  * ERROR!(L" + line_number + ") Expecting a SPACE between '//' and '" + new String(tempbuf, 2, l) + "'.", OsdColor.RED);
        } else if (tempbuf[0] == '/' && tempbuf[1] == '*' && tempbuf[2] != '\u0000') {
            Console.out.println("  * ERROR!(L" + line_number + ") Expecting a SPACE between '/*' and '" + new String(tempbuf, 2, l) + "'.", OsdColor.RED);
        } else if (tempbuf[0] == '*' && tempbuf[1] == '/' && tempbuf[2] != '\u0000') {
            Console.out.println("  * ERROR!(L" + line_number + ") Expecting a SPACE between '*/' and '" + new String(tempbuf, 2, l) + "'.", OsdColor.RED);
        } else {
            Console.out.println("  * ERROR!(L" + line_number + ") Expecting key word, but found '" + new String(tempbuf, 0, l) + "'.", OsdColor.RED);
        }
        ++error;
        return -1;
    }

    public static void transnum(Script con) {
        int i;
        while (!Gamedef.isaltok(text[textptr])) {
            if (text[textptr] == '\n') {
                line_number = (short)(line_number + 1);
            }
            if (text[++textptr] != '\u0000') continue;
            return;
        }
        int l = 0;
        while (Gamedef.isaltok(text[textptr + l])) {
            Gamedef.tempbuf[l] = text[textptr + l];
            ++l;
        }
        Gamedef.tempbuf[l] = '\u0000';
        for (i = 0; i < NUMKEYWORDS; ++i) {
            if (Strhandler.Bstrcmp(label, labelcnt << 6, keyw[i], 0) != 0) continue;
            ++error;
            Console.out.println("  * ERROR!(L" + line_number + ") Symbol '" + label[labelcnt << 6] + "' is a key word.", OsdColor.RED);
            textptr += l;
        }
        for (i = 0; i < labelcnt; ++i) {
            if (Strhandler.Bstrcmp(tempbuf, 0, label, i << 6) != 0) continue;
            con.script[Gamedef.scriptptr] = labelcode.get(i);
            ++scriptptr;
            textptr += l;
            return;
        }
        if (!Character.isDigit(text[textptr]) && text[textptr] != '-') {
            Console.out.println("  * ERROR!(L" + line_number + ") Parameter '" + new String(tempbuf, 0, l) + "' is undefined.", OsdColor.RED);
            ++error;
            textptr += l;
            return;
        }
        try {
            con.script[Gamedef.scriptptr] = Integer.parseInt(new String(text, textptr, l));
        }
        catch (Exception e) {
            Console.out.println("  * ERROR!(L" + line_number + ") Parameter '" + new String(tempbuf, 0, l) + "' is undefined.", OsdColor.RED);
            ++error;
            textptr += l;
            return;
        }
        ++scriptptr;
        textptr += l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean parsecommand(Script con) {
        if (error > 12 || text[textptr] == '\u0000' || text[textptr + 1] == '\u0000') {
            return true;
        }
        int tw = Gamedef.transword(con);
        switch (tw) {
            default: {
                return false;
            }
            case 39: {
                --scriptptr;
                short j = line_number;
                do {
                    if (text[++textptr] == '\n') {
                        line_number = (short)(line_number + 1);
                    }
                    if (text[textptr] != '\u0000') continue;
                    Console.out.println("  * ERROR!(L" + j + ") Found '/*' with no '*/'.", OsdColor.RED);
                    ++error;
                    return false;
                } while (text[textptr] != '*' || text[textptr + 1] != '/');
                textptr += 2;
                return false;
            }
            case 17: {
                int j;
                if (parsing_actor == 0 && parsing_state == 0) {
                    Gamedef.getlabel();
                    labelcode.add(--scriptptr);
                    labelcnt = Gamedef.labelcode.size;
                    parsing_state = 1;
                    return false;
                }
                Gamedef.getlabel();
                for (int i = 0; i < NUMKEYWORDS; ++i) {
                    if (Strhandler.Bstrcmp(label, labelcnt << 6, keyw[i], 0) != 0) continue;
                    ++error;
                    Console.out.println("  * ERROR!(L" + line_number + ") Symbol '" + label[labelcnt << 6] + "' is a key word.", OsdColor.RED);
                    return false;
                }
                for (j = 0; j < labelcnt; ++j) {
                    if (Strhandler.Bstrcmp(label, j << 6, label, labelcnt << 6) != 0) continue;
                    con.script[Gamedef.scriptptr] = labelcode.get(j);
                    break;
                }
                if (j == labelcnt) {
                    Console.out.println("  * ERROR!(L" + line_number + ") State '" + label[labelcnt << 6] + "' not found.", OsdColor.RED);
                    ++error;
                }
                ++scriptptr;
                return false;
            }
            case 11: 
            case 13: 
            case 15: 
            case 25: 
            case 31: 
            case 40: 
            case 52: 
            case 68: 
            case 69: 
            case 74: 
            case 77: 
            case 80: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 110: {
                Gamedef.transnum(con);
                return false;
            }
            case 18: {
                if (parsing_state == 0) {
                    Console.out.println("  * ERROR!(L" + line_number + ") Found 'ends' with no 'state'.", OsdColor.RED);
                    ++error;
                }
                if (num_squigilly_brackets > 0) {
                    Console.out.println("  * ERROR!(L" + line_number + ") Found more '{' than '}' before 'ends'.", OsdColor.RED);
                    ++error;
                }
                if (num_squigilly_brackets < 0) {
                    Console.out.println("  * ERROR!(L" + line_number + ") Found more '}' than '{' before 'ends'.", OsdColor.RED);
                    ++error;
                }
                parsing_state = 0;
                return false;
            }
            case 19: {
                int i;
                Gamedef.getlabel();
                for (i = 0; i < NUMKEYWORDS; ++i) {
                    if (Strhandler.Bstrcmp(label, labelcnt << 6, keyw[i], 0) != 0) continue;
                    ++error;
                    Console.out.println("  * ERROR!(L" + line_number + ") Symbol '" + label[labelcnt << 6] + "' is a key word.", OsdColor.RED);
                    return false;
                }
                for (i = 0; i < labelcnt; ++i) {
                    if (Strhandler.Bstrcmp(label, labelcnt << 6, label, i << 6) != 0) continue;
                    ++warning;
                    Console.out.println("  * WARNING.(L" + line_number + ") Duplicate definition '" + label[labelcnt << 6] + "' ignored.", OsdColor.RED);
                    break;
                }
                Gamedef.transnum(con);
                if (i == labelcnt) {
                    labelcode.add(con.script[scriptptr - 1]);
                    labelcnt = Gamedef.labelcode.size;
                }
                scriptptr -= 2;
                return false;
            }
            case 14: {
                int j;
                for (j = 0; j < 4 && Gamedef.keyword() == -1; ++j) {
                    Gamedef.transnum(con);
                }
                while (j < 4) {
                    con.script[Gamedef.scriptptr] = 0;
                    ++scriptptr;
                    ++j;
                }
                return false;
            }
            case 32: {
                if (parsing_actor != 0 || parsing_state != 0) {
                    Gamedef.transnum(con);
                    int j = 0;
                    while (Gamedef.keyword() == -1) {
                        Gamedef.transnum(con);
                        j |= con.script[--scriptptr];
                    }
                    con.script[Gamedef.scriptptr] = j;
                    ++scriptptr;
                    return false;
                } else {
                    int i;
                    --scriptptr;
                    Gamedef.getlabel();
                    for (i = 0; i < NUMKEYWORDS; ++i) {
                        if (Strhandler.Bstrcmp(label, labelcnt << 6, keyw[i], 0) != 0) continue;
                        ++error;
                        Console.out.println("  * ERROR!(L" + line_number + ") Symbol '" + label[labelcnt << 6] + "' is a key word.", OsdColor.RED);
                        return false;
                    }
                    for (i = 0; i < labelcnt; ++i) {
                        if (Strhandler.Bstrcmp(label, labelcnt << 6, label, i << 6) != 0) continue;
                        ++warning;
                        Console.out.println("  * WARNING.(L" + line_number + ") Duplicate move '" + label[labelcnt << 6] + "' ignored.", OsdColor.RED);
                        break;
                    }
                    if (i == labelcnt) {
                        labelcode.add(scriptptr);
                        labelcnt = Gamedef.labelcode.size;
                    }
                    for (int j = 0; j < 2 && Gamedef.keyword() < 0; ++j) {
                        Gamedef.transnum(con);
                    }
                    for (int k = j; k < 2; ++k) {
                        con.script[Gamedef.scriptptr] = 0;
                        ++scriptptr;
                    }
                }
                return false;
            }
            case 54: {
                --scriptptr;
                Gamedef.transnum(con);
                int k = con.script[--scriptptr] - 1;
                int i = 0;
                if (k >= 0) {
                    while (Gamedef.keyword() == -1) {
                        while (!Gamedef.isaltok(text[textptr])) {
                            if (text[textptr] == '\n') {
                                line_number = (short)(line_number + 1);
                            }
                            if (text[++textptr] != '\u0000') continue;
                        }
                        int startptr = textptr;
                        int j = 0;
                        while (Gamedef.isaltok(text[textptr + j])) {
                            ++j;
                        }
                        con.music_fn[k][i] = new String(text, startptr, j);
                        textptr += j;
                        if (i > 9) return false;
                        ++i;
                    }
                    return false;
                } else {
                    while (Gamedef.keyword() == -1) {
                        while (!Gamedef.isaltok(text[textptr])) {
                            if (text[textptr] == '\n') {
                                line_number = (short)(line_number + 1);
                            }
                            if (text[++textptr] != '\u0000') continue;
                        }
                        int startptr = textptr;
                        int j = 0;
                        while (Gamedef.isaltok(text[textptr + j])) {
                            ++j;
                        }
                        con.env_music_fn[i] = new String(text, startptr, j);
                        textptr += j;
                        if (i > 9) return false;
                        ++i;
                    }
                }
                return false;
            }
            case 55: {
                boolean done;
                --scriptptr;
                while (!Gamedef.isaltok(text[textptr])) {
                    if (text[textptr] == '\n') {
                        line_number = (short)(line_number + 1);
                    }
                    if (text[++textptr] != '\u0000') continue;
                }
                int j = 0;
                while (Gamedef.isaltok(text[textptr])) {
                    Gamedef.tempbuf[j] = text[textptr++];
                    ++j;
                }
                Gamedef.tempbuf[j] = '\u0000';
                String name = new String(tempbuf, 0, j).trim();
                Entry fp = Main.game.getCache().getEntry(name, !Globals.loadfromgrouponly);
                if (!fp.exists()) {
                    ++error;
                    Console.out.println("  * ERROR!(L" + line_number + ") Could not find '" + label[labelcnt << 6] + "'.", OsdColor.RED);
                    return false;
                }
                j = (int)fp.getSize();
                byte[] buf = new byte[j + 1];
                System.arraycopy(fp.getBytes(), 0, buf, 0, j);
                Console.out.println("Including: '" + name + "'.");
                short temp_line_number = line_number;
                line_number = 1;
                char temp_ifelse_check = (char)checking_ifelse;
                checking_ifelse = 0;
                char[] origtext = text;
                int origtptr = textptr;
                textptr = 0;
                last_used_text = new String(buf);
                last_used_size = j;
                text = last_used_text.toCharArray();
                Gamedef.text[j] = '\u0000';
                while (!(done = Gamedef.parsecommand(con))) {
                }
                text = origtext;
                textptr = origtptr;
                line_number = temp_line_number;
                checking_ifelse = (short)temp_ifelse_check;
                return false;
            }
            case 24: {
                if (parsing_actor != 0 || parsing_state != 0) {
                    Gamedef.transnum(con);
                    return false;
                } else {
                    int i;
                    --scriptptr;
                    Gamedef.getlabel();
                    for (i = 0; i < NUMKEYWORDS; ++i) {
                        if (Strhandler.Bstrcmp(label, labelcnt << 6, keyw[i], 0) != 0) continue;
                        ++error;
                        Console.out.println("  * ERROR!(L" + line_number + ") Symbol '" + label[labelcnt << 6] + "' is a key word.", OsdColor.RED);
                        return false;
                    }
                    for (i = 0; i < labelcnt; ++i) {
                        if (Strhandler.Bstrcmp(label, labelcnt << 6, label, i << 6) != 0) continue;
                        ++warning;
                        Console.out.println("  * WARNING.(L" + line_number + ") Duplicate ai '" + label[labelcnt << 6] + "' ignored.", OsdColor.RED);
                        break;
                    }
                    if (i == labelcnt) {
                        labelcode.add(scriptptr);
                        labelcnt = Gamedef.labelcode.size;
                    }
                    for (int j = 0; j < 3 && Gamedef.keyword() < 0; ++j) {
                        if (j == 2) {
                            int k = 0;
                            while (Gamedef.keyword() == -1) {
                                Gamedef.transnum(con);
                                k |= con.script[--scriptptr];
                            }
                            con.script[Gamedef.scriptptr] = k;
                            ++scriptptr;
                            return false;
                        }
                        Gamedef.transnum(con);
                    }
                    for (int k = j; k < 3; ++k) {
                        con.script[Gamedef.scriptptr] = 0;
                        ++scriptptr;
                    }
                }
                return false;
            }
            case 7: {
                if (parsing_actor != 0 || parsing_state != 0) {
                    Gamedef.transnum(con);
                    return false;
                } else {
                    int i;
                    --scriptptr;
                    Gamedef.getlabel();
                    for (i = 0; i < NUMKEYWORDS; ++i) {
                        if (Strhandler.Bstrcmp(label, labelcnt << 6, keyw[i], 0) != 0) continue;
                        ++error;
                        Console.out.println("  * ERROR!(L" + line_number + ") Symbol '" + label[labelcnt << 6] + "' is a key word.", OsdColor.RED);
                        return false;
                    }
                    for (i = 0; i < labelcnt; ++i) {
                        if (Strhandler.Bstrcmp(label, labelcnt << 6, label, i << 6) != 0) continue;
                        ++warning;
                        Console.out.println("  * WARNING.(L" + line_number + ") Duplicate action '" + label[labelcnt << 6] + "' ignored.", OsdColor.RED);
                        break;
                    }
                    if (i == labelcnt) {
                        labelcode.add(scriptptr);
                        labelcnt = Gamedef.labelcode.size;
                    }
                    for (int j = 0; j < 5 && Gamedef.keyword() < 0; ++j) {
                        Gamedef.transnum(con);
                    }
                    for (int k = j; k < 5; ++k) {
                        con.script[Gamedef.scriptptr] = 0;
                        ++scriptptr;
                    }
                }
                return false;
            }
            case 1: {
                if (parsing_state != 0) {
                    Console.out.println("  * ERROR!(L" + line_number + ") Found 'actor' within 'state'.", OsdColor.RED);
                    ++error;
                }
                if (parsing_actor != 0) {
                    Console.out.println("  * ERROR!(L" + line_number + ") Found 'actor' within 'actor'.", OsdColor.RED);
                    ++error;
                }
                num_squigilly_brackets = 0;
                --scriptptr;
                parsing_actor = scriptptr--;
                Gamedef.transnum(con);
                con.actorscrptr[con.script[Gamedef.scriptptr]] = parsing_actor;
                for (int j = 0; j < 4; ++j) {
                    con.script[Gamedef.parsing_actor + j] = 0;
                    if (j == 3) {
                        j = 0;
                        while (Gamedef.keyword() == -1) {
                            Gamedef.transnum(con);
                            j |= con.script[--scriptptr];
                        }
                        con.script[Gamedef.scriptptr] = j;
                        ++scriptptr;
                        break;
                    }
                    if (Gamedef.keyword() >= 0) {
                        for (int i = 4 - j; i > 0; --i) {
                            con.script[Gamedef.scriptptr++] = 0;
                        }
                        break;
                    }
                    Gamedef.transnum(con);
                    con.script[Gamedef.parsing_actor + j] = con.script[scriptptr - 1];
                }
                checking_ifelse = 0;
                return false;
            }
            case 98: {
                if (parsing_state != 0) {
                    Console.out.println("  * ERROR!(L" + line_number + ") Found 'useritem' within 'state'.", OsdColor.RED);
                    ++error;
                }
                if (parsing_actor != 0) {
                    Console.out.println("  * ERROR!(L" + line_number + ") Found 'useritem' within 'actor'.", OsdColor.RED);
                    ++error;
                }
                num_squigilly_brackets = 0;
                --scriptptr;
                parsing_actor = scriptptr--;
                Gamedef.transnum(con);
                int j = con.script[scriptptr];
                Gamedef.transnum(con);
                con.actorscrptr[con.script[--Gamedef.scriptptr]] = parsing_actor;
                con.actortype[con.script[Gamedef.scriptptr]] = (short)j;
                for (j = 0; j < 4; ++j) {
                    con.script[Gamedef.parsing_actor + j] = 0;
                    if (j == 3) {
                        j = 0;
                        while (Gamedef.keyword() == -1) {
                            Gamedef.transnum(con);
                            j |= con.script[--scriptptr];
                        }
                        con.script[Gamedef.scriptptr] = j;
                        ++scriptptr;
                        break;
                    }
                    if (Gamedef.keyword() >= 0) {
                        for (int i = 4 - j; i > 0; --i) {
                            con.script[Gamedef.scriptptr++] = 0;
                        }
                        break;
                    }
                    Gamedef.transnum(con);
                    con.script[Gamedef.parsing_actor + j] = con.script[scriptptr - 1];
                }
                checking_ifelse = 0;
                return false;
            }
            case 2: 
            case 23: 
            case 28: 
            case 37: 
            case 48: 
            case 58: 
            case 99: {
                Gamedef.transnum(con);
                Gamedef.transnum(con);
                return false;
            }
            case 50: {
                Gamedef.transnum(con);
                Gamedef.transnum(con);
                Gamedef.transnum(con);
                Gamedef.transnum(con);
                Gamedef.transnum(con);
                return false;
            }
            case 10: {
                if (checking_ifelse != 0) {
                    checking_ifelse = (short)(checking_ifelse - 1);
                    int tempscrptr = scriptptr++;
                    Gamedef.parsecommand(con);
                    con.script[tempscrptr] = scriptptr;
                    return false;
                } else {
                    --scriptptr;
                    ++error;
                    Console.out.println("  * ERROR!(L" + line_number + ") Found 'else' with no 'if'.", OsdColor.RED);
                }
                return false;
            }
            case 75: {
                Gamedef.transnum(con);
            }
            case 3: 
            case 8: 
            case 9: 
            case 21: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 46: 
            case 53: 
            case 56: 
            case 59: 
            case 62: 
            case 72: 
            case 73: 
            case 78: 
            case 85: 
            case 94: 
            case 111: {
                Gamedef.transnum(con);
            }
            case 5: 
            case 6: 
            case 26: 
            case 27: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 51: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 70: 
            case 71: 
            case 81: 
            case 82: 
            case 90: 
            case 91: 
            case 109: 
            case 112: {
                int j;
                if (tw == 51) {
                    j = 0;
                    do {
                        Gamedef.transnum(con);
                        j |= con.script[--scriptptr];
                    } while (Gamedef.keyword() == -1);
                    con.script[Gamedef.scriptptr] = j;
                    ++scriptptr;
                }
                int tempscrptr = scriptptr++;
                do {
                    if ((j = Gamedef.keyword()) != 20 && j != 39) continue;
                    Gamedef.parsecommand(con);
                } while (j == 20 || j == 39);
                Gamedef.parsecommand(con);
                con.script[tempscrptr] = scriptptr;
                checking_ifelse = (short)(checking_ifelse + 1);
                return false;
            }
            case 29: {
                boolean done;
                num_squigilly_brackets = (short)(num_squigilly_brackets + 1);
                while (!(done = Gamedef.parsecommand(con))) {
                }
                return false;
            }
            case 30: {
                num_squigilly_brackets = (short)(num_squigilly_brackets - 1);
                if (num_squigilly_brackets >= 0) return true;
                Console.out.println("  * ERROR!(L" + line_number + ") Found more '}' than '{'.", OsdColor.RED);
                ++error;
                return true;
            }
            case 76: {
                --scriptptr;
                int j = 0;
                while (text[textptr] != '\n' && text[textptr] != '\u0000') {
                    con.betaname[j] = text[textptr];
                    ++j;
                    ++textptr;
                }
                con.betaname[j] = '\u0000';
                return false;
            }
            case 20: {
                --scriptptr;
                while (text[textptr] != '\n' && text[textptr] != '\u0000') {
                    ++textptr;
                }
                return false;
            }
            case 107: {
                --scriptptr;
                Gamedef.transnum(con);
                int j = con.script[--scriptptr];
                while (text[textptr] == ' ') {
                    ++textptr;
                }
                int i = 0;
                while (text[textptr] != '\n' && text[textptr] != '\u0000') {
                    con.volume_names[j][i] = Character.toUpperCase(text[textptr]);
                    ++textptr;
                    if (++i < 32) continue;
                    Console.out.println("  * ERROR!(L" + line_number + ") Volume name exceeds character size limit of 32.", OsdColor.RED);
                    ++error;
                    while (text[textptr] != '\n' && text[textptr] != '\u0000') {
                        ++textptr;
                    }
                    break block75;
                }
                con.volume_names[j][i - 1] = '\u0000';
                con.nEpisodes = Math.max(con.nEpisodes, j + 1);
                return false;
            }
            case 108: {
                --scriptptr;
                Gamedef.transnum(con);
                int j = con.script[--scriptptr];
                while (text[textptr] == ' ') {
                    ++textptr;
                }
                int i = 0;
                while (text[textptr] != '\n' && text[textptr] != '\u0000') {
                    con.skill_names[j][i] = Character.toUpperCase(text[textptr]);
                    ++textptr;
                    if (++i < 32) continue;
                    Console.out.println("  * ERROR!(L" + line_number + ") Skill name exceeds character size limit of 32.", OsdColor.RED);
                    ++error;
                    while (text[textptr] != '\n' && text[textptr] != '\u0000') {
                        ++textptr;
                    }
                    break block78;
                }
                con.skill_names[j][i - 1] = '\u0000';
                con.nSkills = Math.max(con.nSkills, j + 1);
                return false;
            }
            case 0: {
                --scriptptr;
                Gamedef.transnum(con);
                int j = con.script[--scriptptr];
                Gamedef.transnum(con);
                int k = con.script[--scriptptr];
                while (text[textptr] == ' ') {
                    ++textptr;
                }
                int i = 0;
                while (text[textptr] != ' ' && text[textptr] != '\n' && text[textptr] != '\u0000') {
                    con.level_file_names[j * 11 + k][i] = text[textptr];
                    ++textptr;
                    if (++i <= 127) continue;
                    Console.out.println("  * ERROR!(L" + line_number + ") Level file name exceeds character size limit of 128.", OsdColor.RED);
                    ++error;
                    while (text[textptr] != ' ' && text[textptr] != '\u0000') {
                        ++textptr;
                    }
                    break block81;
                }
                con.level_names[j * 11 + k][i - 1] = '\u0000';
                while (text[textptr] == ' ') {
                    ++textptr;
                }
                con.partime[j * 11 + k] = ((text[textptr] - 48) * 10 + (text[textptr + 1] - 48)) * 26 * 60 + ((text[textptr + 3] - 48) * 10 + (text[textptr + 4] - 48)) * 26;
                textptr += 5;
                while (text[textptr] == ' ') {
                    ++textptr;
                }
                con.designertime[j * 11 + k] = ((text[textptr] - 48) * 10 + (text[textptr + 1] - 48)) * 26 * 60 + ((text[textptr + 3] - 48) * 10 + (text[textptr + 4] - 48)) * 26;
                textptr += 5;
                while (text[textptr] == ' ') {
                    ++textptr;
                }
                i = 0;
                while (text[textptr] != '\n' && text[textptr] != '\u0000') {
                    con.level_names[j * 11 + k][i] = Character.toUpperCase(text[textptr]);
                    ++textptr;
                    if (++i < 32) continue;
                    Console.out.println("  * ERROR!(L" + line_number + ") Level name exceeds character size limit of 32.", OsdColor.RED);
                    ++error;
                    while (text[textptr] != '\n' && text[textptr] != '\u0000') {
                        ++textptr;
                    }
                    break block86;
                }
                con.level_names[j * 11 + k][i - 1] = '\u0000';
                con.nMaps[j] = Math.max(con.nMaps[j], k + 1);
                return false;
            }
            case 79: {
                Gamedef.transnum(con);
                int k = con.script[--scriptptr - 1];
                if (k >= 256) {
                    Console.out.println("  * ERROR!(L" + line_number + ") Quote amount exceeds limit of " + 256 + " characters.", OsdColor.RED);
                    ++error;
                    return false;
                }
                --scriptptr;
                int i = 0;
                while (text[textptr] == ' ') {
                    ++textptr;
                }
                while (text[textptr] != '\n' && text[textptr] != '\u0000') {
                    con.fta_quotes[k][i] = text[textptr];
                    ++textptr;
                    if (++i < 64) continue;
                    Console.out.println("  * ERROR!(L" + line_number + ") Quote exceeds character size limit of 64.", OsdColor.RED);
                    ++error;
                    while (text[textptr] != '\n') {
                        ++textptr;
                    }
                    break block89;
                }
                con.fta_quotes[k][i] = '\u0000';
                String quote = Strhandler.toLowerCase(new String(con.fta_quotes[k]).trim());
                if (!quote.contains("press space")) return false;
                quote = quote.replace("press space", "press \"open\"");
                quote.getChars(0, quote.length(), con.fta_quotes[k], 0);
                con.fta_quotes[k][quote.length()] = '\u0000';
                return false;
            }
            case 57: {
                Gamedef.transnum(con);
                int k = con.script[--scriptptr - 1];
                if (k >= 500) {
                    Console.out.println("  * ERROR!(L" + line_number + ") Exceeded sound limit of " + 500 + ".", OsdColor.RED);
                    ++error;
                }
                --scriptptr;
                int i = 0;
                while (text[textptr] == ' ' && text[textptr] != '\t' && text[textptr] != '\u0000') {
                    ++textptr;
                }
                int soundptr = textptr;
                while (text[textptr] != ' ' && text[textptr] != '\t' && text[textptr] != '\u0000') {
                    ++textptr;
                    if (++i < 128) continue;
                    Console.out.println(new String(text, soundptr, i));
                    Console.out.println("  * ERROR!(L" + line_number + ") Sound filename exceeded limit of 128 characters.", OsdColor.RED);
                    ++error;
                    while (text[textptr] != ' ' && text[textptr] != '\t') {
                        ++textptr;
                    }
                    break block92;
                }
                con.sounds[k] = FileUtils.getCorrectPath(new String(text, soundptr, i));
                Gamedef.transnum(con);
                con.soundps[k] = (short)con.script[scriptptr - 1];
                Gamedef.transnum(con);
                con.soundpe[k] = (short)con.script[--scriptptr - 1];
                Gamedef.transnum(con);
                con.soundpr[k] = (short)con.script[--scriptptr - 1];
                Gamedef.transnum(con);
                con.soundm[k] = (short)con.script[--scriptptr - 1];
                Gamedef.transnum(con);
                con.soundvo[k] = (short)con.script[--scriptptr - 1];
                --scriptptr;
                return false;
            }
            case 4: {
                if (parsing_actor == 0) {
                    Console.out.println("  * ERROR!(L" + line_number + ") Found 'enda' without defining 'actor'.", OsdColor.RED);
                    ++error;
                }
                if (num_squigilly_brackets > 0) {
                    Console.out.println("  * ERROR!(L" + line_number + ") Found more '{' than '}' before 'enda'.", OsdColor.RED);
                    ++error;
                }
                parsing_actor = 0;
                return false;
            }
            case 12: 
            case 16: 
            case 22: 
            case 36: 
            case 38: 
            case 42: 
            case 47: 
            case 61: 
            case 66: 
            case 83: 
            case 84: 
            case 95: 
            case 96: 
            case 97: 
            case 104: 
            case 106: {
                return false;
            }
            case 60: {
                int j;
                for (j = 0; j < 31; ++j) {
                    Gamedef.transnum(con);
                    Gamedef.params[j] = con.script[--scriptptr];
                    if (j != 25 && j != 29) continue;
                    if (error > 0) {
                        return false;
                    }
                    if (Gamedef.keyword() != -1) break;
                    con.type = j == 25 ? 14 : 20;
                }
                j = 0;
                con.const_visibility = params[j++];
                con.impact_damage = params[j++];
                con.max_player_health = params[j++];
                con.max_armour_amount = params[j++];
                con.respawnactortime = params[j++];
                con.respawnitemtime = params[j++];
                con.dukefriction = params[j++];
                if (con.type != 13) {
                    con.gc = params[j++];
                }
                con.rpgblastradius = params[j++];
                con.pipebombblastradius = params[j++];
                con.shrinkerblastradius = params[j++];
                con.tripbombblastradius = params[j++];
                con.morterblastradius = params[j++];
                con.bouncemineblastradius = params[j++];
                con.seenineblastradius = params[j++];
                con.max_ammo_amount[1] = params[j++];
                con.max_ammo_amount[2] = params[j++];
                con.max_ammo_amount[3] = params[j++];
                con.max_ammo_amount[4] = params[j++];
                con.max_ammo_amount[5] = params[j++];
                con.max_ammo_amount[6] = params[j++];
                con.max_ammo_amount[7] = params[j++];
                con.max_ammo_amount[8] = params[j++];
                con.max_ammo_amount[9] = params[j++];
                if (con.type != 13) {
                    con.max_ammo_amount[11] = params[j++];
                }
                con.camerashitable = (char)params[j++];
                con.numfreezebounces = params[j++];
                con.freezerhurtowner = (char)params[j++];
                if (con.type != 13) {
                    con.spriteqamount = (short)params[j++];
                    if (con.spriteqamount > 1024) {
                        con.spriteqamount = (short)1024;
                    } else if (con.spriteqamount < 0) {
                        con.spriteqamount = 0;
                    }
                    con.lasermode = (char)params[j++];
                }
                if (con.type == 20) {
                    con.max_ammo_amount[12] = params[j];
                }
                ++scriptptr;
                return false;
            }
        }
    }

    public static void passone(Script con) {
        while (!Gamedef.parsecommand(con)) {
        }
        if (error + warning > 12) {
            Console.out.println("  * ERROR! Too many warnings or errors.", OsdColor.RED);
        }
    }

    public static Script loadefs(String filenam) throws InitializationException {
        Entry fp = Main.game.getCache().getEntry(filenam, !Globals.loadfromgrouponly);
        if (!fp.exists()) {
            throw new InitializationException("\nMissing con file(s).");
        }
        Console.out.println("Compiling: " + filenam + ".");
        int fs = (int)fp.getSize();
        byte[] buf = new byte[fs + 1];
        label = new char[131072];
        System.arraycopy(fp.getBytes(), 0, buf, 0, fs);
        last_used_text = new String(buf);
        last_used_size = fs;
        text = last_used_text.toCharArray();
        if (fs < text.length) {
            Gamedef.text[fs] = '\u0000';
        }
        Script con = new Script();
        labelcnt = 0;
        scriptptr = 1;
        warning = 0;
        error = 0;
        line_number = 1;
        try {
            Gamedef.passone(con);
        }
        catch (Exception e) {
            e.printStackTrace();
            error = 1;
        }
        if ((warning | error) != 0) {
            Console.out.println("Found " + warning + " warning(s), " + error + " error(s).");
        }
        if (error != 0) {
            throw new InitializationException("\nCompilation error in " + filenam + ".");
        }
        Console.out.println("Code Size:" + ((scriptptr << 2) - 4) + " bytes(" + labelcnt + " labels).");
        return con;
    }

    public static boolean dodge(Sprite s) {
        int mx = s.getX();
        int my = s.getY();
        int mxvect = EngineUtils.sin(s.getAng() + 512 & 0x7FF);
        int myvect = EngineUtils.sin(s.getAng() & 0x7FF);
        for (ListNode<Sprite> node = Main.boardService.getStatNode(4); node != null; node = node.getNext()) {
            int d;
            Sprite sp = node.get();
            if (sp.getOwner() == node.getIndex() || sp.getSectnum() != s.getSectnum()) continue;
            int bx = sp.getX() - mx;
            int by = sp.getY() - my;
            int bxvect = EngineUtils.cos(sp.getAng());
            int byvect = EngineUtils.sin(sp.getAng());
            if (mxvect * bx + myvect * by < 0 || bxvect * bx + byvect * by >= 0 || Pragmas.klabs(d = bxvect * by - byvect * bx) >= 0x400000) continue;
            s.setAng(s.getAng() - (512 + (Main.engine.krand() & 0x400)));
            return true;
        }
        return false;
    }

    public static short furthestangle(int i, int angs) {
        Sprite s = Main.boardService.getSprite(i);
        if (s == null) {
            return 0;
        }
        long greatestd = -1073741824L;
        int angincs = 2048 / angs;
        if (s.getPicnum() != 1405 && (g_t[0] & 0x3F) > 2) {
            return (short)(s.getAng() + 1024);
        }
        int furthest_angle = 0;
        for (int j = s.getAng(); j < 2048 + s.getAng(); j += angincs) {
            Main.engine.hitscan(s.getX(), s.getY(), s.getZ() - 2048, s.getSectnum(), EngineUtils.sin(j + 512 & 0x7FF), EngineUtils.sin(j & 0x7FF), 0, Engine.pHitInfo, 0x1000040);
            long d = Pragmas.klabs(Engine.pHitInfo.hitx - s.getX()) + Pragmas.klabs(Engine.pHitInfo.hity - s.getY());
            if (d <= greatestd) continue;
            greatestd = d;
            furthest_angle = j;
        }
        return (short)(furthest_angle & 0x7FF);
    }

    public static int furthestcanseepoint(int i, Sprite ts, int dax, int day) {
        Sprite s = Main.boardService.getSprite(i);
        if (s == null) {
            return -1;
        }
        furthest_x = dax;
        furthest_y = day;
        if ((g_t[0] & 0x3F) != 0) {
            return -1;
        }
        int angincs = 1024;
        if (Globals.ud.multimode >= 2 || Globals.ud.player_skill >= 3) {
            angincs = (short)(2048 / (1 + (Main.engine.krand() & 1)));
        }
        for (int j = ts.getAng(); j < 2048 + ts.getAng(); j += angincs - (Main.engine.krand() & 0x1FF)) {
            Main.engine.hitscan(ts.getX(), ts.getY(), ts.getZ() - 4096, ts.getSectnum(), EngineUtils.cos(j & 0x7FF), EngineUtils.sin(j & 0x7FF), 16384 - (Main.engine.krand() & Short.MAX_VALUE), Engine.pHitInfo, 0x1000040);
            long d = Pragmas.klabs(Engine.pHitInfo.hitx - ts.getX()) + Pragmas.klabs(Engine.pHitInfo.hity - ts.getY());
            long da = Pragmas.klabs(Engine.pHitInfo.hitx - s.getX()) + Pragmas.klabs(Engine.pHitInfo.hity - s.getY());
            if (d >= da || !Main.engine.cansee(Engine.pHitInfo.hitx, Engine.pHitInfo.hity, Engine.pHitInfo.hitz, Engine.pHitInfo.hitsect, s.getX(), s.getY(), s.getZ() - 4096, s.getSectnum())) continue;
            furthest_x = Engine.pHitInfo.hitx;
            furthest_y = Engine.pHitInfo.hity;
            return Engine.pHitInfo.hitsect;
        }
        return -1;
    }

    public static void alterang(Script con, int a) {
        int j;
        int ticselapsed = g_t[0] & 0x1F;
        short aang = g_sp.getAng();
        g_sp.setXvel(g_sp.getXvel() + (con.script[g_t[1]] - g_sp.getXvel()) / 5);
        if (g_sp.getZvel() < 648) {
            g_sp.setZvel(g_sp.getZvel() + ((con.script[g_t[1] + 1] << 4) - g_sp.getZvel()) / 5);
        }
        if ((a & 0x200) != 0) {
            j = Globals.ps[Gamedef.g_p].holoduke_on;
            Sprite shd = Main.boardService.getSprite(j);
            if (shd != null && Main.engine.cansee(shd.getX(), shd.getY(), shd.getZ(), shd.getSectnum(), g_sp.getX(), g_sp.getY(), g_sp.getZ(), g_sp.getSectnum())) {
                g_sp.setOwner(j);
            } else {
                g_sp.setOwner(Globals.ps[Gamedef.g_p].i);
            }
            int goalang = 0;
            Sprite spo = Main.boardService.getSprite(g_sp.getOwner());
            if (spo != null) {
                goalang = spo.getPicnum() == 1405 ? EngineUtils.getAngle(Globals.hittype[Gamedef.g_i].lastvx - g_sp.getX(), Globals.hittype[Gamedef.g_i].lastvy - g_sp.getY()) : EngineUtils.getAngle(spo.getX() - g_sp.getX(), spo.getY() - g_sp.getY());
            }
            if (g_sp.getXvel() != 0 && g_sp.getPicnum() != 1880) {
                int angdif = Gamedef.getincangle(aang, goalang);
                if (ticselapsed < 2) {
                    if (Pragmas.klabs(angdif) < 256) {
                        j = 128 - (Main.engine.krand() & 0x100);
                        g_sp.setAng(g_sp.getAng() + j);
                        if (Player.hits(g_i) < 844) {
                            g_sp.setAng(g_sp.getAng() - j);
                        }
                    }
                } else if (ticselapsed > 18 && ticselapsed < 26) {
                    if (Pragmas.klabs(angdif >> 2) < 128) {
                        g_sp.setAng(goalang);
                    } else {
                        g_sp.setAng(g_sp.getAng() + (angdif >> 2));
                    }
                }
            } else {
                g_sp.setAng(goalang);
            }
        }
        if (ticselapsed < 1) {
            j = 2;
            if ((a & 0x400) != 0) {
                short goalang = Gamedef.furthestangle(g_i, j);
                g_sp.setAng(goalang);
                g_sp.setOwner(Globals.ps[Gamedef.g_p].i);
            }
            if ((a & 0x80) != 0) {
                short goalang = Gamedef.furthestangle(g_i, j);
                g_sp.setAng(goalang);
            }
        }
    }

    public static void move(Script con) {
        Sector sec;
        int angdif;
        int goalang;
        short a = g_sp.getHitag();
        if (a == -1) {
            a = 0;
        }
        g_t[0] = g_t[0] + 1;
        if ((a & 1) != 0) {
            goalang = Globals.ps[Gamedef.g_p].newowner >= 0 ? EngineUtils.getAngle(Globals.ps[Gamedef.g_p].oposx - g_sp.getX(), Globals.ps[Gamedef.g_p].oposy - g_sp.getY()) : EngineUtils.getAngle(Globals.ps[Gamedef.g_p].posx - g_sp.getX(), Globals.ps[Gamedef.g_p].posy - g_sp.getY());
            angdif = Gamedef.getincangle(g_sp.getAng(), goalang) >> 2;
            if (angdif > -8 && angdif < 0) {
                angdif = 0;
            }
            g_sp.setAng(g_sp.getAng() + angdif);
        }
        if ((a & 0x20) != 0) {
            g_sp.setAng(g_sp.getAng() + (EngineUtils.sin(g_t[0] << 3 & 0x7FF) >> 6));
        }
        if ((a & 0x10) != 0) {
            goalang = Globals.ps[Gamedef.g_p].newowner >= 0 ? EngineUtils.getAngle(Globals.ps[Gamedef.g_p].oposx - g_sp.getX(), Globals.ps[Gamedef.g_p].oposy - g_sp.getY()) : EngineUtils.getAngle(Globals.ps[Gamedef.g_p].posx - g_sp.getX(), Globals.ps[Gamedef.g_p].posy - g_sp.getY());
            angdif = (short)(Pragmas.ksgn(Gamedef.getincangle(g_sp.getAng(), goalang)) << 5);
            if (angdif > -32 && angdif < 0) {
                angdif = 0;
                g_sp.setAng(goalang);
            }
            g_sp.setAng(g_sp.getAng() + angdif);
        }
        if ((a & 0x101) == 257 && g_t[0] < 16) {
            g_sp.setZvel(g_sp.getZvel() - (EngineUtils.sin(512 + (g_t[0] << 4) & 0x7FF) >> 5));
        }
        if ((a & 0x40) != 0) {
            int newx = Globals.ps[Gamedef.g_p].posx + Globals.ps[Gamedef.g_p].posxv / 768;
            int newy = Globals.ps[Gamedef.g_p].posy + Globals.ps[Gamedef.g_p].posyv / 768;
            goalang = EngineUtils.getAngle(newx - g_sp.getX(), newy - g_sp.getY());
            angdif = (short)(Gamedef.getincangle(g_sp.getAng(), goalang) >> 2);
            if (angdif > -8 && angdif < 0) {
                angdif = 0;
            }
            g_sp.setAng(g_sp.getAng() + angdif);
        }
        if (g_t[1] == 0 || a == 0) {
            Interpolation.ILoc oldLoc = Main.game.pInt.getsprinterpolate(g_i);
            if (oldLoc != null && (Actors.badguy(g_sp) && g_sp.getExtra() <= 0 || oldLoc.x != g_sp.getX() || oldLoc.y != g_sp.getY())) {
                oldLoc.x = g_sp.getX();
                oldLoc.y = g_sp.getY();
                Main.engine.setsprite(g_i, g_sp.getX(), g_sp.getY(), g_sp.getZ());
            }
            return;
        }
        if ((a & 2) != 0) {
            g_sp.setXvel(g_sp.getXvel() + (con.script[g_t[1]] - g_sp.getXvel() >> 1));
        }
        if ((a & 4) != 0) {
            g_sp.setZvel(g_sp.getZvel() + ((con.script[g_t[1] + 1] << 4) - g_sp.getZvel() >> 1));
        }
        if ((a & 0x1000) != 0) {
            Gamedef.dodge(g_sp);
        }
        if (g_sp.getPicnum() != 1405) {
            Gamedef.alterang(con, a);
        }
        if (g_sp.getXvel() > -6 && g_sp.getXvel() < 6) {
            g_sp.setXvel(0);
        }
        a = (short)(Actors.badguy(g_sp) ? 1 : 0);
        if (g_sp.getXvel() != 0 || g_sp.getZvel() != 0) {
            if (a != 0 && g_sp.getPicnum() != 2360) {
                if ((g_sp.getPicnum() == 1880 || g_sp.getPicnum() == 1920) && g_sp.getExtra() > 0) {
                    if (g_sp.getPicnum() == 1920) {
                        int l;
                        Globals.hittype[Gamedef.g_i].floorz = l = Main.engine.getflorzofslope(g_sp.getSectnum(), g_sp.getX(), g_sp.getY());
                        if (g_sp.getZ() > l - 2048) {
                            if (g_sp.getZ() > l - 2048) {
                                g_sp.setZ(l - 2048);
                            }
                            g_sp.setZvel(0);
                        }
                        Globals.hittype[Gamedef.g_i].ceilingz = l = Main.engine.getceilzofslope(g_sp.getSectnum(), g_sp.getX(), g_sp.getY());
                        if (g_sp.getZ() - l < 20480) {
                            g_sp.setZ(l + 20480);
                            g_sp.setZvel(0);
                        }
                    } else if (g_sp.getZvel() > 0) {
                        int l;
                        Globals.hittype[Gamedef.g_i].floorz = l = Main.engine.getflorzofslope(g_sp.getSectnum(), g_sp.getX(), g_sp.getY());
                        if (g_sp.getZ() > l - 7680) {
                            g_sp.setZ(l - 7680);
                        }
                    } else {
                        int l;
                        Globals.hittype[Gamedef.g_i].ceilingz = l = Main.engine.getceilzofslope(g_sp.getSectnum(), g_sp.getX(), g_sp.getY());
                        if (g_sp.getZ() - l < 12800) {
                            g_sp.setZ(l + 12800);
                            g_sp.setZvel(0);
                        }
                    }
                } else if (g_sp.getPicnum() != 2420) {
                    if (g_sp.getZvel() > 0 && Globals.hittype[Gamedef.g_i].floorz < g_sp.getZ()) {
                        g_sp.setZ(Globals.hittype[Gamedef.g_i].floorz);
                    }
                    if (g_sp.getZvel() < 0) {
                        int l = Main.engine.getceilzofslope(g_sp.getSectnum(), g_sp.getX(), g_sp.getY());
                        if (g_sp.getZ() - l < 16896) {
                            g_sp.setZ(l + 16896);
                            g_sp.setZvel(g_sp.getZvel() >> 1);
                        }
                    }
                }
            } else if (g_sp.getPicnum() == 1405 && g_sp.getZ() - Globals.hittype[Gamedef.g_i].ceilingz < 8192) {
                g_sp.setZ(Globals.hittype[Gamedef.g_i].ceilingz + 8192);
            }
            int daxvel = g_sp.getXvel();
            angdif = g_sp.getAng();
            if (a != 0 && g_sp.getPicnum() != 2360) {
                if (g_x < 960 && g_sp.getXrepeat() > 16) {
                    daxvel = -(1024 - g_x);
                    angdif = EngineUtils.getAngle(Globals.ps[Gamedef.g_p].posx - g_sp.getX(), Globals.ps[Gamedef.g_p].posy - g_sp.getY());
                    if (g_x < 512) {
                        Globals.ps[Gamedef.g_p].posxv = 0;
                        Globals.ps[Gamedef.g_p].posyv = 0;
                    } else {
                        Globals.ps[Gamedef.g_p].posxv = Pragmas.mulscale(Globals.ps[Gamedef.g_p].posxv, con.dukefriction - 8192, 16);
                        Globals.ps[Gamedef.g_p].posyv = Pragmas.mulscale(Globals.ps[Gamedef.g_p].posyv, con.dukefriction - 8192, 16);
                    }
                } else if (g_sp.getPicnum() != 1880 && g_sp.getPicnum() != 1550 && g_sp.getPicnum() != 1920) {
                    Interpolation.ILoc oldLoc = Main.game.pInt.getsprinterpolate(g_i);
                    if (oldLoc != null && oldLoc.z != g_sp.getZ() || Globals.ud.multimode < 2 && Globals.ud.player_skill < 2) {
                        if ((g_t[0] & 1) != 0 || Globals.ps[Gamedef.g_p].actorsqu == g_i) {
                            return;
                        }
                        daxvel <<= 1;
                    } else {
                        if ((g_t[0] & 3) != 0 || Globals.ps[Gamedef.g_p].actorsqu == g_i) {
                            return;
                        }
                        daxvel <<= 2;
                    }
                }
            }
            Globals.hittype[Gamedef.g_i].movflag = Actors.movesprite(g_i, daxvel * EngineUtils.sin(angdif + 512 & 0x7FF) >> 14, daxvel * EngineUtils.sin(angdif & 0x7FF) >> 14, g_sp.getZvel(), 65537);
        }
        if ((sec = Main.boardService.getSector(g_sp.getSectnum())) != null && a != 0) {
            if ((sec.getCeilingstat() & 1) != 0) {
                g_sp.setShade(g_sp.getShade() + (sec.getCeilingshade() - g_sp.getShade() >> 1));
            } else {
                g_sp.setShade(g_sp.getShade() + (sec.getFloorshade() - g_sp.getShade() >> 1));
            }
            if (sec.getFloorpicnum() == 560) {
                Main.engine.deletesprite(g_i);
            }
        }
    }

    public static void parseifelse(Script con, boolean condition) {
        if (condition) {
            insptr += 2;
            Gamedef.parse(con);
        } else if (con.script[insptr = con.script[insptr + 1]] == 10) {
            insptr += 2;
            Gamedef.parse(con);
        }
    }

    public static boolean parse(Script con) {
        if (killit_flag != 0) {
            return true;
        }
        block0 : switch (con.script[insptr]) {
            case 3: {
                Gamedef.parseifelse(con, Gameutils.rnd(con.script[++insptr]));
                break;
            }
            case 45: {
                int j;
                if (g_x > 1024) {
                    int angdif;
                    int sclip;
                    if (Actors.badguy(g_sp) && g_sp.getXrepeat() > 56) {
                        sclip = 3084;
                        angdif = 48;
                    } else {
                        sclip = 768;
                        angdif = 16;
                    }
                    j = Player.hitasprite(g_i);
                    int temphit = Engine.pHitInfo.hitsprite;
                    if (j == 0x40000000) {
                        Gamedef.parseifelse(con, true);
                        break;
                    }
                    if (j > sclip) {
                        Sprite hsp = Main.boardService.getSprite(temphit);
                        if (hsp != null && hsp.getPicnum() == g_sp.getPicnum()) {
                            j = 0;
                        } else {
                            g_sp.setAng(g_sp.getAng() + angdif);
                            j = Player.hitasprite(g_i);
                            temphit = Engine.pHitInfo.hitsprite;
                            hsp = Main.boardService.getSprite(temphit);
                            g_sp.setAng(g_sp.getAng() - angdif);
                            if (j > sclip) {
                                if (hsp != null && hsp.getPicnum() == g_sp.getPicnum()) {
                                    j = 0;
                                } else {
                                    g_sp.setAng(g_sp.getAng() - angdif);
                                    j = Player.hitasprite(g_i);
                                    temphit = Engine.pHitInfo.hitsprite;
                                    hsp = Main.boardService.getSprite(temphit);
                                    g_sp.setAng(g_sp.getAng() + angdif);
                                    j = j > 768 ? (hsp != null && hsp.getPicnum() == g_sp.getPicnum() ? 0 : 1) : 0;
                                }
                            } else {
                                j = 0;
                            }
                        }
                    } else {
                        j = 0;
                    }
                } else {
                    j = 1;
                }
                Gamedef.parseifelse(con, j != 0);
                break;
            }
            case 91: {
                Sprite psp = Main.boardService.getSprite(Globals.ps[Gamedef.g_p].i);
                if (psp == null) break;
                boolean cansee = Main.engine.cansee(g_sp.getX(), g_sp.getY(), g_sp.getZ() - ((Main.engine.krand() & 0x29) << 8), g_sp.getSectnum(), Globals.ps[Gamedef.g_p].posx, Globals.ps[Gamedef.g_p].posy, Globals.ps[Gamedef.g_p].posz, psp.getSectnum());
                Gamedef.parseifelse(con, cansee);
                if (!cansee) break;
                Globals.hittype[Gamedef.g_i].timetosleep = 1536;
                break;
            }
            case 49: {
                Gamedef.parseifelse(con, Globals.hittype[Gamedef.g_i].actorstayput == -1);
                break;
            }
            case 5: {
                boolean cansee;
                Sprite spr;
                if (Globals.ps[Gamedef.g_p].holoduke_on >= 0) {
                    spr = Main.boardService.getSprite(Globals.ps[Gamedef.g_p].holoduke_on);
                    boolean bl = cansee = spr != null && Main.engine.cansee(g_sp.getX(), g_sp.getY(), g_sp.getZ() - (Main.engine.krand() & 0x1FFF), g_sp.getSectnum(), spr.getX(), spr.getY(), spr.getZ(), spr.getSectnum());
                    if (!cansee) {
                        spr = Main.boardService.getSprite(Globals.ps[Gamedef.g_p].i);
                    }
                } else {
                    spr = Main.boardService.getSprite(Globals.ps[Gamedef.g_p].i);
                }
                if (spr == null) break;
                cansee = Main.engine.cansee(g_sp.getX(), g_sp.getY(), g_sp.getZ() - (Main.engine.krand() & 0x2F00), g_sp.getSectnum(), spr.getX(), spr.getY(), spr.getZ() - 6144, spr.getSectnum());
                if (!cansee) {
                    int j = Gamedef.furthestcanseepoint(g_i, spr, Globals.hittype[Gamedef.g_i].lastvx, Globals.hittype[Gamedef.g_i].lastvy);
                    Globals.hittype[Gamedef.g_i].lastvx = furthest_x;
                    Globals.hittype[Gamedef.g_i].lastvy = furthest_y;
                    cansee = j != -1;
                } else {
                    Globals.hittype[Gamedef.g_i].lastvx = spr.getX();
                    Globals.hittype[Gamedef.g_i].lastvy = spr.getY();
                }
                if (cansee && (g_sp.getStatnum() == 1 || g_sp.getStatnum() == 6)) {
                    Globals.hittype[Gamedef.g_i].timetosleep = 1536;
                }
                Gamedef.parseifelse(con, cansee);
                break;
            }
            case 6: {
                Gamedef.parseifelse(con, Actors.ifhitbyweapon(g_i) >= 0);
                break;
            }
            case 27: {
                Gamedef.parseifelse(con, Actors.ifsquished(g_i, g_p));
                break;
            }
            case 26: {
                int j = g_sp.getExtra();
                if (g_sp.getPicnum() == 1405) {
                    --j;
                }
                Gamedef.parseifelse(con, j < 0);
                break;
            }
            case 24: {
                Gamedef.g_t[5] = con.script[++insptr];
                Gamedef.g_t[4] = con.script[g_t[5]];
                Gamedef.g_t[1] = con.script[g_t[5] + 1];
                g_sp.setHitag((short)con.script[g_t[5] + 2]);
                Gamedef.g_t[3] = 0;
                Gamedef.g_t[2] = 0;
                Gamedef.g_t[0] = 0;
                if ((g_sp.getHitag() & 8) != 0) {
                    g_sp.setAng((short)(Main.engine.krand() & 0x7FF));
                }
                ++insptr;
                break;
            }
            case 7: {
                Gamedef.g_t[2] = 0;
                Gamedef.g_t[3] = 0;
                Gamedef.g_t[4] = con.script[++insptr];
                ++insptr;
                break;
            }
            case 8: {
                Gamedef.parseifelse(con, g_x < con.script[++insptr]);
                if (g_x <= 16384 || Globals.hittype[Gamedef.g_i].timetosleep != 0) break;
                Globals.hittype[Gamedef.g_i].timetosleep = 1536;
                break;
            }
            case 9: {
                Gamedef.parseifelse(con, g_x > con.script[++insptr]);
                if (g_x <= 16384 || Globals.hittype[Gamedef.g_i].timetosleep != 0) break;
                Globals.hittype[Gamedef.g_i].timetosleep = 1536;
                break;
            }
            case 10: {
                insptr = con.script[insptr + 1];
                break;
            }
            case 100: {
                g_sp.setExtra(g_sp.getExtra() + con.script[++insptr]);
                ++insptr;
                break;
            }
            case 11: {
                g_sp.setExtra((short)con.script[++insptr]);
                ++insptr;
                break;
            }
            case 94: {
                ++insptr;
                if (Globals.ud.coop >= 1 && Globals.ud.multimode > 1) {
                    if (con.script[insptr] == 0) {
                        int j;
                        for (j = 0; j < Globals.ps[Gamedef.g_p].weapreccnt && Globals.ps[Gamedef.g_p].weaprecs[j] != g_sp.getPicnum(); ++j) {
                        }
                        Gamedef.parseifelse(con, j < Globals.ps[Gamedef.g_p].weapreccnt && g_sp.getOwner() == g_i);
                        break;
                    }
                    if (Globals.ps[Gamedef.g_p].weapreccnt >= 16) break;
                    short s = Globals.ps[Gamedef.g_p].weapreccnt;
                    Globals.ps[Gamedef.g_p].weapreccnt = (short)(s + 1);
                    Globals.ps[Gamedef.g_p].weaprecs[s] = g_sp.getPicnum();
                    Gamedef.parseifelse(con, g_sp.getOwner() == g_i);
                    break;
                }
                Gamedef.parseifelse(con, false);
                break;
            }
            case 95: {
                ++insptr;
                if (g_sp.getPicnum() == 1405) {
                    g_sp.setPal(Globals.ps[Gamedef.g_sp.getYvel()].palookup);
                } else {
                    if (g_sp.getPicnum() == 675 && Globals.hittype[Gamedef.g_i].temp_data[5] == 677 && g_sp.getPal() == 1) {
                        Globals.ps[Mmulti.connecthead].max_actors_killed = (short)(Globals.ps[Mmulti.connecthead].max_actors_killed + 1);
                        Globals.hittype[Gamedef.g_i].temp_data[5] = 0;
                    }
                    g_sp.setPal((short)Globals.hittype[Gamedef.g_i].tempang);
                }
                Globals.hittype[Gamedef.g_i].tempang = 0;
                break;
            }
            case 104: {
                ++insptr;
                Weapons.checkweapons(Globals.ps[g_sp.getYvel()]);
                break;
            }
            case 106: {
                ++insptr;
                break;
            }
            case 97: {
                ++insptr;
                if (Globals.Sound[g_sp.getYvel()].getSoundOwnerCount() != 0) break;
                Sounds.spritesound(g_sp.getYvel(), g_i);
                break;
            }
            case 96: {
                ++insptr;
                if (Globals.ud.multimode > 1 && g_sp.getPicnum() == 1405) {
                    if (Globals.ps[Actors.otherp].quick_kick != 0) break;
                    Globals.ps[Actors.otherp].quick_kick = (short)14;
                    break;
                }
                if (g_sp.getPicnum() == 1405 || Globals.ps[Gamedef.g_p].quick_kick != 0) break;
                Globals.ps[Gamedef.g_p].quick_kick = (short)14;
                break;
            }
            case 28: {
                if (con.type == 13 && con.script[++insptr] == 0) {
                    con.script[Gamedef.insptr] = 4;
                }
                int j = con.script[insptr] - g_sp.getXrepeat() << 1;
                g_sp.setXrepeat(g_sp.getXrepeat() + Pragmas.ksgn(j));
                if ((g_sp.getPicnum() == 1405 && g_sp.getYrepeat() < 36 || con.script[++insptr] < g_sp.getYrepeat() || g_sp.getYrepeat() * (Main.engine.getTile(g_sp.getPicnum()).getHeight() + 8) << 2 < Globals.hittype[Gamedef.g_i].floorz - Globals.hittype[Gamedef.g_i].ceilingz) && Pragmas.klabs(j = con.script[insptr] - g_sp.getYrepeat() << 1) != 0) {
                    g_sp.setYrepeat(g_sp.getYrepeat() + Pragmas.ksgn(j));
                }
                ++insptr;
                break;
            }
            case 99: {
                g_sp.setXrepeat((short)con.script[++insptr]);
                g_sp.setYrepeat((short)con.script[++insptr]);
                ++insptr;
                break;
            }
            case 13: {
                Weapons.shoot(g_i, con.script[++insptr]);
                ++insptr;
                break;
            }
            case 87: {
                if (Globals.Sound[con.script[++insptr]].getSoundOwnerCount() == 0) {
                    Sounds.spritesound((short)con.script[insptr], g_i);
                }
                ++insptr;
                break;
            }
            case 89: {
                if (Globals.Sound[con.script[++insptr]].getSoundOwnerCount() > 0) {
                    Sounds.stopsound((short)con.script[insptr]);
                }
                ++insptr;
                break;
            }
            case 92: {
                ++insptr;
                if (g_p == Globals.screenpeek || Globals.ud.coop == 1) {
                    Sounds.spritesound((short)con.script[insptr], Globals.ps[Globals.screenpeek].i);
                }
                ++insptr;
                break;
            }
            case 15: {
                Sounds.spritesound((short)con.script[++insptr], g_i);
                ++insptr;
                break;
            }
            case 84: {
                ++insptr;
                Globals.ps[Gamedef.g_p].tipincs = (short)26;
                break;
            }
            case 16: {
                ++insptr;
                g_sp.setXoffset(0);
                g_sp.setYoffset(0);
                Sector sec = Main.boardService.getSector(g_sp.getSectnum());
                if (sec == null) break;
                long c = DSector.floorspace(g_sp.getSectnum()) ? 0L : (DSector.ceilingspace(g_sp.getSectnum()) || sec.getLotag() == 2 ? (long)(con.gc / 6) : (long)con.gc);
                if (Globals.hittype[Gamedef.g_i].cgg <= 0 || (sec.getFloorstat() & 2) != 0) {
                    Gamedef.getglobalz(g_i);
                    Globals.hittype[Gamedef.g_i].cgg = (short)6;
                } else {
                    Globals.hittype[Gamedef.g_i].cgg = (short)(Globals.hittype[Gamedef.g_i].cgg - 1);
                }
                if (g_sp.getZ() < Globals.hittype[Gamedef.g_i].floorz - 256) {
                    g_sp.setZvel((int)((long)g_sp.getZvel() + c));
                    g_sp.setZ(g_sp.getZ() + g_sp.getZvel());
                    if (g_sp.getZvel() <= 6144) break;
                    g_sp.setZvel(6144);
                    break;
                }
                g_sp.setZ(Globals.hittype[Gamedef.g_i].floorz - 256);
                if (Actors.badguy(g_sp) || g_sp.getPicnum() == 1405 && g_sp.getOwner() >= 0) {
                    if (g_sp.getZvel() > 3084 && g_sp.getExtra() <= 1) {
                        if (g_sp.getPal() != 1 && g_sp.getPicnum() != 1880 && (g_sp.getPicnum() != 1405 || g_sp.getExtra() <= 0)) {
                            Spawn.guts(g_sp, 2286, 15, g_p);
                            Sounds.spritesound(69, g_i);
                            Spawn.spawn(g_i, 1226);
                        }
                        Globals.hittype[Gamedef.g_i].picnum = 2595;
                        Globals.hittype[Gamedef.g_i].extra = 1;
                        g_sp.setZvel(0);
                    } else if (g_sp.getZvel() > 2048 && sec.getLotag() != 1) {
                        short pushsect = g_sp.getSectnum();
                        Main.engine.pushmove(g_sp.getX(), g_sp.getY(), g_sp.getZ(), pushsect, 128, 1024, 1024, 65537);
                        g_sp.setX(Engine.pushmove_x);
                        g_sp.setY(Engine.pushmove_y);
                        g_sp.setZ(Engine.pushmove_z);
                        pushsect = Engine.pushmove_sectnum;
                        if (pushsect != g_sp.getSectnum() && pushsect != -1) {
                            Main.engine.changespritesect(g_i, pushsect);
                        }
                        Sounds.spritesound(158, g_i);
                    }
                }
                if (sec.getLotag() == 1) {
                    switch (g_sp.getPicnum()) {
                        case 1820: 
                        case 1880: 
                        case 1920: {
                            break block0;
                        }
                    }
                    g_sp.setZ(g_sp.getZ() + 6144);
                    break;
                }
                g_sp.setZvel(0);
                break;
            }
            case 4: 
            case 12: 
            case 18: {
                return true;
            }
            case 30: {
                ++insptr;
                return true;
            }
            case 2: {
                int ammo = con.script[++insptr];
                if (ammo < 13) {
                    if (Globals.ps[Gamedef.g_p].ammo_amount[con.script[insptr]] >= con.max_ammo_amount[con.script[insptr]]) {
                        killit_flag = 2;
                        break;
                    }
                    Weapons.addammo(con.script[insptr], Globals.ps[g_p], con.script[insptr + 1]);
                    if (Globals.ps[Gamedef.g_p].curr_weapon == 0 && Globals.ps[Gamedef.g_p].gotweapon[con.script[insptr]]) {
                        Weapons.addweapon(Globals.ps[g_p], con.script[insptr]);
                    }
                }
                insptr += 2;
                break;
            }
            case 86: {
                Spawn.lotsofmoney(g_sp, con.script[++insptr]);
                ++insptr;
                break;
            }
            case 102: {
                Spawn.lotsofmail(g_sp, con.script[++insptr]);
                ++insptr;
                break;
            }
            case 105: {
                Globals.hittype[Gamedef.g_i].timetosleep = (short)con.script[++insptr];
                ++insptr;
                break;
            }
            case 103: {
                Spawn.lotsofpaper(g_sp, con.script[++insptr]);
                ++insptr;
                break;
            }
            case 88: {
                ++insptr;
                if (Globals.hittype[Gamedef.g_i].temp_data[5] != 677 || g_sp.getPal() != 1) {
                    Globals.ps[Mmulti.connecthead].actors_killed = (short)(Globals.ps[Mmulti.connecthead].actors_killed + (short)con.script[insptr]);
                    if (Globals.ud.coop == 1) {
                        Globals.ps[Gamedef.g_p].frag = (short)(Globals.ps[Gamedef.g_p].frag + (short)con.script[insptr]);
                    }
                }
                Globals.hittype[Gamedef.g_i].actorstayput = -1;
                ++insptr;
                break;
            }
            case 93: {
                Spawn.spriteglass(g_i, con.script[++insptr]);
                ++insptr;
                break;
            }
            case 22: {
                ++insptr;
                killit_flag = 1;
                break;
            }
            case 23: {
                int weap = con.script[++insptr];
                if (weap < 13) {
                    if (!Globals.ps[Gamedef.g_p].gotweapon[weap]) {
                        Weapons.addweapon(Globals.ps[g_p], weap);
                    } else if (Globals.ps[Gamedef.g_p].ammo_amount[weap] >= con.max_ammo_amount[weap]) {
                        killit_flag = 2;
                        break;
                    }
                    Weapons.addammo(weap, Globals.ps[g_p], con.script[insptr + 1]);
                    if (Globals.ps[Gamedef.g_p].curr_weapon == 0 && Globals.ps[Gamedef.g_p].gotweapon[weap]) {
                        Weapons.addweapon(Globals.ps[g_p], weap);
                    }
                }
                insptr += 2;
                break;
            }
            case 68: {
                Console.out.println("" + con.script[++insptr]);
                ++insptr;
                break;
            }
            case 69: {
                Globals.ps[Gamedef.g_p].timebeforeexit = (short)con.script[++insptr];
                Globals.ps[Gamedef.g_p].customexitsound = (short)-1;
                Globals.ud.eog = 1;
                ++insptr;
                break;
            }
            case 25: {
                Sprite psp;
                ++insptr;
                if (Globals.ps[Gamedef.g_p].newowner >= 0) {
                    Globals.ps[Gamedef.g_p].newowner = (short)-1;
                    Globals.ps[Gamedef.g_p].posx = Globals.ps[Gamedef.g_p].oposx;
                    Globals.ps[Gamedef.g_p].posy = Globals.ps[Gamedef.g_p].oposy;
                    Globals.ps[Gamedef.g_p].posz = Globals.ps[Gamedef.g_p].oposz;
                    Globals.ps[Gamedef.g_p].ang = Globals.ps[Gamedef.g_p].oang;
                    Globals.ps[Gamedef.g_p].cursectnum = Main.engine.updatesector(Globals.ps[Gamedef.g_p].posx, Globals.ps[Gamedef.g_p].posy, Globals.ps[Gamedef.g_p].cursectnum);
                    Player.setpal(Globals.ps[g_p]);
                    for (ListNode<Sprite> node = Main.boardService.getStatNode(1); node != null; node = node.getNext()) {
                        Sprite sp = node.get();
                        if (sp.getPicnum() != 621) continue;
                        sp.setYvel(0);
                    }
                }
                if ((psp = Main.boardService.getSprite(Globals.ps[Gamedef.g_p].i)) == null) break;
                int j = psp.getExtra();
                if (g_sp.getPicnum() != 100) {
                    if (j > con.max_player_health && con.script[insptr] > 0) {
                        ++insptr;
                        break;
                    }
                    if (j > 0) {
                        j += con.script[insptr];
                    }
                    if (j > con.max_player_health && con.script[insptr] > 0) {
                        j = con.max_player_health;
                    }
                } else {
                    if (j > 0) {
                        j += con.script[insptr];
                    }
                    if (j > con.max_player_health << 1) {
                        j = con.max_player_health << 1;
                    }
                }
                if (j < 0) {
                    j = 0;
                }
                if (!Globals.ud.god) {
                    if (con.script[insptr] > 0) {
                        if (j - con.script[insptr] < con.max_player_health >> 2 && j >= con.max_player_health >> 2) {
                            Sounds.spritesound(229, Globals.ps[Gamedef.g_p].i);
                        }
                        Globals.ps[Gamedef.g_p].last_extra = (short)j;
                    }
                    psp.setExtra((short)j);
                }
                ++insptr;
                break;
            }
            case 17: {
                int tempscrptr = insptr + 2;
                insptr = con.script[insptr + 1];
                while (!Gamedef.parse(con)) {
                }
                insptr = tempscrptr;
                break;
            }
            case 29: {
                ++insptr;
                while (!Gamedef.parse(con)) {
                }
                break;
            }
            case 32: {
                Gamedef.g_t[0] = 0;
                Gamedef.g_t[1] = con.script[++insptr];
                g_sp.setHitag((short)con.script[++insptr]);
                ++insptr;
                if ((g_sp.getHitag() & 8) == 0) break;
                g_sp.setAng((short)(Main.engine.krand() & 0x7FF));
                break;
            }
            case 31: {
                ++insptr;
                Sector g_sec = Main.boardService.getSector(g_sp.getSectnum());
                if (g_sec != null) {
                    if (g_sp.getPicnum() == 675 && con.script[insptr] == 2370) {
                        Globals.hittype[Gamedef.g_i].temp_data[5] = 677;
                    }
                    Spawn.spawn(g_i, con.script[insptr]);
                }
                ++insptr;
                break;
            }
            case 33: 
            case 59: {
                Gamedef.parseifelse(con, Globals.hittype[Gamedef.g_i].picnum == con.script[++insptr]);
                break;
            }
            case 21: {
                Gamedef.parseifelse(con, g_t[5] == con.script[++insptr]);
                break;
            }
            case 34: {
                Gamedef.parseifelse(con, g_t[4] == con.script[++insptr]);
                break;
            }
            case 35: {
                Gamedef.parseifelse(con, g_t[2] >= con.script[++insptr]);
                break;
            }
            case 36: {
                ++insptr;
                Gamedef.g_t[2] = 0;
                break;
            }
            case 37: {
                int dnum = con.script[++insptr];
                ++insptr;
                Sector g_sec = Main.boardService.getSector(g_sp.getSectnum());
                if (g_sec != null) {
                    for (int j = con.script[insptr] - 1; j >= 0; --j) {
                        int s = g_sp.getPicnum() == 3400 && dnum == 2400 ? 0 : Main.engine.krand() % 3;
                        int vz = -(Main.engine.krand() & 0x7FF);
                        int ve = (Main.engine.krand() & 0x7F) + 32;
                        int va = Main.engine.krand() & 0x7FF;
                        int vy = 32 + (Main.engine.krand() & 0xF);
                        int vx = 32 + (Main.engine.krand() & 0xF);
                        int sz = g_sp.getZ() - 2048 - (Main.engine.krand() & 0x1FFF);
                        int sy = g_sp.getY() + (Main.engine.krand() & 0xFF) - 128;
                        int sx = g_sp.getX() + (Main.engine.krand() & 0xFF) - 128;
                        int l = Spawn.EGS(g_sp.getSectnum(), sx, sy, sz, dnum + s, g_sp.getShade(), vx, vy, va, ve, vz, g_i, 5);
                        Sprite sp = Main.boardService.getSprite(l);
                        if (sp == null) continue;
                        if (g_sp.getPicnum() == 3400 && dnum == 2400) {
                            sp.setYvel(Globals.weaponsandammosprites[j % 14]);
                        } else {
                            sp.setYvel(-1);
                        }
                        sp.setPal(g_sp.getPal());
                    }
                }
                ++insptr;
                break;
            }
            case 52: {
                Gamedef.g_t[0] = (short)con.script[++insptr];
                ++insptr;
                break;
            }
            case 101: {
                g_sp.setCstat(g_sp.getCstat() | (short)con.script[++insptr]);
                ++insptr;
                break;
            }
            case 110: {
                g_sp.setClipdist((short)con.script[++insptr]);
                ++insptr;
                break;
            }
            case 40: {
                g_sp.setCstat((short)con.script[++insptr]);
                ++insptr;
                break;
            }
            case 41: {
                Gamedef.parseifelse(con, g_t[1] == con.script[++insptr]);
                break;
            }
            case 112: {
                Gamedef.parseifelse(con, false);
                break;
            }
            case 42: {
                ++insptr;
                if (Globals.ud.multimode < 2) {
                    if (DemoScreen.isDemoPlaying()) break;
                    if (!Main.gGameScreen.enterlevel(Main.gGameScreen.getTitle(), Globals.ud.volume_number, Globals.ud.level_number)) {
                        Main.game.show();
                        return false;
                    }
                    killit_flag = 2;
                } else {
                    Premap.pickrandomspot(g_p);
                    Main.game.pInt.clearspriteinterpolate(g_i);
                    Main.game.pInt.setsprinterpolate(g_i, Main.boardService.getSprite(Globals.ps[Gamedef.g_p].i));
                    Globals.ps[Gamedef.g_p].bobposx = Globals.ps[Gamedef.g_p].oposx = Globals.ps[Gamedef.g_p].posx;
                    g_sp.setX(Globals.ps[Gamedef.g_p].oposx);
                    Globals.ps[Gamedef.g_p].bobposy = Globals.ps[Gamedef.g_p].oposy = Globals.ps[Gamedef.g_p].posy;
                    g_sp.setY(Globals.ps[Gamedef.g_p].oposy);
                    Globals.ps[Gamedef.g_p].oposz = Globals.ps[Gamedef.g_p].posz;
                    g_sp.setZ(Globals.ps[Gamedef.g_p].oposz);
                    Globals.ps[Gamedef.g_p].cursectnum = Main.engine.updatesector(Globals.ps[Gamedef.g_p].posx, Globals.ps[Gamedef.g_p].posy, Globals.ps[Gamedef.g_p].cursectnum);
                    Main.engine.setsprite(Globals.ps[Gamedef.g_p].i, Globals.ps[Gamedef.g_p].posx, Globals.ps[Gamedef.g_p].posy, Globals.ps[Gamedef.g_p].posz + 9728);
                    g_sp.setCstat(257);
                    g_sp.setShade(-12);
                    g_sp.setClipdist(64);
                    g_sp.setXrepeat(42);
                    g_sp.setYrepeat(36);
                    g_sp.setOwner(g_i);
                    g_sp.setXoffset(0);
                    g_sp.setPal(Globals.ps[Gamedef.g_p].palookup);
                    g_sp.setExtra(con.max_player_health);
                    Globals.ps[Gamedef.g_p].last_extra = (short)con.max_player_health;
                    Globals.ps[Gamedef.g_p].wantweaponfire = (short)-1;
                    Globals.ps[Gamedef.g_p].horiz = 100.0f;
                    Globals.ps[Gamedef.g_p].on_crane = (short)-1;
                    Globals.ps[Gamedef.g_p].frag_ps = g_p;
                    Globals.ps[Gamedef.g_p].horizoff = 0;
                    Globals.ps[Gamedef.g_p].opyoff = 0;
                    Globals.ps[Gamedef.g_p].wackedbyactor = (short)-1;
                    Globals.ps[Gamedef.g_p].shield_amount = (short)con.max_armour_amount;
                    Globals.ps[Gamedef.g_p].dead_flag = 0;
                    Globals.ps[Gamedef.g_p].pals_time = 0;
                    Globals.ps[Gamedef.g_p].footprintcount = 0;
                    Globals.ps[Gamedef.g_p].weapreccnt = 0;
                    Globals.ps[Gamedef.g_p].posyv = 0;
                    Globals.ps[Gamedef.g_p].posxv = 0;
                    Globals.ps[Gamedef.g_p].rotscrnang = 0;
                    Globals.ps[Gamedef.g_p].falling_counter = 0;
                    Globals.hittype[Gamedef.g_i].extra = -1;
                    Globals.hittype[Gamedef.g_i].owner = g_i;
                    Globals.hittype[Gamedef.g_i].cgg = 0;
                    Globals.hittype[Gamedef.g_i].movflag = 0;
                    Globals.hittype[Gamedef.g_i].tempang = 0;
                    Globals.hittype[Gamedef.g_i].actorstayput = -1;
                    Globals.hittype[Gamedef.g_i].dispicnum = 0;
                    Globals.hittype[Gamedef.g_i].owner = Globals.ps[Gamedef.g_p].i;
                    Premap.resetinventory(g_p);
                    Premap.resetweapons(g_p);
                    View.fta = 0;
                    View.ftq = 0;
                    View.cameradist = 0;
                    View.cameraclock = Main.engine.getTotalClock();
                }
                Player.setpal(Globals.ps[g_p]);
                break;
            }
            case 43: {
                Sector sec = Main.boardService.getSector(g_sp.getSectnum());
                if (sec == null) break;
                Gamedef.parseifelse(con, Pragmas.klabs(g_sp.getZ() - sec.getFloorz()) < 8192 && sec.getLotag() == 1);
                break;
            }
            case 44: {
                Sector sec = Main.boardService.getSector(g_sp.getSectnum());
                if (sec == null) break;
                Gamedef.parseifelse(con, sec.getLotag() == 2);
                break;
            }
            case 46: {
                Gamedef.parseifelse(con, g_t[0] >= con.script[++insptr]);
                break;
            }
            case 53: {
                Gamedef.parseifelse(con, g_sp.getPicnum() == con.script[++insptr]);
                break;
            }
            case 47: {
                ++insptr;
                Gamedef.g_t[0] = 0;
                break;
            }
            case 48: {
                switch (con.script[(insptr += 2) - 1]) {
                    case 0: {
                        Globals.ps[Gamedef.g_p].steroids_amount = (short)con.script[insptr];
                        Globals.ps[Gamedef.g_p].inven_icon = 2;
                        break;
                    }
                    case 1: {
                        Globals.ps[Gamedef.g_p].shield_amount = (short)(Globals.ps[Gamedef.g_p].shield_amount + (short)con.script[insptr]);
                        if (Globals.ps[Gamedef.g_p].shield_amount <= con.max_player_health) break;
                        Globals.ps[Gamedef.g_p].shield_amount = (short)con.max_player_health;
                        break;
                    }
                    case 2: {
                        Globals.ps[Gamedef.g_p].scuba_amount = (short)con.script[insptr];
                        Globals.ps[Gamedef.g_p].inven_icon = 6;
                        break;
                    }
                    case 3: {
                        Globals.ps[Gamedef.g_p].holoduke_amount = (short)con.script[insptr];
                        Globals.ps[Gamedef.g_p].inven_icon = 3;
                        break;
                    }
                    case 4: {
                        Globals.ps[Gamedef.g_p].jetpack_amount = (short)con.script[insptr];
                        Globals.ps[Gamedef.g_p].inven_icon = 4;
                        break;
                    }
                    case 6: {
                        switch (g_sp.getPal()) {
                            case 0: {
                                Globals.ps[Gamedef.g_p].got_access = (short)(Globals.ps[Gamedef.g_p].got_access | 1);
                                break;
                            }
                            case 21: {
                                Globals.ps[Gamedef.g_p].got_access = (short)(Globals.ps[Gamedef.g_p].got_access | 2);
                                break;
                            }
                            case 23: {
                                Globals.ps[Gamedef.g_p].got_access = (short)(Globals.ps[Gamedef.g_p].got_access | 4);
                            }
                        }
                        break;
                    }
                    case 7: {
                        Globals.ps[Gamedef.g_p].heat_amount = (short)con.script[insptr];
                        Globals.ps[Gamedef.g_p].inven_icon = 5;
                        break;
                    }
                    case 9: {
                        Globals.ps[Gamedef.g_p].inven_icon = 1;
                        Globals.ps[Gamedef.g_p].firstaid_amount = (short)con.script[insptr];
                        break;
                    }
                    case 10: {
                        Globals.ps[Gamedef.g_p].inven_icon = 7;
                        Globals.ps[Gamedef.g_p].boot_amount = (short)con.script[insptr];
                    }
                }
                ++insptr;
                break;
            }
            case 50: {
                Actors.hitradius(g_i, con.script[insptr + 1], con.script[insptr + 2], con.script[insptr + 3], con.script[insptr + 4], con.script[insptr + 5]);
                insptr += 6;
                break;
            }
            case 51: {
                int l = con.script[++insptr];
                int j = 0;
                short s = g_sp.getXvel();
                Sprite psp = Main.boardService.getSprite(Globals.ps[Gamedef.g_p].i);
                if ((l & 8) != 0 && Globals.ps[Gamedef.g_p].on_ground && (Globals.sync[Gamedef.g_p].bits & 2) != 0) {
                    j = 1;
                } else if ((l & 0x10) != 0 && Globals.ps[Gamedef.g_p].jumping_counter == 0 && !Globals.ps[Gamedef.g_p].on_ground && Globals.ps[Gamedef.g_p].poszv > 2048) {
                    j = 1;
                } else if ((l & 0x20) != 0 && Globals.ps[Gamedef.g_p].jumping_counter > 348) {
                    j = 1;
                } else if ((l & 1) != 0 && s >= 0 && s < 8) {
                    j = 1;
                } else if ((l & 2) != 0 && s >= 8 && (Globals.sync[Gamedef.g_p].bits & 0x20) == 0) {
                    j = 1;
                } else if ((l & 4) != 0 && s >= 8 && (Globals.sync[Gamedef.g_p].bits & 0x20) != 0) {
                    j = 1;
                } else if ((l & 0x40) != 0 && Globals.ps[Gamedef.g_p].posz < g_sp.getZ() - 12288) {
                    j = 1;
                } else if ((l & 0x80) != 0 && s <= -8 && (Globals.sync[Gamedef.g_p].bits & 0x20) == 0) {
                    j = 1;
                } else if ((l & 0x100) != 0 && s <= -8 && (Globals.sync[Gamedef.g_p].bits & 0x20) != 0) {
                    j = 1;
                } else if ((l & 0x200) != 0 && (Globals.ps[Gamedef.g_p].quick_kick > 0 || Globals.ps[Gamedef.g_p].curr_weapon == 0 && Globals.ps[Gamedef.g_p].kickback_pic > 0)) {
                    j = 1;
                } else if ((l & 0x400) != 0 && psp != null && psp.getXrepeat() < 32) {
                    j = 1;
                } else if ((l & 0x800) != 0 && Globals.ps[Gamedef.g_p].jetpack_on != 0) {
                    j = 1;
                } else if ((l & 0x1000) != 0 && Globals.ps[Gamedef.g_p].steroids_amount > 0 && Globals.ps[Gamedef.g_p].steroids_amount < 400) {
                    j = 1;
                } else if ((l & 0x2000) != 0 && Globals.ps[Gamedef.g_p].on_ground) {
                    j = 1;
                } else if ((l & 0x4000) != 0 && Globals.ps[g_p].getPlayerSprite().getXrepeat() > 32 && Globals.ps[g_p].getPlayerSprite().getExtra() > 0 && Globals.ps[Gamedef.g_p].timebeforeexit == 0) {
                    j = 1;
                } else if ((l & 0x8000) != 0 && psp != null && psp.getExtra() <= 0) {
                    j = 1;
                } else if ((l & 0x10000) != 0) {
                    j = g_sp.getPicnum() == 1405 && Globals.ud.multimode > 1 ? Gamedef.getincangle((int)Globals.ps[Actors.otherp].ang, EngineUtils.getAngle(Globals.ps[Gamedef.g_p].posx - Globals.ps[Actors.otherp].posx, Globals.ps[Gamedef.g_p].posy - Globals.ps[Actors.otherp].posy)) : Gamedef.getincangle((int)Globals.ps[Gamedef.g_p].ang, EngineUtils.getAngle(g_sp.getX() - Globals.ps[Gamedef.g_p].posx, g_sp.getY() - Globals.ps[Gamedef.g_p].posy));
                    j = j > -128 && j < 128 ? 1 : 0;
                }
                Gamedef.parseifelse(con, j != 0);
                break;
            }
            case 56: {
                Gamedef.parseifelse(con, g_sp.getExtra() <= con.script[++insptr]);
                break;
            }
            case 58: {
                Spawn.guts(g_sp, con.script[(insptr += 2) - 1], con.script[insptr], g_p);
                ++insptr;
                break;
            }
            case 61: {
                ++insptr;
                Player.forceplayerangle(Globals.ps[g_p]);
                return false;
            }
            case 62: {
                Gamedef.parseifelse(con, Globals.hittype[Gamedef.g_i].floorz - Globals.hittype[Gamedef.g_i].ceilingz >> 8 < con.script[++insptr]);
                break;
            }
            case 63: {
                Gamedef.parseifelse(con, (Globals.sync[Gamedef.g_p].bits & 0x20000000) != 0);
                break;
            }
            case 64: {
                Sector sec = Main.boardService.getSector(g_sp.getSectnum());
                if (sec == null) break;
                Gamedef.parseifelse(con, (sec.getCeilingstat() & 1) != 0);
                break;
            }
            case 65: {
                Gamedef.parseifelse(con, Globals.ud.multimode > 1);
                break;
            }
            case 66: {
                Sprite sp;
                ListNode<Sprite> node;
                ++insptr;
                Sector sec = Main.boardService.getSector(g_sp.getSectnum());
                if (sec == null || sec.getLotag() != 0) break;
                Gameutils.neartag(g_sp.getX(), g_sp.getY(), g_sp.getZ() - 8192, g_sp.getSectnum(), g_sp.getAng(), 768, 1);
                Sector nearsec = Main.boardService.getSector(Globals.neartagsector);
                if (nearsec == null || !DSector.isanearoperator(nearsec.getLotag()) || (nearsec.getLotag() & 0xFF) != 23 && nearsec.getFloorz() != nearsec.getCeilingz() || (nearsec.getLotag() & 0x4000) != 0 || (nearsec.getLotag() & 0x8000) != 0) break;
                for (node = Main.boardService.getSectNode(Globals.neartagsector); node != null && (sp = node.get()).getPicnum() != 2; node = node.getNext()) {
                }
                if (node != null) break;
                DSector.operatesectors(Globals.neartagsector, g_i);
                break;
            }
            case 67: {
                Gamedef.parseifelse(con, DSector.ceilingspace(g_sp.getSectnum()));
                break;
            }
            case 74: {
                ++insptr;
                if (g_sp.getPicnum() != 1405) {
                    Globals.hittype[Gamedef.g_i].tempang = g_sp.getPal();
                }
                g_sp.setPal(con.script[insptr]);
                ++insptr;
                break;
            }
            case 77: {
                g_sp.setPicnum(con.script[++insptr]);
                ++insptr;
                break;
            }
            case 70: {
                Gamedef.parseifelse(con, Gamedef.dodge(g_sp));
                break;
            }
            case 71: {
                if (Actors.badguy(g_sp)) {
                    Gamedef.parseifelse(con, Globals.ud.respawn_monsters);
                    break;
                }
                if (Player.inventory(g_sp)) {
                    Gamedef.parseifelse(con, Globals.ud.respawn_inventory);
                    break;
                }
                Gamedef.parseifelse(con, Globals.ud.respawn_items);
                break;
            }
            case 72: {
                Gamedef.parseifelse(con, Globals.hittype[Gamedef.g_i].floorz - g_sp.getZ() <= con.script[++insptr] << 8);
                break;
            }
            case 73: {
                Gamedef.parseifelse(con, g_sp.getZ() - Globals.hittype[Gamedef.g_i].ceilingz <= con.script[++insptr] << 8);
                break;
            }
            case 14: {
                Globals.ps[Gamedef.g_p].pals_time = con.script[++insptr];
                ++insptr;
                for (int j = 0; j < 3; ++j) {
                    Globals.ps[Gamedef.g_p].pals[j] = (short)con.script[insptr];
                    ++insptr;
                }
                break;
            }
            case 78: {
                Gamedef.parseifelse(con, Globals.ps[g_p].getPlayerSprite().getExtra() < con.script[++insptr]);
                break;
            }
            case 75: {
                ++insptr;
                boolean j = false;
                switch (con.script[insptr++]) {
                    case 0: {
                        if (Globals.ps[Gamedef.g_p].steroids_amount == con.script[insptr]) break;
                        j = true;
                        break;
                    }
                    case 1: {
                        if (Globals.ps[Gamedef.g_p].shield_amount == con.max_player_health) break;
                        j = true;
                        break;
                    }
                    case 2: {
                        if (Globals.ps[Gamedef.g_p].scuba_amount == con.script[insptr]) break;
                        j = true;
                        break;
                    }
                    case 3: {
                        if (Globals.ps[Gamedef.g_p].holoduke_amount == con.script[insptr]) break;
                        j = true;
                        break;
                    }
                    case 4: {
                        if (Globals.ps[Gamedef.g_p].jetpack_amount == con.script[insptr]) break;
                        j = true;
                        break;
                    }
                    case 6: {
                        switch (g_sp.getPal()) {
                            case 0: {
                                if ((Globals.ps[Gamedef.g_p].got_access & 1) == 0) break;
                                j = true;
                                break;
                            }
                            case 21: {
                                if ((Globals.ps[Gamedef.g_p].got_access & 2) == 0) break;
                                j = true;
                                break;
                            }
                            case 23: {
                                if ((Globals.ps[Gamedef.g_p].got_access & 4) == 0) break;
                                j = true;
                            }
                        }
                        break;
                    }
                    case 7: {
                        if (Globals.ps[Gamedef.g_p].heat_amount == con.script[insptr]) break;
                        j = true;
                        break;
                    }
                    case 9: {
                        if (Globals.ps[Gamedef.g_p].firstaid_amount == con.script[insptr]) break;
                        j = true;
                        break;
                    }
                    case 10: {
                        if (Globals.ps[Gamedef.g_p].boot_amount == con.script[insptr]) break;
                        j = true;
                    }
                }
                Gamedef.parseifelse(con, j);
                break;
            }
            case 38: {
                ++insptr;
                Sprite psp = Main.boardService.getSprite(Globals.ps[Gamedef.g_p].i);
                if (psp == null || Globals.ps[Gamedef.g_p].knee_incs != 0 || psp.getXrepeat() < 40 || !Main.engine.cansee(g_sp.getX(), g_sp.getY(), g_sp.getZ() - 1024, g_sp.getSectnum(), Globals.ps[Gamedef.g_p].posx, Globals.ps[Gamedef.g_p].posy, Globals.ps[Gamedef.g_p].posz + 4096, psp.getSectnum())) break;
                Globals.ps[Gamedef.g_p].knee_incs = 1;
                if (Globals.ps[Gamedef.g_p].weapon_pos == 0) {
                    Globals.ps[Gamedef.g_p].weapon_pos = (short)-1;
                }
                Globals.ps[Gamedef.g_p].actorsqu = g_i;
                break;
            }
            case 90: {
                int s1 = g_sp.getSectnum();
                boolean j = false;
                s1 = Main.engine.updatesector(g_sp.getX() + 108, g_sp.getY() + 108, s1);
                if (s1 == g_sp.getSectnum() && (s1 = Main.engine.updatesector(g_sp.getX() - 108, g_sp.getY() - 108, s1)) == g_sp.getSectnum() && (s1 = Main.engine.updatesector(g_sp.getX() + 108, g_sp.getY() - 108, s1)) == g_sp.getSectnum() && (s1 = Main.engine.updatesector(g_sp.getX() - 108, g_sp.getY() + 108, s1)) == g_sp.getSectnum()) {
                    j = true;
                }
                Gamedef.parseifelse(con, j);
                break;
            }
            case 80: {
                View.FTA(con.script[++insptr], Globals.ps[g_p]);
                ++insptr;
                break;
            }
            case 81: {
                Gamedef.parseifelse(con, DSector.floorspace(g_sp.getSectnum()));
                break;
            }
            case 82: {
                int hitType = Globals.hittype[Gamedef.g_i].movflag & 0xE0000000;
                Gamedef.parseifelse(con, hitType == Integer.MIN_VALUE || hitType == -1073741824);
                break;
            }
            case 83: {
                ++insptr;
                switch (g_sp.getPicnum()) {
                    case 603: 
                    case 753: 
                    case 1294: 
                    case 1312: 
                    case 1317: 
                    case 1321: 
                    case 1323: 
                    case 1325: 
                    case 1334: 
                    case 1336: 
                    case 1395: 
                    case 3450: 
                    case 4864: {
                        if (g_sp.getYvel() == 0) break block0;
                        DSector.operaterespawns(g_sp.getYvel());
                        break;
                    }
                    default: {
                        if (g_sp.getHitag() < 0) break block0;
                        DSector.operaterespawns(g_sp.getHitag());
                        break;
                    }
                }
                break;
            }
            case 85: {
                Gamedef.parseifelse(con, g_sp.getPal() == con.script[++insptr]);
                break;
            }
            case 111: {
                int j = Pragmas.klabs((int)Gamedef.getincangle(Globals.ps[Gamedef.g_p].ang, (float)g_sp.getAng()));
                Gamedef.parseifelse(con, j <= con.script[++insptr]);
                break;
            }
            case 109: {
                int j;
                for (j = 1; j < 500 && Globals.Sound[j].getSoundOwner((int)0).i != g_i; ++j) {
                }
                Gamedef.parseifelse(con, j == 500);
                break;
            }
            default: {
                killit_flag = 1;
            }
        }
        return false;
    }

    public static void execute(Script con, int i, int p, int x) {
        boolean done;
        g_i = (short)i;
        g_p = (short)p;
        g_x = x;
        g_sp = Main.boardService.getSprite(g_i);
        g_t = Globals.hittype[Gamedef.g_i].temp_data;
        if (g_sp == null) {
            return;
        }
        if (con.actorscrptr[g_sp.getPicnum()] == 0) {
            return;
        }
        insptr = 4 + con.actorscrptr[g_sp.getPicnum()];
        killit_flag = 0;
        Sector g_sec = Main.boardService.getSector(g_sp.getSectnum());
        if (g_sec == null) {
            if (Actors.badguy(g_sp)) {
                Globals.ps[Mmulti.connecthead].actors_killed = (short)(Globals.ps[Mmulti.connecthead].actors_killed + 1);
                if (Globals.ud.coop == 1) {
                    Globals.ps[Gamedef.g_p].frag = (short)(Globals.ps[Gamedef.g_p].frag + 1);
                }
            }
            Main.engine.deletesprite(g_i);
            return;
        }
        if (g_t[4] != 0) {
            g_sp.setLotag(g_sp.getLotag() + 4);
            if (g_sp.getLotag() > con.script[g_t[4] + 4]) {
                g_t[2] = g_t[2] + 1;
                g_sp.setLotag(0);
                g_t[3] = g_t[3] + con.script[g_t[4] + 3];
            }
            if (Pragmas.klabs(g_t[3]) >= Pragmas.klabs(con.script[g_t[4] + 1] * con.script[g_t[4] + 3])) {
                Gamedef.g_t[3] = 0;
            }
        }
        while (!(done = Gamedef.parse(con))) {
        }
        if (killit_flag == 1) {
            if (Globals.ps[Gamedef.g_p].actorsqu == g_i) {
                Globals.ps[Gamedef.g_p].actorsqu = (short)-1;
            }
            Main.engine.deletesprite(g_i);
        } else {
            Gamedef.move(con);
            if (g_sp.getStatnum() == 1) {
                if (Actors.badguy(g_sp)) {
                    if (g_sp.getXrepeat() > 60) {
                        return;
                    }
                    if (Globals.ud.respawn_monsters && g_sp.getExtra() <= 0) {
                        return;
                    }
                } else if (Globals.ud.respawn_items && (g_sp.getCstat() & 0x8000) != 0) {
                    return;
                }
                if (Globals.hittype[Gamedef.g_i].timetosleep > 1) {
                    --Globals.hittype[Gamedef.g_i].timetosleep;
                } else if (Globals.hittype[Gamedef.g_i].timetosleep == 1) {
                    Main.engine.changespritestat(g_i, 2);
                }
            } else if (g_sp.getStatnum() == 6) {
                switch (g_sp.getPicnum()) {
                    case 675: 
                    case 904: 
                    case 1026: 
                    case 1062: 
                    case 1227: 
                    case 1228: 
                    case 1229: 
                    case 1232: 
                    case 1238: 
                    case 1240: 
                    case 2566: {
                        if (Globals.hittype[Gamedef.g_i].timetosleep > 1) {
                            --Globals.hittype[Gamedef.g_i].timetosleep;
                            break;
                        }
                        if (Globals.hittype[Gamedef.g_i].timetosleep != 1) break;
                        Main.engine.changespritestat(g_i, 2);
                    }
                }
            }
        }
    }

    public static void compilecons() throws InitializationException {
        int i;
        Script con = Gamedef.loadefs(confilename);
        try {
            List<EpisodeEntry> entryList;
            EpisodeEntry entry;
            Entry conEntry;
            FileEntry grpEntry = Main.game.getCache().getGameDirectory().getEntry(Main.game.mainGrp);
            if (!grpEntry.exists()) {
                throw new FileNotFoundException();
            }
            if (Main.game.isGameType(GameType.NAM) && (conEntry = Main.game.getCache().getEntry(confilename, true)).exists()) {
                GrpFile group = (GrpFile)Main.game.getCache().getGroup(Main.game.mainGrp);
                group.addEntry(new UserEntry(conEntry));
            }
            if (!(entry = (entryList = ResourceHandler.episodeManager.getEpisodeEntries(grpEntry)).get(0)).getConFile().getName().equalsIgnoreCase(confilename)) {
                throw new RuntimeException("Can't initialize script file: GAME.CON");
            }
            Globals.defGame = ResourceHandler.episodeManager.getEpisode(entry);
        }
        catch (Exception e) {
            throw new RuntimeException("[ " + e.getClass().getSimpleName() + "]: Unknown error!", e);
        }
        switch (con.type) {
            case 13: {
                Console.out.println("Looks like Standard CON files.");
                Strhandler.buildString(con.volume_names[0], 0, "L.A. MELTDOWN");
                Strhandler.buildString(con.volume_names[1], 0, "LUNAR APOCALYPSE");
                Strhandler.buildString(con.volume_names[2], 0, "SHRAPNEL CITY");
                Strhandler.buildString(con.skill_names[0], 0, "PIECE OF CAKE");
                Strhandler.buildString(con.skill_names[1], 0, "LET'S ROCK");
                Strhandler.buildString(con.skill_names[2], 0, "COME GET SOME");
                Strhandler.buildString(con.skill_names[3], 0, "DAMN I'M GOOD");
                con.nEpisodes = 3;
                con.nSkills = 4;
                break;
            }
            case 14: {
                con.PLUTOPAK = true;
                Console.out.println("Looks like Atomic Edition CON files.");
                break;
            }
            case 20: {
                con.PLUTOPAK = true;
                Console.out.println("Looks like Twentieth Anniversary World Tour CON files.");
                Gamedef.handleWTCons(con);
            }
        }
        Globals.defGame.setCON(con);
        Globals.defGame.title = "Default";
        Globals.defGame.nEpisodes = con.nEpisodes;
        for (i = 0; i < con.nEpisodes; ++i) {
            Globals.defGame.episodes[i] = new EpisodeInfo(new String(con.volume_names[i]).trim());
            Globals.defGame.episodes[i].nMaps = con.nMaps[i];
            for (int j = 0; j < con.nMaps[i]; ++j) {
                Path path = FileUtils.getPath(new String(con.level_file_names[i * 11 + j]).trim(), new String[0]);
                if (Globals.defGame.episodes[i].setMapInfo(j, new MapInfo(path, new String(con.level_names[i * 11 + j]).trim(), con.partime[i * 11 + j], con.designertime[i * 11 + j]))) continue;
                Console.out.println("Warning! Can't set map info for index " + j, OsdColor.YELLOW);
            }
        }
        for (i = 0; i < con.nSkills; ++i) {
            Globals.defGame.skillnames[i] = new String(con.skill_names[i]).trim();
        }
        Globals.currentGame = Globals.defGame;
    }

    private static void handleWTCons(Script con) {
        Console.out.println("Trying to open an english locale file");
        FileEntry res = Main.game.getCache().getGameDirectory().getEntry(FileUtils.getPath("locale", "english", "strings.txt"));
        if (res.exists()) {
            int len;
            String quote;
            int i;
            Console.out.println("Parsing the locale file");
            LocaleScript scr = new LocaleScript(res);
            for (i = 0; i < 256; ++i) {
                quote = scr.getLocale(Strhandler.toLowerCase(new String(con.fta_quotes[i]).trim()));
                if (quote == null) continue;
                len = Math.min(con.fta_quotes[i].length - 1, quote.length());
                quote.getChars(0, len, con.fta_quotes[i], 0);
                con.fta_quotes[i][len] = '\u0000';
            }
            for (i = 0; i < con.volume_names.length; ++i) {
                quote = scr.getLocale(Strhandler.toLowerCase(new String(con.volume_names[i]).trim()));
                if (quote == null) continue;
                len = Math.min(con.volume_names[i].length - 1, quote.length());
                quote.getChars(0, len, con.volume_names[i], 0);
                con.volume_names[i][len] = '\u0000';
            }
            for (i = 0; i < con.level_names.length; ++i) {
                quote = scr.getLocale(Strhandler.toLowerCase(new String(con.level_names[i]).trim()));
                if (quote == null) continue;
                len = Math.min(con.level_names[i].length - 1, quote.length());
                quote.getChars(0, len, con.level_names[i], 0);
                con.level_names[i][len] = '\u0000';
            }
        }
    }

    public static byte[] preparescript(byte[] buf) {
        int textptr;
        if (buf == null) {
            return null;
        }
        int index = -1;
        while ((index = Strhandler.indexOf("//", buf, index + 1)) != -1) {
            textptr = index + 2;
            while (buf[textptr] != 10) {
                buf[textptr] = 0;
                if (++textptr < buf.length) continue;
                return buf;
            }
        }
        while ((index = Strhandler.indexOf("/*", buf, index + 1)) != -1) {
            textptr = index + 2;
            do {
                buf[textptr] = 0;
                if (++textptr < buf.length) continue;
                return buf;
            } while (buf[textptr] != 42 || buf[textptr + 1] != 47);
        }
        return buf;
    }

    public static Script loaduserdef(Entry fp) {
        if (!fp.exists()) {
            return null;
        }
        int fs = (int)fp.getSize();
        Console.out.println("Compiling: " + fp.getName() + ".");
        byte[] buf = new byte[fs + 1];
        label = new char[131072];
        System.arraycopy(fp.getBytes(), 0, buf, 0, fs);
        parsing_actor = 0;
        parsing_state = 0;
        num_squigilly_brackets = 0;
        checking_ifelse = 0;
        killit_flag = 0;
        textptr = 0;
        last_used_text = new String(buf);
        last_used_size = fs;
        text = last_used_text.toCharArray();
        if (fs < text.length) {
            Gamedef.text[fs] = '\u0000';
        }
        Script con = new Script();
        Arrays.fill(con.actorscrptr, 0);
        Arrays.fill(con.actortype, (short)0);
        labelcode.clear();
        labelcnt = 0;
        scriptptr = 1;
        warning = 0;
        error = 0;
        line_number = 1;
        try {
            Gamedef.passone(con);
        }
        catch (Exception e) {
            e.printStackTrace();
            error = 1;
            return null;
        }
        switch (con.type) {
            case 13: {
                Console.out.println("Looks like Standard CON files.");
                Strhandler.buildString(con.volume_names[0], 0, "L.A. MELTDOWN");
                Strhandler.buildString(con.volume_names[1], 0, "LUNAR APOCALYPSE");
                Strhandler.buildString(con.volume_names[2], 0, "SHRAPNEL CITY");
                Strhandler.buildString(con.skill_names[0], 0, "PIECE OF CAKE");
                Strhandler.buildString(con.skill_names[1], 0, "LET'S ROCK");
                Strhandler.buildString(con.skill_names[2], 0, "COME GET SOME");
                Strhandler.buildString(con.skill_names[3], 0, "DAMN I'M GOOD");
                break;
            }
            case 14: {
                con.PLUTOPAK = true;
                Console.out.println("Looks like Atomic Edition CON files.");
                break;
            }
            case 20: {
                con.PLUTOPAK = true;
                Console.out.println("Looks like Twentieth Anniversary World Tour CON files.");
                Gamedef.handleWTCons(con);
            }
        }
        if ((warning | error) != 0) {
            Console.out.println("Found " + warning + " warning(s), " + error + " error(s).");
        }
        if (error != 0) {
            return null;
        }
        Console.out.println("Code Size:" + ((scriptptr << 2) - 4) + " bytes(" + labelcnt + " labels).");
        return con;
    }

    static {
        labelcode = new IntArray();
        textptr = 0;
    }

    private static class LocaleScript
    extends Scriptfile {
        private final HashMap<String, String> locale = new HashMap();

        public LocaleScript(Entry data) {
            super("Locale", data);
            while (!this.eof()) {
                String tag = this.getstring();
                String text = this.getstring();
                if (tag == null || text == null) continue;
                this.locale.put(tag.trim(), text);
            }
        }

        public String getLocale(String txt) {
            return this.locale.get(txt);
        }
    }
}

