/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.filehandle.StreamUtils;

public class Input
implements BuildNet.NetInput {
    private static final int sizeof = 10;
    private static final int jfsizeof = 12;
    private static final int gdxsizeof = 16;
    public float avel;
    public float horz;
    public short fvel;
    public short svel;
    public int bits;

    public static int sizeof(int nVersion) {
        int size = 10;
        if (nVersion == 127) {
            size = 12;
        }
        if (nVersion >= 147) {
            size = 16;
        }
        return size;
    }

    public Input readObject(InputStream is, int nVersion) throws IOException {
        if (nVersion < 147) {
            this.avel = StreamUtils.readByte(is);
            this.horz = StreamUtils.readByte(is);
        } else {
            this.avel = StreamUtils.readFloat(is);
            this.horz = StreamUtils.readFloat(is);
        }
        this.fvel = StreamUtils.readShort(is);
        this.svel = StreamUtils.readShort(is);
        if (nVersion == 127) {
            StreamUtils.readShort(is);
        }
        this.bits = StreamUtils.readInt(is);
        return this;
    }

    public void writeObject(OutputStream os, int nVersion) throws IOException {
        if (nVersion < 147) {
            StreamUtils.writeByte(os, (byte)this.avel);
            StreamUtils.writeByte(os, (byte)this.horz);
        } else {
            StreamUtils.writeFloat(os, this.avel);
            StreamUtils.writeFloat(os, this.horz);
        }
        StreamUtils.writeShort(os, this.fvel);
        StreamUtils.writeShort(os, this.svel);
        if (nVersion == 127) {
            StreamUtils.writeShort(os, 0);
        }
        StreamUtils.writeInt(os, this.bits);
    }

    @Override
    public int GetInput(byte[] packbuf, int offset, BuildNet.NetInput oldInput) {
        int k = packbuf[offset++] & 0xFF;
        this.Copy(oldInput);
        if ((k & 1) != 0) {
            this.fvel = LittleEndian.getShort(packbuf, offset);
            offset += 2;
        }
        if ((k & 2) != 0) {
            this.svel = LittleEndian.getShort(packbuf, offset);
            offset += 2;
        }
        if ((k & 4) != 0) {
            this.avel = LittleEndian.getFloat(packbuf, offset);
            offset += 4;
        }
        if ((k & 8) != 0) {
            this.bits = this.bits & 0xFFFFFF00 | packbuf[offset++] & 0xFF;
        }
        if ((k & 0x10) != 0) {
            this.bits = this.bits & 0xFFFF00FF | (packbuf[offset++] & 0xFF) << 8;
        }
        if ((k & 0x20) != 0) {
            this.bits = this.bits & 0xFF00FFFF | (packbuf[offset++] & 0xFF) << 16;
        }
        if ((k & 0x40) != 0) {
            this.bits = this.bits & 0xFFFFFF | (packbuf[offset++] & 0xFF) << 24;
        }
        if ((k & 0x80) != 0) {
            this.horz = LittleEndian.getFloat(packbuf, offset);
            offset += 4;
        }
        return offset;
    }

    @Override
    public int PutInput(byte[] packbuf, int offset, BuildNet.NetInput oldInput) {
        int syncptr = offset;
        packbuf[offset++] = 0;
        Input osyn = (Input)oldInput;
        if (this.fvel != osyn.fvel) {
            LittleEndian.putShort(packbuf, offset, this.fvel);
            offset += 2;
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 1);
        }
        if (this.svel != osyn.svel) {
            LittleEndian.putShort(packbuf, offset, this.svel);
            offset += 2;
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 2);
        }
        if (this.avel != osyn.avel) {
            LittleEndian.putFloat(packbuf, offset, this.avel);
            offset += 4;
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 4);
        }
        if (((this.bits ^ osyn.bits) & 0xFF) != 0) {
            packbuf[offset++] = (byte)(this.bits & 0xFF);
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 8);
        }
        if (((this.bits ^ osyn.bits) & 0xFF00) != 0) {
            packbuf[offset++] = (byte)(this.bits >> 8 & 0xFF);
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 0x10);
        }
        if (((this.bits ^ osyn.bits) & 0xFF0000) != 0) {
            packbuf[offset++] = (byte)(this.bits >> 16 & 0xFF);
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 0x20);
        }
        if (((this.bits ^ osyn.bits) & 0xFF000000) != 0) {
            packbuf[offset++] = (byte)(this.bits >> 24 & 0xFF);
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 0x40);
        }
        if (this.horz != osyn.horz) {
            LittleEndian.putFloat(packbuf, offset, this.horz);
            offset += 4;
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 0xFFFFFF80);
        }
        return offset;
    }

    @Override
    public void reset() {
        this.fvel = 0;
        this.svel = 0;
        this.avel = 0.0f;
        this.bits = 0;
        this.horz = 0.0f;
    }

    @Override
    public BuildNet.NetInput Copy(BuildNet.NetInput netsrc) {
        if (netsrc == null) {
            return null;
        }
        Input src = (Input)netsrc;
        this.fvel = src.fvel;
        this.svel = src.svel;
        this.avel = src.avel;
        this.bits = src.bits;
        this.horz = src.horz;
        return this;
    }
}

