/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D;

import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Duke3D.Actors;
import ru.m210projects.Duke3D.DSector;
import ru.m210projects.Duke3D.Gamedef;
import ru.m210projects.Duke3D.Gameutils;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Input;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Premap;
import ru.m210projects.Duke3D.Screen;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Spawn;
import ru.m210projects.Duke3D.Types.PlayerStruct;
import ru.m210projects.Duke3D.View;
import ru.m210projects.Duke3D.Weapons;

public class Player {
    public static final byte[] waterpal = new byte[768];
    public static final byte[] slimepal = new byte[768];
    public static final byte[] titlepal = new byte[768];
    public static final byte[] drealms = new byte[768];
    public static final byte[] endingpal = new byte[768];
    public static final int[][] fdmatrix = new int[][]{{128, -1, -1, -1, 128, -1, -1, -1, 128, -1, 128, -1, -1}, {1024, 1024, 1024, 1024, 2560, 128, 2560, 2560, 1024, 2560, 2560, 2560, -1}, {512, 512, 512, 512, 2560, 128, 2560, 2560, 1024, 2560, 2560, 2560, -1}, {512, 512, 512, 512, 2560, 128, 2560, 2560, 1024, 2560, 2560, 2560, -1}, {2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, -1}, {512, 512, 512, 512, 2048, 512, 2560, 2560, 512, 2560, 2560, 2560, -1}, {128, 128, 128, 128, 2560, 128, 2560, 2560, 128, 128, 128, 128, -1}, {1536, 1536, 1536, 1536, 2560, 1536, 1536, 1536, 1536, 1536, 1536, 1536, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {128, 128, 128, 128, 2560, 128, 2560, 2560, 128, 128, 128, 128, -1}, {2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, -1}, {128, 128, 128, 128, 2560, 128, 2560, 2560, 128, 128, 128, 128, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
    public static final int[] goalx = new int[16];
    public static final int[] goaly = new int[16];
    public static final int[] goalz = new int[16];
    public static final int[] goalsect = new int[16];
    public static final int[] goalwall = new int[16];
    public static final int[] goalsprite = new int[16];
    public static final int[] goalplayer = new int[16];
    public static final int[] clipmovecount = new int[16];
    public static final short[] searchsect = new short[Engine.MAXSECTORS];
    public static final short[] searchparent = new short[Engine.MAXSECTORS];
    public static final byte[] dashow2dsector = new byte[Engine.MAXSECTORS + 7 >> 3];

    public static void InitPlayers() {
        Globals.ps[Mmulti.myconnectindex].reset();
        Globals.ps[Mmulti.myconnectindex].palette = Main.engine.getPaletteManager().getBasePalette();
        Globals.ps[Mmulti.myconnectindex].aim_mode = Main.cfg.isgMouseAim() ? 1 : 0;
        Globals.ps[Mmulti.myconnectindex].auto_aim = Main.cfg.gAutoAim ? 1 : 0;
        for (int i = 1; i < 16; ++i) {
            Globals.ps[i].copy(Globals.ps[Mmulti.myconnectindex]);
        }
        Main.game.net.getnames();
    }

    public static void checkavailinven(PlayerStruct p) {
        p.inven_icon = p.firstaid_amount > 0 ? 1 : (p.steroids_amount > 0 ? 2 : (p.holoduke_amount > 0 ? 3 : (p.jetpack_amount > 0 ? 4 : (p.heat_amount > 0 ? 5 : (p.scuba_amount > 0 ? 6 : (p.boot_amount > 0 ? 7 : 0))))));
    }

    public static void checkavailweapon(PlayerStruct p) {
        int i;
        int weap;
        if (p.wantweaponfire >= 0) {
            weap = p.wantweaponfire;
            p.wantweaponfire = (short)-1;
            if (weap == p.curr_weapon || weap >= 13) {
                return;
            }
            if (p.gotweapon[weap] && p.ammo_amount[weap] > 0) {
                Weapons.addweapon(p, weap);
                return;
            }
        }
        if (p.gotweapon[weap = p.curr_weapon] && p.ammo_amount[weap] > 0) {
            return;
        }
        Sprite psp = Main.boardService.getSprite(p.i);
        if (psp == null) {
            return;
        }
        short snum = psp.getYvel();
        for (i = 0; i < 10; ++i) {
            weap = Globals.ud.wchoice[snum][i];
            weap = weap == 0 ? 9 : --weap;
            if (weap == 0 || p.gotweapon[weap] && p.ammo_amount[weap] > 0) break;
        }
        if (i == 10) {
            weap = 0;
        }
        p.last_weapon = p.curr_weapon;
        p.random_club_frame = 0;
        p.curr_weapon = (short)weap;
        p.kickback_pic = 0;
        if (p.holster_weapon == 1) {
            p.holster_weapon = 0;
            p.weapon_pos = (short)10;
        } else {
            p.weapon_pos = (short)-1;
        }
    }

    public static boolean inventory(Sprite s) {
        switch (s.getPicnum()) {
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 1348: {
                return true;
            }
        }
        return false;
    }

    public static void setpal(PlayerStruct p) {
        if (p.heat_on != 0) {
            p.palette = slimepal;
        } else {
            Sector psec = Main.boardService.getSector(p.cursectnum);
            if (psec == null) {
                return;
            }
            switch (psec.getCeilingpicnum()) {
                case 200: 
                case 201: 
                case 202: {
                    p.palette = slimepal;
                    break;
                }
                default: {
                    p.palette = psec.getLotag() == 2 ? waterpal : Main.engine.getPaletteManager().getBasePalette();
                }
            }
        }
        Screen.changepalette = 1;
    }

    public static void incur_damage(PlayerStruct p) {
        Sprite psp = Main.boardService.getSprite(p.i);
        if (psp == null) {
            return;
        }
        psp.setExtra(psp.getExtra() - (p.extra_extra8 >> 8));
        int damage = psp.getExtra() - p.last_extra;
        if (damage < 0) {
            p.extra_extra8 = 0;
            if (p.shield_amount > 0) {
                int shield_damage = damage * (20 + Main.engine.krand() % 30) / 100;
                damage -= shield_damage;
                p.shield_amount = (short)(p.shield_amount + (short)shield_damage);
                if (p.shield_amount < 0) {
                    damage += p.shield_amount;
                    p.shield_amount = 0;
                }
            }
            psp.setExtra(p.last_extra + damage);
        }
    }

    public static void quickkill(PlayerStruct p) {
        Sprite psp = Main.boardService.getSprite(p.i);
        if (psp == null) {
            return;
        }
        p.pals[0] = 48;
        p.pals[1] = 48;
        p.pals[2] = 48;
        p.pals_time = 48;
        psp.setExtra(0);
        psp.setCstat(psp.getCstat() | 0x8000);
        if (!Globals.ud.god) {
            Spawn.guts(psp, 2286, 8, Mmulti.myconnectindex);
        }
    }

    public static void forceplayerangle(PlayerStruct p) {
        int n = 128 - (Main.engine.krand() & 0xFF);
        p.horiz += 64.0f;
        p.return_to_center = (short)9;
        p.look_ang = (short)(n >> 1);
        p.rotscrnang = (short)(n >> 1);
    }

    public static int hits(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return 0;
        }
        int zoff = 0;
        if (spr.getPicnum() == 1405) {
            zoff = 10240;
        }
        Main.engine.hitscan(spr.getX(), spr.getY(), spr.getZ() - zoff, spr.getSectnum(), EngineUtils.sin(spr.getAng() + 512 & 0x7FF), EngineUtils.sin(spr.getAng() & 0x7FF), 0, Engine.pHitInfo, 0x1000040);
        return Gameutils.FindDistance2D(Engine.pHitInfo.hitx - spr.getX(), Engine.pHitInfo.hity - spr.getY());
    }

    public static int hitasprite(int i) {
        Sprite sp = Main.boardService.getSprite(i);
        if (sp == null) {
            return 0x40000000;
        }
        int zoff = 0;
        if (Actors.badguy(sp)) {
            zoff = 10752;
        } else if (sp.getPicnum() == 1405) {
            zoff = 9984;
        }
        Main.engine.hitscan(sp.getX(), sp.getY(), sp.getZ() - zoff, sp.getSectnum(), EngineUtils.cos(sp.getAng() & 0x7FF), EngineUtils.sin(sp.getAng() & 0x7FF), 0, Engine.pHitInfo, 0x1000040);
        Wall hw = Main.boardService.getWall(Engine.pHitInfo.hitwall);
        if (hw != null && (hw.getCstat() & 0x10) != 0 && Actors.badguy(sp)) {
            return 0x40000000;
        }
        return Gameutils.FindDistance2D(Engine.pHitInfo.hitx - sp.getX(), Engine.pHitInfo.hity - sp.getY());
    }

    public static int hitawall(PlayerStruct p) {
        if (Main.IsOriginalDemo()) {
            Main.engine.hitscan(p.posx, p.posy, p.posz, p.cursectnum, EngineUtils.sin((int)p.ang + 512 & 0x7FF), EngineUtils.sin((int)p.ang & 0x7FF), 0, Engine.pHitInfo, 65537);
        } else {
            Main.engine.hitscan(p.posx, p.posy, p.posz, p.cursectnum, (int)ru.m210projects.Build.Gameutils.BCosAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)), (int)ru.m210projects.Build.Gameutils.BSinAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)), 0, Engine.pHitInfo, 65537);
        }
        return Gameutils.FindDistance2D(Engine.pHitInfo.hitx - p.posx, Engine.pHitInfo.hity - p.posy);
    }

    public static boolean doincrements(PlayerStruct p) {
        Sprite psp = Main.boardService.getSprite(p.i);
        if (psp == null) {
            return false;
        }
        short snum = psp.getYvel();
        ++p.player_par;
        if (p.invdisptime > 0) {
            --p.invdisptime;
        }
        if (p.tipincs > 0) {
            p.tipincs = (short)(p.tipincs - 1);
        }
        if (p.last_pissed_time > 0) {
            --p.last_pissed_time;
            if (p.last_pissed_time == 5694) {
                Sounds.spritesound(79, p.i);
                if (snum == Globals.screenpeek || Globals.ud.coop == 1) {
                    Sounds.spritesound(218, p.i);
                }
            }
            if (p.last_pissed_time == 5668) {
                p.holster_weapon = 0;
                p.weapon_pos = (short)10;
            }
        }
        if (p.crack_time > 0) {
            --p.crack_time;
            if (p.crack_time == 0) {
                p.knuckle_incs = 1;
                p.crack_time = 777;
            }
        }
        if (p.steroids_amount > 0 && p.steroids_amount < 400) {
            p.steroids_amount = (short)(p.steroids_amount - 1);
            if (p.steroids_amount == 0) {
                Player.checkavailinven(p);
            }
            if ((p.steroids_amount & 7) == 0 && (snum == Globals.screenpeek || Globals.ud.coop == 1)) {
                Sounds.spritesound(39, p.i);
            }
        }
        if (p.heat_on != 0 && p.heat_amount > 0) {
            p.heat_amount = (short)(p.heat_amount - 1);
            if (p.heat_amount == 0) {
                p.heat_on = 0;
                Player.checkavailinven(p);
                Sounds.spritesound(213, p.i);
                Player.setpal(p);
            }
        }
        if (p.holoduke_on >= 0) {
            p.holoduke_amount = (short)(p.holoduke_amount - 1);
            if (p.holoduke_amount <= 0) {
                Sounds.spritesound(70, p.i);
                p.holoduke_on = (short)-1;
                Player.checkavailinven(p);
            }
        }
        if (p.jetpack_on != 0 && p.jetpack_amount > 0) {
            p.jetpack_amount = (short)(p.jetpack_amount - 1);
            if (p.jetpack_amount <= 0) {
                p.jetpack_on = 0;
                Player.checkavailinven(p);
                Sounds.spritesound(51, p.i);
                Sounds.stopsound(50, p.i);
                Sounds.stopsound(49, p.i);
            }
        }
        if (p.quick_kick > 0 && psp.getPal() != 1) {
            p.quick_kick = (short)(p.quick_kick - 1);
            if (p.quick_kick == 8) {
                Weapons.shoot(p.i, 2521);
            }
        }
        if (p.access_incs != 0 && psp.getPal() != 1) {
            p.access_incs = (short)(p.access_incs + 1);
            if (psp.getExtra() <= 0) {
                p.access_incs = (short)12;
            }
            if (p.access_incs == 12) {
                Sprite asp = Main.boardService.getSprite(p.access_spritenum);
                if (asp != null) {
                    DSector.checkhitswitch(snum, p.access_spritenum, 1);
                    switch (asp.getPal()) {
                        case 0: {
                            p.got_access = (short)(p.got_access & 0xFFFFFFFE);
                            break;
                        }
                        case 21: {
                            p.got_access = (short)(p.got_access & 0xFFFFFFFD);
                            break;
                        }
                        case 23: {
                            p.got_access = (short)(p.got_access & 0xFFFFFFFB);
                        }
                    }
                    p.access_spritenum = (short)-1;
                } else {
                    Wall awal = Main.boardService.getWall(p.access_wallnum);
                    if (awal != null) {
                        DSector.checkhitswitch(snum, p.access_wallnum, 0);
                        switch (awal.getPal()) {
                            case 0: {
                                p.got_access = (short)(p.got_access & 0xFFFFFFFE);
                                break;
                            }
                            case 21: {
                                p.got_access = (short)(p.got_access & 0xFFFFFFFD);
                                break;
                            }
                            case 23: {
                                p.got_access = (short)(p.got_access & 0xFFFFFFFB);
                            }
                        }
                    }
                }
            }
            if (p.access_incs > 20) {
                p.access_incs = 0;
                p.weapon_pos = (short)10;
                p.kickback_pic = 0;
            }
        }
        Sector psec = Main.boardService.getSector(p.cursectnum);
        if (p.scuba_on == 0 && psec != null && psec.getLotag() == 2) {
            if (p.scuba_amount > 0) {
                p.scuba_on = 1;
                p.inven_icon = 6;
                View.FTA(76, p);
            } else if (p.airleft > 0) {
                p.airleft = (short)(p.airleft - 1);
            } else {
                p.extra_extra8 = (short)(p.extra_extra8 + 32);
                if (p.last_extra < Globals.currentGame.getCON().max_player_health >> 1 && (p.last_extra & 3) == 0) {
                    Sounds.spritesound(211, p.i);
                }
            }
        } else if (p.scuba_amount > 0 && p.scuba_on != 0) {
            p.scuba_amount = (short)(p.scuba_amount - 1);
            if (p.scuba_amount == 0) {
                p.scuba_on = 0;
                Player.checkavailinven(p);
            }
        }
        if (p.knuckle_incs != 0) {
            p.knuckle_incs = (short)(p.knuckle_incs + 1);
            if (p.knuckle_incs == 10) {
                if (Main.engine.getTotalClock() > 1024 && (snum == Globals.screenpeek || Globals.ud.coop == 1)) {
                    if ((Main.engine.rand() & 1) != 0) {
                        Sounds.spritesound(33, p.i);
                    } else {
                        Sounds.spritesound(208, p.i);
                    }
                }
                Sounds.spritesound(215, p.i);
            } else if (p.knuckle_incs == 22 || (Globals.sync[snum].bits & 4) != 0) {
                p.knuckle_incs = 0;
            }
            return true;
        }
        return false;
    }

    public static void processinput(int snum) {
        Sprite pHitSprite;
        int psect;
        PlayerStruct p = Globals.ps[snum];
        short pi = p.i;
        Sprite psp = Main.boardService.getSprite(pi);
        if (psp == null) {
            return;
        }
        int sb_snum = 0;
        if (p.cheat_phase <= 0) {
            sb_snum = Globals.sync[snum].bits;
        }
        if ((psect = p.cursectnum) == -1) {
            if (psp.getExtra() > 0 && !Globals.ud.clipping) {
                Player.quickkill(p);
                Sounds.spritesound(69, pi);
            }
            psect = 0;
        }
        Sector psec = Main.boardService.getSector(psect);
        if (!Main.boardService.isValidSector(psp.getSectnum()) || psec == null) {
            return;
        }
        short psectlotag = psec.getLotag();
        p.spritebridge = 0;
        boolean shrunk = psp.getYrepeat() < 32;
        Main.engine.getzrange(p.posx, p.posy, p.posz, psect, 163, 65537);
        int cz = Engine.zr_ceilz;
        int hz = Engine.zr_ceilhit;
        int fz = Engine.zr_florz;
        int lz = Engine.zr_florhit;
        p.truefz = Main.engine.getflorzofslope(psect, p.posx, p.posy);
        p.truecz = Main.engine.getceilzofslope(psect, p.posx, p.posy);
        int truefdist = Pragmas.klabs(p.posz - p.truefz);
        if ((lz & 0xE0000000) == 0x40000000 && psectlotag == 1 && truefdist > 13824) {
            psectlotag = 0;
        }
        Globals.hittype[pi].floorz = fz;
        Globals.hittype[pi].ceilingz = cz;
        p.ohoriz = p.horiz;
        p.ohorizoff = p.horizoff;
        if (p.aim_mode == 0 && p.on_ground && psectlotag != 2 && (psec.getFloorstat() & 2) != 0) {
            int y;
            int x;
            if (Main.IsOriginalDemo()) {
                x = p.posx + (EngineUtils.sin((int)p.ang + 512 & 0x7FF) >> 5);
                y = p.posy + (EngineUtils.sin((int)p.ang & 0x7FF) >> 5);
            } else {
                x = (int)((double)p.posx + ru.m210projects.Build.Gameutils.BCosAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)) / 32.0);
                y = (int)((double)p.posy + ru.m210projects.Build.Gameutils.BSinAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang)) / 32.0);
            }
            int tempsect = Main.engine.updatesector(x, y, psect);
            if (tempsect >= 0) {
                int k = Main.engine.getflorzofslope(psect, x, y);
                if (psect == tempsect) {
                    p.horizoff = (short)(p.horizoff + (short)Pragmas.mulscale(p.truefz - k, 160L, 16));
                } else if (Pragmas.klabs(Main.engine.getflorzofslope(tempsect, x, y) - k) <= 1024) {
                    p.horizoff = (short)(p.horizoff + (short)Pragmas.mulscale(p.truefz - k, 160L, 16));
                }
            }
        }
        if (p.horizoff > 0) {
            p.horizoff = (short)(p.horizoff - (short)((p.horizoff >> 3) + 1));
        } else if (p.horizoff < 0) {
            p.horizoff = (short)(p.horizoff + (short)((-p.horizoff >> 3) + 1));
        }
        if ((hz & 0xE0000000) == -1073741824 && (pHitSprite = Main.boardService.getSprite(hz & 0x1FFFFFFF)) != null && pHitSprite.getStatnum() == 1 && pHitSprite.getExtra() >= 0) {
            cz = p.truecz;
        }
        if ((lz & 0xE0000000) == -1073741824) {
            pHitSprite = Main.boardService.getSprite(lz & 0x1FFFFFFF);
            if (pHitSprite != null && (pHitSprite.getCstat() & 0x21) == 33) {
                psectlotag = 0;
                p.footprintcount = 0;
                p.spritebridge = 1;
            } else if (Actors.badguy(pHitSprite) && pHitSprite.getXrepeat() > 24 && Pragmas.klabs(psp.getZ() - pHitSprite.getZ()) < 21504) {
                int j = EngineUtils.getAngle(pHitSprite.getX() - p.posx, pHitSprite.getY() - p.posy);
                p.posxv -= EngineUtils.cos(j & 0x7FF) << 4;
                p.posyv -= EngineUtils.sin(j & 0x7FF) << 4;
            }
        }
        if (psp.getExtra() > 0) {
            Player.incur_damage(p);
        } else {
            psp.setExtra(0);
            p.shield_amount = 0;
        }
        p.last_extra = psp.getExtra();
        p.loogcnt = p.loogcnt > 0 ? --p.loogcnt : 0;
        if (p.fist_incs != 0) {
            p.fist_incs = (short)(p.fist_incs + 1);
            if (p.fist_incs == 28) {
                Main.gDemoScreen.onStopRecord();
                Sounds.sound(14);
                p.pals[0] = 64;
                p.pals[1] = 64;
                p.pals[2] = 64;
                p.pals_time = 48;
            }
            if (p.fist_incs > 42) {
                if (p.buttonpalette != 0 && Globals.ud.from_bonus == 0) {
                    Globals.ud.from_bonus = Globals.ud.level_number + 1;
                    if (Globals.ud.secretlevel > 0 && Globals.ud.secretlevel < 12) {
                        Globals.ud.level_number = Globals.ud.secretlevel - 1;
                    }
                } else if (Globals.ud.from_bonus != 0) {
                    Globals.ud.level_number = Globals.ud.from_bonus;
                    Globals.ud.from_bonus = 0;
                } else {
                    ++Globals.ud.level_number;
                }
                Premap.LeaveMap();
                p.fist_incs = 0;
                return;
            }
        }
        if (p.timebeforeexit > 1 && p.last_extra > 0) {
            p.timebeforeexit = (short)(p.timebeforeexit - 1);
            if (p.timebeforeexit == 130) {
                Sounds.stopAllSounds();
                Sounds.clearsoundlocks();
                if (p.customexitsound >= 0) {
                    Sounds.sound(p.customexitsound);
                    View.FTA(102, p);
                }
            } else if (p.timebeforeexit == 1) {
                Premap.LeaveMap();
                if (Globals.ud.from_bonus != 0) {
                    Globals.ud.level_number = Globals.ud.from_bonus;
                    Globals.ud.from_bonus = 0;
                } else {
                    ++Globals.ud.level_number;
                }
                return;
            }
        }
        if (p.pals_time > 0) {
            --p.pals_time;
        }
        if (psp.getExtra() <= 0) {
            if (p.dead_flag == 0) {
                if (psp.getPal() != 1) {
                    p.pals[0] = 63;
                    p.pals[1] = 0;
                    p.pals[2] = 0;
                    p.pals_time = 63;
                    p.posz -= 4096;
                    psp.setZ(psp.getZ() - 4096);
                }
                if (Globals.ud.multimode < 2) {
                    Main.gDemoScreen.onStopRecord();
                }
                if (psp.getPal() != 1) {
                    p.dead_flag = (short)(512 - ((Main.engine.krand() & 1) << 10) + (Main.engine.krand() & 0xFF) - 512 & 0x7FF);
                }
                p.jetpack_on = 0;
                p.holoduke_on = (short)-1;
                Sounds.stopsound(50, p.i);
                if (p.scream_voice != null) {
                    p.scream_voice.stop();
                    p.scream_voice = null;
                }
                if (psp.getPal() != 1 && (psp.getCstat() & 0x8000) == 0) {
                    psp.setCstat(0);
                }
                if (Globals.ud.multimode > 1 && (psp.getPal() != 1 || (psp.getCstat() & 0x8000) != 0)) {
                    if (p.frag_ps != snum && p.frag_ps < Globals.ps.length) {
                        Globals.ps[p.frag_ps].frag = (short)(Globals.ps[p.frag_ps].frag + 1);
                        short[] sArray = Globals.frags[p.frag_ps];
                        int n = snum;
                        sArray[n] = (short)(sArray[n] + 1);
                        if (snum == Globals.screenpeek) {
                            if (Globals.ud.user_name[p.frag_ps] != null && !Globals.ud.user_name[p.frag_ps].isEmpty()) {
                                Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[115], 0, "KILLED BY ", Globals.ud.user_name[p.frag_ps]);
                            } else {
                                Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[115], 0, "KILLED BY PLAYER ", 1 + p.frag_ps);
                            }
                            View.FTA(115, p);
                        } else {
                            if (Globals.ud.user_name[snum] != null && !Globals.ud.user_name[snum].isEmpty()) {
                                Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[116], 0, "KILLED ", Globals.ud.user_name[snum]);
                            } else {
                                Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[116], 0, "KILLED PLAYER ", 1 + snum);
                            }
                            View.FTA(116, Globals.ps[p.frag_ps]);
                        }
                    } else {
                        p.fraggedself = (short)(p.fraggedself + 1);
                    }
                    p.frag_ps = (short)snum;
                }
            }
            if (psectlotag == 2) {
                if (p.on_warping_sector == 0) {
                    if (Pragmas.klabs(p.posz - fz) > 4864) {
                        p.posz += 348;
                    }
                } else {
                    psp.setZ(psp.getZ() - 512);
                    psp.setZvel(-348);
                }
                Main.engine.clipmove(p.posx, p.posy, p.posz, p.cursectnum, 0L, 0L, 164, 1024, 1024, 65537);
                if (Engine.clipmove_sectnum != -1) {
                    p.posx = Engine.clipmove_x;
                    p.posy = Engine.clipmove_y;
                    p.posz = Engine.clipmove_z;
                    p.cursectnum = Engine.clipmove_sectnum;
                }
            }
            p.oposx = p.posx;
            p.oposy = p.posy;
            p.oposz = p.posz;
            p.oang = p.ang;
            p.opyoff = p.pyoff;
            p.horiz = 100.0f;
            p.horizoff = 0;
            int sect = Main.engine.updatesector(p.posx, p.posy, p.cursectnum);
            if (sect != -1) {
                p.cursectnum = sect;
            }
            Main.engine.pushmove(p.posx, p.posy, p.posz, p.cursectnum, 128, 1024, 5120, 65537);
            if (Engine.pushmove_sectnum != -1) {
                p.posx = Engine.pushmove_x;
                p.posy = Engine.pushmove_y;
                p.posz = Engine.pushmove_z;
                p.cursectnum = Engine.pushmove_sectnum;
            }
            if (fz > cz + 4096 && psp.getPal() != 1) {
                p.rotscrnang = (short)(p.dead_flag + (fz + p.posz >> 7) & 0x7FF);
            }
            p.on_warping_sector = 0;
            return;
        }
        if (p.transporter_hold > 0) {
            p.transporter_hold = (short)(p.transporter_hold - 1);
            if (p.transporter_hold == 0 && p.on_warping_sector != 0) {
                p.transporter_hold = (short)2;
            }
        }
        if (p.transporter_hold < 0) {
            p.transporter_hold = (short)(p.transporter_hold + 1);
        }
        boolean SHOOTINCODE = false;
        if (p.newowner >= 0) {
            Globals.hittype[p.i].tempang = (int)p.ang;
            Sprite spo = Main.boardService.getSprite(p.newowner);
            if (spo != null) {
                p.posx = spo.getX();
                p.posy = spo.getY();
                p.posz = spo.getZ();
                p.ang = spo.getAng();
            }
            psp.setXvel(0);
            p.posyv = 0;
            p.posxv = 0;
            p.look_ang = 0;
            p.rotscrnang = 0;
            Player.doincrements(p);
            if (p.curr_weapon == 10) {
                SHOOTINCODE = true;
            } else {
                return;
            }
        }
        if (!SHOOTINCODE) {
            Sector psec2;
            int moveHit;
            int doubvel = 4;
            if (p.rotscrnang > 0) {
                p.rotscrnang = (short)(p.rotscrnang - (short)((p.rotscrnang >> 1) + 1));
            } else if (p.rotscrnang < 0) {
                p.rotscrnang = (short)(p.rotscrnang + (short)((-p.rotscrnang >> 1) + 1));
            }
            p.look_ang -= p.look_ang >> 2;
            if ((sb_snum & 0x40) != 0) {
                p.look_ang -= 152;
                p.rotscrnang = (short)(p.rotscrnang + 24);
            }
            if ((sb_snum & 0x80) != 0) {
                p.look_ang += 152;
                p.rotscrnang = (short)(p.rotscrnang - 24);
            }
            if (p.on_crane < 0) {
                p.weapon_sway = psp.getXvel() < 32 || !p.on_ground || p.bobcounter == 1024 ? ((p.weapon_sway & 0x7FF) > 1120 ? (p.weapon_sway -= 96) : ((p.weapon_sway & 0x7FF) < 928 ? (p.weapon_sway += 96) : 1024)) : p.bobcounter;
                psp.setXvel((short)EngineUtils.sqrt((p.posx - p.bobposx) * (p.posx - p.bobposx) + (p.posy - p.bobposy) * (p.posy - p.bobposy)));
                if (p.on_ground) {
                    p.bobcounter += psp.getXvel() >> 1;
                }
                Sector psec22 = Main.boardService.getSector(p.cursectnum);
                if (!(Globals.ud.clipping || psec22 != null && psec22.getFloorpicnum() != 560)) {
                    p.posx = p.oposx;
                    p.posy = p.oposy;
                } else {
                    p.oposx = p.posx;
                    p.oposy = p.posy;
                }
                p.bobposx = p.posx;
                p.bobposy = p.posy;
                p.oposz = p.posz;
                p.opyoff = p.pyoff;
                p.oang = p.ang;
                if (p.one_eighty_count < 0) {
                    p.one_eighty_count = (short)(p.one_eighty_count + 128);
                    p.ang += 128.0f;
                }
                int zoffs = 40;
                if (psectlotag == 2) {
                    Sprite bubbl;
                    p.jumping_counter = 0;
                    p.pycount = (short)(p.pycount + 32);
                    p.pycount = (short)(p.pycount & 0x7FF);
                    p.pyoff = EngineUtils.sin(p.pycount) >> 7;
                    if (Globals.Sound[48].getSoundOwnerCount() == 0) {
                        Sounds.spritesound(48, pi);
                    }
                    if ((sb_snum & 1) != 0) {
                        if (p.poszv > 0) {
                            p.poszv = 0;
                        }
                        p.poszv -= 348;
                        if (p.poszv < -1536) {
                            p.poszv = -1536;
                        }
                    } else if ((sb_snum & 2) != 0) {
                        if (p.poszv < 0) {
                            p.poszv = 0;
                        }
                        p.poszv += 348;
                        if (p.poszv > 1536) {
                            p.poszv = 1536;
                        }
                    } else {
                        if (p.poszv < 0) {
                            p.poszv += 256;
                            if (p.poszv > 0) {
                                p.poszv = 0;
                            }
                        }
                        if (p.poszv > 0) {
                            p.poszv -= 256;
                            if (p.poszv < 0) {
                                p.poszv = 0;
                            }
                        }
                    }
                    if (p.poszv > 2048) {
                        p.poszv >>= 1;
                    }
                    p.posz += p.poszv;
                    if (p.posz > fz - 3840) {
                        p.posz += fz - 3840 - p.posz >> 1;
                    }
                    if (p.posz < cz + 1024) {
                        p.posz = cz + 1024;
                        p.poszv = 0;
                    }
                    if (p.scuba_on != 0 && (Main.engine.krand() & 0xFF) < 8 && (bubbl = Main.boardService.getSprite(Spawn.spawn(pi, 661))) != null) {
                        if (Main.IsOriginalDemo()) {
                            bubbl.setX(bubbl.getX() + (EngineUtils.cos((int)p.ang + 64 - (Globals.global_random & 0x80) & 0x7FF) >> 6));
                            bubbl.setY(bubbl.getY() + (EngineUtils.sin((int)p.ang + 64 - (Globals.global_random & 0x80) & 0x7FF) >> 6));
                        } else {
                            bubbl.setX((int)((double)bubbl.getX() + ru.m210projects.Build.Gameutils.BCosAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang + 64.0f - (float)(Globals.global_random & 0x80)) / 64.0f)));
                            bubbl.setY((int)((double)bubbl.getY() + ru.m210projects.Build.Gameutils.BSinAngle(ru.m210projects.Build.Gameutils.BClampAngle(p.ang + 64.0f - (float)(Globals.global_random & 0x80)) / 64.0f)));
                        }
                        bubbl.setXrepeat(3);
                        bubbl.setYrepeat(2);
                        bubbl.setZ(p.posz + 2048);
                    }
                } else if (p.jetpack_on != 0) {
                    p.on_ground = false;
                    p.jumping_counter = 0;
                    p.hard_landing = 0;
                    p.falling_counter = 0;
                    p.pycount = (short)(p.pycount + 32);
                    p.pycount = (short)(p.pycount & 0x7FF);
                    p.pyoff = EngineUtils.sin(p.pycount) >> 7;
                    if (p.jetpack_on < 11) {
                        ++p.jetpack_on;
                        p.posz -= p.jetpack_on << 7;
                    } else if (p.jetpack_on == 11 && Globals.Sound[50].getSoundOwnerCount() < 1) {
                        Sounds.spritesound(50, pi);
                    }
                    int j = shrunk ? 512 : 2048;
                    if ((sb_snum & 1) != 0) {
                        p.posz -= j;
                        p.crack_time = 777;
                    }
                    if ((sb_snum & 2) != 0) {
                        p.posz += j;
                        p.crack_time = 777;
                    }
                    int k = !shrunk && psectlotag == 0 ? 32 : 16;
                    if (p.scuba_on == 1) {
                        p.scuba_on = 0;
                    }
                    if (p.posz > fz - (k << 8)) {
                        p.posz += fz - (k << 8) - p.posz >> 1;
                    }
                    if (p.posz < Globals.hittype[pi].ceilingz + 4608) {
                        p.posz = Globals.hittype[pi].ceilingz + 4608;
                    }
                } else {
                    if (p.airleft != 390) {
                        p.airleft = (short)390;
                    }
                    if (p.scuba_on == 1) {
                        p.scuba_on = 0;
                    }
                    if (psectlotag == 1 && p.spritebridge == 0) {
                        if (!shrunk) {
                            zoffs = 34;
                            p.pycount = (short)(p.pycount + 32);
                            p.pycount = (short)(p.pycount & 0x7FF);
                            p.pyoff = EngineUtils.sin(p.pycount) >> 6;
                        } else {
                            zoffs = 12;
                        }
                        if (!shrunk && truefdist <= 9728 && p.on_ground) {
                            if (p.dummyplayersprite == -1) {
                                p.dummyplayersprite = (short)Spawn.spawn(pi, 1420);
                            }
                            p.footprintcount = (short)6;
                            p.footprintpal = psec22 != null && psec22.getFloorpicnum() == 200 ? (short)8 : (short)0;
                            p.footprintshade = 0;
                        }
                    } else if (p.footprintcount > 0 && p.on_ground && psec22 != null && (psec22.getFloorstat() & 2) != 2) {
                        Sprite sj;
                        ListNode<Sprite> node;
                        for (node = Main.boardService.getSectNode(psect); node != null && ((sj = node.get()).getPicnum() != 550 && sj.getPicnum() != 672 && sj.getPicnum() != 673 && sj.getPicnum() != 674 || Pragmas.klabs(sj.getX() - p.posx) >= 384 || Pragmas.klabs(sj.getY() - p.posy) >= 384); node = node.getNext()) {
                        }
                        if (node == null) {
                            p.footprintcount = (short)(p.footprintcount - 1);
                            if (psec22.getLotag() == 0 && psec22.getHitag() == 0) {
                                int foot;
                                switch (Main.engine.krand() & 3) {
                                    case 0: {
                                        foot = Spawn.spawn(pi, 550);
                                        break;
                                    }
                                    case 1: {
                                        foot = Spawn.spawn(pi, 672);
                                        break;
                                    }
                                    case 2: {
                                        foot = Spawn.spawn(pi, 673);
                                        break;
                                    }
                                    default: {
                                        foot = Spawn.spawn(pi, 674);
                                    }
                                }
                                Sprite sj2 = Main.boardService.getSprite(foot);
                                if (sj2 != null) {
                                    sj2.setPal(p.footprintpal);
                                    sj2.setShade((byte)p.footprintshade);
                                }
                            }
                        }
                    }
                    if (p.posz < fz - (zoffs << 8)) {
                        if ((sb_snum & 3) == 0 && p.on_ground && (psec.getFloorstat() & 2) != 0 && p.posz >= fz - (zoffs << 8) - 4096) {
                            p.posz = fz - (zoffs << 8);
                        } else {
                            p.on_ground = false;
                            p.poszv += Globals.currentGame.getCON().gc + 80;
                            if (p.poszv >= 6144) {
                                p.poszv = 6144;
                            }
                            if (p.poszv > 2400 && p.falling_counter < 255) {
                                p.falling_counter = (short)(p.falling_counter + 1);
                                if (p.falling_counter == 38) {
                                    p.scream_voice = Sounds.spritesound(245, pi);
                                }
                            }
                            if (p.posz + p.poszv >= fz - (zoffs << 8) && psec22 != null && psec22.getLotag() != 1) {
                                if (p.falling_counter > 62) {
                                    Player.quickkill(p);
                                } else if (p.falling_counter > 9) {
                                    psp.setExtra(psp.getExtra() - (p.falling_counter - (Main.engine.krand() & 3)));
                                    if (psp.getExtra() <= 0) {
                                        Sounds.spritesound(69, pi);
                                    } else {
                                        Sounds.spritesound(42, pi);
                                        Sounds.spritesound(200, pi);
                                    }
                                    p.pals[0] = 16;
                                    p.pals[1] = 0;
                                    p.pals[2] = 0;
                                    p.pals_time = 32;
                                } else if (p.poszv > 2048) {
                                    Sounds.spritesound(42, pi);
                                }
                            }
                        }
                    } else {
                        p.falling_counter = 0;
                        if (p.scream_voice != null) {
                            p.scream_voice.stop();
                            p.scream_voice = null;
                        }
                        if (psectlotag != 1 && !p.on_ground && p.poszv > 3072) {
                            p.hard_landing = (short)(p.poszv >> 10);
                        }
                        p.on_ground = true;
                        if (zoffs == 40) {
                            int k = fz - (zoffs << 8) - p.posz >> 1;
                            if (Pragmas.klabs(k) < 256) {
                                k = 0;
                            }
                            p.posz += k;
                            p.poszv -= 768;
                            if (p.poszv < 0) {
                                p.poszv = 0;
                            }
                        } else if (p.jumping_counter == 0) {
                            p.posz += fz - (zoffs << 7) - p.posz >> 1;
                            if (p.on_warping_sector == 0 && p.posz > fz - 4096) {
                                p.posz = fz - 4096;
                                p.poszv >>= 1;
                            }
                        }
                        p.on_warping_sector = 0;
                        if ((sb_snum & 2) != 0) {
                            p.posz += 2816;
                            p.crack_time = 777;
                        }
                        if ((sb_snum & 1) == 0 && p.jumping_toggle == 1) {
                            p.jumping_toggle = 0;
                        } else if ((sb_snum & 1) != 0 && p.jumping_toggle == 0 && p.jumping_counter == 0 && fz - cz > 14336) {
                            p.jumping_counter = 1;
                            p.jumping_toggle = 1;
                        }
                        if (p.jumping_counter != 0 && (sb_snum & 1) == 0) {
                            p.jumping_toggle = 0;
                        }
                    }
                    if (p.jumping_counter != 0) {
                        p.crouch_toggle = 0;
                        if ((sb_snum & 1) == 0 && p.jumping_toggle == 1) {
                            p.jumping_toggle = 0;
                        }
                        if (p.jumping_counter < 1280) {
                            if (psectlotag == 1 && p.jumping_counter > 768) {
                                p.jumping_counter = 0;
                                p.poszv = -512;
                            } else {
                                p.poszv -= EngineUtils.sin(1920 + p.jumping_counter & 0x7FF) / 12;
                                p.jumping_counter = (short)(p.jumping_counter + 180);
                                p.on_ground = false;
                            }
                        } else {
                            p.jumping_counter = 0;
                            p.poszv = 0;
                        }
                    }
                    p.posz += p.poszv;
                    if (p.posz < cz + 1024) {
                        p.jumping_counter = 0;
                        if (p.poszv < 0) {
                            p.posyv = 0;
                            p.posxv = 0;
                        }
                        p.poszv = 128;
                        p.posz = cz + 1024;
                    }
                }
                if (p.fist_incs != 0 || p.transporter_hold > 2 || p.hard_landing != 0 || p.access_incs > 0 || p.knee_incs > 0 || p.curr_weapon == 8 && p.kickback_pic > 1 && p.kickback_pic < 4) {
                    doubvel = 0;
                    p.posxv = 0;
                    p.posyv = 0;
                } else if (Globals.sync[snum].avel != 0.0f) {
                    if (Main.IsOriginalDemo()) {
                        int tempang = (int)Globals.sync[snum].avel << 1;
                        p.angvel = psectlotag == 2 ? (float)((tempang - (tempang >> 3)) * Pragmas.ksgn(doubvel)) : (float)(tempang * Pragmas.ksgn(doubvel));
                        p.ang += p.angvel;
                        p.ang = (int)p.ang & 0x7FF;
                    } else {
                        float tempang = Globals.sync[snum].avel * 2.0f;
                        p.angvel = psectlotag == 2 ? (tempang - tempang / 8.0f) * (float)Gameutils.sgn(doubvel) : tempang * (float)Gameutils.sgn(doubvel);
                        p.ang += p.angvel;
                        p.ang = ru.m210projects.Build.Gameutils.BClampAngle(p.ang);
                    }
                    p.crack_time = 777;
                }
                Sector pssec = Main.boardService.getSector(psp.getSectnum());
                if (p.spritebridge == 0 && pssec != null) {
                    short floorpicnum = pssec.getFloorpicnum();
                    if (floorpicnum == 4240 || pssec.getCeilingpicnum() == 4240) {
                        if (p.boot_amount > 0) {
                            p.boot_amount = (short)(p.boot_amount - 1);
                            p.inven_icon = 7;
                            if (p.boot_amount <= 0) {
                                Player.checkavailinven(p);
                            }
                        } else {
                            if (Globals.Sound[211].getSoundOwnerCount() < 1) {
                                Sounds.spritesound(211, pi);
                            }
                            p.pals[0] = 0;
                            p.pals[1] = 8;
                            p.pals[2] = 0;
                            p.pals_time = 32;
                            psp.setExtra(psp.getExtra() - 1);
                        }
                    }
                    boolean k = false;
                    if (p.on_ground && truefdist <= 13824) {
                        switch (floorpicnum) {
                            case 859: {
                                if (!Gameutils.rnd(32)) break;
                                if (p.boot_amount > 0) {
                                    k = true;
                                    break;
                                }
                                if (Globals.Sound[211].getSoundOwnerCount() < 1) {
                                    Sounds.spritesound(211, pi);
                                }
                                p.pals[0] = 64;
                                p.pals[1] = 64;
                                p.pals[2] = 64;
                                p.pals_time = 32;
                                psp.setExtra(psp.getExtra() - (1 + (Main.engine.krand() & 3)));
                                if (Globals.Sound[21].getSoundOwnerCount() >= 1) break;
                                Sounds.spritesound(21, pi);
                                break;
                            }
                            case 200: {
                                if (!Gameutils.rnd(16)) break;
                                if (p.boot_amount > 0) {
                                    k = true;
                                    break;
                                }
                                if (Globals.Sound[211].getSoundOwnerCount() < 1) {
                                    Sounds.spritesound(211, pi);
                                }
                                p.pals[0] = 0;
                                p.pals[1] = 8;
                                p.pals[2] = 0;
                                p.pals_time = 32;
                                psp.setExtra(psp.getExtra() - (1 + (Main.engine.krand() & 3)));
                                break;
                            }
                            case 1082: {
                                if (!Gameutils.rnd(32)) break;
                                if (p.boot_amount > 0) {
                                    k = true;
                                    break;
                                }
                                if (Globals.Sound[211].getSoundOwnerCount() < 1) {
                                    Sounds.spritesound(211, pi);
                                }
                                p.pals[0] = 8;
                                p.pals[1] = 0;
                                p.pals[2] = 0;
                                p.pals_time = 32;
                                psp.setExtra(psp.getExtra() - (1 + (Main.engine.krand() & 3)));
                            }
                        }
                    }
                    if (k) {
                        View.FTA(75, p);
                        p.boot_amount = (short)(p.boot_amount - 2);
                        if (p.boot_amount <= 0) {
                            Player.checkavailinven(p);
                        }
                    }
                }
                if (p.posxv != 0 || p.posyv != 0 || Globals.sync[snum].fvel != 0 || Globals.sync[snum].svel != 0) {
                    p.crack_time = 777;
                    int k = EngineUtils.sin(p.bobcounter & 0x7FF) >> 12;
                    if (truefdist < 11776) {
                        if (k == 1 || k == 3) {
                            if (p.spritebridge == 0 && p.walking_snd_toggle == 0 && p.on_ground) {
                                switch (psectlotag) {
                                    case 0: {
                                        short pic = 0;
                                        if ((lz & 0xE0000000) == -1073741824) {
                                            Sprite hsp = Main.boardService.getSprite(lz & 0x1FFFFFFF);
                                            if (hsp != null) {
                                                pic = hsp.getPicnum();
                                            }
                                        } else {
                                            pic = psec.getFloorpicnum();
                                        }
                                        switch (pic) {
                                            case 342: 
                                            case 343: {
                                                Sounds.spritesound(43, pi);
                                                p.walking_snd_toggle = 1;
                                            }
                                        }
                                        break;
                                    }
                                    case 1: {
                                        if ((Main.engine.krand() & 1) == 0) {
                                            Sounds.spritesound(40, pi);
                                        }
                                        p.walking_snd_toggle = 1;
                                    }
                                }
                            }
                        } else if (p.walking_snd_toggle > 0) {
                            p.walking_snd_toggle = (short)(p.walking_snd_toggle - 1);
                        }
                    }
                    if (p.jetpack_on == 0 && p.steroids_amount > 0 && p.steroids_amount < 400) {
                        doubvel <<= 1;
                    }
                    p.posxv += Globals.sync[snum].fvel * doubvel << 6;
                    p.posyv += Globals.sync[snum].svel * doubvel << 6;
                    if (p.curr_weapon == 0 && p.kickback_pic > 10 && p.on_ground || p.on_ground && (sb_snum & 2) != 0) {
                        p.posxv = Pragmas.mulscale(p.posxv, Globals.currentGame.getCON().dukefriction - 8192, 16);
                        p.posyv = Pragmas.mulscale(p.posyv, Globals.currentGame.getCON().dukefriction - 8192, 16);
                    } else if (psectlotag == 2) {
                        p.posxv = Pragmas.mulscale(p.posxv, Globals.currentGame.getCON().dukefriction - 5120, 16);
                        p.posyv = Pragmas.mulscale(p.posyv, Globals.currentGame.getCON().dukefriction - 5120, 16);
                    } else {
                        p.posxv = Pragmas.mulscale(p.posxv, Globals.currentGame.getCON().dukefriction, 16);
                        p.posyv = Pragmas.mulscale(p.posyv, Globals.currentGame.getCON().dukefriction, 16);
                    }
                    if (Math.abs(p.posxv) < 2048 && Math.abs(p.posyv) < 2048) {
                        p.posyv = 0;
                        p.posxv = 0;
                    }
                    if (shrunk) {
                        p.posxv = Pragmas.mulscale(p.posxv, Globals.currentGame.getCON().dukefriction - (Globals.currentGame.getCON().dukefriction >> 1) + (Globals.currentGame.getCON().dukefriction >> 2), 16);
                        p.posyv = Pragmas.mulscale(p.posyv, Globals.currentGame.getCON().dukefriction - (Globals.currentGame.getCON().dukefriction >> 1) + (Globals.currentGame.getCON().dukefriction >> 2), 16);
                    }
                }
            }
            int i = 5120;
            if (psectlotag == 1 || p.spritebridge == 1) {
                i = 1024;
            }
            if (Globals.ud.clipping) {
                moveHit = 0;
                p.posx += p.posxv >> 14;
                p.posy += p.posyv >> 14;
                int sect = Main.engine.updatesector(p.posx, p.posy, p.cursectnum);
                if (sect != -1) {
                    p.cursectnum = sect;
                }
                Main.engine.changespritesect(pi, p.cursectnum);
            } else {
                moveHit = Main.engine.clipmove(p.posx, p.posy, p.posz, p.cursectnum, p.posxv, p.posyv, 164, 1024, i, 65537);
                if (Engine.clipmove_sectnum != -1) {
                    p.posx = Engine.clipmove_x;
                    p.posy = Engine.clipmove_y;
                    p.posz = Engine.clipmove_z;
                    p.cursectnum = Engine.clipmove_sectnum;
                }
            }
            if (p.jetpack_on == 0 && psectlotag != 2 && psectlotag != 1 && shrunk) {
                p.posz += 8192;
            }
            if (moveHit != 0) {
                DSector.checkplayerhurt(p, moveHit);
            }
            if (p.jetpack_on == 0) {
                if (psp.getXvel() > 16) {
                    if (psectlotag != 1 && psectlotag != 2 && p.on_ground) {
                        p.pycount = (short)(p.pycount + 52);
                        p.pycount = (short)(p.pycount & 0x7FF);
                        p.pyoff = Pragmas.klabs(psp.getXvel() * EngineUtils.sin(p.pycount)) / 1596;
                    }
                } else if (psectlotag != 2 && psectlotag != 1) {
                    p.pyoff = 0;
                }
            }
            Main.engine.setsprite(pi, p.posx, p.posy, p.posz + 9728);
            if (psectlotag < 3) {
                Sprite pspr;
                psect = psp.getSectnum();
                psec = Main.boardService.getSector(psect);
                if (!Globals.ud.clipping && psec != null && psec.getLotag() == 31 && (pspr = Main.boardService.getSprite(psec.getHitag())) != null && pspr.getXvel() != 0 && Globals.hittype[psec.getHitag()].temp_data[0] == 0) {
                    Player.quickkill(p);
                    return;
                }
            }
            if ((psec2 = Main.boardService.getSector(p.cursectnum)) != null && truefdist < 9728 && p.on_ground && psectlotag != 1 && !shrunk && psec2.getLotag() == 1 && Globals.Sound[40].getSoundOwnerCount() == 0) {
                Sounds.spritesound(40, pi);
            }
            if (p.cursectnum != psp.getSectnum() && psec2 != null) {
                Main.engine.changespritesect(pi, p.cursectnum);
            }
            boolean pushMove = false;
            if (!Globals.ud.clipping) {
                boolean bl = pushMove = Main.engine.pushmove(p.posx, p.posy, p.posz, p.cursectnum, 164, 1024, 1024, 65537) < 0 && Gamedef.furthestangle(pi, 8) < 512;
                if (Engine.pushmove_sectnum != -1) {
                    p.posx = Engine.pushmove_x;
                    p.posy = Engine.pushmove_y;
                    p.posz = Engine.pushmove_z;
                    p.cursectnum = Engine.pushmove_sectnum;
                }
            }
            if (!Globals.ud.clipping) {
                if (Pragmas.klabs(Globals.hittype[pi].floorz - Globals.hittype[pi].ceilingz) < 12288 || pushMove) {
                    Sector pssec = Main.boardService.getSector(psp.getSectnum());
                    if (pssec != null && (pssec.getLotag() & 0x8000) == 0 && (DSector.isanunderoperator(pssec.getLotag()) || DSector.isanearoperator(pssec.getLotag()))) {
                        DSector.activatebysector(psp.getSectnum(), pi);
                    }
                    if (pushMove) {
                        Player.quickkill(p);
                        return;
                    }
                } else if (Pragmas.klabs(fz - cz) < 8192 && psec != null && DSector.isanunderoperator(psec.getLotag())) {
                    DSector.activatebysector(psect, pi);
                }
            }
            if ((sb_snum & 0x40000) != 0 || p.hard_landing != 0) {
                p.return_to_center = (short)9;
            }
            if ((sb_snum & 0x2000) != 0) {
                p.return_to_center = (short)9;
                if ((sb_snum & 0x20) != 0) {
                    p.horiz += 12.0f;
                }
                p.horiz += 12.0f;
            } else if ((sb_snum & 0x4000) != 0) {
                p.return_to_center = (short)9;
                if ((sb_snum & 0x20) != 0) {
                    p.horiz -= 12.0f;
                }
                p.horiz -= 12.0f;
            } else if ((sb_snum & 8) != 0) {
                if ((sb_snum & 0x20) != 0) {
                    p.horiz += 6.0f;
                }
                p.horiz += 6.0f;
            } else if ((sb_snum & 0x10) != 0) {
                if ((sb_snum & 0x20) != 0) {
                    p.horiz -= 6.0f;
                }
                p.horiz -= 6.0f;
            }
            if (p.return_to_center > 0 && (sb_snum & 0x2000) == 0 && (sb_snum & 0x4000) == 0) {
                p.return_to_center = (short)(p.return_to_center - 1);
                if (Main.IsOriginalDemo()) {
                    int dh = (int)p.horiz / 3;
                    p.horiz += (float)(33 - dh);
                } else {
                    p.horiz += 33.0f - p.horiz / 3.0f;
                }
            }
            if (p.hard_landing > 0) {
                p.hard_landing = (short)(p.hard_landing - 1);
                p.horiz -= (float)(p.hard_landing << 4);
            }
            if (p.aim_mode != 0) {
                p.horiz = Main.IsOriginalDemo() ? (p.horiz += (float)((int)Globals.sync[snum].horz >> 1)) : (p.horiz += Globals.sync[snum].horz / 2.0f);
            } else {
                if (p.horiz > 95.0f && p.horiz < 105.0f) {
                    p.horiz = 100.0f;
                }
                if (p.horizoff > -5 && p.horizoff < 5) {
                    p.horizoff = 0;
                }
            }
            if (p.horiz > 299.0f) {
                p.horiz = 299.0f;
            } else if (p.horiz < -99.0f) {
                p.horiz = -99.0f;
            }
            if (p.show_empty_weapon > 0) {
                p.show_empty_weapon = (short)(p.show_empty_weapon - 1);
                if (p.show_empty_weapon == 0) {
                    if (p.last_full_weapon == 11) {
                        p.subweapon |= 0x800;
                    } else if (p.last_full_weapon == 6) {
                        p.subweapon &= 0xFFFFF7FF;
                    }
                    Weapons.addweapon(p, p.last_full_weapon);
                    return;
                }
            }
            if (p.knee_incs > 0) {
                p.knee_incs = (short)(p.knee_incs + 1);
                p.horiz -= 48.0f;
                p.return_to_center = (short)9;
                if (p.knee_incs > 15) {
                    Sprite squ;
                    p.knee_incs = 0;
                    p.holster_weapon = 0;
                    if (p.weapon_pos < 0) {
                        p.weapon_pos = -p.weapon_pos;
                    }
                    if ((squ = Main.boardService.getSprite(p.actorsqu)) != null && DSector.dist(psp, squ) < 1400) {
                        Spawn.guts(squ, 2286, 7, Mmulti.myconnectindex);
                        Spawn.spawn(p.actorsqu, 1226);
                        Sounds.spritesound(69, p.actorsqu);
                        switch (squ.getPicnum()) {
                            case 603: 
                            case 753: 
                            case 1294: 
                            case 1312: 
                            case 1317: 
                            case 1321: 
                            case 1323: 
                            case 1325: 
                            case 1334: 
                            case 1336: 
                            case 1395: 
                            case 3450: 
                            case 4864: {
                                if (squ.getYvel() == 0) break;
                                DSector.operaterespawns(squ.getYvel());
                            }
                        }
                        if (squ.getPicnum() == 1405) {
                            Player.quickkill(Globals.ps[squ.getYvel()]);
                            Globals.ps[squ.getYvel()].frag_ps = (short)snum;
                        } else if (Actors.badguy(squ)) {
                            Main.engine.deletesprite(p.actorsqu);
                            Globals.ps[Mmulti.connecthead].actors_killed = (short)(Globals.ps[Mmulti.connecthead].actors_killed + 1);
                        } else {
                            Main.engine.deletesprite(p.actorsqu);
                        }
                    }
                    p.actorsqu = (short)-1;
                } else {
                    Sprite squ = Main.boardService.getSprite(p.actorsqu);
                    if (squ != null) {
                        p.ang += Gamedef.getincangle(p.ang, (float)EngineUtils.getAngle(squ.getX() - p.posx, squ.getY() - p.posy)) / 4.0f;
                    }
                }
            }
            if (Player.doincrements(p)) {
                return;
            }
            if (p.weapon_pos != 0) {
                if (p.weapon_pos == -9) {
                    if (p.last_weapon >= 0) {
                        p.weapon_pos = (short)10;
                        p.last_weapon = (short)-1;
                    } else if (p.holster_weapon == 0) {
                        p.weapon_pos = (short)10;
                    }
                } else {
                    p.weapon_pos = (short)(p.weapon_pos - 1);
                }
            }
        }
        if (!shrunk) {
            Weapons.weaponprocess(snum);
        }
    }

    public static int getspritescore(int snum, int dapicnum) {
        switch (dapicnum) {
            case 21: {
                return 5;
            }
            case 22: 
            case 27: {
                return 50;
            }
            case 23: {
                return 200;
            }
            case 24: {
                return 25;
            }
            case 25: {
                return 80;
            }
            case 26: {
                return 60;
            }
            case 28: 
            case 29: {
                return 120;
            }
            case 37: {
                if (Globals.ps[snum].ammo_amount[9] < Globals.currentGame.getCON().max_ammo_amount[9]) {
                    return 10;
                }
                return 0;
            }
            case 5135: {
                if (Globals.ps[snum].ammo_amount[12] < Globals.currentGame.getCON().max_ammo_amount[12]) {
                    return 10;
                }
                return 0;
            }
            case 40: {
                if (Globals.ps[snum].ammo_amount[2] < Globals.currentGame.getCON().max_ammo_amount[2]) {
                    return 10;
                }
                return 0;
            }
            case 41: {
                if (Globals.ps[snum].ammo_amount[3] < Globals.currentGame.getCON().max_ammo_amount[3]) {
                    return 20;
                }
                return 0;
            }
            case 42: {
                if (Globals.ps[snum].ammo_amount[7] < Globals.currentGame.getCON().max_ammo_amount[7]) {
                    return 25;
                }
                return 0;
            }
            case 44: {
                if (Globals.ps[snum].ammo_amount[4] < Globals.currentGame.getCON().max_ammo_amount[4]) {
                    return 50;
                }
                return 0;
            }
            case 46: {
                if (Globals.ps[snum].ammo_amount[6] < Globals.currentGame.getCON().max_ammo_amount[6]) {
                    return 10;
                }
                return 0;
            }
            case 47: {
                if (Globals.ps[snum].ammo_amount[5] < Globals.currentGame.getCON().max_ammo_amount[5]) {
                    return 30;
                }
                return 0;
            }
            case 49: {
                if (Globals.ps[snum].ammo_amount[2] < Globals.currentGame.getCON().max_ammo_amount[2]) {
                    return 25;
                }
                return 0;
            }
            case 51: {
                Sprite psp = Main.boardService.getSprite(Globals.ps[snum].i);
                if (psp != null && psp.getExtra() < 100) {
                    return 10;
                }
                return 0;
            }
            case 52: {
                Sprite psp = Main.boardService.getSprite(Globals.ps[snum].i);
                if (psp != null && psp.getExtra() < 100) {
                    return 30;
                }
                return 0;
            }
            case 53: {
                if (Globals.ps[snum].firstaid_amount < 100) {
                    return 100;
                }
                return 0;
            }
            case 54: {
                if (Globals.ps[snum].shield_amount < 100) {
                    return 50;
                }
                return 0;
            }
            case 55: {
                if (Globals.ps[snum].steroids_amount < 400) {
                    return 30;
                }
                return 0;
            }
            case 56: {
                if (Globals.ps[snum].scuba_amount < 6400) {
                    return 30;
                }
                return 0;
            }
            case 57: {
                if (Globals.ps[snum].jetpack_amount < 1600) {
                    return 100;
                }
                return 0;
            }
            case 59: {
                if (Globals.ps[snum].heat_amount < 1200) {
                    return 10;
                }
                return 0;
            }
            case 60: {
                return 1;
            }
            case 61: {
                if (Globals.ps[snum].boot_amount < 200) {
                    return 50;
                }
                return 0;
            }
            case 100: {
                Sprite psp = Main.boardService.getSprite(Globals.ps[snum].i);
                if (psp != null && psp.getExtra() < Globals.currentGame.getCON().max_player_health) {
                    return 50;
                }
                return 0;
            }
            case 1348: {
                if (Globals.ps[snum].holoduke_amount < 2400) {
                    return 30;
                }
                return 0;
            }
        }
        return 0;
    }

    public static void computergetinput(int snum, Input syn) {
        int daang;
        int dy;
        int dx;
        int l;
        int z3;
        int y3;
        int x3;
        int k;
        int dist;
        int i;
        int z2;
        int y2;
        int x2;
        Sprite goalSprite;
        PlayerStruct p = Globals.ps[snum];
        Sprite psp = Main.boardService.getSprite(p.i);
        if (psp == null) {
            return;
        }
        syn.fvel = 0;
        syn.svel = 0;
        syn.avel = 0.0f;
        syn.horz = 0.0f;
        syn.bits = 0;
        int x1 = psp.getX();
        int y1 = psp.getY();
        int z1 = psp.getZ();
        short damyang = psp.getAng();
        int damysect = psp.getSectnum();
        if (Mmulti.numplayers >= 2 && snum == Mmulti.myconnectindex) {
            x1 = Main.game.net.predict.x;
            y1 = Main.game.net.predict.y;
            z1 = Main.game.net.predict.z + 9728;
            damyang = (short)Main.game.net.predict.ang;
            damysect = Main.game.net.predict.sectnum;
        }
        if ((goalSprite = Main.boardService.getSprite(Globals.ps[Player.goalplayer[snum]].i)) != null && (Globals.numframes & 7) == 0 && !Main.engine.cansee(x1, y1, z1 - 12288, damysect, x2 = goalSprite.getX(), y2 = goalSprite.getY(), (z2 = goalSprite.getZ()) - 12288, goalSprite.getSectnum())) {
            Player.goalplayer[snum] = snum;
        }
        if (goalplayer[snum] == snum || Globals.ps[Player.goalplayer[snum]].dead_flag != 0) {
            int j = Integer.MAX_VALUE;
            i = Mmulti.connecthead;
            while (i >= 0) {
                Sprite playerSprite;
                if (i != snum && (playerSprite = Main.boardService.getSprite(Globals.ps[i].i)) != null) {
                    dist = EngineUtils.sqrt((playerSprite.getX() - x1) * (playerSprite.getX() - x1) + (playerSprite.getY() - y1) * (playerSprite.getY() - y1));
                    x2 = playerSprite.getX();
                    if (!Main.engine.cansee(x1, y1, z1 - 12288, damysect, x2, y2 = playerSprite.getY(), (z2 = playerSprite.getZ()) - 12288, playerSprite.getSectnum())) {
                        dist <<= 1;
                    }
                    if (dist < j) {
                        j = dist;
                        Player.goalplayer[snum] = i;
                    }
                }
                i = Mmulti.connectpoint2[i];
            }
        }
        if (goalSprite == null) {
            return;
        }
        x2 = goalSprite.getX();
        y2 = goalSprite.getY();
        z2 = goalSprite.getZ();
        if (p.dead_flag != 0) {
            syn.bits |= 0x20000000;
        }
        if (p.firstaid_amount > 0 && p.last_extra < 100) {
            syn.bits |= 0x10000;
        }
        for (ListNode<Sprite> node = Main.boardService.getStatNode(4); node != null; node = node.getNext()) {
            Sprite spr = node.get();
            switch (spr.getPicnum()) {
                case 1641: 
                case 1647: {
                    k = 4;
                    break;
                }
                case 1646: 
                case 2605: {
                    k = 16;
                    break;
                }
                default: {
                    k = 0;
                }
            }
            if (k == 0) continue;
            x3 = spr.getX();
            y3 = spr.getY();
            z3 = spr.getZ();
            for (l = 0; l <= 8; ++l) {
                if (Pragmas.tmulscale(x3 - x1, x3 - x1, y3 - y1, y3 - y1, z3 - z1 >> 4, z3 - z1 >> 4, 11) < 3072) {
                    dx = EngineUtils.cos(spr.getAng() & 0x7FF);
                    dy = EngineUtils.sin(spr.getAng() & 0x7FF);
                    int i2 = k * 512;
                    if ((x1 - x3) * dy > (y1 - y3) * dx) {
                        i2 *= -1;
                    }
                    syn.fvel = (short)(syn.fvel - (short)Pragmas.mulscale(dy, i2, 17));
                    syn.svel = (short)(syn.svel + (short)Pragmas.mulscale(dx, i2, 17));
                }
                if (l < 7) {
                    x3 += Pragmas.mulscale(spr.getXvel(), EngineUtils.cos(spr.getAng() & 0x7FF), 14) << 2;
                    y3 += Pragmas.mulscale(spr.getXvel(), EngineUtils.sin(spr.getAng() & 0x7FF), 14) << 2;
                    z3 += spr.getZvel() << 2;
                    continue;
                }
                Main.engine.hitscan(spr.getX(), spr.getY(), spr.getZ(), spr.getSectnum(), Pragmas.mulscale(spr.getXvel(), EngineUtils.cos(spr.getAng() & 0x7FF), 14), Pragmas.mulscale(spr.getXvel(), EngineUtils.sin(spr.getAng() & 0x7FF), 14), spr.getZvel(), Engine.pHitInfo, 0x1000040);
                x3 = Engine.pHitInfo.hitx;
                y3 = Engine.pHitInfo.hity;
                z3 = Engine.pHitInfo.hitz;
            }
        }
        if (Globals.ps[Player.goalplayer[snum]].dead_flag == 0 && (Main.engine.cansee(x1, y1, z1, damysect, x2, y2, z2, goalSprite.getSectnum()) || Main.engine.cansee(x1, y1, z1 - 6144, damysect, x2, y2, z2 - 6144, goalSprite.getSectnum()) || Main.engine.cansee(x1, y1, z1 - 12288, damysect, x2, y2, z2 - 12288, goalSprite.getSectnum()))) {
            int fightdist;
            syn.bits |= 4;
            if (p.curr_weapon == 5 && (Main.engine.krand() & 7) == 0) {
                syn.bits &= 0xFFFFFFFB;
            }
            if (p.curr_weapon == 8) {
                syn.bits |= Main.engine.krand() % 13 << 8;
            }
            if (p.curr_weapon == 4) {
                Main.engine.hitscan(x1, y1, z1 - 9728, damysect, EngineUtils.cos(damyang & 0x7FF), EngineUtils.sin(damyang & 0x7FF), (int)(100.0f - p.horiz - (float)p.horizoff) * 32, Engine.pHitInfo, 0x1000040);
                x3 = Engine.pHitInfo.hitx;
                y3 = Engine.pHitInfo.hity;
                if ((x3 - x1) * (x3 - x1) + (y3 - y1) * (y3 - y1) < 0x640000) {
                    syn.bits &= 0xFFFFFFFB;
                }
            }
            if ((fightdist = fdmatrix[p.curr_weapon][Globals.ps[Player.goalplayer[snum]].curr_weapon]) < 128) {
                fightdist = 128;
            }
            if ((dist = EngineUtils.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1))) == 0) {
                dist = 1;
            }
            int daang2 = EngineUtils.getAngle(x2 + (Globals.ps[Player.goalplayer[snum]].posxv >> 14) - x1, y2 + (Globals.ps[Player.goalplayer[snum]].posyv >> 14) - y1);
            int zang = 100 - (z2 - z1) * 8 / dist;
            fightdist = Math.max(fightdist, Pragmas.klabs(z2 - z1) >> 4);
            if (goalSprite.getYrepeat() < 32) {
                fightdist = 0;
                syn.bits &= 0xFFFFFFFB;
            }
            if (goalSprite.getPal() == 1) {
                fightdist = 0;
                syn.bits &= 0xFFFFFFFB;
            }
            if (dist < 256) {
                syn.bits |= 0x400000;
            }
            x3 = x2 + (x1 - x2) * fightdist / dist;
            y3 = y2 + (y1 - y2) * fightdist / dist;
            syn.fvel = (short)(syn.fvel + (short)((x3 - x1) * 2047 / dist));
            syn.svel = (short)(syn.svel + (short)((y3 - y1) * 2047 / dist));
            if (fightdist != 0) {
                int j = Main.engine.getTotalClock() + snum * 13468;
                i = EngineUtils.sin(j << 6 & 0x7FF);
                i += EngineUtils.sin(j + 4245 << 5 & 0x7FF);
                i += EngineUtils.sin(j + 6745 << 4 & 0x7FF);
                i += EngineUtils.sin(j + 15685 << 3 & 0x7FF);
                dx = EngineUtils.cos(goalSprite.getAng() & 0x7FF);
                dy = EngineUtils.sin(goalSprite.getAng() & 0x7FF);
                i = (x1 - x2) * dy > (y1 - y2) * dx ? (i += 8192) : (i -= 8192);
                syn.fvel = (short)(syn.fvel + (short)(EngineUtils.cos(daang2 + 512 & 0x7FF) * i >> 17));
                syn.svel = (short)(syn.svel + (short)(EngineUtils.sin(daang2 + 512 & 0x7FF) * i >> 17));
            }
            syn.avel = (short)Math.min(Math.max((daang2 + 1024 - damyang & 0x7FF) - 1024 >> 1, -127), 127);
            syn.horz = Math.min(Math.max(((float)zang - p.horiz) / 2.0f, -127.0f), 127.0f);
            syn.bits |= 0x800000;
            return;
        }
        Player.goalsect[snum] = -1;
        if (goalsect[snum] < 0) {
            Player.goalwall[snum] = -1;
            short startsect = psp.getSectnum();
            short endsect = goalSprite.getSectnum();
            Sector startsec = Main.boardService.getSector(startsect);
            if (startsec == null) {
                return;
            }
            Arrays.fill(dashow2dsector, (byte)0);
            Player.searchsect[0] = startsect;
            Player.searchparent[0] = -1;
            int n = startsect >> 3;
            dashow2dsector[n] = (byte)(dashow2dsector[n] | (byte)(1 << (startsect & 7)));
            int send = 1;
            for (int splc = 0; splc < send; ++splc) {
                Sector searchsec = Main.boardService.getSector(searchsect[splc]);
                if (searchsec == null) continue;
                for (ListNode<Wall> wn = searchsec.getWallNode(); wn != null; wn = wn.getNext()) {
                    Wall kwal;
                    Wall wal2;
                    ListNode<Wall> wn2;
                    Wall wal = wn.get();
                    short j = wal.getNextsector();
                    Sector nsec = Main.boardService.getSector(j);
                    if (nsec == null || Main.engine.getceilzofslope(j, dx = wal.getWall2().getX() + wal.getX() >> 1, dy = wal.getWall2().getY() + wal.getY() >> 1) > Main.engine.getflorzofslope(j, dx, dy) - 7168 && (nsec.getLotag() < 15 || nsec.getLotag() > 22) || Main.engine.getflorzofslope(j, dx, dy) < Main.engine.getflorzofslope(searchsect[splc], dx, dy) - 18432 || (dashow2dsector[j >> 3] & 1 << (j & 7)) != 0) continue;
                    int n2 = j >> 3;
                    dashow2dsector[n2] = (byte)(dashow2dsector[n2] | (byte)(1 << (j & 7)));
                    Player.searchsect[send] = j;
                    Player.searchparent[send] = (short)splc;
                    ++send;
                    if (j != endsect) continue;
                    Arrays.fill(dashow2dsector, (byte)0);
                    k = send - 1;
                    while (k >= 0) {
                        int n3 = searchsect[k] >> 3;
                        dashow2dsector[n3] = (byte)(dashow2dsector[n3] | (byte)(1 << (searchsect[k] & 7)));
                        k = searchparent[k];
                    }
                    k = send - 1;
                    while (k >= 0 && searchparent[k] != 0) {
                        k = searchparent[k];
                    }
                    Player.goalsect[snum] = searchsect[k];
                    Sector goalsec = Main.boardService.getSector(goalsect[snum]);
                    if (goalsec == null) continue;
                    short startwall = goalsec.getWallptr();
                    int endwall = startwall + goalsec.getWallnum();
                    y3 = 0;
                    x3 = 0;
                    for (wn2 = goalsec.getWallNode(); wn2 != null; wn2 = wn2.getNext()) {
                        wal2 = wn2.get();
                        x3 += wal2.getX();
                        y3 += wal2.getY();
                    }
                    x3 /= endwall - startwall;
                    y3 /= endwall - startwall;
                    l = 0;
                    k = startsec.getWallptr();
                    for (wn2 = startsec.getWallNode(); wn2 != null; wn2 = wn2.getNext()) {
                        wal2 = wn2.get();
                        if (wal2.getNextsector() != goalsect[snum]) continue;
                        dx = wal2.getWall2().getX() - wal2.getX();
                        dy = wal2.getWall2().getY() - wal2.getY();
                        if ((x3 - x1) * (wal2.getY() - y1) <= (y3 - y1) * (wal2.getX() - x1) && (x3 - x1) * (wal2.getWall2().getY() - y1) >= (y3 - y1) * (wal2.getWall2().getX() - x1)) {
                            k = wn2.getIndex();
                            break;
                        }
                        dist = EngineUtils.sqrt(dx * dx + dy * dy);
                        if (dist <= l) continue;
                        l = dist;
                        k = wn2.getIndex();
                    }
                    if ((kwal = Main.boardService.getWall(k)) == null) break;
                    Player.goalwall[snum] = k;
                    daang = kwal.getWallAngle() + 1536 & 0x7FF;
                    Player.goalx[snum] = (kwal.getX() + kwal.getWall2().getX() >> 1) + (EngineUtils.cos(daang & 0x7FF) >> 8);
                    Player.goaly[snum] = (kwal.getY() + kwal.getWall2().getY() >> 1) + (EngineUtils.sin(daang & 0x7FF) >> 8);
                    Player.goalz[snum] = goalsec.getFloorz() - 8192;
                    break;
                }
                for (ListNode<Sprite> node = Main.boardService.getSectNode(searchsect[splc]); node != null; node = node.getNext()) {
                    short j;
                    Sprite spo;
                    Sprite sp = node.get();
                    if (sp.getLotag() != 7 || (spo = Main.boardService.getSprite(sp.getOwner())) == null || (dashow2dsector[(j = spo.getSectnum()) >> 3] & 1 << (j & 7)) != 0) continue;
                    int n4 = j >> 3;
                    dashow2dsector[n4] = (byte)(dashow2dsector[n4] | (byte)(1 << (j & 7)));
                    Player.searchsect[send] = j;
                    Player.searchparent[send] = (short)splc;
                    ++send;
                    if (j != endsect) continue;
                    Arrays.fill(dashow2dsector, (byte)0);
                    k = send - 1;
                    while (k >= 0) {
                        int n5 = searchsect[k] >> 3;
                        dashow2dsector[n5] = (byte)(dashow2dsector[n5] | (byte)(1 << (searchsect[k] & 7)));
                        k = searchparent[k];
                    }
                    k = send - 1;
                    while (k >= 0 && searchparent[k] != 0) {
                        k = searchparent[k];
                    }
                    Player.goalsect[snum] = searchsect[k];
                    l = 0;
                    k = startsec.getWallptr();
                    for (ListNode<Wall> wn = startsec.getWallNode(); wn != null; wn = wn.getNext()) {
                        Wall wal = wn.get();
                        dx = wal.getWall2().getX() - wal.getX();
                        dy = wal.getWall2().getY() - wal.getY();
                        dist = EngineUtils.sqrt(dx * dx + dy * dy);
                        if (wal.getNextsector() != goalsect[snum] || dist <= l) continue;
                        l = dist;
                        k = wn.getIndex();
                    }
                    Wall kwal = Main.boardService.getWall(k);
                    if (kwal == null) break;
                    Player.goalwall[snum] = k;
                    daang = kwal.getWallAngle() + 1536 & 0x7FF;
                    Player.goalx[snum] = (kwal.getX() + kwal.getWall2().getX() >> 1) + (EngineUtils.sin(daang + 512 & 0x7FF) >> 8);
                    Player.goaly[snum] = (kwal.getY() + kwal.getWall2().getY() >> 1) + (EngineUtils.sin(daang & 0x7FF) >> 8);
                    Sector goalsec = Main.boardService.getSector(goalsect[snum]);
                    if (goalsec == null) break;
                    Player.goalz[snum] = goalsec.getFloorz() - 8192;
                    break;
                }
                if (goalwall[snum] >= 0) break;
            }
        }
        if (goalsect[snum] < 0 || goalwall[snum] < 0) {
            if (goalsprite[snum] < 0) {
                block17: for (k = 0; k < 4; ++k) {
                    int i3 = Main.engine.krand() % Main.boardService.getSectorCount();
                    for (ListNode<Sprite> node = Main.boardService.getSectNode(i3); node != null; node = node.getNext()) {
                        int j = node.getIndex();
                        Sprite sp = node.get();
                        if (sp.getXrepeat() <= 0 || sp.getYrepeat() <= 0 || Player.getspritescore(snum, sp.getPicnum()) <= 0 || !Main.engine.cansee(x1, y1, z1 - 8192, damysect, sp.getX(), sp.getY(), sp.getZ() - 1024, (short)i3)) continue;
                        Player.goalx[snum] = sp.getX();
                        Player.goaly[snum] = sp.getY();
                        Player.goalz[snum] = sp.getZ();
                        Player.goalsprite[snum] = j;
                        continue block17;
                    }
                }
            }
            if ((dist = EngineUtils.sqrt(((x2 = goalx[snum]) - x1) * (x2 - x1) + ((y2 = goaly[snum]) - y1) * (y2 - y1))) == 0) {
                return;
            }
            daang = EngineUtils.getAngle(x2 - x1, y2 - y1);
            syn.fvel = (short)(syn.fvel + (short)((x2 - x1) * 2047 / dist));
            syn.svel = (short)(syn.svel + (short)((y2 - y1) * 2047 / dist));
            syn.avel = (byte)Math.min(Math.max((daang + 1024 - damyang & 0x7FF) - 1024 >> 3, -127), 127);
        } else {
            Player.goalsprite[snum] = -1;
        }
        x3 = p.posx;
        y3 = p.posy;
        z3 = p.posz;
        int dasect = p.cursectnum;
        int moveHit = Main.engine.clipmove(x3, y3, z3, dasect, p.posxv, p.posyv, 164, 1024, 1024, 65537);
        if (moveHit == 0) {
            x3 = p.posx;
            y3 = p.posy;
            z3 = p.posz + 6144;
            dasect = p.cursectnum;
            moveHit = Main.engine.clipmove(x3, y3, z3, dasect, p.posxv, p.posyv, 164, 1024, 1024, 65537);
        }
        if (moveHit != 0) {
            Wall hwal;
            int n = snum;
            clipmovecount[n] = clipmovecount[n] + 1;
            int j = 0;
            if ((moveHit & 0xE0000000) == Integer.MIN_VALUE && (hwal = Main.boardService.getWall(moveHit & 0x1FFFFFFF)) != null && hwal.getNextsector() >= 0) {
                if (Main.engine.getflorzofslope(hwal.getNextsector(), p.posx, p.posy) <= p.posz + 6144) {
                    j |= 1;
                }
                if (Main.engine.getceilzofslope(hwal.getNextsector(), p.posx, p.posy) >= p.posz - 6144) {
                    j |= 2;
                }
            }
            if ((moveHit & 0xE0000000) == -1073741824) {
                j = 1;
            }
            if (j & true && clipmovecount[snum] == 4) {
                syn.bits |= 1;
            }
            if ((j & 2) != 0) {
                syn.bits |= 2;
            }
            daang = EngineUtils.getAngle(x2 - x1, y2 - y1);
            if ((moveHit & 0xE0000000) == Integer.MIN_VALUE && (hwal = Main.boardService.getWall(moveHit & 0x1FFFFFFF)) != null) {
                daang = hwal.getWallAngle();
            }
            j = Main.engine.getTotalClock() + snum * 13468;
            int i4 = EngineUtils.sin(j << 6 & 0x7FF);
            i4 += EngineUtils.sin(j + 4245 << 5 & 0x7FF);
            i4 += EngineUtils.sin(j + 6745 << 4 & 0x7FF);
            syn.fvel = (short)(syn.fvel + (short)(EngineUtils.cos(daang + 512 & 0x7FF) * (i4 += EngineUtils.sin(j + 15685 << 3 & 0x7FF)) >> 17));
            syn.svel = (short)(syn.svel + (short)(EngineUtils.sin(daang + 512 & 0x7FF) * i4 >> 17));
            if ((clipmovecount[snum] & 0x1F) == 2) {
                syn.bits |= 0x20000000;
            }
            if ((clipmovecount[snum] & 0x1F) == 17) {
                syn.bits |= 0x400000;
            }
            if (clipmovecount[snum] > 32) {
                Player.goalsect[snum] = -1;
                Player.goalwall[snum] = -1;
                Player.clipmovecount[snum] = 0;
            }
            Player.goalsprite[snum] = -1;
        } else {
            Player.clipmovecount[snum] = 0;
        }
        if (goalsect[snum] >= 0 && goalwall[snum] >= 0) {
            x2 = goalx[snum];
            y2 = goaly[snum];
            dist = EngineUtils.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            if (dist == 0) {
                return;
            }
            daang = EngineUtils.getAngle(x2 - x1, y2 - y1);
            Wall goalwal = Main.boardService.getWall(goalwall[snum]);
            if (goalwal != null && dist < 4096) {
                daang = goalwal.getWallAngle() + 1536 & 0x7FF;
            }
            syn.fvel = (short)(syn.fvel + (short)((x2 - x1) * 2047 / dist));
            syn.svel = (short)(syn.svel + (short)((y2 - y1) * 2047 / dist));
            syn.avel = (byte)Math.min(Math.max((daang + 1024 - damyang & 0x7FF) - 1024 >> 3, -127), 127);
        }
    }
}

