/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Screens;

import com.badlogic.gdx.Screen;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.LoadSave;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Player;
import ru.m210projects.Duke3D.ResourceHandler;
import ru.m210projects.Duke3D.Screens.GameScreen;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Types.CompareService.CompareService;
import ru.m210projects.Duke3D.Types.GameInfo;
import ru.m210projects.Duke3D.Types.PlayerStruct;
import ru.m210projects.Duke3D.View;
import ru.m210projects.Duke3D.filehandle.DemoFile;
import ru.m210projects.Duke3D.filehandle.DemoRecorder;

public class DemoScreen
extends GameScreen {
    public int nDemonum = -1;
    public final Map<Group, List<Entry>> demofiles = new HashMap<Group, List<Entry>>();
    public static DemoFile demfile;
    protected Entry lastDemoEntry = Directory.DUMMY_ENTRY;

    public DemoScreen(Main game) {
        super(game);
    }

    @Override
    public void show() {
        LoadSave.lastload = null;
    }

    @Override
    public void hide() {
        Globals.ud.user_name[Mmulti.myconnectindex] = Main.cfg.getpName();
    }

    public boolean showDemo(Entry entry, Entry ini) {
        this.onStopRecord();
        demfile = null;
        try (InputStream is = entry.getInputStream();){
            demfile = new DemoFile(is);
        }
        catch (Exception e) {
            Console.out.println("Can't play the demo file: " + entry.getName(), OsdColor.RED);
            return false;
        }
        Player.InitPlayers();
        boolean bl = Globals.mFakeMultiplayer = DemoScreen.demfile.multimode > 1;
        if (Globals.mFakeMultiplayer) {
            Globals.nFakePlayers = DemoScreen.demfile.multimode;
        }
        if (Mmulti.numplayers > 1) {
            Main.game.pNet.NetDisconnect(Mmulti.myconnectindex);
        }
        Globals.ud.volume_number = DemoScreen.demfile.volume_number;
        Globals.ud.level_number = DemoScreen.demfile.level_number;
        Globals.ud.player_skill = DemoScreen.demfile.player_skill;
        Globals.ud.coop = DemoScreen.demfile.coop;
        Globals.ud.ffire = DemoScreen.demfile.ffire;
        Globals.ud.multimode = DemoScreen.demfile.multimode;
        Globals.ud.monsters_off = DemoScreen.demfile.monsters_off;
        Globals.ud.respawn_monsters = DemoScreen.demfile.respawn_monsters;
        Globals.ud.respawn_items = DemoScreen.demfile.respawn_items;
        Globals.ud.respawn_inventory = DemoScreen.demfile.respawn_inventory;
        Globals.ud.playerai = DemoScreen.demfile.playerai;
        System.arraycopy(DemoScreen.demfile.user_name, 0, Globals.ud.user_name, 0, 16);
        for (int i = 0; i < Globals.ud.multimode; ++i) {
            Globals.ps[i].aim_mode = DemoScreen.demfile.aim_mode[i];
            Globals.ps[i].auto_aim = DemoScreen.demfile.version >= 127 ? DemoScreen.demfile.auto_aim[i] : 1;
        }
        Globals.ud.god = false;
        Globals.ud.showallmap = 0;
        Globals.ud.eog = 0;
        Globals.ud.cashman = 0;
        Globals.ud.scrollmode = false;
        Globals.ud.clipping = false;
        Globals.ud.overhead_on = 0;
        Globals.ud.recstat = 2;
        GameInfo addon = ResourceHandler.levelGetEpisode(ini);
        if (DemoScreen.demfile.addon != null) {
            addon = DemoScreen.demfile.addon;
        }
        this.lastDemoEntry = entry;
        Main.gDemoScreen.newgame(Globals.mFakeMultiplayer, addon, Globals.ud.volume_number, Globals.ud.level_number, Globals.ud.player_skill);
        Console.out.println("Playing demo " + entry.getName());
        return true;
    }

    public List<Entry> checkDemoEntry(Group group) {
        if (this.demofiles.containsKey(group)) {
            return this.demofiles.get(group);
        }
        this.nDemonum = -1;
        List<Entry> demos = group.stream().filter(this::isDemoFile).sorted(Entry::compareTo).collect(Collectors.toList());
        if (demos.isEmpty()) {
            int k;
            int which_demo = 1;
            do {
                k = which_demo;
                char[] d = "demo_.dmo".toCharArray();
                d[4] = which_demo == 10 ? 120 : (char)(48 + which_demo);
                String name = String.copyValueOf(d);
                Entry entry = Main.game.getCache().getEntry(name, true);
                if (!this.isDemoFile(entry)) break;
                demos.add(entry);
            } while (k != ++which_demo);
        }
        this.demofiles.put(group, demos);
        Console.out.println("There are " + demos.size() + " demo(s) in the loop", OsdColor.YELLOW);
        if (Main.cfg.gDemoSeq == 2) {
            int nextnum = this.nDemonum;
            if (demos.size() > 1) {
                while (nextnum == this.nDemonum) {
                    nextnum = (int)(Math.random() * (double)demos.size());
                }
            }
            this.nDemonum = nextnum;
        }
        return demos;
    }

    @Override
    protected void startboard(Runnable startboard) {
        Main.game.doPrecache(() -> {
            startboard.run();
            this.pNet.ResetTimers();
            Globals.lockclock = 0;
            this.pNet.ready2send = false;
        });
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (this.gameKeyDownCommon(gameKey, false)) {
            return true;
        }
        if (GameKeys.Enlarge_Screen.equals(gameKey)) {
            if (Globals.ud.screen_size > 0) {
                Sounds.sound(158);
                this.enlargeScreen();
            }
            return true;
        }
        if (GameKeys.Shrink_Screen.equals(gameKey)) {
            if (Globals.ud.screen_size < 3) {
                Sounds.sound(158);
                this.shrinkScreen();
            }
            return true;
        }
        return false;
    }

    @Override
    public void render(float delta) {
        if (Mmulti.numplayers > 1) {
            this.pNet.GetPackets();
        }
        this.DemoRender();
        float smoothratio = 65536.0f;
        if (!Main.game.gPaused && ((smoothratio = (float)this.pEngine.getTimer().getsmoothratio(delta)) < 0.0f || smoothratio > 65536.0f)) {
            smoothratio = Gameutils.BClipRange(smoothratio, 0.0f, 65536.0f);
        }
        Main.game.pInt.dointerpolations(smoothratio);
        this.DrawWorld(smoothratio);
        this.DrawHud(smoothratio);
        Main.game.pInt.restoreinterpolations();
        View.operatefta();
        if (Globals.ud.last_camsprite != Globals.ud.camerasprite) {
            Globals.ud.last_camsprite = Globals.ud.camerasprite;
            Globals.ud.camera_time = Main.engine.getTotalClock() + 240;
        }
        if (this.pMenu.gShowMenu) {
            this.pMenu.mDrawMenu();
        }
        this.PostFrame(this.pNet);
        this.pEngine.nextpage(delta);
    }

    private void DemoRender() {
        this.pNet.ready2send = false;
        if (!Main.game.isCurrentScreen(this)) {
            return;
        }
        if (!Main.game.gPaused && demfile != null) {
            while (Main.engine.getTotalClock() >= Globals.lockclock + 4) {
                CompareService.update(DemoScreen.demfile.rcnt);
                short j = Mmulti.connecthead;
                while (j >= 0) {
                    this.pNet.gFifoInput[this.pNet.gNetFifoHead[j] & 0xFF][j].Copy(DemoScreen.demfile.recsync[DemoScreen.demfile.rcnt][j]);
                    short s = j;
                    this.pNet.gNetFifoHead[s] = this.pNet.gNetFifoHead[s] + 1;
                    --DemoScreen.demfile.reccnt;
                    j = Mmulti.connectpoint2[j];
                }
                if (DemoScreen.demfile.reccnt <= 0) {
                    demfile = null;
                    Group group = this.lastDemoEntry.getParent();
                    if (!this.showDemo(group)) {
                        Main.game.changeScreen(Main.gMenuScreen);
                    }
                    return;
                }
                ++DemoScreen.demfile.rcnt;
                Main.game.pInt.clearinterpolations();
                this.ProcessFrame(this.pNet);
            }
        } else {
            Globals.lockclock = Main.engine.getTotalClock();
        }
    }

    public boolean showDemo(Group group) {
        List<Entry> list = this.checkDemoEntry(group);
        switch (Main.cfg.gDemoSeq) {
            case 0: {
                return false;
            }
            case 1: {
                if (this.nDemonum < list.size() - 1) {
                    ++this.nDemonum;
                    break;
                }
                this.nDemonum = 0;
                break;
            }
            case 2: {
                int nextnum = this.nDemonum;
                if (list.size() > 1) {
                    while (nextnum == this.nDemonum) {
                        nextnum = (int)(Math.random() * (double)list.size());
                    }
                }
                this.nDemonum = Gameutils.BClipRange(nextnum, 0, list.size() - 1);
            }
        }
        if (!list.isEmpty()) {
            boolean result = this.showDemo(list.get(this.nDemonum), null);
            if (!result) {
                list.remove(this.nDemonum);
                return this.showDemo(group);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDemoFile(Entry file) {
        if (!file.exists()) return false;
        if (!file.isExtension("dmo")) return false;
        try (InputStream is = file.getInputStream();){
            StreamUtils.skip(is, 4);
            int version = StreamUtils.readUnsignedByte(is);
            if (version != 116 && version != 117 && version != 127) {
                if (version != 147) return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean IsOriginalGame() {
        return DemoScreen.demfile.version <= 127;
    }

    public boolean isRecordEnabled() {
        return Globals.ud.m_recstat == 1;
    }

    public void onPrepareboard(GameScreen screen) {
        if (screen != this && DemoScreen.isDemoPlaying()) {
            Main.gDemoScreen.onStopPlaying();
        }
        if (DemoScreen.isDemoPlaying() && demfile != null && DemoScreen.demfile.version >= 147) {
            short i = Mmulti.connecthead;
            while (i >= 0) {
                PlayerStruct p = Globals.ps[i];
                Sprite psp = Main.boardService.getSprite(p.i);
                if (psp != null) {
                    p.last_extra = DemoScreen.demfile.health[i];
                    psp.setExtra(DemoScreen.demfile.health[i]);
                }
                p.shield_amount = (short)DemoScreen.demfile.armor[i];
                for (int j = 0; j < 13; ++j) {
                    p.gotweapon[j] = DemoScreen.demfile.gotweapon[i][j];
                    p.ammo_amount[j] = DemoScreen.demfile.ammo_amount[i][j];
                }
                p.firstaid_amount = (short)DemoScreen.demfile.firstaid_amount[i];
                p.steroids_amount = (short)DemoScreen.demfile.steroids_amount[i];
                p.holoduke_amount = (short)DemoScreen.demfile.holoduke_amount[i];
                p.jetpack_amount = (short)DemoScreen.demfile.jetpack_amount[i];
                p.heat_amount = (short)DemoScreen.demfile.heat_amount[i];
                p.scuba_amount = (short)DemoScreen.demfile.scuba_amount[i];
                p.boot_amount = (short)DemoScreen.demfile.boot_amount[i];
                p.inven_icon = DemoScreen.demfile.inven_icon[i];
                i = Mmulti.connectpoint2[i];
            }
        }
        if (screen != this && Main.gDemoScreen.isRecordEnabled()) {
            Globals.ud.m_recstat = 0;
            int democount = 0;
            do {
                int a = democount / 1000 % 10;
                int b = democount / 100 % 10;
                int c = democount / 10 % 10;
                int d = democount % 10;
                String fn = "demo" + a + b + c + d + ".dmo";
                if (Main.game.getCache().getGameDirectory().getEntry(fn).exists()) continue;
                try {
                    Path path = Main.game.getCache().getGameDirectory().getPath().resolve(fn);
                    Globals.ud.rec = new DemoRecorder(new FileOutputStream(path.toFile()), path, 147);
                    Console.out.println("Start recording to " + fn);
                    Globals.ud.recstat = 1;
                }
                catch (Exception e) {
                    Console.out.println("Can't start demo record: " + e, OsdColor.RED);
                }
                break;
            } while (++democount < 9999);
        }
    }

    public static boolean isDemoPlaying() {
        return Globals.ud.recstat == 2;
    }

    public static boolean isDemoScreen(Screen screen) {
        return screen == Main.gDemoScreen;
    }

    public boolean isDemoRecording() {
        return Globals.ud.recstat == 1;
    }

    public void onLoad() {
        this.onStopRecord();
        demfile = null;
        Globals.ud.recstat = 0;
    }

    public void onStopPlaying() {
        demfile = null;
        Globals.ud.recstat = 0;
    }

    public void onRecord() {
        if (Globals.ud.rec != null) {
            Globals.ud.rec.record();
        }
    }

    public void onStopRecord() {
        if (Globals.ud.rec == null) {
            return;
        }
        CompareService.close();
        Globals.ud.rec.close();
        Globals.ud.rec = null;
        Globals.ud.recstat = 0;
    }
}

