/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Screens;

import com.badlogic.gdx.Gdx;
import java.util.Arrays;
import java.util.Objects;
import ru.m210projects.Build.Architecture.common.audio.SoundData;
import ru.m210projects.Build.Architecture.common.audio.Source;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Duke3D.Actors;
import ru.m210projects.Duke3D.Animate;
import ru.m210projects.Duke3D.Config;
import ru.m210projects.Duke3D.DSector;
import ru.m210projects.Duke3D.Factory.DukeMenuHandler;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Input;
import ru.m210projects.Duke3D.LoadSave;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Player;
import ru.m210projects.Duke3D.Premap;
import ru.m210projects.Duke3D.ResourceHandler;
import ru.m210projects.Duke3D.Screen;
import ru.m210projects.Duke3D.Screens.DemoScreen;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Spawn;
import ru.m210projects.Duke3D.Types.GameInfo;
import ru.m210projects.Duke3D.Types.PlayerStruct;
import ru.m210projects.Duke3D.View;
import ru.m210projects.Duke3D.Weapons;

public class GameScreen
extends GameAdapter {
    private final Main game;
    boolean shiftPressed = false;
    boolean ctrlPressed = false;
    private int nonsharedtimer;

    public GameScreen(Main game) {
        super(game, Main.gLoadingScreen);
        this.game = game;
        for (int i = 0; i < 16; ++i) {
            Globals.sync[i] = new Input();
        }
    }

    @Override
    public void hide() {
        Sounds.StopCommentary(Sounds.pCommentary);
    }

    @Override
    public void PostFrame(BuildNet net) {
        if (LoadSave.gQuickSaving) {
            if (this.captBuffer != null) {
                LoadSave.savegame(this.game.getUserDirectory(), "[quicksave_" + LoadSave.quickslot + "]", "quicksav" + LoadSave.quickslot + ".sav");
                LoadSave.quickslot ^= 1;
                LoadSave.gQuickSaving = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
        if (LoadSave.gAutosaveRequest) {
            if (this.captBuffer != null) {
                LoadSave.savegame(this.game.getUserDirectory(), "[autosave]", "autosave.sav");
                LoadSave.gAutosaveRequest = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
    }

    @Override
    public void ProcessFrame(BuildNet net) {
        int i;
        Globals.ud.camerasprite = -1;
        short i2 = Mmulti.connecthead;
        while (i2 >= 0) {
            Globals.sync[i2].Copy(net.gFifoInput[net.gNetFifoTail & 0xFF][i2]);
            i2 = Mmulti.connectpoint2[i2];
        }
        ++net.gNetFifoTail;
        int j = -1;
        short i3 = Mmulti.connecthead;
        while (i3 >= 0) {
            this.cheatkeys(i3);
            if (DemoScreen.isDemoScreen(this) || (Globals.sync[i3].bits & 0x4000000) == 0) {
                j = i3;
            } else {
                Main.gDemoScreen.onStopRecord();
                if (i3 == Mmulti.myconnectindex) {
                    this.game.gExit = true;
                }
                if (Globals.screenpeek == i3 && (Globals.screenpeek = Mmulti.connectpoint2[i3]) < 0) {
                    Globals.screenpeek = Mmulti.connecthead;
                }
                if (i3 == Mmulti.connecthead) {
                    Mmulti.connecthead = Mmulti.connectpoint2[Mmulti.connecthead];
                } else {
                    Mmulti.connectpoint2[j] = Mmulti.connectpoint2[i3];
                }
                Mmulti.numplayers = (short)(Mmulti.numplayers - 1);
                --Globals.ud.multimode;
                if (Mmulti.numplayers < 2) {
                    Sounds.sound(177);
                }
                Player.quickkill(Globals.ps[i3]);
                Main.engine.deletesprite(Globals.ps[i3].i);
                Strhandler.buildString(Globals.buf, 0, Globals.ud.user_name[i3], " is history!");
                View.adduserquote(Globals.buf);
                Screen.vscrn(Globals.ud.screen_size);
                if (j < 0) {
                    this.game.show();
                    Console.out.println(" \nThe 'MASTER/First player' just quit the game.  All\nplayers are returned from the game.");
                    return;
                }
            }
            i3 = Mmulti.connectpoint2[i3];
        }
        net.CalcChecksum();
        if (this.game.gPaused || !DemoScreen.isDemoPlaying() && !DemoScreen.isDemoScreen(this) && Globals.ud.multimode < 2 && (this.game.menu.gShowMenu || Console.out.isShowing())) {
            return;
        }
        Main.gDemoScreen.onRecord();
        Globals.everyothertime = (char)(Globals.everyothertime + '\u0001');
        int TICSPERFRAME = Main.engine.getTimer().getFrameTicks();
        Globals.lockclock += TICSPERFRAME;
        if (Globals.earthquaketime > 0) {
            Globals.earthquaketime = (short)(Globals.earthquaketime - 1);
        }
        if (Sounds.rtsplaying > '\u0000') {
            Sounds.rtsplaying = (char)(Sounds.rtsplaying - '\u0001');
        }
        for (i = 0; i < 4; ++i) {
            if (View.user_quote_time[i] == 0) continue;
            int n = i;
            View.user_quote_time[n] = (short)(View.user_quote_time[n] - 1);
        }
        View.quotebot = Pragmas.klabs(View.quotebotgoal - View.quotebot) <= 16 && Globals.ud.screen_size <= 2 ? (View.quotebot += Pragmas.ksgn(View.quotebotgoal - View.quotebot)) : View.quotebotgoal;
        if (View.fta > 0 && (View.fta = (short)(View.fta - 1)) == 0) {
            View.ftq = 0;
        }
        if (Main.engine.getTotalClock() < View.lastvisinc) {
            if (Pragmas.klabs(Globals.gVisibility - Globals.currentGame.getCON().const_visibility) > 8) {
                Globals.gVisibility += Globals.currentGame.getCON().const_visibility - Globals.gVisibility >> 2;
            }
        } else {
            Globals.gVisibility = Globals.currentGame.getCON().const_visibility;
        }
        Globals.global_random = (short)Main.engine.krand();
        Actors.movedummyplayers();
        i = Mmulti.connecthead;
        while (i >= 0) {
            Globals.ps[i].UpdatePlayerLoc();
            Player.processinput(i);
            DSector.checksectors(i);
            i = Mmulti.connectpoint2[i];
        }
        Actors.movefta();
        Weapons.moveweapons();
        Actors.movetransports();
        Actors.moveplayers();
        Actors.movefallers();
        Actors.moveexplosions();
        Actors.moveactors();
        Actors.moveeffectors();
        Actors.movestandables();
        Animate.doanimations();
        Actors.movefx();
        net.CorrectPrediction();
        Sounds.MusicUpdate();
        if ((Globals.everyothertime & '\u0001') == 0) {
            DSector.animatewalls();
            Actors.movecyclers();
            Sounds.pan3dsound();
        }
        if ((Globals.uGameFlags & 1) == 1) {
            this.game.pNet.ready2send = false;
            if (DemoScreen.isDemoScreen(this)) {
                return;
            }
            if (Globals.ud.eog == 1) {
                Globals.ud.eog = 0;
                Globals.uGameFlags |= 2;
                switch (Globals.ud.volume_number) {
                    case 0: {
                        Main.gEndScreen.episode1();
                        break;
                    }
                    case 1: {
                        Main.gEndScreen.episode2();
                        break;
                    }
                    case 2: {
                        Main.gEndScreen.episode3();
                        break;
                    }
                    case 3: {
                        Main.gEndScreen.episode4();
                        break;
                    }
                    case 4: {
                        Main.gEndScreen.episode5();
                        break;
                    }
                    default: {
                        Gdx.app.postRunnable(this.game::show);
                        break;
                    }
                }
            } else {
                Gdx.app.postRunnable(() -> this.game.changeScreen(Main.gStatisticScreen));
            }
        }
    }

    @Override
    public void DrawWorld(float smooth) {
        View.displayrooms(Globals.screenpeek, (int)smooth);
    }

    @Override
    public void DrawHud(float smooth) {
        Renderer renderer = this.game.getRenderer();
        View.displayrest((int)smooth);
        if (this.game.net.bOutOfSync) {
            this.game.getFont(1).drawTextScaled(renderer, 160, 20, "Out of sync!", 1.0f, 0, 12, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
            switch (this.game.net.bOutOfSyncByte / 4) {
                case 0: {
                    this.game.getFont(1).drawTextScaled(renderer, 160, 30, "seed checksum error", 1.0f, 0, 12, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                    break;
                }
                case 1: {
                    this.game.getFont(1).drawTextScaled(renderer, 160, 30, "player struct checksum error", 1.0f, 0, 12, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                    break;
                }
                case 2: {
                    this.game.getFont(1).drawTextScaled(renderer, 160, 30, "player sprite checksum error", 1.0f, 0, 12, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                }
            }
        }
    }

    @Override
    public void processInput(GameProcessor processor) {
        if (Globals.ud.overhead_on != 0) {
            int j = Main.engine.getTotalClock() - this.nonsharedtimer;
            this.nonsharedtimer += j;
            if (processor.isGameKeyPressed(GameKeys.Enlarge_Screen)) {
                View.zoom = (short)(View.zoom + (short)Pragmas.mulscale(j, Math.max(View.zoom, 256), 6));
            }
            if (processor.isGameKeyPressed(GameKeys.Shrink_Screen)) {
                View.zoom = (short)(View.zoom - (short)Pragmas.mulscale(j, Math.max(View.zoom, 256), 6));
            }
            if (View.zoom > 2048) {
                View.zoom = (short)2048;
            }
            if (View.zoom < 48) {
                View.zoom = (short)48;
            }
        }
    }

    protected boolean gameKeyDownCommon(GameKey gameKey, boolean inGame) {
        if (super.gameKeyDown(gameKey)) {
            return true;
        }
        DukeMenuHandler menu = this.game.menu;
        if (GameKeys.Menu_Toggle.equals(gameKey)) {
            if (inGame) {
                menu.mOpen(menu.mMenus[1], -1);
            } else {
                menu.mOpen(menu.mMenus[0], -1);
            }
            return true;
        }
        if (Config.DukeKeys.Show_Loadmenu.equals(gameKey)) {
            if (Mmulti.numplayers > 1 || Globals.mFakeMultiplayer) {
                return false;
            }
            menu.mOpen(menu.mMenus[7], -1);
            return true;
        }
        if (Config.DukeKeys.Show_Sounds.equals(gameKey)) {
            menu.mOpen(menu.mMenus[3], -1);
            return true;
        }
        if (Config.DukeKeys.Show_Options.equals(gameKey)) {
            menu.mOpen(menu.mMenus[15], -1);
            return true;
        }
        if (Config.DukeKeys.Gamma.equals(gameKey)) {
            this.openGamma(menu);
            return true;
        }
        if (Config.DukeKeys.Messages.equals(gameKey)) {
            Globals.ud.fta_on ^= 1;
            if (Globals.ud.fta_on != 0) {
                View.FTA(23, Globals.ps[Mmulti.myconnectindex]);
            } else {
                Globals.ud.fta_on = 1;
                View.FTA(24, Globals.ps[Mmulti.myconnectindex]);
                Globals.ud.fta_on = 0;
            }
            return true;
        }
        if (Config.DukeKeys.Show_Help.equals(gameKey)) {
            menu.mOpen(menu.mMenus[6], -1);
            return true;
        }
        if (Config.DukeKeys.Quit.equals(gameKey)) {
            menu.mOpen(menu.mMenus[9], -1);
            return true;
        }
        if (Config.DukeKeys.Screenshot.equals(gameKey)) {
            this.makeScreenshot();
            return true;
        }
        if (Config.DukeKeys.See_Coop_View.equals(gameKey) && (Globals.ud.coop == 1 || Globals.mFakeMultiplayer)) {
            if ((Globals.screenpeek = Mmulti.connectpoint2[Globals.screenpeek]) < 0) {
                Globals.screenpeek = Mmulti.connecthead;
            }
            Screen.changepalette = 1;
        }
        return false;
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (this.shiftPressed || this.ctrlPressed) {
            return false;
        }
        if (this.gameKeyDownCommon(gameKey, true)) {
            return true;
        }
        DukeMenuHandler menu = this.game.menu;
        if (Config.DukeKeys.Show_Savemenu.equals(gameKey)) {
            if (Mmulti.numplayers > 1 || Globals.mFakeMultiplayer) {
                return false;
            }
            if (Globals.ps[Mmulti.myconnectindex].getPlayerSprite().getExtra() > 0) {
                Main.gGameScreen.capture(160, 100);
                menu.mOpen(menu.mMenus[8], -1);
                return true;
            }
        }
        if (Config.DukeKeys.See_Chase_View.equals(gameKey)) {
            if (View.over_shoulder_on != 0) {
                View.over_shoulder_on = 0;
            } else {
                View.over_shoulder_on = 1;
                View.cameradist = 0;
                View.cameraclock = Main.engine.getTotalClock();
            }
            View.FTA(109 + View.over_shoulder_on, Globals.ps[Mmulti.myconnectindex]);
            return true;
        }
        if (Globals.ud.overhead_on != 0) {
            if (Config.DukeKeys.Map_Follow_Mode.equals(gameKey)) {
                boolean bl = Globals.ud.scrollmode = !Globals.ud.scrollmode;
                if (Globals.ud.scrollmode) {
                    Globals.ud.folx = Globals.ps[Mmulti.myconnectindex].oposx;
                    Globals.ud.foly = Globals.ps[Mmulti.myconnectindex].oposy;
                    Globals.ud.fola = (int)Globals.ps[Mmulti.myconnectindex].oang;
                }
                View.FTA(83 + (Globals.ud.scrollmode ? 1 : 0), Globals.ps[Mmulti.myconnectindex]);
                return true;
            }
        } else {
            if (GameKeys.Enlarge_Screen.equals(gameKey)) {
                if (Globals.ud.screen_size > 0) {
                    Sounds.sound(158);
                    this.enlargeScreen();
                }
                return true;
            }
            if (GameKeys.Shrink_Screen.equals(gameKey)) {
                if (Globals.ud.screen_size < 3) {
                    Sounds.sound(158);
                    this.shrinkScreen();
                }
                return true;
            }
        }
        if (GameKeys.Map_Toggle.equals(gameKey)) {
            if (Globals.ud.last_overhead != Globals.ud.overhead_on && Globals.ud.last_overhead != 0) {
                Globals.ud.overhead_on = Globals.ud.last_overhead;
                Globals.ud.last_overhead = 0;
            } else {
                ++Globals.ud.overhead_on;
                if (Globals.ud.overhead_on == 3) {
                    Globals.ud.overhead_on = 0;
                }
                Globals.ud.last_overhead = Globals.ud.overhead_on;
            }
            return true;
        }
        if (Config.DukeKeys.AutoRun.equals(gameKey)) {
            Globals.ud.auto_run ^= 1;
            View.FTA(85 + Globals.ud.auto_run, Globals.ps[Mmulti.myconnectindex]);
            return true;
        }
        if (Config.DukeKeys.Toggle_Crosshair.equals(gameKey)) {
            Globals.ud.crosshair ^= 1;
            View.FTA(21 - Globals.ud.crosshair, Globals.ps[Mmulti.myconnectindex]);
            return true;
        }
        if (Config.DukeKeys.Show_Opp_Weapon.equals(gameKey)) {
            Globals.ud.showweapons ^= 1;
            View.FTA(82 - Globals.ud.showweapons, Globals.ps[Mmulti.myconnectindex]);
            return true;
        }
        if (Config.DukeKeys.Quicksave.equals(gameKey)) {
            LoadSave.quicksave();
            return true;
        }
        if (Config.DukeKeys.Quickload.equals(gameKey)) {
            LoadSave.quickload();
            return true;
        }
        return false;
    }

    public void shrinkScreen() {
        ++Globals.ud.screen_size;
        if (!Main.engine.getTile(9219).exists() && !Main.engine.getTile(9218).exists() && Globals.ud.screen_size == 2) {
            ++Globals.ud.screen_size;
        }
        if (Globals.ud.screen_size > 3) {
            Globals.ud.screen_size = 3;
        }
        Screen.vscrn(Globals.ud.screen_size);
    }

    public void enlargeScreen() {
        --Globals.ud.screen_size;
        if (!Main.engine.getTile(9219).exists() && !Main.engine.getTile(9218).exists() && Globals.ud.screen_size == 2) {
            --Globals.ud.screen_size;
        }
        if (Globals.ud.screen_size < 0) {
            Globals.ud.screen_size = 0;
        }
        Screen.vscrn(Globals.ud.screen_size);
    }

    protected void openGamma(DukeMenuHandler menu) {
        menu.mOpen(menu.mMenus[13], -1);
    }

    @Override
    public void sndHandlePause(boolean pause) {
        Sounds.sndHandlePause(pause);
    }

    @Override
    protected boolean prepareboard(Entry entry) {
        View.gNameShowTime = 500;
        this.shiftPressed = false;
        this.ctrlPressed = false;
        Premap.checknextlevel();
        try {
            Board board = Main.engine.loadboard(entry);
            Globals.boardfilename = entry;
            BuildPos out = board.getPos();
            Globals.ps[0].posx = out.x;
            Globals.ps[0].posy = out.y;
            Globals.ps[0].posz = out.z;
            Globals.ps[0].ang = out.ang;
            Globals.ps[0].cursectnum = out.sectnum;
            Arrays.fill(Premap.rorsector, (short)-1);
            Arrays.fill(Premap.rortype, (byte)-1);
            Premap.rorcnt = 0;
            Premap.prelevel();
            DSector.allignwarpelevators();
            Premap.resetpspritevars();
            Engine.automapping = 0;
            View.ftq = 0;
            View.fta = 0;
            Arrays.fill(View.loogiex, 0);
            Arrays.fill(View.loogiey, 0);
            short i = Mmulti.connecthead;
            while (i >= 0) {
                Sector psec;
                Sprite psp = Main.boardService.getSprite(Globals.ps[i].i);
                if (psp != null && psp.getSectnum() != Engine.MAXSECTORS && (psec = Main.boardService.getSector(psp.getSectnum())) != null) {
                    switch (psec.getFloorpicnum()) {
                        case 200: 
                        case 859: 
                        case 1082: {
                            Premap.resetweapons(i);
                            Premap.resetinventory(i);
                            Globals.ps[i].gotweapon[1] = false;
                            Globals.ps[i].ammo_amount[1] = 0;
                            Globals.ps[i].curr_weapon = 0;
                            Globals.ps[i].kickback_pic = 0;
                        }
                    }
                }
                i = Mmulti.connectpoint2[i];
            }
            Main.gDemoScreen.onPrepareboard(this);
            if (!DemoScreen.isDemoPlaying()) {
                Sounds.sndStopMusic();
                Globals.musicvolume = Globals.ud.volume_number;
                Globals.musiclevel = Globals.ud.level_number;
                Sounds.sndPlayMusic(Globals.currentGame.getCON().music_fn[Globals.musicvolume][Globals.musiclevel]);
            }
            Globals.ps[Mmulti.myconnectindex].palette = Main.engine.getPaletteManager().getBasePalette();
            Player.setpal(Globals.ps[Mmulti.myconnectindex]);
            Globals.everyothertime = '\u0000';
            Globals.global_random = 0;
            Globals.ud.last_level = Globals.ud.level_number + 1;
            Screen.changepalette = 1;
            this.game.net.WaitForAllPlayers(0);
            Main.engine.getTimer().reset();
            Screen.palto(0, 0, 0, 0);
            if (!this.game.menu.gShowMenu) {
                Screen.vscrn(Globals.ud.screen_size);
            }
            this.game.getRenderer().clearview(0);
            View.over_shoulder_on = 0;
            Arrays.fill(View.user_quote_time, (short)0);
            this.game.net.predict.reset();
            Premap.clearfrags();
            System.err.println("New level " + entry);
            if ((Globals.uGameFlags & 1) == 1 && this.game.nNetMode == BuildGame.NetMode.Single) {
                LoadSave.gAutosaveRequest = true;
            }
            Globals.uGameFlags &= 0xFFFFFFFC;
            return true;
        }
        catch (Exception e) {
            Console.out.println("Load map exception: " + e);
            if (e.getMessage() != null) {
                this.game.GameMessage("Load map exception:\n" + e.getMessage());
            } else {
                this.game.GameMessage("Can't load the map " + entry);
            }
            return false;
        }
    }

    protected void makeScreenshot() {
        Renderer renderer;
        String filename;
        String name = "scrxxxx.png";
        Entry map = Globals.boardfilename;
        if (Main.mUserFlag == Main.UserFlag.UserMap && map.exists()) {
            name = "scr-" + map.getName() + "-xxxx.png";
        }
        if (Main.mUserFlag != Main.UserFlag.UserMap && Globals.currentGame != null) {
            name = "scr-e" + (Globals.ud.volume_number + 1) + "m" + (Globals.ud.level_number + 1) + "[" + Globals.currentGame.getEpisodeEntry().getFileEntry().getName() + "]-xxxx.png";
        }
        if ((filename = (renderer = this.game.getRenderer()).screencapture(this.game.getUserDirectory(), name)) != null) {
            Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[103], 0, filename, " saved");
        } else {
            Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[103], 0, "Screenshot not saved. Access denied!");
        }
        View.FTA(103, Globals.ps[Mmulti.myconnectindex]);
    }

    public void newgame(boolean isMultiplayer, Object item, int nEpisode, int nLevel, int nDifficulty) {
        Main.gDemoScreen.onStopRecord();
        this.pNet.ready2send = false;
        this.game.changeScreen(this.load);
        this.load.init(() -> {
            String title;
            if (!isMultiplayer) {
                Globals.ud.multimode = 1;
                Globals.mFakeMultiplayer = false;
                if (Mmulti.numplayers > 1) {
                    this.pNet.NetDisconnect(Mmulti.myconnectindex);
                }
                Globals.ud.monsters_off = false;
                Globals.ud.respawn_monsters = false;
                Globals.ud.respawn_items = false;
                Globals.ud.respawn_inventory = false;
                Mmulti.connecthead = 0;
                Mmulti.connectpoint2[0] = -1;
                this.game.nNetMode = BuildGame.NetMode.Single;
            } else {
                if (Globals.mFakeMultiplayer) {
                    Globals.ud.multimode = Globals.nFakePlayers;
                    Mmulti.connecthead = 0;
                    for (int i = 0; i < 16; i = (int)((short)(i + 1))) {
                        Mmulti.connectpoint2[i] = (short)(i + 1);
                    }
                    Mmulti.connectpoint2[Globals.ud.multimode - 1] = -1;
                } else {
                    Globals.ud.multimode = Mmulti.numplayers;
                }
                if (!DemoScreen.isDemoScreen(this)) {
                    Globals.ud.coop = Globals.pNetInfo.nGameType == 1 ? 1 : 0;
                    Globals.ud.monsters_off = Globals.pNetInfo.nMonsters == 1;
                    Globals.ud.respawn_monsters = false;
                    Globals.ud.respawn_inventory = true;
                    Globals.ud.respawn_items = Globals.pNetInfo.nGameType == 0;
                    Globals.ud.marker = Globals.pNetInfo.nMarkers;
                    Globals.ud.ffire = Globals.pNetInfo.nFriendlyFire;
                }
                Globals.ud.god = false;
                this.game.nNetMode = BuildGame.NetMode.Multiplayer;
                short c = Mmulti.connecthead;
                while (c >= 0) {
                    Premap.resetweapons(c);
                    Premap.resetinventory(c);
                    c = Mmulti.connectpoint2[c];
                }
            }
            Main.UserFlag flag = Main.UserFlag.None;
            if (item instanceof GameInfo && !item.equals(Globals.defGame)) {
                flag = Main.UserFlag.Addon;
                GameInfo game = (GameInfo)item;
                ResourceHandler.checkEpisodeResources(game);
                Console.out.println("Start user episode: " + game.title);
            } else {
                ResourceHandler.resetEpisodeResources();
            }
            if (item instanceof Entry) {
                flag = Main.UserFlag.UserMap;
                Globals.boardfilename = (Entry)item;
                Globals.ud.level_number = 7;
                Globals.ud.volume_number = 0;
                Console.out.println("Start user map: " + ((Entry)item).getName());
            }
            Main.mUserFlag = flag;
            if (!DemoScreen.isDemoScreen(this)) {
                if (!isMultiplayer) {
                    Source skillvoice = null;
                    switch (nDifficulty) {
                        case 0: {
                            skillvoice = Sounds.sound(227);
                            break;
                        }
                        case 1: {
                            skillvoice = Sounds.sound(195);
                            break;
                        }
                        case 2: {
                            skillvoice = Sounds.sound(107);
                            break;
                        }
                        case 3: {
                            skillvoice = Sounds.sound(226);
                        }
                    }
                    long startTime = System.currentTimeMillis();
                    while (skillvoice != null && skillvoice.isActive() && System.currentTimeMillis() - startTime <= 2000L) {
                    }
                }
                if (Main.mUserFlag != Main.UserFlag.UserMap) {
                    Globals.ud.level_number = nLevel;
                    Globals.ud.volume_number = nEpisode;
                }
                Globals.ud.player_skill = nDifficulty + 1;
                Globals.ud.respawn_monsters = Globals.ud.player_skill == 4;
            }
            Globals.uGameFlags = 0;
            Globals.ud.secretlevel = 0;
            Globals.ud.from_bonus = 0;
            Globals.ud.last_level = -1;
            LoadSave.lastload = null;
            if (!isMultiplayer) {
                PlayerStruct p = Globals.ps[Mmulti.myconnectindex];
                if (Globals.ud.coop != 1) {
                    p.curr_weapon = 1;
                    p.gotweapon[1] = true;
                    p.gotweapon[0] = true;
                    p.ammo_amount[1] = 48;
                    p.gotweapon[10] = true;
                    p.last_weapon = (short)-1;
                }
                p.last_used_weapon = 0;
            }
            Globals.display_mirror = '\u0000';
            View.zoom = (short)768;
            if (flag == Main.UserFlag.Addon && nEpisode != 3 && this.game.nNetMode == BuildGame.NetMode.Single && !DemoScreen.isDemoScreen(this) && nLevel == 0) {
                Entry currentAnm = this.game.getCache().getEntry("logo.anm", false);
                Entry defAnm = this.game.getCache().getEntry("logo.anm", true);
                if (currentAnm.exists() && defAnm.exists() && currentAnm.getChecksum() != defAnm.getChecksum() && this.game.nNetMode == BuildGame.NetMode.Single && Main.gAnmScreen.init("logo.anm", 5)) {
                    this.game.changeScreen(Main.gAnmScreen.setCallback(() -> this.enterlevel(this.getTitle(), Globals.ud.volume_number, Globals.ud.level_number)).escSkipping(true));
                    return;
                }
            }
            if (!this.checkCutscene(title = this.getTitle())) {
                this.enterlevel(title, Globals.ud.volume_number, Globals.ud.level_number);
            }
        });
    }

    public boolean enterlevel(String title, int vol, int lev) {
        if (title == null) {
            return false;
        }
        if (Main.mUserFlag != Main.UserFlag.UserMap) {
            Globals.boardfilename = this.game.getCache().getEntry(Globals.currentGame.episodes[vol].getMapInfo(lev).getPath(), true);
        }
        this.loadboard(Globals.boardfilename, null).setTitle(title);
        return true;
    }

    private boolean checkCutscene(String loadTitle) {
        if (this.game.nNetMode != BuildGame.NetMode.Single || Main.mUserFlag == Main.UserFlag.UserMap || Globals.ud.level_number != 0 || Globals.ud.volume_number != 3 || Globals.ud.lockout != 0 || DemoScreen.isDemoScreen(this)) {
            return false;
        }
        if (Main.gAnmScreen.init("vol41a.anm", 6)) {
            Sounds.sndPlayMusic(Globals.currentGame.getCON().env_music_fn[1]);
            Main.gAnmScreen.setCallback(() -> this.enterlevel(loadTitle, Globals.ud.volume_number, Globals.ud.level_number)).escSkipping(true);
            this.game.changeScreen(Main.gAnmScreen.escSkipping(true));
            return true;
        }
        return false;
    }

    public String getTitle() {
        String title = "null";
        if (Main.mUserFlag != Main.UserFlag.UserMap) {
            if (Globals.ud.volume_number < 5 && Globals.currentGame.episodes[Globals.ud.volume_number].getMapInfo(Globals.ud.level_number) != null) {
                title = Globals.currentGame.episodes[Globals.ud.volume_number].getMapTitle(Globals.ud.level_number);
            }
        } else {
            Entry file = Globals.boardfilename;
            if (file.exists()) {
                title = file.getName();
            }
        }
        return title;
    }

    public void cheatkeys(int snum) {
        int sb_snum = Globals.sync[snum].bits;
        PlayerStruct p = Globals.ps[snum];
        if (p.cheat_phase == 1) {
            return;
        }
        int aim = p.aim_mode;
        p.aim_mode = sb_snum >> 23 & 1;
        if (!(p.aim_mode >= aim || this.game.nNetMode == BuildGame.NetMode.Single && this.pMenu.gShowMenu)) {
            p.return_to_center = (short)9;
        }
        if ((sb_snum & 0x400000) != 0 && p.quick_kick == 0 && (p.curr_weapon != 0 || p.kickback_pic == 0)) {
            p.quick_kick = (short)14;
            View.FTA(80, p);
        }
        if ((sb_snum & 0xFB799F00) == 0) {
            p.interface_toggle_flag = 0;
        } else if (p.interface_toggle_flag == 0 && (sb_snum & 0x20000) == 0) {
            int j;
            int i;
            int k;
            p.interface_toggle_flag = 1;
            if ((sb_snum & 0x200000) != 0) {
                this.game.gPaused = !this.game.gPaused;
                this.sndHandlePause(this.game.gPaused);
            }
            if (this.game.gPaused) {
                return;
            }
            Sprite psp = Main.boardService.getSprite(p.i);
            if (psp == null || psp.getExtra() <= 0) {
                return;
            }
            if ((sb_snum & 0x40000000) != 0 && p.newowner == -1) {
                switch (p.inven_icon) {
                    case 4: {
                        sb_snum |= 0x2000000;
                        break;
                    }
                    case 3: {
                        sb_snum |= 0x1000000;
                        break;
                    }
                    case 5: {
                        sb_snum |= 0x8000;
                        break;
                    }
                    case 1: {
                        sb_snum |= 0x10000;
                        break;
                    }
                    case 2: {
                        sb_snum |= 0x1000;
                    }
                }
            }
            if ((sb_snum & 0x8000) != 0 && p.heat_amount > 0) {
                p.heat_on = (short)(p.heat_on ^ 1);
                Player.setpal(p);
                p.inven_icon = 5;
                Sounds.spritesound(213, p.i);
                View.FTA(106 + (p.heat_on == 0 ? 1 : 0), p);
            }
            if ((sb_snum & 0x1000) != 0) {
                if (p.steroids_amount == 400) {
                    p.steroids_amount = (short)(p.steroids_amount - 1);
                    Sounds.spritesound(217, p.i);
                    p.inven_icon = 2;
                    View.FTA(12, p);
                }
                return;
            }
            if (p.newowner == -1 && ((sb_snum & 0x100000) != 0 || (sb_snum & 0x8000000) != 0 || p.refresh_inventory)) {
                boolean CHECKINV;
                p.invdisptime = 52;
                k = 0;
                if ((sb_snum & 0x8000000) != 0) {
                    k = 1;
                }
                if (p.refresh_inventory) {
                    p.refresh_inventory = false;
                }
                int dainv = p.inven_icon;
                i = 0;
                do {
                    CHECKINV = false;
                    if (i < 9) {
                        ++i;
                        switch (dainv) {
                            case 4: {
                                if (p.jetpack_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 5 : 3;
                                CHECKINV = true;
                                break;
                            }
                            case 6: {
                                if (p.scuba_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 7 : 5;
                                CHECKINV = true;
                                break;
                            }
                            case 2: {
                                if (p.steroids_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 3 : 1;
                                CHECKINV = true;
                                break;
                            }
                            case 3: {
                                if (p.holoduke_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 4 : 2;
                                CHECKINV = true;
                                break;
                            }
                            case 0: 
                            case 1: {
                                if (p.firstaid_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 2 : 7;
                                CHECKINV = true;
                                break;
                            }
                            case 5: {
                                if (p.heat_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 6 : 4;
                                CHECKINV = true;
                                break;
                            }
                            case 7: {
                                if (p.boot_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 1 : 6;
                                CHECKINV = true;
                            }
                        }
                    } else {
                        dainv = 0;
                    }
                    p.inven_icon = dainv;
                } while (CHECKINV);
                switch (dainv) {
                    case 1: {
                        View.FTA(3, p);
                        break;
                    }
                    case 2: {
                        View.FTA(90, p);
                        break;
                    }
                    case 3: {
                        View.FTA(91, p);
                        break;
                    }
                    case 4: {
                        View.FTA(88, p);
                        break;
                    }
                    case 5: {
                        View.FTA(101, p);
                        break;
                    }
                    case 6: {
                        View.FTA(89, p);
                        break;
                    }
                    case 7: {
                        View.FTA(6, p);
                    }
                }
            }
            if ((j = ((sb_snum & 0xF00) >> 8) - 1) > 0 && p.kickback_pic > 0 && this.IsOriginalGame()) {
                p.wantweaponfire = (short)j;
            }
            if (p.last_pissed_time <= 5668 && p.show_empty_weapon == 0 && p.kickback_pic == 0 && p.quick_kick == 0 && psp.getXrepeat() > 32 && p.access_incs == 0 && p.knee_incs == 0) {
                if (!this.IsOriginalGame() || p.weapon_pos == 0 || p.holster_weapon != 0 && p.weapon_pos == -9) {
                    if (j == 12) {
                        j = p.curr_weapon;
                        if (p.last_used_weapon == 0) {
                            j = p.last_used_weapon;
                        } else if (p.gotweapon[p.last_used_weapon] && p.ammo_amount[p.last_used_weapon] > 0) {
                            j = p.last_used_weapon;
                        }
                    }
                    if (j == 10 || j == 11) {
                        k = p.curr_weapon;
                        j = j == 10 ? -1 : 1;
                        i = 0;
                        while (k >= 0 && k < 10 || Globals.currentGame.getCON().PLUTOPAK && k == 11 && (p.subweapon & 0x800) != 0 || Globals.currentGame.getCON().type == 20 && k == 12 && (p.subweapon & 0x1000) != 0) {
                            switch (k) {
                                case 12: {
                                    if (j == -1) {
                                        k = 8;
                                        break;
                                    }
                                    k = 1;
                                    break;
                                }
                                case 11: {
                                    if (j == -1) {
                                        k = 5;
                                        break;
                                    }
                                    k = 7;
                                    break;
                                }
                                default: {
                                    if ((k += j) == 6 && (p.subweapon & 0x800) != 0) {
                                        k = 11;
                                    }
                                    if (k != 9 || (p.subweapon & 0x1000) == 0) break;
                                    k = 12;
                                }
                            }
                            if (k == -1) {
                                k = 9;
                            } else if (k == 10) {
                                k = 0;
                            }
                            if (p.gotweapon[k] && p.ammo_amount[k] > 0) {
                                if (Globals.currentGame.getCON().PLUTOPAK && k == 6 && (p.subweapon & 0x800) != 0) {
                                    k = 11;
                                }
                                if (Globals.currentGame.getCON().type == 20 && k == 9 && (p.subweapon & 0x1000) != 0) {
                                    k = 12;
                                }
                                j = k;
                                break;
                            }
                            if (Globals.currentGame.getCON().PLUTOPAK && k == 11 && p.ammo_amount[11] == 0 && p.gotweapon[6] && p.ammo_amount[6] > 0) {
                                j = 6;
                                p.subweapon &= 0xFFFFF7FF;
                                break;
                            }
                            if (Globals.currentGame.getCON().PLUTOPAK && k == 6 && p.ammo_amount[6] == 0 && p.gotweapon[11] && p.ammo_amount[11] > 0) {
                                j = 11;
                                p.subweapon |= 0x800;
                                break;
                            }
                            if (Globals.currentGame.getCON().type == 20 && k == 12 && p.ammo_amount[12] == 0 && p.gotweapon[9] && p.ammo_amount[9] > 0) {
                                j = 9;
                                p.subweapon &= 0xFFFFEFFF;
                                break;
                            }
                            if (Globals.currentGame.getCON().type == 20 && k == 9 && p.ammo_amount[9] == 0 && p.gotweapon[12] && p.ammo_amount[12] > 0) {
                                j = 12;
                                p.subweapon |= 0x1000;
                                break;
                            }
                            if (++i != 10) continue;
                            Weapons.addweapon(p, 0);
                            break;
                        }
                    }
                    k = -1;
                    if (j == 5 && p.ammo_amount[5] == 0) {
                        for (ListNode<Sprite> node = Main.boardService.getStatNode(1); node != null; node = node.getNext()) {
                            Sprite sp = node.get();
                            k = node.getIndex();
                            if (sp.getPicnum() != 26 || sp.getOwner() != p.i) continue;
                            p.gotweapon[5] = true;
                            j = 10;
                            break;
                        }
                    }
                    if (j == 9 && Globals.currentGame.getCON().type == 20) {
                        if (p.curr_weapon != 12 && p.curr_weapon != 9) {
                            if (p.ammo_amount[12] > 0) {
                                if ((p.subweapon & 0x1000) == 4096) {
                                    j = 12;
                                } else if (p.ammo_amount[9] == 0) {
                                    j = 12;
                                    p.subweapon |= 0x1000;
                                }
                            } else if (p.ammo_amount[9] > 0) {
                                p.subweapon &= 0xFFFFEFFF;
                            }
                        } else if (p.curr_weapon == 9) {
                            p.subweapon |= 0x1000;
                            j = 12;
                        } else {
                            p.subweapon &= 0xFFFFEFFF;
                        }
                    } else if (j == 6 && Globals.currentGame.getCON().PLUTOPAK) {
                        if (p.curr_weapon != 11 && p.curr_weapon != 6) {
                            if (p.ammo_amount[11] > 0) {
                                if ((p.subweapon & 0x800) == 2048) {
                                    j = 11;
                                } else if (p.ammo_amount[6] == 0) {
                                    j = 11;
                                    p.subweapon |= 0x800;
                                }
                            } else if (p.ammo_amount[6] > 0) {
                                p.subweapon &= 0xFFFFF7FF;
                            }
                        } else if (p.curr_weapon == 6) {
                            p.subweapon |= 0x800;
                            j = 11;
                        } else {
                            p.subweapon &= 0xFFFFF7FF;
                        }
                    }
                    if (p.holster_weapon != 0) {
                        sb_snum |= 0x80000;
                        p.weapon_pos = (short)-9;
                    } else if (j >= 0 && j < 13 && p.gotweapon[j] && p.curr_weapon != j) {
                        switch (j) {
                            case 0: {
                                Weapons.addweapon(p, 0);
                                break;
                            }
                            case 1: {
                                if (p.ammo_amount[1] == 0 && p.show_empty_weapon == 0) {
                                    p.last_full_weapon = p.curr_weapon;
                                    p.show_empty_weapon = (short)32;
                                }
                                Weapons.addweapon(p, 1);
                                break;
                            }
                            case 2: {
                                if (p.ammo_amount[2] == 0 && p.show_empty_weapon == 0) {
                                    p.last_full_weapon = p.curr_weapon;
                                    p.show_empty_weapon = (short)32;
                                }
                                Weapons.addweapon(p, 2);
                                break;
                            }
                            case 3: {
                                if (p.ammo_amount[3] == 0 && p.show_empty_weapon == 0) {
                                    p.last_full_weapon = p.curr_weapon;
                                    p.show_empty_weapon = (short)32;
                                }
                                Weapons.addweapon(p, 3);
                                break;
                            }
                            case 4: {
                                if (p.ammo_amount[4] == 0 && p.show_empty_weapon == 0) {
                                    p.last_full_weapon = p.curr_weapon;
                                    p.show_empty_weapon = (short)32;
                                }
                                Weapons.addweapon(p, 4);
                                break;
                            }
                            case 7: {
                                if (p.ammo_amount[7] == 0 && p.show_empty_weapon == 0) {
                                    p.last_full_weapon = p.curr_weapon;
                                    p.show_empty_weapon = (short)32;
                                }
                                Weapons.addweapon(p, 7);
                                break;
                            }
                            case 9: 
                            case 12: {
                                if (p.ammo_amount[j] == 0 && p.show_empty_weapon == 0) {
                                    p.last_full_weapon = p.curr_weapon;
                                    p.show_empty_weapon = (short)32;
                                }
                                Weapons.addweapon(p, j);
                                break;
                            }
                            case 6: 
                            case 11: {
                                if (p.ammo_amount[j] == 0 && p.show_empty_weapon == 0) {
                                    p.show_empty_weapon = (short)32;
                                    p.last_full_weapon = p.curr_weapon;
                                }
                                Weapons.addweapon(p, j);
                                break;
                            }
                            case 10: {
                                if (k < 0) break;
                                p.curr_weapon = (short)10;
                                p.last_weapon = (short)-1;
                                p.weapon_pos = (short)10;
                                break;
                            }
                            case 5: {
                                if (p.ammo_amount[5] <= 0) break;
                                Weapons.addweapon(p, 5);
                                break;
                            }
                            case 8: {
                                if (p.ammo_amount[8] <= 0 || !p.gotweapon[8]) break;
                                Weapons.addweapon(p, 8);
                            }
                        }
                    }
                }
                if ((sb_snum & 0x80000) != 0 && p.curr_weapon > 0) {
                    if (p.holster_weapon == 0 && p.weapon_pos == 0) {
                        p.holster_weapon = 1;
                        p.weapon_pos = (short)-1;
                        View.FTA(73, p);
                    } else if (p.holster_weapon == 1 && p.weapon_pos == -9) {
                        p.holster_weapon = 0;
                        p.weapon_pos = (short)10;
                        View.FTA(74, p);
                    }
                }
            }
            if ((sb_snum & 0x1000000) != 0 && p.newowner == -1) {
                if (p.holoduke_on == -1) {
                    if (p.holoduke_amount > 0) {
                        p.inven_icon = 3;
                        int i2 = Spawn.EGS(p.cursectnum, p.posx, p.posy, p.posz + 7680, 1405, -64, 0, 0, (short)p.ang, 0, 0, -1, 10);
                        Sprite holoduke = Main.boardService.getSprite(i2);
                        if (holoduke != null) {
                            p.holoduke_on = (short)i2;
                            Globals.hittype[i2].temp_data[4] = 0;
                            Globals.hittype[i2].temp_data[3] = 0;
                            holoduke.setYvel((short)snum);
                            holoduke.setExtra(0);
                            View.FTA(47, p);
                            Sounds.spritesound(70, p.holoduke_on);
                        }
                    } else {
                        View.FTA(49, p);
                    }
                } else {
                    Sounds.spritesound(70, p.holoduke_on);
                    p.holoduke_on = (short)-1;
                    View.FTA(48, p);
                }
            }
            if ((sb_snum & 0x10000) != 0 && p.firstaid_amount > 0 && psp.getExtra() < Globals.currentGame.getCON().max_player_health) {
                j = Globals.currentGame.getCON().max_player_health - psp.getExtra();
                if (p.firstaid_amount > j) {
                    p.firstaid_amount = (short)(p.firstaid_amount - (short)j);
                    psp.setExtra((short)Globals.currentGame.getCON().max_player_health);
                    p.inven_icon = 1;
                } else {
                    psp.setExtra(psp.getExtra() + p.firstaid_amount);
                    p.firstaid_amount = 0;
                    Player.checkavailinven(p);
                }
                Sounds.spritesound(216, p.i);
            }
            if ((sb_snum & 0x2000000) != 0 && p.newowner == -1) {
                if (p.jetpack_amount > 0) {
                    int n = p.jetpack_on = p.jetpack_on != 0 ? 0 : 1;
                    if (p.jetpack_on != 0) {
                        p.inven_icon = 4;
                        if (p.scream_voice != null) {
                            p.scream_voice.stop();
                            p.scream_voice = null;
                        }
                        Sounds.spritesound(49, p.i);
                        View.FTA(52, p);
                    } else {
                        p.hard_landing = 0;
                        p.poszv = 0;
                        Sounds.spritesound(51, p.i);
                        Sounds.stopsound(50, p.i);
                        Sounds.stopsound(49, p.i);
                        View.FTA(53, p);
                    }
                } else {
                    View.FTA(50, p);
                }
            }
            if ((sb_snum & 0x10000000) != 0 && p.one_eighty_count == 0) {
                p.one_eighty_count = (short)-1024;
            }
        }
    }

    public boolean IsOriginalGame() {
        return Main.gDemoScreen.isDemoRecording() && Globals.ud.rec != null && Globals.ud.rec.recversion <= 127;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 59) {
            this.shiftPressed = true;
            return true;
        }
        if (keycode == 129) {
            this.ctrlPressed = true;
            return true;
        }
        if (this.shiftPressed || this.ctrlPressed) {
            int i;
            int fkey = -1;
            for (i = 0; i < 10; ++i) {
                if (keycode != i + 131) continue;
                fkey = i;
                break;
            }
            if (this.shiftPressed && fkey == 4 && View.fta > 0 && View.ftq == 26) {
                int music_select = 11 * Globals.musicvolume + Globals.musiclevel;
                if (++music_select >= 44) {
                    music_select = 0;
                }
                Globals.musicvolume = music_select / 11;
                Globals.musiclevel = music_select % 11;
                Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[26], 0, "PLAYING ", Globals.currentGame.getCON().music_fn[Globals.musicvolume][Globals.musiclevel]);
                Sounds.sndPlayMusic(Globals.currentGame.getCON().music_fn[Globals.musicvolume][Globals.musiclevel]);
                View.FTA(26, Globals.ps[Mmulti.myconnectindex]);
                return true;
            }
            if (!Main.cfg.isNoSound() && Main.RTS_File != null && Main.RTS_File.getSize() > 0 && Sounds.rtsplaying == '\u0000') {
                Objects.requireNonNull(Main.cfg);
                if (fkey >= 0) {
                    SoundData data;
                    Entry entry;
                    if (this.ctrlPressed && (entry = Main.RTS_File.getEntry(fkey)).exists() && (data = Sounds.audio.getSoundDecoder("VOC").decode(entry)) != null) {
                        Source voice = Sounds.newSound(data.getData(), data.getRate(), data.getBits(), 255);
                        if (voice != null) {
                            voice.play(1.0f);
                        }
                        Sounds.rtsplaying = (char)7;
                        if (Globals.ud.multimode > 1) {
                            Globals.tempbuf[0] = 5;
                            Globals.tempbuf[1] = (byte)fkey;
                            this.game.net.sendtoall(Globals.tempbuf, 2);
                        }
                    }
                    if (this.shiftPressed) {
                        View.adduserquote(Globals.ud.ridecule[fkey]);
                        if (Globals.ud.multimode > 1) {
                            Globals.tempbuf[0] = 4;
                            Globals.tempbuf[1] = -1;
                            Globals.tempbuf[2] = 0;
                            for (i = 0; i < Globals.ud.ridecule[fkey].length; ++i) {
                                Globals.tempbuf[2 + i] = (byte)Globals.ud.ridecule[fkey][i];
                            }
                            this.game.net.sendtoall(Globals.tempbuf, 2 + Globals.ud.ridecule[fkey].length);
                        }
                    }
                    return true;
                }
            }
        }
        if (keycode == 135 && !Main.cfg.isMuteMusic()) {
            Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[26], 0, Globals.currentGame.getCON().music_fn[Globals.musicvolume][Globals.musiclevel], ".  USE SHIFT-F5 TO CHANGE.");
            View.FTA(26, Globals.ps[Mmulti.myconnectindex]);
        }
        return super.keyDown(keycode);
    }

    @Override
    public boolean keyUp(int keycode) {
        if (keycode == 59) {
            this.shiftPressed = false;
            return true;
        }
        if (keycode == 129) {
            this.ctrlPressed = false;
            return true;
        }
        return super.keyUp(keycode);
    }
}

