/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.filehandle;

import java.io.InputStream;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Duke3D.Input;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Types.GameInfo;
import ru.m210projects.Duke3D.Types.SafeLoader;
import ru.m210projects.Duke3D.filehandle.LZWInputStream;

public class DemoFile {
    public int rcnt = 0;
    public Input[][] recsync;
    public int reccnt;
    public int version;
    public int volume_number;
    public int level_number;
    public int player_skill;
    public int coop;
    public int ffire;
    public int multimode;
    public boolean monsters_off;
    public boolean respawn_monsters;
    public boolean respawn_items;
    public boolean respawn_inventory;
    public int playerai;
    public final String[] user_name = new String[16];
    public int auto_run;
    public String boardfilename;
    public final int[] aim_mode = new int[16];
    public final int[] auto_aim = new int[16];
    public int[] armor;
    public int[] health;
    public boolean[][] gotweapon;
    public int[][] ammo_amount;
    public int[] firstaid_amount;
    public int[] steroids_amount;
    public int[] holoduke_amount;
    public int[] jetpack_amount;
    public int[] heat_amount;
    public int[] scuba_amount;
    public int[] boot_amount;
    public int[] inven_icon;
    public GameInfo addon;

    public DemoFile(InputStream is) throws Exception {
        String name;
        this.reccnt = StreamUtils.readInt(is);
        this.version = StreamUtils.readUnsignedByte(is);
        if (this.version != 116 && this.version != 117 && this.version != 127 && this.version != 147) {
            throw new Exception("Wrong version!");
        }
        if (this.reccnt == 0) {
            throw new Exception("reccnt == 0");
        }
        this.volume_number = StreamUtils.readUnsignedByte(is);
        this.level_number = StreamUtils.readUnsignedByte(is);
        this.player_skill = StreamUtils.readUnsignedByte(is);
        this.coop = StreamUtils.readUnsignedByte(is);
        this.ffire = StreamUtils.readUnsignedByte(is);
        this.multimode = StreamUtils.readShort(is);
        this.monsters_off = StreamUtils.readShort(is) == 1;
        this.respawn_monsters = StreamUtils.readInt(is) == 1;
        this.respawn_items = StreamUtils.readInt(is) == 1;
        this.respawn_inventory = StreamUtils.readInt(is) == 1;
        this.playerai = StreamUtils.readInt(is);
        for (int i = 0; i < 16; ++i) {
            this.user_name[i] = StreamUtils.readString(is, 32);
        }
        this.auto_run = StreamUtils.readInt(is);
        int MAX_PATH = 128;
        if (this.version >= 127) {
            MAX_PATH = 260;
        }
        if (!(name = FileUtils.getCorrectPath(StreamUtils.readString(is, MAX_PATH))).isEmpty() && Main.game.getCache().getEntry(name, true).exists()) {
            this.boardfilename = name;
            this.level_number = 7;
            this.volume_number = 0;
        }
        if (this.version == 147) {
            boolean isPacked = StreamUtils.readBoolean(is);
            String addonFileName = StreamUtils.readDataString(is).toLowerCase();
            String addonPackedConName = null;
            if (isPacked) {
                addonPackedConName = StreamUtils.readDataString(is).toLowerCase();
            }
            this.addon = SafeLoader.findAddon(addonFileName, addonPackedConName);
            this.armor = new int[this.multimode];
            this.health = new int[this.multimode];
            this.gotweapon = new boolean[this.multimode][13];
            this.ammo_amount = new int[this.multimode][13];
            this.firstaid_amount = new int[this.multimode];
            this.steroids_amount = new int[this.multimode];
            this.holoduke_amount = new int[this.multimode];
            this.jetpack_amount = new int[this.multimode];
            this.heat_amount = new int[this.multimode];
            this.scuba_amount = new int[this.multimode];
            this.boot_amount = new int[this.multimode];
            this.inven_icon = new int[this.multimode];
            for (int i = 0; i < this.multimode; ++i) {
                this.armor[i] = StreamUtils.readInt(is);
                this.health[i] = StreamUtils.readInt(is);
                for (int j = 0; j < 13; ++j) {
                    this.gotweapon[i][j] = StreamUtils.readBoolean(is);
                    this.ammo_amount[i][j] = StreamUtils.readInt(is);
                }
                this.firstaid_amount[i] = StreamUtils.readInt(is);
                this.steroids_amount[i] = StreamUtils.readInt(is);
                this.holoduke_amount[i] = StreamUtils.readInt(is);
                this.jetpack_amount[i] = StreamUtils.readInt(is);
                this.heat_amount[i] = StreamUtils.readInt(is);
                this.scuba_amount[i] = StreamUtils.readInt(is);
                this.boot_amount[i] = StreamUtils.readInt(is);
                this.inven_icon[i] = StreamUtils.readInt(is);
            }
        }
        for (int i = 0; i < this.multimode; ++i) {
            this.aim_mode[i] = StreamUtils.readUnsignedByte(is);
            if (this.version < 127) continue;
            this.auto_aim[i] = StreamUtils.readUnsignedByte(is);
        }
        this.recsync = new Input[this.reccnt][16];
        LZWInputStream lis = new LZWInputStream(is, Input.sizeof(this.version) * this.multimode);
        for (int c = 0; c < this.reccnt; ++c) {
            for (int i = 0; i < this.multimode; ++i) {
                this.recsync[c][i] = new Input().readObject(lis, this.version);
            }
        }
    }
}

