/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.settings.ConfigContext;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Build.settings.InputContext;
import ru.m210projects.Build.settings.Properties;

public class Config
extends GameConfig {
    public static final int[] defclassickeys = new int[]{19, 20, 21, 22, 67, 57, 55, 56, 29, 54, 59, 62, 129, 75, 74, 92, 93, 61, 70, 69, 0, 49, 111, 68, 8, 9, 10, 0, 34, 37, 115, 139, 136, 132, 133, 134, 135, 140, 141, 0, 142};
    public static final int[] defkeys = new int[]{51, 47, 21, 22, 67, 57, 29, 32, 62, 129, 59, 33, 0, 75, 74, 92, 93, 61, 70, 69, 0, 49, 111, 68, 8, 9, 10, 45, 34, 37, 115, 139, 136, 132, 133, 134, 135, 140, 141, 0, 142};
    public boolean gAutoRun = false;
    public int gOverlayMap = 2;
    public boolean gShowMessages = true;
    public boolean gCrosshair = true;
    public int gCrossSize = 65536;
    public int gShowStat = 0;
    public int gHUDSize = 65536;
    public int showMapInfo = 1;
    public boolean bHeadBob = true;
    public boolean bShowExit = false;
    public boolean bOriginal = false;
    public int gDemoSeq = 1;

    public Config(Path path) {
        super(path);
    }

    public GameKey[] getKeyMap() {
        return new GameKey[]{GameKeys.Move_Forward, GameKeys.Move_Backward, GameKeys.Turn_Left, GameKeys.Turn_Right, GameKeys.Turn_Around, GameKeys.Strafe, GameKeys.Strafe_Left, GameKeys.Strafe_Right, GameKeys.Jump, GameKeys.Crouch, LSPKeys.Crouch_toggle, GameKeys.Open, GameKeys.Weapon_Fire, GameKeys.Menu_Toggle, LSPKeys.Weapon_1, LSPKeys.Weapon_2, LSPKeys.Weapon_3, GameKeys.Previous_Weapon, GameKeys.Next_Weapon, LSPKeys.Last_Used_Weapon, GameKeys.Look_Up, GameKeys.Look_Down, GameKeys.Mouse_Aiming, GameKeys.Run, LSPKeys.AutoRun, GameKeys.Map_Toggle, GameKeys.Enlarge_Screen, GameKeys.Shrink_Screen, GameKeys.Show_Console, LSPKeys.Map_Follow_Mode, LSPKeys.Toggle_Crosshair, LSPKeys.Quickload, LSPKeys.Quicksave, LSPKeys.Show_Savemenu, LSPKeys.Show_Loadmenu, LSPKeys.Show_Sounds, LSPKeys.Show_Options, LSPKeys.Quit, LSPKeys.Gamma, LSPKeys.Make_Screenshot};
    }

    @Override
    protected InputContext createDefaultInputContext() {
        return new InputContext(this.getKeyMap(), defkeys, defclassickeys);
    }

    @Override
    protected ConfigContext createDefaultGameContext() {
        return new ConfigContext(){

            @Override
            public void load(Properties prop) {
                if (prop.setContext("Options")) {
                    Config.this.gAutoRun = prop.getBooleanValue("AutoRun", Config.this.gAutoRun);
                    Config.this.gOverlayMap = prop.getIntValue("OverlayMap", Config.this.gOverlayMap);
                    Config.this.gShowMessages = prop.getBooleanValue("ShowMessages", Config.this.gShowMessages);
                    Config.this.gCrosshair = prop.getBooleanValue("Crosshair", Config.this.gCrosshair);
                    Config.this.gCrossSize = Math.max(16384, prop.getIntValue("CrossSize", Config.this.gCrossSize));
                    Config.this.gShowStat = prop.getIntValue("ShowStat", Config.this.gShowStat);
                    Config.this.gHUDSize = Math.max(16384, prop.getIntValue("HUDSize", Config.this.gHUDSize));
                    Config.this.showMapInfo = prop.getIntValue("showMapInfo", Config.this.showMapInfo);
                    Config.this.bHeadBob = prop.getBooleanValue("HeadBob", Config.this.bHeadBob);
                    Config.this.bOriginal = prop.getBooleanValue("ProjectileSpam", Config.this.bOriginal);
                    Config.this.bShowExit = prop.getBooleanValue("ShowExits", Config.this.bShowExit);
                    Config.this.gDemoSeq = prop.getIntValue("DemoSequence", Config.this.gDemoSeq);
                }
            }

            @Override
            public void save(OutputStream os) throws IOException {
                this.putString(os, "[Options]\r\n");
                this.putBoolean(os, "AutoRun", Config.this.gAutoRun);
                this.putInteger(os, "OverlayMap", Config.this.gOverlayMap);
                this.putBoolean(os, "ShowMessages", Config.this.gShowMessages);
                this.putBoolean(os, "Crosshair", Config.this.gCrosshair);
                this.putInteger(os, "CrossSize", Config.this.gCrossSize);
                this.putInteger(os, "ShowStat", Config.this.gShowStat);
                this.putInteger(os, "HUDSize", Config.this.gHUDSize);
                this.putInteger(os, "showMapInfo", Config.this.showMapInfo);
                this.putBoolean(os, "HeadBob", Config.this.bHeadBob);
                this.putBoolean(os, "ProjectileSpam", Config.this.bOriginal);
                this.putBoolean(os, "ShowExits", Config.this.bShowExit);
                this.putInteger(os, "DemoSequence", Config.this.gDemoSeq);
            }
        };
    }

    public static enum LSPKeys implements GameKey
    {
        Weapon_1,
        Weapon_2,
        Weapon_3,
        Last_Used_Weapon,
        Map_Follow_Mode,
        Toggle_Crosshair,
        AutoRun,
        Quickload,
        Quicksave,
        Show_Savemenu,
        Show_Loadmenu,
        Show_Sounds,
        Show_Options,
        Quit,
        Gamma,
        Crouch_toggle,
        Make_Screenshot;


        @Override
        public int getNum() {
            return GameKeys.values().length + this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

