/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Factory;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.SpriteMap;
import ru.m210projects.Build.Types.collections.ValueSetter;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.LSP.Factory.SectorVer4;
import ru.m210projects.LSP.Factory.SpriteVer4;
import ru.m210projects.LSP.Factory.WallVer4;

public class LSPBoardService
extends BoardService {
    public LSPBoardService() {
        this.registerBoard(4, SectorVer4.class, WallVer4.class, SpriteVer4.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Board loadBoard(Entry entry) throws IOException {
        try (InputStream is = entry.getInputStream();){
            int i;
            int version = StreamUtils.readInt(is);
            if (version != 4) {
                is.close();
                Board board2 = super.loadBoard(entry);
                return board2;
            }
            BuildPos startPos = new BuildPos(StreamUtils.readInt(is), StreamUtils.readInt(is), StreamUtils.readInt(is), StreamUtils.readShort(is), StreamUtils.readShort(is));
            ArrayList<Sprite> sprites = new ArrayList<Sprite>();
            Constructor sectorConstructor = ((Class)this.versionToSectorClass.get(version)).getConstructor(new Class[0]);
            Constructor wallConstructor = ((Class)this.versionToWallClass.get(version)).getConstructor(new Class[0]);
            Constructor spriteConstructor = ((Class)this.versionToSpriteClass.get(version)).getConstructor(new Class[0]);
            short numSectors = StreamUtils.readShort(is);
            short numWalls = StreamUtils.readShort(is);
            int numSprites = StreamUtils.readShort(is);
            Sector[] sectors = new Sector[numSectors];
            for (int i2 = 0; i2 < sectors.length; ++i2) {
                sectors[i2] = ((Sector)sectorConstructor.newInstance(new Object[0])).readObject(is);
            }
            Wall[] walls = new Wall[numWalls];
            for (i = 0; i < walls.length; ++i) {
                walls[i] = ((Wall)wallConstructor.newInstance(new Object[0])).readObject(is);
            }
            for (i = 0; i < numSprites; ++i) {
                sprites.add(((Sprite)spriteConstructor.newInstance(new Object[0])).readObject(is));
            }
            Board board = new Board(startPos, sectors, walls, sprites);
            return board;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void initSpriteLists(Board board) {
        List<Sprite> sprites = board.getSprites();
        this.spriteStatMap = this.createSpriteMap(1024, sprites, Engine.MAXSPRITES, Sprite::setStatnum);
        this.spriteSectMap = this.createSpriteMap(Engine.MAXSECTORS, sprites, Engine.MAXSPRITES, Sprite::setSectnum);
    }

    @Override
    protected SpriteMap createSpriteMap(int listCount, List<Sprite> spriteList, int spriteCount, ValueSetter<Sprite> valueSetter) {
        return new SpriteMap(listCount, spriteList, spriteCount, valueSetter){

            @Override
            protected Sprite getInstance() {
                return new SpriteVer4();
            }
        };
    }
}

