/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Factory;

import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Tables;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TileManager;
import ru.m210projects.LSP.Factory.LSPBoardService;
import ru.m210projects.LSP.Factory.LSPPaletteManager;
import ru.m210projects.LSP.Factory.LSPTables;
import ru.m210projects.LSP.Factory.LSPTileManager;
import ru.m210projects.LSP.Main;

public class LSPEngine
extends Engine {
    public static String randomStack = "";

    public LSPEngine(BuildGame game) throws Exception {
        super(game);
        this.inittimer(game.pCfg.isLegacyTimer(), 120, 4);
    }

    @Override
    public int krand() {
        return super.krand();
    }

    @Override
    protected TileManager loadTileManager() {
        return new LSPTileManager();
    }

    @Override
    public LSPTileManager getTileManager() {
        return (LSPTileManager)super.getTileManager();
    }

    @Override
    public PaletteManager loadpalette() throws Exception {
        LSPPaletteManager paletteManager = new LSPPaletteManager((Engine)this, this.game.getCache().getEntry("palette.dat", true));
        byte[] remapbuf = new byte[256];
        remapbuf[58] = 96;
        remapbuf[57] = 96;
        remapbuf[56] = 96;
        paletteManager.makePalookup(96, remapbuf, 0, 0, 0, 1);
        remapbuf[58] = -29;
        remapbuf[57] = -29;
        remapbuf[56] = -29;
        paletteManager.makePalookup(228, remapbuf, 0, 0, 0, 1);
        remapbuf[58] = 17;
        remapbuf[57] = 17;
        remapbuf[56] = 17;
        remapbuf[227] = 17;
        remapbuf[163] = -82;
        remapbuf[0] = 28;
        paletteManager.makePalookup(70, remapbuf, 0, 0, 0, 1);
        return paletteManager;
    }

    @Override
    protected BoardService createBoardService() {
        return new LSPBoardService();
    }

    public int movesprite(int spritenum, int dx, int dy, int dz, int clipdist, int ceildist, int flordist, int cliptype, int vel) {
        Sprite spr = this.boardService.getSprite(spritenum);
        if (spr == null) {
            return 0;
        }
        this.game.pInt.setsprinterpolate(spritenum, spr);
        int zoffs = 0;
        if ((spr.getCstat() & 0x80) == 0) {
            zoffs = -(Main.engine.getTile(spr.getPicnum()).getHeight() * spr.getYrepeat() << 1);
        }
        short dasectnum = spr.getSectnum();
        int daz = spr.getZ() + zoffs;
        int retval = this.clipmove(spr.getX(), spr.getY(), daz, dasectnum, (long)vel * (long)dx << 11, (long)vel * (long)dy << 11, clipdist, ceildist, flordist, cliptype);
        if (clipmove_sectnum != -1) {
            spr.setX(clipmove_x);
            spr.setY(clipmove_y);
            dasectnum = clipmove_sectnum;
        }
        if (dasectnum != spr.getSectnum() && dasectnum >= 0) {
            Main.engine.changespritesect(spritenum, dasectnum);
        }
        short oldcstat = spr.getCstat();
        spr.setCstat(spr.getCstat() & 0xFFFFFFFE);
        Main.engine.getzrange(spr.getX(), spr.getY(), spr.getZ() - 1, spr.getSectnum(), clipdist, cliptype);
        spr.setCstat(oldcstat);
        daz = spr.getZ() + zoffs + (vel * dz >> 3);
        if (daz <= zr_ceilz || daz > zr_florz) {
            if (retval != 0) {
                return retval;
            }
            return 0x40000000 | dasectnum;
        }
        spr.setZ(daz - zoffs);
        return retval;
    }

    @Override
    public int clipmove(int x, int y, int z, int sectnum, long xvect, long yvect, int walldist, int ceildist, int flordist, int cliptype) {
        this.clipmove.setTraceNum(clipmoveboxtracenum);
        return super.clipmove(x, y, z, sectnum, xvect, yvect, walldist, ceildist, flordist, cliptype);
    }

    @Override
    protected Tables loadtables() throws Exception {
        return new LSPTables(this.game.getCache().getEntry("tables.dat", true));
    }
}

