/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.OsdFunc;
import ru.m210projects.LSP.Factory.LSPEngine;
import ru.m210projects.LSP.Factory.LSPMenuHandler;
import ru.m210projects.LSP.Factory.LSPNetwork;
import ru.m210projects.LSP.Factory.LSPOsdFunc;
import ru.m210projects.LSP.Factory.LSPPolygdx;
import ru.m210projects.LSP.Factory.LSPPolymost;
import ru.m210projects.LSP.Factory.LSPRenderer;
import ru.m210projects.LSP.Factory.LSPSliderDrawable;
import ru.m210projects.LSP.Factory.LSPSoftware;
import ru.m210projects.LSP.Fonts.FontA;
import ru.m210projects.LSP.Fonts.MenuFont;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Types.LSPDatFile;
import ru.m210projects.LSP.Types.MapGroup;

public class LSPFactory
extends BuildFactory {
    private final Main app;

    public LSPFactory(Main app) {
        super("stuff.dat");
        this.app = app;
        OsdColor.DEFAULT.setPal(4);
    }

    @Override
    public void drawInitScreen() {
        LSPRenderer renderer = Main.game.getRenderer();
        renderer.rotatesprite(0, 0, 65536, 0, 770, -128, 0, 26);
    }

    @Override
    public Engine engine() throws Exception {
        FileEntry entry = Main.game.cache.getGameDirectory().getEntry("LVART000.DAT");
        if (entry.exists() && !entry.isDirectory()) {
            Main.gResGroup = new LSPDatFile(entry.getName(), 135, entry::getInputStream);
            Main.game.getCache().addGroup(Main.gResGroup, CacheResourceMap.CachePriority.NORMAL);
            Console.out.println("Found " + Main.gResGroup.getSize() + " files in " + Main.gResGroup.getName() + " archive");
        }
        if ((entry = Main.game.cache.getGameDirectory().getEntry("LMART000.DAT")).exists() && !entry.isDirectory()) {
            Main.gMapGroup = new MapGroup(entry::getInputStream);
            Main.game.getCache().addGroup(Main.gMapGroup, CacheResourceMap.CachePriority.NORMAL);
            Console.out.println("Found " + Main.gMapGroup.getSize() + " files in " + Main.gMapGroup.getName() + " archive");
        }
        Main.engine = new LSPEngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new LSPSoftware(this.app.pCfg);
        }
        if (type == Renderer.RenderType.PolyGDX) {
            return new LSPPolygdx(this.app.pCfg);
        }
        return new LSPPolymost(this.app.pCfg);
    }

    @Override
    public DefScript getBaseDef(Engine engine) {
        return new DefScript(engine);
    }

    @Override
    public OsdFunc getOsdFunc() {
        return new LSPOsdFunc();
    }

    @Override
    public MenuHandler menus() {
        this.app.menu = new LSPMenuHandler(this.app);
        return this.app.menu;
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(3){

            @Override
            protected Font init(int i) {
                if (i == 0) {
                    return new FontA(((LSPFactory)LSPFactory.this).app.pEngine);
                }
                if (i == 2) {
                    return new MenuFont(((LSPFactory)LSPFactory.this).app.pEngine);
                }
                return EngineUtils.getLargeFont();
            }
        };
    }

    @Override
    public BuildNet net() {
        return new LSPNetwork(this.app);
    }

    @Override
    public SliderDrawable slider() {
        return new LSPSliderDrawable();
    }
}

