/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Menus;

import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.LSP.Factory.LSPRenderer;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Types.PCXFile;

public class ItemPCX
extends MenuItem {
    private PCXFile fil;
    private final byte index;

    public ItemPCX(int x, int y, int index) {
        super(null, null);
        this.x = x;
        this.y = y;
        this.flags |= 0xB;
        this.index = (byte)index;
    }

    @Override
    public void draw(MenuHandler handler) {
        LSPRenderer renderer = Main.game.getRenderer();
        renderer.rotatesprite(this.x << 16, this.y << 16, 65536, 512, Globals.TILE_ANIM, -128, 251, 94);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case LEFT: 
            case BSPACE: 
            case RMB: {
                this.m_pMenu.mNavUp();
                return false;
            }
            case RIGHT: 
            case ENTER: 
            case SPACE: 
            case LMB: {
                this.m_pMenu.mNavDown();
                return false;
            }
            case UP: 
            case DW: 
            case ESC: 
            case DELETE: {
                return this.m_pMenu.mNavigation(opt);
            }
        }
        return false;
    }

    public void show() {
        if (this.fil == null) {
            try {
                this.fil = new PCXFile(Main.game.getCache().getEntry(Integer.toString(this.index & 0xFF), false));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        Main.engine.getPaletteManager().changePalette(this.fil.getPalette());
        ArtEntry pic = Main.engine.getTile(Globals.TILE_ANIM);
        if (!(pic instanceof DynamicArtEntry) || !pic.exists() || pic.getWidth() != this.fil.getWidth() || pic.getHeight() != this.fil.getHeight()) {
            pic = Main.engine.allocatepermanenttile(Globals.TILE_ANIM, this.fil.getHeight(), this.fil.getWidth());
        }
        ((DynamicArtEntry)pic).copyData(this.fil.getData());
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean mouseAction(int x, int y) {
        return false;
    }
}

