/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Screens;

import com.badlogic.gdx.Screen;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.LoadSave;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Screens.GameScreen;
import ru.m210projects.LSP.Types.CompareService.CompareService;
import ru.m210projects.LSP.Types.DemoFile;
import ru.m210projects.LSP.Types.DemoRec;

public class DemoScreen
extends GameScreen {
    public static final String header = "LSPD";
    public final List<Entry> demofiles = new ArrayList<Entry>();
    public int nDemonum = -1;
    public DemoFile demfile;

    public DemoScreen(Main game) {
        super(game);
    }

    @Override
    public void show() {
        LoadSave.lastload = null;
    }

    public boolean showDemo(Entry entry) {
        this.onStopRecord();
        this.demfile = null;
        try (InputStream is = entry.getInputStream();){
            this.demfile = new DemoFile(is);
        }
        catch (Exception e) {
            Console.out.println("Can't play the demo file: " + entry.getName(), OsdColor.RED);
            return false;
        }
        if (Mmulti.numplayers > 1) {
            this.game.pNet.NetDisconnect(Mmulti.myconnectindex);
        }
        Globals.nDifficult = (short)this.demfile.skill;
        Globals.recstat = 2;
        Main.gDemoScreen.newgame(this.demfile.map);
        Console.out.println("Playing demo " + entry.getName());
        return true;
    }

    @Override
    protected void startboard(Runnable startboard) {
        this.game.doPrecache(() -> {
            startboard.run();
            this.pNet.ResetTimers();
            Globals.lockclock = 0;
            this.pNet.ready2send = false;
        });
    }

    @Override
    public void render(float delta) {
        if (Mmulti.numplayers > 1) {
            this.pNet.GetPackets();
        }
        this.DemoRender();
        float smoothratio = 65536.0f;
        if (!this.game.gPaused && ((smoothratio = (float)this.pEngine.getTimer().getsmoothratio(delta)) < 0.0f || smoothratio > 65536.0f)) {
            smoothratio = Gameutils.BClipRange(smoothratio, 0.0f, 65536.0f);
        }
        this.game.pInt.dointerpolations(smoothratio);
        this.DrawWorld(smoothratio);
        this.DrawHud(smoothratio);
        this.game.pInt.restoreinterpolations();
        if (this.pMenu.gShowMenu) {
            this.pMenu.mDrawMenu();
        }
        this.PostFrame(this.pNet);
        this.pEngine.nextpage(delta);
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        return this.gameKeyDownCommon(gameKey, false);
    }

    private void DemoRender() {
        this.pNet.ready2send = false;
        if (!this.game.isCurrentScreen(this)) {
            return;
        }
        if (!this.game.gPaused && this.demfile != null) {
            while (Main.engine.getTotalClock() >= Globals.lockclock + 4) {
                CompareService.update(this.demfile.rcnt);
                short j = Mmulti.connecthead;
                while (j >= 0) {
                    this.pNet.gFifoInput[this.pNet.gNetFifoHead[j] & 0xFF][j].Copy(this.demfile.recsync[this.demfile.rcnt][j]);
                    short s = j;
                    this.pNet.gNetFifoHead[s] = this.pNet.gNetFifoHead[s] + 1;
                    --this.demfile.reccnt;
                    j = Mmulti.connectpoint2[j];
                }
                if (this.demfile.reccnt <= 0) {
                    this.demfile = null;
                    if (!this.showDemo()) {
                        this.game.changeScreen(Main.gMenuScreen);
                    }
                    return;
                }
                ++this.demfile.rcnt;
                this.game.pInt.clearinterpolations();
                this.ProcessFrame(this.pNet);
            }
        }
    }

    @Override
    public void resume() {
        this.game.pEngine.getTimer().setTotalClock(Globals.lockclock);
        super.resume();
    }

    public boolean showDemo() {
        List<Entry> list = this.demofiles;
        switch (Main.cfg.gDemoSeq) {
            case 0: {
                return false;
            }
            case 1: {
                if (this.nDemonum < list.size() - 1) {
                    ++this.nDemonum;
                    break;
                }
                this.nDemonum = 0;
                break;
            }
            case 2: {
                int nextnum = this.nDemonum;
                if (list.size() > 1) {
                    while (nextnum == this.nDemonum) {
                        nextnum = (int)(Math.random() * (double)list.size());
                    }
                }
                this.nDemonum = Gameutils.BClipRange(nextnum, 0, list.size() - 1);
            }
        }
        if (!list.isEmpty()) {
            boolean result = this.showDemo(list.get(this.nDemonum));
            if (!result) {
                list.remove(this.nDemonum);
                return this.showDemo();
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDemoFile(Entry file) {
        if (!file.exists()) return false;
        if (!file.isExtension("dmo")) return false;
        try (InputStream is = file.getInputStream();){
            String header = StreamUtils.readString(is, header.length());
            StreamUtils.skip(is, 4);
            int version = StreamUtils.readUnsignedByte(is);
            if (!header.equals(header)) return false;
            if (version != 100) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isDemoScreen(Screen screen) {
        return screen == Main.gDemoScreen;
    }

    public static boolean isDemoPlaying() {
        return Globals.recstat == 2;
    }

    public void onPrepareboard(GameScreen screen) {
        if (screen != this && DemoScreen.isDemoPlaying()) {
            Main.gDemoScreen.onStopPlaying();
        }
        if (this.demfile != null && this.demfile.version >= 100 && DemoScreen.isDemoPlaying()) {
            short i = Mmulti.connecthead;
            while (i >= 0) {
                this.demfile.playerData.applyTo(Globals.gPlayer[i]);
                i = Mmulti.connectpoint2[i];
            }
        }
        if (screen != this && this.isRecordEnabled()) {
            Globals.m_recstat = 0;
            int democount = 0;
            do {
                int a = democount / 1000 % 10;
                int b = democount / 100 % 10;
                int c = democount / 10 % 10;
                int d = democount % 10;
                String fn = "demo" + a + b + c + d + ".dmo";
                if (this.game.getCache().getGameDirectory().getEntry(fn).exists()) continue;
                try {
                    Path path = this.game.getCache().getGameDirectory().getPath().resolve(fn);
                    Globals.rec = new DemoRec(new FileOutputStream(path.toFile()), path, 100);
                    Console.out.println("Start recording to " + fn);
                    Globals.recstat = 1;
                }
                catch (Exception e) {
                    Console.out.println("Can't start demo record: " + e, OsdColor.RED);
                }
                break;
            } while (++democount < 9999);
        }
    }

    public boolean isRecordEnabled() {
        return Globals.m_recstat == 1;
    }

    public void onStopPlaying() {
        this.demfile = null;
        Globals.recstat = 0;
    }

    public void onLoad() {
        this.onStopRecord();
        this.demfile = null;
        Globals.recstat = 0;
    }

    public void onStopRecord() {
        if (Globals.rec == null) {
            return;
        }
        CompareService.close();
        Globals.rec.close();
        Globals.rec = null;
        Globals.recstat = 0;
    }

    public void onRecord() {
        if (Globals.rec != null) {
            Globals.rec.record();
        }
    }

    public void demoscan(Directory directory) {
        this.demofiles.clear();
        for (Entry file : directory.getEntries()) {
            if (!file.isExtension("dmo") || !this.isDemoFile(file)) continue;
            this.demofiles.add(file);
        }
        if (!this.demofiles.isEmpty()) {
            this.demofiles.sort(Comparator.comparing(Entry::getName));
        }
        Console.out.println("There are " + this.demofiles.size() + " demo(s) in the loop", OsdColor.YELLOW);
    }
}

