/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Screens;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.SkippableAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.LSP.Sounds;

public class IntroScreen
extends SkippableAdapter {
    private int toffs;
    private int state;
    private float time;

    public IntroScreen(BuildGame game) {
        super(game);
    }

    @Override
    public void show() {
        this.toffs = 0;
        this.state = 0;
        this.time = 0.0f;
        Sounds.stopallsounds();
        this.game.pNet.ResetTimers();
        Sounds.startmusic(14);
    }

    @Override
    public void draw(float delta) {
        switch (this.state) {
            case 0: {
                this.screen1(delta);
                break;
            }
            case 1: {
                this.screen2(delta);
                break;
            }
            case 2: {
                this.screen3(delta);
            }
        }
    }

    private void screen1(float delta) {
        float f;
        this.time += delta;
        if (f >= 0.2f) {
            if (++this.toffs >= 320) {
                this.toffs = 0;
            }
            this.time = 0.0f;
        }
        Renderer renderer = this.game.getRenderer();
        int xdim = renderer.getWidth();
        int ydim = renderer.getHeight();
        int xscreen = Gameutils.coordsConvertXScaled(1, ConvertType.Normal);
        renderer.rotatesprite(-this.toffs << 16, 0, 65536, 0, 1102, 0, 0, 26, xscreen, 0, xdim, ydim);
        renderer.rotatesprite(319 - this.toffs << 16, 0, 65536, 0, 1102, 0, 0, 26, 0, 0, xdim - xscreen, ydim);
        renderer.rotatesprite(0, 655360, 65536, 0, 1100, 0, 0, 26);
        if (this.engine.getTotalClock() < 762) {
            int angle = 8 * this.engine.getTotalClock();
            int scale = angle << 5;
            if (this.engine.getTotalClock() >= 256) {
                if (this.engine.getTotalClock() >= 514) {
                    angle = 8 * (this.engine.getTotalClock() + 1286);
                    scale = 762 - this.engine.getTotalClock() << 8;
                } else {
                    scale = 65536;
                    angle = 0;
                }
            }
            renderer.rotatesprite(0xA00000, 0x640000, scale, angle, 610, 0, 0, 10, xscreen, 0, xdim - xscreen, ydim);
        }
        if (this.engine.getTotalClock() > 800) {
            int count = this.engine.getTotalClock() - 800;
            int xoffs = count >> 3;
            if (count >= 2464) {
                xoffs = 308;
            }
            renderer.rotatesprite(320 - xoffs << 16, 0x810000, 65536, 0, 1103, 0, 0, 26, 0, 0, xdim - xscreen, ydim);
            if (count <= 2464) {
                if (count > 1440) {
                    renderer.rotatesprite(0xA00000, 0xB00000, count - 1440 << 6, 0, 1105, 0, 0, 10);
                }
                if (count > 1952) {
                    renderer.rotatesprite((177 * EngineUtils.sin(count + 96 & 0x7FF) >> 14) + 104 << 16, (177 * EngineUtils.sin(count - 1952 + 1536 & 0x7FF) >> 14) + 189 << 16, 65536, 4 * (count - 1952), 1107, 0, 0, 10);
                }
            } else {
                Sounds.stopmusic();
                renderer.rotatesprite(0xA00000, 0xB00000, 65536, 0, 1105, 0, 0, 10);
                renderer.rotatesprite(0x1070000, 0xB10000, 65536, 0, 1107, 0, 0, 26);
            }
            if (this.engine.getTotalClock() > 3600) {
                int angle = 8 * (this.engine.getTotalClock() - 3600);
                int scale = angle << 5;
                if (scale >= 65536) {
                    scale = 65536;
                    angle = 0;
                    this.toffs = 0;
                    this.state = 1;
                    this.time = 0.0f;
                    this.game.pNet.ResetTimers();
                    Sounds.startmusic(3);
                }
                renderer.rotatesprite(0xA00000, 0x640000, scale, angle, 770, 0, 0, 10, xscreen, 0, xdim - xscreen, ydim);
            }
        }
    }

    private void screen2(float delta) {
        float f;
        this.time += delta;
        if (f >= 0.5f) {
            if (++this.toffs >= 18) {
                this.toffs = 0;
            }
            this.time = 0.0f;
        }
        Renderer renderer = this.game.getRenderer();
        renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, 770 + this.toffs, 0, 0, 10);
        int yoffs = this.engine.getTotalClock() >> 5;
        if (this.engine.getTotalClock() >= 6240) {
            yoffs = 195;
        }
        renderer.rotatesprite(0x140000, 199 - yoffs << 16, 65536, 0, 788, Pragmas.klabs(13 - (this.engine.getTotalClock() >> 8)), 0, 26);
        if (this.engine.getTotalClock() >= 7680) {
            this.toffs = 0;
            this.state = 2;
            this.game.pNet.ResetTimers();
        }
    }

    private void screen3(float delta) {
        float f;
        this.time += delta;
        if (f >= 0.005f) {
            if (++this.toffs > 256) {
                this.toffs = 256;
                this.skip();
            }
            this.time = 0.0f;
        }
        Renderer renderer = this.game.getRenderer();
        renderer.rotatesprite(0, 0, 65536, 0, 1102, 0, 0, 26);
        renderer.rotatesprite(0, 655360, 65536, 0, 1100, 0, 0, 26);
        renderer.rotatesprite(0xA00000, 0x640000, 256 - this.toffs << 8, 8 * this.toffs, 770, 0, 0, 10);
        renderer.rotatesprite(0xA00000, 0x640000, 256 - this.toffs << 8, 8 * (2048 - this.toffs), 788, 0, 0, 10);
    }
}

