/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Screens;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.ScreenAdapters.DefaultPrecacheScreen;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.LSP.Main;

public class PrecacheScreen
extends DefaultPrecacheScreen {
    public PrecacheScreen(Runnable toLoad, PrecacheListener listener) {
        super(Main.game, toLoad, listener);
        this.addQueue("Preload floor and ceiling tiles...", () -> {
            Sector[] sectors;
            for (Sector sec : sectors = Main.boardService.getBoard().getSectors()) {
                this.addTile(sec.getFloorpicnum());
                this.addTile(sec.getCeilingpicnum());
            }
            this.doprecache(0);
        });
        this.addQueue("Preload wall tiles...", () -> {
            for (Wall wall : Main.boardService.getBoard().getWalls()) {
                this.addTile(wall.getPicnum());
                if (wall.getOverpicnum() < 0) continue;
                this.addTile(wall.getOverpicnum());
            }
            this.doprecache(0);
        });
        this.addQueue("Preload sprite tiles...", () -> {
            for (int i = 0; i < Engine.MAXSPRITES; ++i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null || spr.getStatnum() >= 1024) continue;
                this.cachespritenum(spr);
            }
            this.doprecache(1);
        });
    }

    @Override
    protected void draw(String title, int index) {
        Renderer renderer = this.game.getRenderer();
        renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, 770, -128, 0, 74);
        this.game.getFont(2).drawTextScaled(renderer, 160, 80, "Loading", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
        this.game.getFont(2).drawTextScaled(renderer, 160, 114, "please wait...", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
        this.game.getFont(2).drawTextScaled(renderer, 160, 130, title, 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
    }

    private void cachespritenum(Sprite spr) {
        int maxc = 1;
        switch (spr.getPicnum()) {
            case 1536: 
            case 1792: 
            case 2048: 
            case 2304: 
            case 2560: {
                maxc = 40;
            }
        }
        for (int j = spr.getPicnum(); j < spr.getPicnum() + maxc; ++j) {
            this.addTile(j);
        }
    }
}

