/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Types;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import ru.m210projects.Build.filehandle.InputStreamProvider;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.grp.GrpEntry;
import ru.m210projects.Build.filehandle.grp.GrpFile;

public class LSPDatFile
extends GrpFile {
    public LSPDatFile(String name, int numFiles, InputStreamProvider provider) throws IOException {
        super(name);
        try (BufferedInputStream is = new BufferedInputStream(provider.newInputStream());){
            int i;
            int fileSize = ((InputStream)is).available();
            int[] offset = new int[numFiles];
            for (i = 0; i < numFiles; ++i) {
                offset[i] = StreamUtils.readInt(is);
            }
            for (i = 0; i < numFiles; ++i) {
                int siz;
                int len = fileSize;
                if (i < numFiles - 1) {
                    len = offset[i + 1];
                }
                if ((siz = len - offset[i]) <= 0 || siz >= fileSize || offset[i] <= 0 || offset[i] >= fileSize) continue;
                GrpEntry entry = this.newEntry(provider, i, offset[i], siz);
                entry.setParent(this);
                this.entries.put(entry.getName().toUpperCase(), entry);
            }
        }
    }

    protected GrpEntry newEntry(InputStreamProvider provider, int index, int offset, int size) {
        return new GrpEntry(provider, Integer.toString(index), offset, size);
    }
}

