/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Types;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Pattern.ScreenAdapters.MovieScreen;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.LSP.Main;

public class LSPMovieFile
implements MovieScreen.MovieFile {
    public boolean paletteChanged;
    private byte[] pal;
    private byte[] frameBuffer;
    private Frame[] frames;
    private final int rate;
    private final int width;
    private final int height;

    public LSPMovieFile(String path) throws Exception {
        Entry fil = Main.game.getCache().getEntry(path, true);
        if (!fil.exists()) {
            throw new FileNotFoundException(path + " not found!");
        }
        try (InputStream is = fil.getInputStream();){
            int size = StreamUtils.readInt(is);
            if ((long)size != fil.getSize()) {
                throw new Exception("Wrong size");
            }
            int type = StreamUtils.readUnsignedShort(is);
            if (type != 44817) {
                throw new Exception("Wrong type");
            }
            int numframes = StreamUtils.readShort(is);
            this.width = StreamUtils.readShort(is);
            this.height = StreamUtils.readShort(is);
            this.rate = StreamUtils.readShort(is);
            StreamUtils.readShort(is);
            StreamUtils.readShort(is);
            StreamUtils.skip(is, 110);
            this.frameBuffer = new byte[this.width * this.height];
            this.frames = new Frame[numframes];
            for (int i = 0; i < numframes; ++i) {
                this.frames[i] = new Frame(is);
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getFrames() {
        if (this.frames != null) {
            return this.frames.length;
        }
        return 0;
    }

    @Override
    public byte[] getPalette() {
        return this.pal;
    }

    @Override
    public float getRate() {
        return 1000.0f / (float)this.rate;
    }

    @Override
    public byte[] getFrame(int num) {
        return this.frames[num].draw();
    }

    @Override
    public void close() {
        this.frameBuffer = null;
        this.pal = null;
        this.frames = null;
    }

    @Override
    public void playAudio() {
    }

    static /* synthetic */ byte[] access$102(LSPMovieFile x0, byte[] x1) {
        x0.pal = x1;
        return x1;
    }

    private class Frame {
        final int size;
        final int type;
        final int chunks;
        final ByteBuffer data;

        public Frame(InputStream is) throws IOException {
            this.size = StreamUtils.readInt(is);
            this.type = StreamUtils.readUnsignedShort(is);
            this.chunks = StreamUtils.readUnsignedShort(is);
            StreamUtils.skip(is, 8);
            this.data = ByteBuffer.allocate(this.size - 16).order(ByteOrder.LITTLE_ENDIAN);
            StreamUtils.readBuffer(is, this.data);
        }

        public byte[] draw() {
            LSPMovieFile.this.paletteChanged = false;
            if (this.type != 61946) {
                return null;
            }
            this.data.rewind();
            block6: for (int j = 0; j < this.chunks; ++j) {
                int chunk_size = this.data.getInt();
                short chunk_type = this.data.getShort();
                switch (chunk_type) {
                    case 11: {
                        this.decode_palette();
                        continue block6;
                    }
                    case 12: {
                        this.decode_block_0c();
                        continue block6;
                    }
                    case 15: {
                        this.decode_block_0f();
                        continue block6;
                    }
                    case 16: {
                        this.data.get(LSPMovieFile.this.frameBuffer, 0, chunk_size - 4);
                        continue block6;
                    }
                }
            }
            return LSPMovieFile.this.frameBuffer;
        }

        private void decode_palette() {
            this.data.getInt();
            LSPMovieFile.access$102(LSPMovieFile.this, new byte[768]);
            this.data.get(LSPMovieFile.this.pal);
            int p = 0;
            while (p < 768) {
                byte[] byArray = LSPMovieFile.this.pal;
                int n = p++;
                byArray[n] = (byte)(byArray[n] << 2);
            }
            LSPMovieFile.this.paletteChanged = true;
        }

        private void decode_block_0c() {
            int line;
            int nextline = line = 320 * this.data.getShort();
            int width = this.data.getShort();
            for (int j = 0; j < width; ++j) {
                nextline += 320;
                int v21 = this.data.get() & 0xFF;
                if (v21 > 0) {
                    for (int i = 0; i < v21; ++i) {
                        line += this.data.get() & 0xFF;
                        int v20 = this.data.get() & 0xFF;
                        if (v20 < 128) {
                            for (int p = 0; p < v20; ++p) {
                                ((LSPMovieFile)LSPMovieFile.this).frameBuffer[line + p] = this.data.get();
                            }
                            line += v20;
                        }
                        if (v20 <= 128) continue;
                        byte col = this.data.get();
                        for (int p = 0; p < 256 - v20; ++p) {
                            ((LSPMovieFile)LSPMovieFile.this).frameBuffer[line + p] = col;
                        }
                        line += 256 - v20;
                    }
                }
                line = nextline;
            }
        }

        private void decode_block_0f() {
            int line = 0;
            for (int i = 1; i <= 200; ++i) {
                int v18 = this.data.get() & 0xFF;
                if (v18 > 0) {
                    for (int j = 0; j < v18; ++j) {
                        int v8 = this.data.get() & 0xFF;
                        if (v8 > 128) {
                            for (int p = 0; p < 256 - v8; ++p) {
                                ((LSPMovieFile)LSPMovieFile.this).frameBuffer[line + p] = this.data.get();
                            }
                            line += 256 - v8;
                        }
                        if (v8 >= 128) continue;
                        byte col = this.data.get();
                        for (int p = 0; p < v8; ++p) {
                            ((LSPMovieFile)LSPMovieFile.this).frameBuffer[line + p] = col;
                        }
                        line += v8;
                    }
                }
                line = 320 * i;
            }
        }
    }
}

