/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Types;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.BitMap;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.LSP.Types.ANIMATION;
import ru.m210projects.LSP.Types.PlayerStruct;
import ru.m210projects.LSP.Types.SwingDoor;

public class SafeLoader {
    public final int MAXSWINGDOORS = 32;
    public int gAnimationCount = 0;
    public final ANIMATION[] gAnimationData = new ANIMATION[512];
    public final PlayerStruct[] plr = new PlayerStruct[16];
    public final int[] gEnemyClock = new int[Engine.MAXSPRITES];
    public final short[] gMoveStatus = new short[Engine.MAXSPRITES];
    public final short[] nKills = new short[6];
    public final short[] nTotalKills = new short[6];
    public int nEnemyKills;
    public int nEnemyMax;
    public short nDiffDoor;
    public short nDiffDoorBack;
    public short nTrainWall;
    public boolean bActiveTrain;
    public boolean bTrainSoundSwitch;
    public int lockclock;
    public int totalmoves;
    public short nPlayerFirstWeapon = (short)17;
    public int oldchoose;
    public short oldpic;
    public int mapnum;
    public int skill;
    public final short[] pskyoff = new short[256];
    public short pskybits;
    public int parallaxyscale;
    public short connecthead;
    public final short[] connectpoint2 = new short[16];
    public int randomseed;
    public int visibility;
    public byte automapping;
    public final BitMap show2dsector = new BitMap(1024);
    public final BitMap show2dwall = new BitMap(8192);
    public final BitMap show2dsprite = new BitMap(4096);
    public Sector[] sector;
    public Wall[] wall;
    public List<Sprite> sprite;
    public final short[] waterfountainwall = new short[16];
    public final short[] waterfountaincnt = new short[16];
    public short ypanningwallcnt;
    public final short[] ypanningwalllist = new short[16];
    public short floorpanningcnt;
    public final short[] floorpanninglist = new short[16];
    public short warpsectorcnt;
    public final short[] warpsectorlist = new short[16];
    public short xpanningsectorcnt;
    public final short[] xpanningsectorlist = new short[16];
    public short warpsector2cnt;
    public final short[] warpsector2list = new short[32];
    public final short[][] subwaytracksector = new short[5][128];
    public final short[] subwaynumsectors = new short[5];
    public short subwaytrackcnt;
    public final int[][] subwaystop = new int[5][8];
    public final int[] subwaystopcnt = new int[5];
    public final int[] subwaytrackx1 = new int[5];
    public final int[] subwaytracky1 = new int[5];
    public final int[] subwaytrackx2 = new int[5];
    public final int[] subwaytracky2 = new int[5];
    public final int[] subwayx = new int[5];
    public final int[] subwaygoalstop = new int[5];
    public final int[] subwayvel = new int[5];
    public final int[] subwaypausetime = new int[5];
    public final short[] revolvesector = new short[4];
    public final short[] revolveang = new short[4];
    public short revolvecnt;
    public final int[][] revolvex = new int[4][48];
    public final int[][] revolvey = new int[4][48];
    public final int[] revolvepivotx = new int[4];
    public final int[] revolvepivoty = new int[4];
    public short swingcnt;
    public final SwingDoor[] swingdoor = new SwingDoor[32];
    public final short[] dragsectorlist = new short[16];
    public final short[] dragxdir = new short[16];
    public final short[] dragydir = new short[16];
    public short dragsectorcnt;
    public final int[] dragx1 = new int[16];
    public final int[] dragy1 = new int[16];
    public final int[] dragx2 = new int[16];
    public final int[] dragy2 = new int[16];
    public final int[] dragfloorz = new int[16];

    public SafeLoader() {
        int i;
        for (i = 0; i < 16; ++i) {
            this.plr[i] = new PlayerStruct();
        }
        for (i = 0; i < 512; ++i) {
            this.gAnimationData[i] = new ANIMATION();
        }
        for (i = 0; i < 32; ++i) {
            this.swingdoor[i] = new SwingDoor();
        }
    }

    public boolean load(InputStream is) {
        try {
            this.LoadGDXHeader(is);
            this.LoadGDXBlock(is);
            this.StuffLoad(is);
            this.MapLoad(is);
            this.SectorLoad(is);
            this.AnimationLoad(is);
            if (is.available() == 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void SectorLoad(InputStream is) throws IOException {
        int j;
        int b;
        int a;
        int i;
        for (i = 0; i < 16; ++i) {
            this.waterfountainwall[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < 16; ++i) {
            this.waterfountaincnt[i] = StreamUtils.readShort(is);
        }
        this.ypanningwallcnt = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            this.ypanningwalllist[i] = StreamUtils.readShort(is);
        }
        this.floorpanningcnt = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            this.floorpanninglist[i] = StreamUtils.readShort(is);
        }
        this.warpsectorcnt = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            this.warpsectorlist[i] = StreamUtils.readShort(is);
        }
        this.xpanningsectorcnt = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            this.xpanningsectorlist[i] = StreamUtils.readShort(is);
        }
        this.warpsector2cnt = StreamUtils.readShort(is);
        for (i = 0; i < 32; ++i) {
            this.warpsector2list[i] = StreamUtils.readShort(is);
        }
        this.subwaytrackcnt = StreamUtils.readShort(is);
        for (a = 0; a < 5; ++a) {
            for (b = 0; b < 128; ++b) {
                this.subwaytracksector[a][b] = StreamUtils.readShort(is);
            }
        }
        for (i = 0; i < 5; ++i) {
            this.subwaynumsectors[i] = StreamUtils.readShort(is);
        }
        for (a = 0; a < 5; ++a) {
            for (b = 0; b < 8; ++b) {
                this.subwaystop[a][b] = StreamUtils.readInt(is);
            }
        }
        for (i = 0; i < 5; ++i) {
            this.subwaystopcnt[i] = StreamUtils.readInt(is);
        }
        for (i = 0; i < 5; ++i) {
            this.subwaytrackx1[i] = StreamUtils.readInt(is);
        }
        for (i = 0; i < 5; ++i) {
            this.subwaytracky1[i] = StreamUtils.readInt(is);
        }
        for (i = 0; i < 5; ++i) {
            this.subwaytrackx2[i] = StreamUtils.readInt(is);
        }
        for (i = 0; i < 5; ++i) {
            this.subwaytracky2[i] = StreamUtils.readInt(is);
        }
        for (i = 0; i < 5; ++i) {
            this.subwayx[i] = StreamUtils.readInt(is);
        }
        for (i = 0; i < 5; ++i) {
            this.subwaygoalstop[i] = StreamUtils.readInt(is);
        }
        for (i = 0; i < 5; ++i) {
            this.subwayvel[i] = StreamUtils.readInt(is);
        }
        for (i = 0; i < 5; ++i) {
            this.subwaypausetime[i] = StreamUtils.readInt(is);
        }
        this.revolvecnt = StreamUtils.readShort(is);
        for (i = 0; i < 4; ++i) {
            this.revolvesector[i] = StreamUtils.readShort(is);
            this.revolveang[i] = StreamUtils.readShort(is);
            for (j = 0; j < 48; ++j) {
                this.revolvex[i][j] = StreamUtils.readInt(is);
                this.revolvey[i][j] = StreamUtils.readInt(is);
            }
            this.revolvepivotx[i] = StreamUtils.readInt(is);
            this.revolvepivoty[i] = StreamUtils.readInt(is);
        }
        this.swingcnt = StreamUtils.readShort(is);
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 8; ++j) {
                this.swingdoor[i].wall[j] = StreamUtils.readShort(is);
            }
            this.swingdoor[i].sector = StreamUtils.readShort(is);
            this.swingdoor[i].angopen = StreamUtils.readShort(is);
            this.swingdoor[i].angclosed = StreamUtils.readShort(is);
            this.swingdoor[i].angopendir = StreamUtils.readShort(is);
            this.swingdoor[i].ang = StreamUtils.readShort(is);
            this.swingdoor[i].anginc = StreamUtils.readShort(is);
            for (j = 0; j < 8; ++j) {
                this.swingdoor[i].x[j] = StreamUtils.readInt(is);
            }
            for (j = 0; j < 8; ++j) {
                this.swingdoor[i].y[j] = StreamUtils.readInt(is);
            }
        }
        this.dragsectorcnt = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            this.dragsectorlist[i] = StreamUtils.readShort(is);
            this.dragxdir[i] = StreamUtils.readShort(is);
            this.dragydir[i] = StreamUtils.readShort(is);
            this.dragx1[i] = StreamUtils.readInt(is);
            this.dragy1[i] = StreamUtils.readInt(is);
            this.dragx2[i] = StreamUtils.readInt(is);
            this.dragy2[i] = StreamUtils.readInt(is);
            this.dragfloorz[i] = StreamUtils.readInt(is);
        }
    }

    public void AnimationLoad(InputStream is) throws IOException {
        for (int i = 0; i < 512; ++i) {
            short index = StreamUtils.readShort(is);
            byte type = StreamUtils.readByte(is);
            this.gAnimationData[i].id = index;
            this.gAnimationData[i].type = type;
            this.gAnimationData[i].ptr = null;
            this.gAnimationData[i].goal = StreamUtils.readInt(is);
            this.gAnimationData[i].vel = StreamUtils.readInt(is);
            this.gAnimationData[i].acc = StreamUtils.readInt(is);
        }
        this.gAnimationCount = StreamUtils.readInt(is);
    }

    public void StuffLoad(InputStream is) throws IOException {
        int i;
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            this.gEnemyClock[i] = StreamUtils.readInt(is);
            this.gMoveStatus[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < 6; ++i) {
            this.nKills[i] = StreamUtils.readShort(is);
            this.nTotalKills[i] = StreamUtils.readShort(is);
        }
        this.nEnemyKills = StreamUtils.readInt(is);
        this.nEnemyMax = StreamUtils.readInt(is);
        this.nDiffDoor = StreamUtils.readShort(is);
        this.nDiffDoorBack = StreamUtils.readShort(is);
        this.nTrainWall = StreamUtils.readShort(is);
        this.bActiveTrain = StreamUtils.readBoolean(is);
        this.bTrainSoundSwitch = StreamUtils.readBoolean(is);
        this.lockclock = StreamUtils.readInt(is);
        this.totalmoves = StreamUtils.readInt(is);
        this.visibility = StreamUtils.readInt(is);
        this.randomseed = StreamUtils.readInt(is);
        this.show2dsector.readObject(is);
        this.show2dwall.readObject(is);
        this.show2dsprite.readObject(is);
        this.automapping = StreamUtils.readByte(is);
        this.pskybits = StreamUtils.readShort(is);
        this.parallaxyscale = StreamUtils.readInt(is);
        for (i = 0; i < 256; ++i) {
            this.pskyoff[i] = StreamUtils.readShort(is);
        }
        this.connecthead = StreamUtils.readShort(is);
        for (i = 0; i < 16; ++i) {
            this.connectpoint2[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < 16; ++i) {
            this.plr[i].readObject(is);
        }
        this.nPlayerFirstWeapon = StreamUtils.readShort(is);
        this.oldchoose = StreamUtils.readInt(is);
        this.oldpic = StreamUtils.readShort(is);
    }

    public void MapLoad(InputStream is) throws IOException {
        int i;
        this.sector = new Sector[StreamUtils.readInt(is)];
        for (i = 0; i < this.sector.length; ++i) {
            this.sector[i] = new Sector().readObject(is);
        }
        this.wall = new Wall[StreamUtils.readInt(is)];
        for (i = 0; i < this.wall.length; ++i) {
            this.wall[i] = new Wall().readObject(is);
        }
        int numSprites = StreamUtils.readInt(is);
        this.sprite = new ArrayList<Sprite>(numSprites * 2);
        for (int i2 = 0; i2 < numSprites; ++i2) {
            this.sprite.add(new Sprite().readObject(is));
        }
    }

    public void LoadGDXHeader(InputStream is) {
        this.mapnum = -1;
        this.skill = -1;
        try {
            StreamUtils.skip(is, 40);
            this.mapnum = StreamUtils.readInt(is);
            this.skill = StreamUtils.readInt(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void LoadGDXBlock(InputStream is) throws IOException {
        StreamUtils.skip(is, 16272);
    }
}

