/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop;

import com.badlogic.gdx.backends.awt.AWTDialog;
import java.awt.Image;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import ru.m210projects.Build.Architecture.DialogUtil;
import ru.m210projects.Build.Architecture.MessageType;
import ru.m210projects.Launcher.desktop.newlauncher.ArgumentsParser;
import ru.m210projects.Launcher.desktop.newlauncher.Controller;
import ru.m210projects.Launcher.desktop.newlauncher.LauncherModel;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.ui.HelpDialog;
import ru.m210projects.Launcher.desktop.newlauncher.ui.HelpException;
import ru.m210projects.Launcher.desktop.newlauncher.ui.LauncherView;
import ru.m210projects.Launcher.desktop.newlauncher.update.VersionChecker;

public class Main {
    public static final String headerPath = "/Headers";
    public static final String iconPath = "Games";
    public static String appversion = "v1.18";

    public static void main(String[] args) throws IOException {
        LauncherModel model;
        ArgumentsParser argumentsParser;
        long start = System.nanoTime();
        try {
            argumentsParser = new ArgumentsParser(args);
            if (argumentsParser.isUpdateSuccess()) {
                Main.showMessage("BuildGDX updater", "BuildGDX is successfully updated to " + appversion, MessageType.Info);
            }
            model = new LauncherModel(argumentsParser);
        }
        catch (HelpException helpException) {
            new HelpDialog(helpException.getMessage());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            Main.showMessage("Initialization error", e.toString(), MessageType.Error);
            return;
        }
        boolean forceUpdate = argumentsParser.isForceUpdate();
        if (model.getPortableEntry() != null || forceUpdate) {
            VersionChecker checker = new VersionChecker((response, resultText) -> {
                switch (response) {
                    case UPDATE_AVAILABLE: {
                        if (!Main.showMessage("New version available", "Do you want to download new version of BuildGDX " + resultText + "?", MessageType.Question).isApproved()) break;
                        return true;
                    }
                    case UPDATE_CANCELED: {
                        Main.showMessage("BuildGDX updater", resultText, MessageType.Info);
                        break;
                    }
                    case UPDATE_ERROR: {
                        Main.showMessage("Update error", resultText, MessageType.Error);
                    }
                }
                if (!forceUpdate) {
                    model.launchGame();
                }
                return false;
            });
            if (forceUpdate) {
                checker.runUpdate();
            } else {
                checker.run();
            }
            System.out.println((double)(System.nanoTime() - start) / 1000000.0);
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable checker) {
            // empty catch block
        }
        Controller controller = new Controller(model);
        LauncherView view = new LauncherView(model.getEntries());
        controller.setView(view);
        new Thread(new VersionChecker(view)).start();
        if (model.getPortableEntry() != null) {
            Game game = model.getPortableEntry().getGame();
            view.oneGameMode(game);
            controller.onChooseGame(game);
            controller.onOpenSettings();
            controller.resetBackStack();
        }
        view.start();
        System.out.println((double)(System.nanoTime() - start) / 1000000.0);
    }

    public static DialogUtil.DialogResult showMessage(String title, String message, MessageType messageType) {
        AWTDialog dialog = new AWTDialog(null);
        dialog.setIconImages(Main.getIconImages());
        return dialog.showMessage(title, message, messageType);
    }

    public static List<Image> getIconImages() {
        return Collections.singletonList(new ImageIcon(Objects.requireNonNull(Main.class.getResource("/Games/build32.png"))).getImage());
    }
}

