/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher;

import com.badlogic.gdx.backends.LwjglLauncherUtil;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALAudio;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.device.SoundBankDevice;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Architecture.common.audio.AudioDriver;
import ru.m210projects.Build.Architecture.common.audio.BuildAudio;
import ru.m210projects.Build.Architecture.common.audio.MidiDevice;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Launcher.desktop.Main;
import ru.m210projects.Launcher.desktop.newlauncher.ArgumentsParser;
import ru.m210projects.Launcher.desktop.newlauncher.ConfigApplicationContext;
import ru.m210projects.Launcher.desktop.newlauncher.Utils;
import ru.m210projects.Launcher.desktop.newlauncher.entries.DummyEntry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.entries.GameEntry;

public class LauncherModel {
    private final List<MidiDevice> list = LwjglLauncherUtil.getMidiDevices();
    private final Map<Game, GameEntry> entries = new HashMap<Game, GameEntry>(32);
    private final Map<Game, Boolean> configLoaded = new HashMap<Game, Boolean>(32);
    private final List<String> gameArgs;
    private GameEntry portableEntry;
    private GameEntry currentEntry = DummyEntry.DUMMY_ENTRY;

    public LauncherModel(ArgumentsParser properties) throws AccessDeniedException {
        Path homePath;
        this.gameArgs = properties.getOtherArguments();
        if (!properties.showLauncher() && !properties.getPath().equals(FileEntry.DUMMY_PATH) && properties.getGame() != Game.NULL) {
            Game game2 = properties.getGame();
            GameEntry entry = Utils.createGameEntry(game2, homePath = properties.getPath());
            if (!entry.equals(DummyEntry.DUMMY_ENTRY)) {
                this.entries.put(game2, entry);
                GameConfig config = entry.getConfig();
                if (this.isPortableGame(config) && entry.canStart()) {
                    this.portableEntry = entry;
                }
            }
        } else {
            homePath = Utils.getHomePath();
        }
        if (!Files.isWritable(homePath)) {
            throw new AccessDeniedException("You don't have write permissions to path \"" + homePath + "\"");
        }
        if (this.portableEntry != null) {
            this.currentEntry = this.portableEntry;
            return;
        }
        Arrays.stream(Game.values()).forEach(game -> this.entries.computeIfAbsent((Game)((Object)game), entry -> Utils.createGameEntry(entry, homePath)));
        for (GameEntry entry : this.getEntries()) {
            if (properties.showLauncher() || !this.isPortableGame(entry.getConfig()) || !entry.canStart()) continue;
            this.currentEntry = this.portableEntry = entry;
            return;
        }
    }

    private boolean isPortableGame(GameConfig config) {
        if (config == null || config.getGamePath().equals(FileEntry.DUMMY_PATH)) {
            return false;
        }
        Path relativePath = config.getGamePath().relativize(config.getCfgPath());
        return !relativePath.isAbsolute() && !relativePath.equals(config.getCfgPath());
    }

    public GameEntry getPortableEntry() {
        return this.portableEntry;
    }

    @NotNull
    public GameEntry getCurrentEntry() {
        GameEntry gameEntry = this.currentEntry;
        if (gameEntry == null) {
            LauncherModel.$$$reportNull$$$0(0);
        }
        return gameEntry;
    }

    public void chooseGame(Game game) {
        this.currentEntry = this.entries.get((Object)game);
        this.loadConfig(this.currentEntry);
    }

    public Path getGamePath() {
        return this.currentEntry.getConfig().getGamePath();
    }

    public List<String> setGamePath(Path path) {
        return this.currentEntry.setGamePath(path);
    }

    public void launchGame() {
        this.loadConfig(this.currentEntry);
        new Thread(() -> this.currentEntry.runApplication(this.gameArgs, Main.appversion)).start();
    }

    public Set<GameEntry> getEntries() {
        return new HashSet<GameEntry>(this.entries.values());
    }

    private void loadConfig(GameEntry entry) {
        this.configLoaded.computeIfAbsent(entry.getGame(), key -> {
            GameConfig config = entry.getConfig();
            config.registerAudioDriver(AudioDriver.DUMMY_AUDIO, new BuildAudio.DummyAudio(config));
            config.registerAudioDriver(AudioDriver.OPENAL_AUDIO, new OpenALAudio(config));
            config.addMidiDevices(this.list);
            config.setApplicationContext(new ConfigApplicationContext());
            config.load();
            for (Path path : config.getSoundBankPaths()) {
                if (!Files.exists(path, new LinkOption[0])) continue;
                try {
                    config.addSoundBank(new SoundBankDevice(path));
                }
                catch (Exception e) {
                    Console.out.println(String.format("Can't add soundbank %s: %s", path, e), OsdColor.RED);
                }
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/m210projects/Launcher/desktop/newlauncher/LauncherModel", "getCurrentEntry"));
    }
}

