/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.Platform;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Launcher.desktop.newlauncher.entries.BloodEntry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Duke3DEntry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.DummyEntry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.entries.GameEntry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.LSPEntry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.NamEntry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.PSlaveEntry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.RREntry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.RRRAEntry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.SWEntry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.TekwarEntry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.WH2Entry;
import ru.m210projects.Launcher.desktop.newlauncher.entries.WHEntry;

public class Utils {
    public static Path getHomePath() {
        Path homePath = Paths.get(System.getProperty("user.home"), Platform.get() == Platform.LINUX ? ".m210projects" : "M210Projects");
        File f = homePath.toFile();
        if (!(f.exists() || f.mkdirs() || f.isDirectory())) {
            Console.out.println("Can't create path \"" + homePath + '\"', OsdColor.RED);
        }
        return homePath;
    }

    public static Path getDirPath() {
        String parent;
        Platform platform = Platform.get();
        if (platform == Platform.LINUX && (parent = System.getProperty("java.class.path")) != null) {
            return Paths.get(parent, new String[0]).toAbsolutePath();
        }
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    @NotNull
    public static GameEntry createGameEntry(Game game, Path path) {
        switch (game) {
            case BLOOD: {
                return new BloodEntry(path);
            }
            case DUKE_NUKEM_3D: {
                return new Duke3DEntry(path);
            }
            case NAM: {
                return new NamEntry(path);
            }
            case SHADOW_WARRIOR: {
                return new SWEntry(path);
            }
            case REDNECK_RAMPAGE: {
                return new RREntry(path);
            }
            case RR_RIDES_AGAIN: {
                return new RRRAEntry(path);
            }
            case POWERSLAVE: {
                return new PSlaveEntry(path);
            }
            case TEKWAR: {
                return new TekwarEntry(path);
            }
            case WITCHAVEN: {
                return new WHEntry(path);
            }
            case WITCHAVEN_2: {
                return new WH2Entry(path);
            }
            case LEGEND_OF_THE_SEVEN_PALADINS: {
                return new LSPEntry(path);
            }
        }
        DummyEntry dummyEntry = DummyEntry.DUMMY_ENTRY;
        if (dummyEntry == null) {
            Utils.$$$reportNull$$$0(0);
        }
        return dummyEntry;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/m210projects/Launcher/desktop/newlauncher/Utils", "createGameEntry"));
    }
}

