/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.entries;

import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import ru.m210projects.Blood.Config;
import ru.m210projects.Blood.Main;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.entries.GameEntry;
import ru.m210projects.Launcher.desktop.newlauncher.stores.GameStoreService;
import ru.m210projects.Launcher.desktop.newlauncher.stores.Store;

public class BloodEntry
implements GameEntry {
    private final String appName = "BloodGDX";
    private final GameConfig entryConfig;
    private List<String> missingFilesCache;
    private boolean isDemo = false;

    public BloodEntry(Path homePath) {
        this.missingFilesCache = this.checkAndGetMissingFiles(homePath);
        boolean portable = this.missingFilesCache.isEmpty();
        String configName = "BloodGDX.ini".toLowerCase(Locale.ROOT);
        if (portable) {
            this.entryConfig = new Config(homePath.resolve(Paths.get(configName, new String[0])));
            this.entryConfig.setGamePath(homePath);
        } else {
            this.entryConfig = new Config(homePath.resolve(Paths.get("BloodGDX", configName)));
        }
    }

    @Override
    public URL getLogo() {
        return this.getClass().getResource("/Headers/headerblood.png");
    }

    @Override
    public Game getGame() {
        return Game.BLOOD;
    }

    @Override
    public String[] getFiles() {
        return new String[]{"blood.ini", "blood.rff", "sounds.rff", "tiles000.art", "tables.dat", "surface.dat"};
    }

    @Override
    public String[] getIcons() {
        return new String[]{"Games/Blood/blood16.png", "Games/Blood/blood32.png", "Games/Blood/blood128.png"};
    }

    @Override
    public List<String> checkAndGetMissingFiles(Path directoryPath) {
        this.isDemo = false;
        List<String> missingFiles = GameEntry.super.checkAndGetMissingFiles(directoryPath);
        if (!missingFiles.isEmpty()) {
            System.out.println("BloodGDX: trying to find demo version");
            List<String> missingDemoFiles = this.checkAndGetMissingDemoFiles(directoryPath);
            if (missingDemoFiles.isEmpty()) {
                this.isDemo = true;
                return missingDemoFiles;
            }
            missingFiles.addAll(missingDemoFiles);
        }
        return missingFiles;
    }

    @Override
    public BuildGame getApplication(List<String> args, String version) throws IOException {
        return new Main(args, this.entryConfig, "BloodGDX", version, this.isDemo);
    }

    @Override
    public GameConfig getConfig() {
        return this.entryConfig;
    }

    @Override
    public List<String> setGamePath(Path path) {
        this.entryConfig.setGamePath(path);
        this.missingFilesCache = this.checkAndGetMissingFiles(path);
        return this.missingFilesCache;
    }

    @Override
    public boolean canStart() {
        return this.missingFilesCache.isEmpty();
    }

    @Override
    public void registerStorePath(GameStoreService gameStoreService) {
        gameStoreService.registerGame(Store.GOG, this.getGame(), "[OUWB GOG]:\\GOGONEUNITONEBLOOD", "[FS GOG]:\\Games\\1374469660");
        gameStoreService.registerGame(Store.STEAM, this.getGame(), "[OUWB Steam]:\\One Unit Whole Blood", "[FS Steam]:\\Blood");
    }

    private List<String> checkAndGetMissingDemoFiles(Path directoryPath) {
        LinkedHashSet<String> missingFiles = new LinkedHashSet<String>(Arrays.asList("blood.ini", "blood.rff", "sounds.rff", "share000.art", "tables.dat", "surface.dat"));
        if (Files.exists(directoryPath, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directoryPath);){
                stream.forEach(path -> missingFiles.remove(path.getFileName().toString().toLowerCase(Locale.ROOT)));
            }
            catch (IOException e) {
                Console.out.println(String.format("Failed to check path %s: %s", directoryPath, e), OsdColor.RED);
            }
        }
        return new ArrayList<String>(missingFiles);
    }
}

