/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.entries;

import com.badlogic.gdx.backends.LwjglLauncherUtil;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.stores.GameStoreService;

public interface GameEntry {
    public URL getLogo();

    public Game getGame();

    public String[] getFiles();

    public String[] getIcons();

    public BuildGame getApplication(List<String> var1, String var2) throws IOException;

    public GameConfig getConfig();

    public List<String> setGamePath(Path var1);

    public boolean canStart();

    default public void registerStorePath(GameStoreService gameStoreService) {
    }

    default public void runApplication(List<String> args, String version) {
        if (!this.canStart()) {
            return;
        }
        try {
            LwjglLauncherUtil.launch(this.getApplication(args, version), this.getIcons());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    default public List<String> checkAndGetMissingFiles(Path directoryPath) {
        LinkedHashSet<String> missingFiles = new LinkedHashSet<String>(Arrays.asList(this.getFiles()));
        if (Files.exists(directoryPath, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directoryPath);){
                stream.forEach(path -> missingFiles.remove(path.getFileName().toString().toLowerCase(Locale.ROOT)));
            }
            catch (IOException e) {
                Console.out.println(String.format("Failed to check path %s: %s", directoryPath, e), OsdColor.RED);
            }
        }
        return new ArrayList<String>(missingFiles);
    }
}

