/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.entries;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.LSP.Config;
import ru.m210projects.LSP.Main;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.entries.GameEntry;

public class LSPEntry
implements GameEntry {
    private final String appName = "LSPGDX";
    private final GameConfig entryConfig;
    private List<String> missingFilesCache;

    public LSPEntry(Path homePath) {
        this.missingFilesCache = this.checkAndGetMissingFiles(homePath);
        boolean portable = this.missingFilesCache.isEmpty();
        String configName = "LSPGDX.ini".toLowerCase(Locale.ROOT);
        if (portable) {
            this.entryConfig = new Config(homePath.resolve(Paths.get(configName, new String[0])));
            this.entryConfig.setGamePath(homePath);
        } else {
            this.entryConfig = new Config(homePath.resolve(Paths.get("LSPGDX", configName)));
        }
    }

    @Override
    public URL getLogo() {
        return this.getClass().getResource("/Headers/headerlot7p.png");
    }

    @Override
    public Game getGame() {
        return Game.LEGEND_OF_THE_SEVEN_PALADINS;
    }

    @Override
    public String[] getFiles() {
        return new String[]{"l0art000.dat", "l1art000.dat", "lmart000.dat", "palette.dat", "tables.dat"};
    }

    @Override
    public String[] getIcons() {
        return new String[]{"Games/Lot7P/lot7p16.png", "Games/Lot7P/lot7p32.png", "Games/Lot7P/lot7p128.png"};
    }

    @Override
    public BuildGame getApplication(List<String> args, String version) throws IOException {
        return new Main(args, this.entryConfig, "LSPGDX", version, true);
    }

    @Override
    public GameConfig getConfig() {
        return this.entryConfig;
    }

    @Override
    public List<String> setGamePath(Path path) {
        this.entryConfig.setGamePath(path);
        this.missingFilesCache = this.checkAndGetMissingFiles(path);
        return this.missingFilesCache;
    }

    @Override
    public boolean canStart() {
        return this.missingFilesCache.isEmpty();
    }
}

