/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.entries;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Duke3D.Config;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.entries.GameEntry;
import ru.m210projects.Launcher.desktop.newlauncher.stores.GameStoreService;
import ru.m210projects.Launcher.desktop.newlauncher.stores.Store;

public class NamEntry
implements GameEntry {
    private final String appName = "NamGDX";
    private final GameConfig entryConfig;
    private List<String> missingFilesCache;

    public NamEntry(Path homePath) {
        this.missingFilesCache = this.checkAndGetMissingFiles(homePath);
        boolean portable = this.missingFilesCache.isEmpty();
        String configName = "NamGDX.ini".toLowerCase(Locale.ROOT);
        if (portable) {
            this.entryConfig = new Config(homePath.resolve(Paths.get(configName, new String[0])));
            this.entryConfig.setGamePath(homePath);
        } else {
            this.entryConfig = new Config(homePath.resolve(Paths.get("NamGDX", configName)));
        }
    }

    @Override
    public URL getLogo() {
        return this.getClass().getResource("/Headers/headernam.png");
    }

    @Override
    public Game getGame() {
        return Game.NAM;
    }

    @Override
    public String[] getFiles() {
        return new String[]{"nam.grp", "game.con"};
    }

    @Override
    public String[] getIcons() {
        return new String[]{"Games/Nam/nam16.png", "Games/Nam/nam32.png", "Games/Nam/nam128.png"};
    }

    @Override
    public List<String> checkAndGetMissingFiles(Path directoryPath) {
        List<String> missingFiles = GameEntry.super.checkAndGetMissingFiles(directoryPath);
        if (!missingFiles.isEmpty()) {
            System.out.println("NamGDX: trying to find another version");
            List<String> missingNapalmFiles = this.checkAndGetMissingNapalmFiles(directoryPath);
            if (missingNapalmFiles.isEmpty()) {
                return missingNapalmFiles;
            }
            missingFiles.addAll(missingNapalmFiles);
        }
        return missingFiles;
    }

    @Override
    public BuildGame getApplication(List<String> args, String version) throws IOException {
        return new Main(args, this.entryConfig, "NamGDX", version, 1, true);
    }

    @Override
    public GameConfig getConfig() {
        return this.entryConfig;
    }

    @Override
    public List<String> setGamePath(Path path) {
        this.entryConfig.setGamePath(path);
        this.missingFilesCache = this.checkAndGetMissingFiles(path);
        return this.missingFilesCache;
    }

    @Override
    public boolean canStart() {
        return this.missingFilesCache.isEmpty();
    }

    @Override
    public void registerStorePath(GameStoreService gameStoreService) {
        gameStoreService.registerGame(Store.GOG, this.getGame(), "[GOG]:\\Games\\1575726518");
        gameStoreService.registerGame(Store.STEAM, this.getGame(), "[Steam]:\\Nam" + File.separator + "NAM");
    }

    private List<String> checkAndGetMissingNapalmFiles(Path directoryPath) {
        LinkedHashSet<String> missingFiles = new LinkedHashSet<String>(Arrays.asList("napalm.grp", "game.con"));
        if (Files.exists(directoryPath, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directoryPath);){
                stream.forEach(path -> missingFiles.remove(path.getFileName().toString().toLowerCase(Locale.ROOT)));
            }
            catch (IOException e) {
                Console.out.println(String.format("Failed to check path %s: %s", directoryPath, e), OsdColor.RED);
            }
        }
        return new ArrayList<String>(missingFiles);
    }
}

