/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.entries;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.entries.GameEntry;
import ru.m210projects.Launcher.desktop.newlauncher.stores.GameStoreService;
import ru.m210projects.Launcher.desktop.newlauncher.stores.Store;
import ru.m210projects.Powerslave.Config;
import ru.m210projects.Powerslave.Main;

public class PSlaveEntry
implements GameEntry {
    private final String appName = "PowerslaveGDX";
    private final GameConfig entryConfig;
    private List<String> missingFilesCache;

    public PSlaveEntry(Path homePath) {
        this.missingFilesCache = this.checkAndGetMissingFiles(homePath);
        boolean portable = this.missingFilesCache.isEmpty();
        String configName = "PowerslaveGDX.ini".toLowerCase(Locale.ROOT);
        if (portable) {
            this.entryConfig = new Config(homePath.resolve(Paths.get(configName, new String[0])));
            this.entryConfig.setGamePath(homePath);
        } else {
            this.entryConfig = new Config(homePath.resolve(Paths.get("PowerslaveGDX", configName)));
        }
    }

    @Override
    public URL getLogo() {
        return this.getClass().getResource("/Headers/headerps.png");
    }

    @Override
    public Game getGame() {
        return Game.POWERSLAVE;
    }

    @Override
    public String[] getFiles() {
        return new String[]{"stuff.dat"};
    }

    @Override
    public String[] getIcons() {
        return new String[]{"Games/PS/ps16.png", "Games/PS/ps32.png", "Games/PS/ps128.png"};
    }

    @Override
    public BuildGame getApplication(List<String> args, String version) throws IOException {
        return new Main(args, this.entryConfig, "PowerslaveGDX", version, true);
    }

    @Override
    public GameConfig getConfig() {
        return this.entryConfig;
    }

    @Override
    public List<String> setGamePath(Path path) {
        this.entryConfig.setGamePath(path);
        this.missingFilesCache = this.checkAndGetMissingFiles(path);
        return this.missingFilesCache;
    }

    @Override
    public boolean canStart() {
        return this.missingFilesCache.isEmpty();
    }

    @Override
    public void registerStorePath(GameStoreService gameStoreService) {
        gameStoreService.registerGame(Store.GOG, this.getGame(), "[GOG]:\\Games\\2132611980");
        gameStoreService.registerGame(Store.STEAM, this.getGame(), "[Steam]:\\PowerslaveCE" + File.separator + "PWRSLAVE");
    }
}

