/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.entries;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.entries.GameEntry;
import ru.m210projects.Launcher.desktop.newlauncher.stores.GameStoreService;
import ru.m210projects.Launcher.desktop.newlauncher.stores.Store;
import ru.m210projects.Redneck.Config;
import ru.m210projects.Redneck.Main;

public class RRRAEntry
implements GameEntry {
    private final String appName = "RedneckAgainGDX";
    private final GameConfig entryConfig;
    private List<String> missingFilesCache;

    public RRRAEntry(Path homePath) {
        this.missingFilesCache = this.checkAndGetMissingFiles(homePath);
        boolean portable = this.missingFilesCache.isEmpty();
        String configName = "RedneckAgainGDX.ini".toLowerCase(Locale.ROOT);
        if (portable) {
            this.entryConfig = new Config(homePath.resolve(Paths.get(configName, new String[0])));
            this.entryConfig.setGamePath(homePath);
        } else {
            this.entryConfig = new Config(homePath.resolve(Paths.get("RedneckAgainGDX", configName)));
        }
    }

    @Override
    public URL getLogo() {
        return this.getClass().getResource("/Headers/headerra.png");
    }

    @Override
    public Game getGame() {
        return Game.RR_RIDES_AGAIN;
    }

    @Override
    public String[] getFiles() {
        return new String[]{"redneck.grp"};
    }

    @Override
    public String[] getIcons() {
        return new String[]{"Games/RRRA/rr16.png", "Games/RRRA/rr32.png", "Games/RRRA/rr128.png"};
    }

    @Override
    public BuildGame getApplication(List<String> args, String version) throws IOException {
        return new Main(args, this.entryConfig, "RedneckAgainGDX", version, true);
    }

    @Override
    public GameConfig getConfig() {
        return this.entryConfig;
    }

    @Override
    public List<String> setGamePath(Path path) {
        this.entryConfig.setGamePath(path);
        this.missingFilesCache = this.checkAndGetMissingFiles(path);
        return this.missingFilesCache;
    }

    @Override
    public boolean canStart() {
        return this.missingFilesCache.isEmpty();
    }

    @Override
    public List<String> checkAndGetMissingFiles(Path directoryPath) {
        List<String> missingFiles = GameEntry.super.checkAndGetMissingFiles(directoryPath);
        if (missingFiles.isEmpty()) {
            Path path = directoryPath.resolve("redneck.grp");
            try {
                if (Files.size(path) == 141174222L) {
                    missingFiles.add("redneck.grp (wrong)");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return missingFiles;
    }

    @Override
    public void registerStorePath(GameStoreService gameStoreService) {
        gameStoreService.registerGame(Store.GOG, this.getGame(), "[GOG]:\\GOGCREDNECKRIDESAGAIN");
        gameStoreService.registerGame(Store.STEAM, this.getGame(), "[Steam]:\\Redneck Rampage Rides Again" + File.separator + "AGAIN");
    }
}

