/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.entries;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.entries.GameEntry;
import ru.m210projects.Launcher.desktop.newlauncher.stores.GameStoreService;
import ru.m210projects.Launcher.desktop.newlauncher.stores.Store;
import ru.m210projects.Wang.Config;
import ru.m210projects.Wang.Main;

public class SWEntry
implements GameEntry {
    private final String appName = "WangGDX";
    private final GameConfig entryConfig;
    private List<String> missingFilesCache;

    public SWEntry(Path homePath) {
        this.missingFilesCache = this.checkAndGetMissingFiles(homePath);
        boolean portable = this.missingFilesCache.isEmpty();
        String configName = "WangGDX.ini".toLowerCase(Locale.ROOT);
        if (portable) {
            this.entryConfig = new Config(homePath.resolve(Paths.get(configName, new String[0])));
            this.entryConfig.setGamePath(homePath);
        } else {
            this.entryConfig = new Config(homePath.resolve(Paths.get("WangGDX", configName)));
        }
    }

    @Override
    public URL getLogo() {
        return this.getClass().getResource("/Headers/headersw.png");
    }

    @Override
    public Game getGame() {
        return Game.SHADOW_WARRIOR;
    }

    @Override
    public String[] getFiles() {
        return new String[]{"sw.grp"};
    }

    @Override
    public String[] getIcons() {
        return new String[]{"Games/SW/sw16.png", "Games/SW/sw32.png", "Games/SW/sw128.png"};
    }

    @Override
    public BuildGame getApplication(List<String> args, String version) throws IOException {
        return new Main(args, this.entryConfig, "WangGDX", version, true);
    }

    @Override
    public GameConfig getConfig() {
        return this.entryConfig;
    }

    @Override
    public List<String> setGamePath(Path path) {
        this.entryConfig.setGamePath(path);
        this.missingFilesCache = this.checkAndGetMissingFiles(path);
        return this.missingFilesCache;
    }

    @Override
    public boolean canStart() {
        return this.missingFilesCache.isEmpty();
    }

    @Override
    public void registerStorePath(GameStoreService gameStoreService) {
        gameStoreService.registerGame(Store.GOG, this.getGame(), "[Redux GOG]:\\Games\\1618073558", "[Complete GOG]:\\GOGSHADOWARRIOR");
        gameStoreService.registerGame(Store.STEAM, this.getGame(), "[Redux Steam]:\\Shadow Warrior Classic" + File.separator + "gameroot", "[Classic Steam]:\\Shadow Warrior Original" + File.separator + "gameroot", "[3RDA Steam]:\\Shadow Warrior DOS" + File.separator + "Shadow Warrior");
    }
}

