/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.stores;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.lwjgl.system.Platform;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.stores.GameLabel;
import ru.m210projects.Launcher.desktop.newlauncher.stores.GameLibrary;
import ru.m210projects.Launcher.desktop.newlauncher.stores.GogLibrary;
import ru.m210projects.Launcher.desktop.newlauncher.stores.SteamLibrary;
import ru.m210projects.Launcher.desktop.newlauncher.stores.Store;
import ru.m210projects.Launcher.desktop.newlauncher.stores.WinReg;
import ru.m210projects.Launcher.desktop.newlauncher.stores.WinRegLibrary;

public class GameStoreService {
    private final Map<Game, Set<GameLabel>> allGamePaths = new HashMap<Game, Set<GameLabel>>();
    private final Map<Store, List<GameLibrary>> storeLibraries = new HashMap<Store, List<GameLibrary>>();
    private final Map<Game, List<GameLabel>> checkedGamePaths = new HashMap<Game, List<GameLabel>>();
    private final Platform platform;

    public GameStoreService(Platform platform) {
        this.platform = platform;
        this.storeLibraries.put(Store.STEAM, this.getSteamLibraries(platform));
        this.storeLibraries.put(Store.GOG, this.getGOGLibraries(platform));
        this.storeLibraries.put(Store.ZOOM, Collections.singletonList(new WinRegLibrary("InstallLocation")));
        this.storeLibraries.put(Store.ANTHOLOGY, Collections.singletonList(new WinRegLibrary("")));
    }

    public List<GameLabel> getGameLabels(Game game) {
        if (this.checkedGamePaths.containsKey((Object)game)) {
            return this.checkedGamePaths.get((Object)game);
        }
        ArrayList<GameLabel> result = new ArrayList<GameLabel>();
        for (GameLabel label : (Set)this.allGamePaths.getOrDefault((Object)game, new HashSet())) {
            List libraries = this.storeLibraries.getOrDefault((Object)label.getStore(), new ArrayList());
            for (GameLibrary library : libraries) {
                Path path;
                if (!library.isPlatformSupported(this.platform) || !Files.exists(path = library.resolvePath(label.getPath()), new LinkOption[0])) continue;
                result.add(new GameLabel(label.getStore(), label.getLabel(), path.toString()));
            }
        }
        this.checkedGamePaths.put(game, result);
        return result;
    }

    public void registerGame(Store store, Game entry, String ... paths) {
        Set list = this.allGamePaths.computeIfAbsent(entry, e -> new HashSet());
        for (String s : paths) {
            int index = s.indexOf(":\\");
            String label = s.substring(0, index);
            String path = s.substring(index + 2).trim();
            list.add(new GameLabel(store, label, path));
        }
    }

    private String getSteamFolder(Platform platform) {
        File folder;
        String steamInstall;
        switch (platform) {
            case LINUX: {
                steamInstall = System.getProperty("user.home") + File.separator + ".steam" + File.separator + "steam";
                steamInstall = steamInstall + File.separator + "steamapps" + File.separator;
                break;
            }
            case WINDOWS: {
                steamInstall = WinReg.getRegValue("HKCU\\Software\\Valve\\Steam", "SteamPath");
                if (steamInstall == null) break;
                steamInstall = (steamInstall + File.separator + "steamapps" + File.separator).replace("/", File.separator);
                break;
            }
            case MACOSX: {
                steamInstall = System.getProperty("user.home") + File.separator + "Library" + File.separator + "Application Support" + File.separator + "Steam";
                steamInstall = steamInstall + File.separator + "steamapps" + File.separator;
                break;
            }
            default: {
                return null;
            }
        }
        if (steamInstall != null && !(folder = new File(steamInstall)).exists()) {
            return null;
        }
        return steamInstall;
    }

    private List<GameLibrary> getSteamLibraries(Platform platform) {
        String steamInstall = this.getSteamFolder(platform);
        HashSet<SteamLibrary> steamLibraries = new HashSet<SteamLibrary>();
        if (steamInstall != null) {
            System.out.println("Found Steam folder");
            steamLibraries.add(new SteamLibrary(steamInstall + "common" + File.separator));
            String pathToVdf = steamInstall + "libraryfolders.vdf";
            try {
                Scanner input = new Scanner(new File(pathToVdf));
                String message = input.nextLine();
                if (message.equals("\"LibraryFolders\"")) {
                    while (input.hasNextLine()) {
                        message = input.nextLine();
                        if (!message.startsWith("\t\"") || !Character.isDigit(message.charAt(2))) continue;
                        String[] sentences = message.split("\t");
                        String s = sentences[sentences.length - 1];
                        s = s.replace("\"", "");
                        s = s.replace("\\\\", File.separator);
                        s = s + File.separator + "steamapps" + File.separator + "common" + File.separator;
                        steamLibraries.add(new SteamLibrary(s));
                    }
                } else if (message.equals("\"libraryfolders\"")) {
                    while (input.hasNextLine()) {
                        message = input.nextLine();
                        if (!message.startsWith("\t\t\"path\"")) continue;
                        String[] sentences = message.split("\t");
                        String s = sentences[sentences.length - 1];
                        s = s.replace("\"", "");
                        s = s.replace("\\\\", File.separator);
                        s = s + File.separator + "steamapps" + File.separator + "common" + File.separator;
                        steamLibraries.add(new SteamLibrary(s));
                    }
                }
                input.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return new ArrayList<GameLibrary>(steamLibraries);
            }
        }
        System.out.println("Steam folder not found");
        return new ArrayList<GameLibrary>(steamLibraries);
    }

    private List<GameLibrary> getGOGLibraries(Platform platform) {
        ArrayList<GameLibrary> gogLibraries = new ArrayList<GameLibrary>();
        switch (platform) {
            case LINUX: {
                break;
            }
            case WINDOWS: {
                String[] gogpaths;
                for (String path : gogpaths = new String[]{"HKLM\\Software\\WOW6432Node\\GOG.com", "HKLM\\Software\\GOG.com"}) {
                    if (WinReg.getRegValue(path, "") == null) continue;
                    gogLibraries.add(new GogLibrary(path));
                }
                break;
            }
        }
        if (!gogLibraries.isEmpty()) {
            System.out.println("Found GOG folder");
        }
        return gogLibraries;
    }
}

