/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.stores;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Objects;
import org.lwjgl.system.Platform;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Launcher.desktop.newlauncher.stores.GameLibrary;
import ru.m210projects.Launcher.desktop.newlauncher.stores.WinReg;

public class GogLibrary
implements GameLibrary {
    private final String storePath;

    public GogLibrary(String storePath) {
        this.storePath = storePath;
    }

    @Override
    public Path resolvePath(String gamePath) {
        String pathToGame = WinReg.getRegValue(this.storePath + "\\" + gamePath, "path");
        if (pathToGame != null) {
            return Paths.get(pathToGame, new String[0]);
        }
        return FileEntry.DUMMY_PATH;
    }

    @Override
    public boolean isPlatformSupported(Platform platform) {
        return platform == Platform.WINDOWS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GogLibrary that = (GogLibrary)o;
        return Objects.equals(this.storePath.toLowerCase(Locale.ROOT), that.storePath.toLowerCase(Locale.ROOT));
    }

    public int hashCode() {
        return Objects.hash(this.storePath.toLowerCase(Locale.ROOT));
    }
}

