/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Insets;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lwjgl.system.Platform;
import ru.m210projects.Build.Architecture.DialogUtil;
import ru.m210projects.Build.Architecture.MessageType;
import ru.m210projects.Build.Architecture.common.audio.MidiDevice;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Launcher.desktop.Main;
import ru.m210projects.Launcher.desktop.newlauncher.Controller;
import ru.m210projects.Launcher.desktop.newlauncher.View;
import ru.m210projects.Launcher.desktop.newlauncher.entries.Game;
import ru.m210projects.Launcher.desktop.newlauncher.entries.GameEntry;
import ru.m210projects.Launcher.desktop.newlauncher.ui.AboutPanel;
import ru.m210projects.Launcher.desktop.newlauncher.ui.DirectoryBrowser;
import ru.m210projects.Launcher.desktop.newlauncher.ui.GamePanel;
import ru.m210projects.Launcher.desktop.newlauncher.ui.SettingsPanel;
import ru.m210projects.Launcher.desktop.newlauncher.update.CheckUpdateResponse;
import ru.m210projects.Launcher.desktop.newlauncher.update.ModelEventListener;

public class LauncherView
extends JFrame
implements View,
ModelEventListener {
    private Controller controller;
    private GamePanel gamePanel;
    private AboutPanel aboutPanel;
    private SettingsPanel settingsPanel;
    private JPanel root;
    private JButton bloodButton;
    private JButton duke3DButton;
    private JPanel logoPanel;
    private JPanel contextPanel;
    private JButton aboutButton;
    private JButton namButton;
    private JButton shadowWarriorButton;
    private JButton redneckRampageButton;
    private JButton rrRidesAgainButton;
    private JButton powerslaveButton;
    private JButton tekWarButton;
    private JButton witchavenButton;
    private JButton witchaven2Button;
    private JButton sevenPaladinsButton;
    private JButton backButton;
    private JPanel buttonPanel;

    public LauncherView(Set<GameEntry> entrySet) {
        this.$$$setupUI$$$();
        this.setContentPane(this.root);
        this.setTitle("BuildGDX " + Main.appversion);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        URL iconUrl = this.getClass().getResource("/Games/build32.png");
        if (iconUrl != null) {
            this.setIconImage(new ImageIcon(iconUrl).getImage());
        }
        for (GameEntry entry : entrySet) {
            JLabel gameLabel = new JLabel();
            URL location = entry.getLogo();
            if (location == null) continue;
            gameLabel.setIcon(new ImageIcon(location));
            this.logoPanel.add((Component)gameLabel, "logo" + entry.getGame().getShortName());
        }
        this.gamePanel.registerStorePaths(entrySet);
    }

    public void oneGameMode(Game game) {
        this.buttonPanel.setVisible(false);
        this.settingsPanel.oneGameMode(game);
    }

    public void start() {
        this.bloodButton.addActionListener(e -> this.controller.onChooseGame(Game.BLOOD));
        this.duke3DButton.addActionListener(e -> this.controller.onChooseGame(Game.DUKE_NUKEM_3D));
        this.namButton.addActionListener(e -> this.controller.onChooseGame(Game.NAM));
        this.shadowWarriorButton.addActionListener(e -> this.controller.onChooseGame(Game.SHADOW_WARRIOR));
        this.redneckRampageButton.addActionListener(e -> this.controller.onChooseGame(Game.REDNECK_RAMPAGE));
        this.rrRidesAgainButton.addActionListener(e -> this.controller.onChooseGame(Game.RR_RIDES_AGAIN));
        this.powerslaveButton.addActionListener(e -> this.controller.onChooseGame(Game.POWERSLAVE));
        this.tekWarButton.addActionListener(e -> this.controller.onChooseGame(Game.TEKWAR));
        this.witchavenButton.addActionListener(e -> this.controller.onChooseGame(Game.WITCHAVEN));
        this.witchaven2Button.addActionListener(e -> this.controller.onChooseGame(Game.WITCHAVEN_2));
        this.sevenPaladinsButton.addActionListener(e -> this.controller.onChooseGame(Game.LEGEND_OF_THE_SEVEN_PALADINS));
        this.aboutButton.addActionListener(e -> this.controller.onOpenAbout());
        this.backButton.addActionListener(e -> this.controller.onBack());
        this.aboutPanel.initListeners(this.controller);
        this.gamePanel.initListeners(this.controller);
        this.settingsPanel.initListeners(this.controller);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public Path showDirectoryChooser(Path path, GameEntry entry) {
        return DirectoryBrowser.showDirectoryChooser(this, path, entry.getGame().getName(), ClassLoader.getSystemResource(entry.getIcons()[0]));
    }

    @Override
    public void startGame(Runnable launchCallback) {
        this.gamePanel.startGame();
        SwingUtilities.invokeLater(() -> {
            this.dispose();
            launchCallback.run();
        });
    }

    @Override
    public void chooseGame(Game game) {
        this.gamePanel.chooseGame(game);
        ((CardLayout)this.logoPanel.getLayout()).show(this.logoPanel, "logo" + game.getShortName());
        ((CardLayout)this.contextPanel.getLayout()).show(this.contextPanel, "gamePanel");
        this.aboutButton.setEnabled(true);
    }

    @Override
    public void openSettings(GameConfig config) {
        this.settingsPanel.openSettings(config);
        ((CardLayout)this.contextPanel.getLayout()).show(this.contextPanel, "settingsPanel");
        this.aboutButton.setEnabled(true);
    }

    @Override
    public void setBackButtonEnable(boolean enable) {
        this.backButton.setEnabled(enable);
    }

    @Override
    public void setGamePath(Path path) {
        this.gamePanel.setGamePath(path);
    }

    @Override
    public void openAbout() {
        ((CardLayout)this.logoPanel.getLayout()).show(this.logoPanel, "logoBuild");
        ((CardLayout)this.contextPanel.getLayout()).show(this.contextPanel, "aboutPanel");
        this.aboutButton.setEnabled(false);
    }

    @Override
    public void openWebpage(String address) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URL(address).toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void openFolder(Path path) {
        try {
            if (Platform.get() == Platform.WINDOWS) {
                Runtime.getRuntime().exec("explorer " + path);
            } else {
                Desktop.getDesktop().open(path.toFile());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showMissingFiles(List<String> missingFiles) {
        this.gamePanel.showMissingFiles(missingFiles);
    }

    @Override
    public void updateMidiDevices(List<MidiDevice> deviceList, String selectedDevice) {
        this.settingsPanel.updateMidiDevices(deviceList, selectedDevice);
    }

    @Override
    public void setMidiDevice(MidiDevice device) {
        this.settingsPanel.setMidiDevice(device);
    }

    @Override
    public boolean onUpdateResult(CheckUpdateResponse response, String resultText) {
        switch (response) {
            case UPDATE_AVAILABLE: {
                this.setTitle("BuildGDX " + Main.appversion + " (new BuildGDX " + resultText + ")");
                DialogUtil.DialogResult result = Main.showMessage("New version available", "Do you want to download new version of BuildGDX " + resultText + "?", MessageType.Question);
                return result.isApproved();
            }
            case UPDATE_ERROR: {
                Main.showMessage("Update error", resultText, MessageType.Error);
            }
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        SettingsPanel settingsPanel;
        AboutPanel aboutPanel;
        GamePanel gamePanel;
        JPanel jPanel;
        JPanel jPanel2;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JButton jButton7;
        JButton jButton8;
        JButton jButton9;
        JButton jButton10;
        JButton jButton11;
        JButton jButton12;
        JButton jButton13;
        JPanel jPanel3;
        JPanel jPanel4;
        this.root = jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(2, 4, new Insets(10, 10, 10, 10), -1, -1, false, false));
        this.buttonPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(13, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 2, 1, 8, 2, 0, 3, null, null, null));
        this.bloodButton = jButton13 = new JButton();
        jButton13.setHorizontalAlignment(2);
        jButton13.setIcon(new ImageIcon(this.getClass().getResource("/Games/Blood/blood16.png")));
        jButton13.setText("Blood");
        jPanel3.add((Component)jButton13, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.duke3DButton = jButton12 = new JButton();
        jButton12.setHorizontalAlignment(2);
        jButton12.setIcon(new ImageIcon(this.getClass().getResource("/Games/Duke3D/duke16.png")));
        jButton12.setText("Duke Nukem 3D");
        jPanel3.add((Component)jButton12, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.namButton = jButton11 = new JButton();
        jButton11.setHorizontalAlignment(2);
        jButton11.setIcon(new ImageIcon(this.getClass().getResource("/Games/Nam/nam16.png")));
        jButton11.setText("NAM");
        jPanel3.add((Component)jButton11, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.shadowWarriorButton = jButton10 = new JButton();
        ((Component)jButton10).setEnabled(true);
        jButton10.setHorizontalAlignment(2);
        jButton10.setIcon(new ImageIcon(this.getClass().getResource("/Games/SW/sw16.png")));
        jButton10.setText("Shadow Warrior");
        jPanel3.add((Component)jButton10, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.redneckRampageButton = jButton9 = new JButton();
        jButton9.setHorizontalAlignment(2);
        jButton9.setIcon(new ImageIcon(this.getClass().getResource("/Games/RR/rr16.png")));
        jButton9.setText("Redneck Rampage");
        jPanel3.add((Component)jButton9, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.rrRidesAgainButton = jButton8 = new JButton();
        jButton8.setHorizontalAlignment(2);
        jButton8.setIcon(new ImageIcon(this.getClass().getResource("/Games/RRRA/rr16.png")));
        jButton8.setText("RR Rides Again");
        jPanel3.add((Component)jButton8, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.powerslaveButton = jButton7 = new JButton();
        ((Component)jButton7).setEnabled(true);
        jButton7.setHorizontalAlignment(2);
        jButton7.setIcon(new ImageIcon(this.getClass().getResource("/Games/PS/ps16.png")));
        jButton7.setText("Powerslave");
        jPanel3.add((Component)jButton7, new GridConstraints(6, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.tekWarButton = jButton6 = new JButton();
        jButton6.setHorizontalAlignment(2);
        jButton6.setIcon(new ImageIcon(this.getClass().getResource("/Games/Tekwar/tekwar16.png")));
        jButton6.setText("TekWar");
        jPanel3.add((Component)jButton6, new GridConstraints(7, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.witchavenButton = jButton5 = new JButton();
        jButton5.setHorizontalAlignment(2);
        jButton5.setIcon(new ImageIcon(this.getClass().getResource("/Games/WH/wh16.png")));
        jButton5.setText("Witchaven");
        jPanel3.add((Component)jButton5, new GridConstraints(8, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.witchaven2Button = jButton4 = new JButton();
        jButton4.setHorizontalAlignment(2);
        jButton4.setIcon(new ImageIcon(this.getClass().getResource("/Games/WH2/whii16.png")));
        jButton4.setText("Witchaven II");
        jPanel3.add((Component)jButton4, new GridConstraints(9, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.sevenPaladinsButton = jButton3 = new JButton();
        jButton3.setHorizontalAlignment(2);
        jButton3.setIcon(new ImageIcon(this.getClass().getResource("/Games/Lot7P/lot7p16.png")));
        jButton3.setText("Seven Paladins");
        jPanel3.add((Component)jButton3, new GridConstraints(10, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(11, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.aboutButton = jButton2 = new JButton();
        jButton2.setHorizontalAlignment(2);
        jButton2.setIcon(new ImageIcon(this.getClass().getResource("/Games/build16.png")));
        jButton2.setText("About");
        jPanel3.add((Component)jButton2, new GridConstraints(12, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.logoPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(this.getClass().getResource("/Headers/headerbuild.png")));
        jLabel.setText("");
        jPanel2.add((Component)jLabel, "logoBuild");
        this.contextPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(10, 10));
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.gamePanel = gamePanel = new GamePanel();
        JComponent jComponent = gamePanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, "gamePanel");
        this.aboutPanel = aboutPanel = new AboutPanel();
        JComponent jComponent2 = aboutPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent2, "aboutPanel");
        this.settingsPanel = settingsPanel = new SettingsPanel();
        JComponent jComponent3 = settingsPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent3, "settingsPanel");
        this.backButton = jButton = new JButton();
        jButton.setText("Back");
        jPanel4.add((Component)jButton, new GridConstraints(1, 3, 1, 1, 4, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }
}

