/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.newlauncher.update;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class AppUpdater {
    public static final String VERSION = "1.0";

    public static void main(String[] args) throws Exception {
        block15: {
            System.out.println("Updater started");
            int timeout = 5000;
            long startWait = System.currentTimeMillis();
            while (System.in.available() == 0) {
                if (System.currentTimeMillis() - startWait < 5000L) continue;
                AppUpdater.showError("Parameters input timeout");
                throw new RuntimeException("Parameters input timeout");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));){
                String updaterVersion = reader.readLine();
                if (!VERSION.equals(updaterVersion)) {
                    AppUpdater.showError("Updater version is wrong!");
                    throw new RuntimeException("Updater version is wrong!");
                }
                String applicationName = "update.jar";
                Path javaExecutablePath = Paths.get(reader.readLine(), new String[0]);
                Path applicationPath = Paths.get(reader.readLine(), new String[0]);
                String currentVersion = reader.readLine();
                Path tempDirectory = Paths.get(reader.readLine(), new String[0]);
                try (Stream<Path> stream = Files.list(tempDirectory);){
                    List pathList = stream.map(Path::normalize).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                    Path src = pathList.stream().filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().equalsIgnoreCase(applicationName)).findFirst().orElse(Paths.get(applicationName, new String[0]));
                    if (!Files.exists(src, new LinkOption[0])) {
                        AppUpdater.showError("Can't update the application, because the file \"" + src.getFileName() + "\" is not found");
                        throw new FileNotFoundException(src.getFileName().toString());
                    }
                    System.out.println("Ready to replace");
                    if (AppUpdater.renameOldApplication(applicationPath, currentVersion)) {
                        Files.move(src, applicationPath, StandardCopyOption.REPLACE_EXISTING);
                        String command = String.format("%s -jar %s -updated", javaExecutablePath, applicationPath);
                        Runtime.getRuntime().exec(command);
                        break block15;
                    }
                    AppUpdater.showError("Can't update the application, while file \"" + applicationPath + "\" is locked");
                    throw new RuntimeException("Update error, because file " + applicationPath + " is locked");
                }
            }
        }
    }

    public static boolean renameOldApplication(Path path, String version) throws InterruptedException {
        if (!Files.exists(path, new LinkOption[0])) {
            return true;
        }
        String filename = path.toFile().getName();
        if (filename.contains(".")) {
            filename = filename.substring(0, filename.lastIndexOf(46));
        }
        filename = filename + "_" + version + ".jar";
        String errorMessage = "";
        for (int repeats = 0; repeats != 50; ++repeats) {
            try {
                Files.move(path, path.resolveSibling(filename), StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
            catch (Exception e) {
                errorMessage = e.toString();
                Thread.sleep(300L);
                continue;
            }
        }
        AppUpdater.showError(errorMessage);
        return false;
    }

    private static void showError(String message) {
        JOptionPane panel = new JOptionPane();
        panel.setMessageType(0);
        panel.setMessage(message);
        panel.setOptionType(-1);
        JDialog dialog = panel.createDialog("Update error");
        dialog.setAlwaysOnTop(true);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
        AppUpdater.writeLog(message);
    }

    private static void writeLog(String message) {
        try {
            FileWriter writer = new FileWriter("appupdater.log", true);
            LocalDateTime date = LocalDateTime.now();
            writer.write(String.format("[%s] Update error: %s\n", date.format(DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm")), message));
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

