/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.AnimStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Anim {
    public static final int MAX_LIL_ANIM = 400;
    public static int nAnimsFree;
    public static final byte[] AnimFlags;
    public static final AnimStruct[] AnimList;
    private static final int[] AnimsFree;
    private static final int[] AnimRunRec;

    public static void InitAnims() {
        for (int i = 0; i < 400; i = (int)((short)(i + 1))) {
            Anim.AnimsFree[i] = i;
            if (AnimList[i] == null) continue;
            Anim.AnimList[i].nSprite = -1;
        }
        nAnimsFree = 400;
        Globals.nMagicSeq = Seq.SeqOffsets[41] + 21;
        Globals.nPreMagicSeq = Seq.SeqOffsets[64];
        Globals.nSavePointSeq = Seq.SeqOffsets[41] + 12;
    }

    public static void saveAnm(OutputStream os) throws IOException {
        int i;
        int nAnims = 0;
        for (i = 0; i < 400; ++i) {
            if (AnimList[i] == null || Anim.AnimList[i].nSprite == -1) continue;
            ++nAnims;
        }
        StreamUtils.writeShort(os, nAnimsFree);
        for (i = 0; i < 400; ++i) {
            StreamUtils.writeShort(os, AnimsFree[i]);
            StreamUtils.writeShort(os, AnimRunRec[i]);
            StreamUtils.writeByte(os, AnimFlags[i]);
        }
        if (nAnims != 0) {
            for (i = 0; i < 400; ++i) {
                if (AnimList[i] == null || Anim.AnimList[i].nSprite == -1) continue;
                StreamUtils.writeShort(os, i);
                AnimList[i].save(os);
            }
        }
    }

    public static void loadAnm(SafeLoader loader) {
        nAnimsFree = loader.nAnimsFree;
        System.arraycopy(loader.AnimsFree, 0, AnimsFree, 0, 400);
        System.arraycopy(loader.AnimRunRec, 0, AnimRunRec, 0, 400);
        System.arraycopy(loader.AnimFlags, 0, AnimFlags, 0, 400);
        for (int i = 0; i < 400; ++i) {
            if (AnimList[i] != null) {
                Anim.AnimList[i].nSprite = -1;
            }
            if (loader.AnimList[i] == null || loader.AnimList[i].nSprite == -1) continue;
            if (AnimList[i] == null) {
                Anim.AnimList[i] = new AnimStruct();
            }
            AnimList[i].copy(loader.AnimList[i]);
        }
        Globals.nMagicSeq = Seq.SeqOffsets[41] + 21;
        Globals.nPreMagicSeq = Seq.SeqOffsets[64];
        Globals.nSavePointSeq = Seq.SeqOffsets[41] + 12;
    }

    public static void loadAnm(SafeLoader loader, InputStream is) throws IOException {
        int i;
        for (i = 0; i < 400; ++i) {
            if (loader.AnimList[i] == null) continue;
            loader.AnimList[i].nSprite = -1;
        }
        loader.nAnimsFree = StreamUtils.readShort(is);
        for (i = 0; i < 400; ++i) {
            loader.AnimsFree[i] = StreamUtils.readShort(is);
            loader.AnimRunRec[i] = StreamUtils.readShort(is);
            loader.AnimFlags[i] = StreamUtils.readByte(is);
        }
        for (int nAnims = 400 - loader.nAnimsFree; nAnims > 0; --nAnims) {
            short i2 = StreamUtils.readShort(is);
            if (loader.AnimList[i2] == null) {
                loader.AnimList[i2] = new AnimStruct();
            }
            loader.AnimList[i2].load(is);
        }
    }

    public static int BuildAnim(int spr, int a2, int a3, int x, int y, int z, int sectnum, int size, int flags) {
        if (--nAnimsFree != 0) {
            int nAnim = AnimsFree[nAnimsFree];
            Sprite pSprite = Main.boardService.getSprite(spr);
            if (pSprite == null) {
                spr = Main.engine.insertsprite(sectnum, 500);
                pSprite = Main.boardService.getSprite(spr);
            }
            if (pSprite == null) {
                return -1;
            }
            pSprite.setY(y);
            pSprite.setZ(z);
            pSprite.setX(x);
            pSprite.setCstat(0);
            if ((flags & 4) != 0) {
                pSprite.setPal(4);
                pSprite.setShade(-64);
            } else {
                pSprite.setPal(0);
                pSprite.setShade(-12);
            }
            pSprite.setClipdist(10);
            pSprite.setXrepeat(size);
            pSprite.setYrepeat(size);
            pSprite.setPicnum(1);
            pSprite.setAng(0);
            pSprite.setXoffset(0);
            pSprite.setYoffset(0);
            pSprite.setXvel(0);
            pSprite.setZvel(0);
            pSprite.setYvel(0);
            if (pSprite.getStatnum() < 900) {
                pSprite.setHitag(-1);
            }
            pSprite.setLotag(RunList.HeadRun() + 1);
            pSprite.setOwner(-1);
            pSprite.setExtra(RunList.AddRunRec(pSprite.getLotag() - 1, 0x100000 | nAnim));
            Anim.AnimRunRec[nAnim] = RunList.AddRunRec(RunList.NewRun, 0x100000 | nAnim);
            Anim.AnimFlags[nAnim] = (byte)flags;
            if ((flags & 0x80) != 0) {
                pSprite.setCstat(pSprite.getCstat() | 2);
            }
            if (AnimList[nAnim] == null) {
                Anim.AnimList[nAnim] = new AnimStruct();
            }
            Anim.AnimList[nAnim].nAction = a3 + Seq.SeqOffsets[a2];
            Anim.AnimList[nAnim].nSeq = 0;
            Anim.AnimList[nAnim].nSprite = spr;
            return nAnim;
        }
        return -1;
    }

    public static int GetAnimSprite(int a1) {
        return Anim.AnimList[a1].nSprite;
    }

    public static void DestroyAnim(int a1) {
        int nSprite = Anim.AnimList[a1].nSprite;
        if (nSprite >= 0) {
            Sound.StopSpriteSound(nSprite);
            RunList.SubRunRec(AnimRunRec[a1]);
            Sprite pSprite = Main.boardService.getSprite(nSprite);
            if (pSprite == null) {
                return;
            }
            RunList.DoSubRunRec(pSprite.getExtra());
            RunList.FreeRun(pSprite.getLotag() - 1);
        }
        Anim.AnimList[a1].nSprite = -1;
        if (nAnimsFree == 400) {
            return;
        }
        Anim.AnimsFree[Anim.nAnimsFree] = a1;
        ++nAnimsFree;
    }

    public static void FuncAnim(int nStack, int ignored, int a3) {
        int nAnim = RunList.RunData[a3].getObject();
        if (nAnim < 0 || nAnim >= 400) {
            throw new AssertException("nAnim>=0 && nAnim<MAX_LIL_ANIM");
        }
        int nSprite = Anim.AnimList[nAnim].nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int nSeq = Anim.AnimList[nAnim].nAction;
        switch (nStack & 0x7F0000) {
            case 131072: {
                short nSource;
                Sprite pSource;
                if ((pSprite.getCstat() & 0x8000) == 0) {
                    Seq.MoveSequence(nSprite, nSeq, Anim.AnimList[nAnim].nSeq);
                }
                if (pSprite.getStatnum() != 404 || (pSource = Main.boardService.getSprite(nSource = pSprite.getHitag())) == null) break;
                pSprite.setX(pSource.getX());
                pSprite.setY(pSource.getY());
                pSprite.setZ(pSource.getZ());
                short v11 = pSource.getSectnum();
                if (v11 != pSprite.getSectnum()) {
                    if (v11 < 0 || v11 >= 1024) {
                        Anim.DestroyAnim(nAnim);
                        Main.engine.mydeletesprite(nSprite);
                        return;
                    }
                    Main.engine.mychangespritesect(nSprite, v11);
                }
                if (Anim.AnimList[nAnim].nSeq != 0) break;
                short v13 = pSource.getHitag();
                if (pSource.getCstat() != Short.MIN_VALUE) {
                    pSource.setHitag(pSource.getHitag() - 1);
                }
                if (pSource.getCstat() == Short.MIN_VALUE || v13 < 15) {
                    pSource.setHitag(1);
                    Anim.DestroyAnim(nAnim);
                    Main.engine.mydeletesprite(nSprite);
                    break;
                }
                Sprites.DamageEnemy(nSource, -1, 2 * (pSource.getHitag() - 14));
                if (pSource.getShade() < 100) {
                    pSource.setPal(0);
                    pSource.setShade(pSource.getShade() + 1);
                }
                if ((pSource.getCstat() & 0x101) != 0) break;
                Anim.DestroyAnim(nAnim);
                Main.engine.mydeletesprite(nSprite);
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get((short)(nStack & 0xFFFF));
                Seq.PlotSequence(tsp, nSeq, Anim.AnimList[nAnim].nSeq, 257);
                return;
            }
            default: {
                return;
            }
        }
        if (++Anim.AnimList[nAnim].nSeq < Seq.SeqSize[nSeq]) {
            return;
        }
        if ((AnimFlags[nAnim] & 0x10) != 0) {
            Anim.AnimList[nAnim].nSeq = 0;
            return;
        }
        if (nSeq == Globals.nPreMagicSeq) {
            Anim.AnimList[nAnim].nSeq = 0;
            Anim.AnimList[nAnim].nAction = Globals.nMagicSeq;
            int n = nAnim;
            AnimFlags[n] = (byte)(AnimFlags[n] | 0x10);
            Sprite spr = Main.boardService.getSprite(Anim.AnimList[nAnim].nSprite);
            if (spr != null) {
                spr.setCstat(spr.getCstat() | 2);
            }
            return;
        }
        if (nSeq == Globals.nSavePointSeq) {
            Anim.AnimList[nAnim].nSeq = Globals.nSavePointSeq ^ nSeq;
            ++Anim.AnimList[nAnim].nAction;
            int n = nAnim;
            AnimFlags[n] = (byte)(AnimFlags[n] | 0x10);
            return;
        }
        Anim.DestroyAnim(nAnim);
        Main.engine.mydeletesprite(nSprite);
    }

    static {
        AnimFlags = new byte[400];
        AnimList = new AnimStruct[400];
        AnimsFree = new int[400];
        AnimRunRec = new int[400];
    }
}

