/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import com.badlogic.gdx.math.Vector2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Render.RenderedSpriteList;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.BulletInfo;
import ru.m210projects.Powerslave.Type.BulletStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Weapons;

public class Bullet {
    public static final BulletInfo[] BulletInfo = new BulletInfo[]{new BulletInfo(25, 1, 20, -1, -1, 13, 0, 0, -1), new BulletInfo(25, -1, 65000, -1, 31, 73, 0, 0, -1), new BulletInfo(15, -1, 60000, -1, 31, 73, 0, 0, -1), new BulletInfo(5, 15, 2000, -1, 14, 38, 4, 5, 3), new BulletInfo(250, 100, 2000, -1, 33, 34, 4, 20, -1), new BulletInfo(200, -1, 2000, -1, 20, 23, 4, 10, -1), new BulletInfo(200, -1, 60000, 68, 68, -1, -1, 0, -1), new BulletInfo(300, 1, 0, -1, -1, -1, 0, 50, -1), new BulletInfo(18, -1, 2000, -1, 18, 29, 4, 0, -1), new BulletInfo(20, -1, 2000, 37, 11, 30, 4, 0, -1), new BulletInfo(25, -1, 3000, -1, 44, 36, 4, 15, 90), new BulletInfo(30, -1, 1000, -1, 52, 53, 4, 20, 48), new BulletInfo(20, -1, 3500, -1, 54, 55, 4, 30, -1), new BulletInfo(10, -1, 5000, -1, 57, 76, 4, 0, -1), new BulletInfo(40, -1, 1500, -1, 63, 38, 4, 10, 40), new BulletInfo(20, -1, 2000, -1, 60, 12, 0, 0, -1), new BulletInfo(5, -1, 60000, -1, 31, 76, 0, 0, -1)};
    public static int lasthitx;
    public static int lasthity;
    public static int lasthitz;
    public static int lasthitsect;
    public static int lasthitwall;
    public static int lasthitsprite;
    private static final Vector2 tmpVec;
    private static final BulletStruct tmpBullet;
    private static final BulletStruct.BulletResult bulletResult;
    private static int nBulletCount;
    private static int nBulletsFree;
    private static final int[] BulletFree;
    private static final int[] nBulletEnemy;
    private static final BulletStruct[] BulletList;

    public static void InitBullets() {
        nBulletCount = 0;
        nBulletsFree = 500;
        for (int i = 0; i < 500; ++i) {
            Bullet.BulletFree[i] = i;
            Bullet.BulletList[i] = new BulletStruct();
        }
        Arrays.fill(nBulletEnemy, -1);
    }

    public static void saveBullets(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, nBulletCount);
        StreamUtils.writeShort(os, nBulletsFree);
        for (int i = 0; i < 500; ++i) {
            StreamUtils.writeShort(os, BulletFree[i]);
            StreamUtils.writeShort(os, nBulletEnemy[i]);
            BulletList[i].save(os);
        }
        StreamUtils.writeInt(os, lasthitx);
        StreamUtils.writeInt(os, lasthity);
        StreamUtils.writeInt(os, lasthitz);
        StreamUtils.writeShort(os, lasthitsect);
        StreamUtils.writeShort(os, lasthitwall);
        StreamUtils.writeShort(os, lasthitsprite);
    }

    public static void loadBullets(SafeLoader loader) {
        nBulletCount = loader.nBulletCount;
        nBulletsFree = loader.nBulletsFree;
        System.arraycopy(loader.BulletFree, 0, BulletFree, 0, 500);
        System.arraycopy(loader.nBulletEnemy, 0, nBulletEnemy, 0, 500);
        for (int i = 0; i < 500; ++i) {
            if (BulletList[i] == null) {
                Bullet.BulletList[i] = new BulletStruct();
            }
            BulletList[i].copy(loader.BulletList[i]);
        }
        lasthitx = loader.lasthitx;
        lasthity = loader.lasthity;
        lasthitz = loader.lasthitz;
        lasthitsect = loader.lasthitsect;
        lasthitwall = loader.lasthitwall;
        lasthitsprite = loader.lasthitsprite;
    }

    public static void loadBullets(SafeLoader loader, InputStream is) throws IOException {
        loader.nBulletCount = StreamUtils.readShort(is);
        loader.nBulletsFree = StreamUtils.readShort(is);
        for (int i = 0; i < 500; ++i) {
            loader.BulletFree[i] = StreamUtils.readShort(is);
            loader.nBulletEnemy[i] = StreamUtils.readShort(is);
            if (loader.BulletList[i] == null) {
                loader.BulletList[i] = new BulletStruct();
            }
            loader.BulletList[i].load(is);
        }
        loader.lasthitx = StreamUtils.readInt(is);
        loader.lasthity = StreamUtils.readInt(is);
        loader.lasthitz = StreamUtils.readInt(is);
        loader.lasthitsect = StreamUtils.readShort(is);
        loader.lasthitwall = StreamUtils.readShort(is);
        loader.lasthitsprite = StreamUtils.readShort(is);
    }

    public static int GrabBullet() {
        return BulletFree[--nBulletsFree];
    }

    public static void DestroyBullet(int nBullet) {
        int nSprite = Bullet.BulletList[nBullet].nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        RunList.DoSubRunRec(Bullet.BulletList[nBullet].bull_6);
        RunList.DoSubRunRec(pSprite.getLotag() - 1);
        RunList.SubRunRec(Bullet.BulletList[nBullet].bull_8);
        Sound.StopSpriteSound(nSprite);
        Main.engine.mydeletesprite(nSprite);
        Bullet.BulletFree[Bullet.nBulletsFree] = nBullet;
        ++nBulletsFree;
    }

    public static void IgniteSprite(int nSprite) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        pSprite.setHitag(pSprite.getHitag() + 2);
        int nAnimSprite = Anim.GetAnimSprite(Anim.BuildAnim(-1, 38, 0, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), 40, 20));
        Sprite pAnimSprite = Main.boardService.getSprite(nAnimSprite);
        if (pAnimSprite == null) {
            return;
        }
        pAnimSprite.setHitag(nSprite);
        Main.engine.changespritestat(nAnimSprite, 404);
        pAnimSprite.setYrepeat(Math.max(32 * Main.engine.getTile(pAnimSprite.getPicnum()).getHeight() / Globals.nFlameHeight, 1));
    }

    public static void BulletHitsSprite(BulletStruct pBullet, int nSource, int nDest, int x, int y, int z, int sectnum) {
        BulletInfo pBulletInfo = BulletInfo[pBullet.type];
        Sprite pDest = Main.boardService.getSprite(nDest);
        if (pDest == null) {
            return;
        }
        int type = pBullet.type;
        short statnum = pDest.getStatnum();
        switch (type) {
            case 14: {
                if (statnum > 107 || statnum == 98) {
                    return;
                }
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                Sprite pSprite;
                if (statnum == 0 || statnum > 98 || (pSprite = Main.boardService.getSprite(pBullet.nSprite)) == null) break;
                if (statnum == 98) {
                    int v20 = pSprite.getAng() + 256 - Random.RandomSize(9);
                    pDest.setXvel(2 * EngineUtils.sin(v20 + 512 & 0x7FF));
                    pDest.setYvel(2 * EngineUtils.sin(v20 & 0x7FF));
                    pDest.setZvel(-256 * (Random.RandomSize(3) + 1));
                    break;
                }
                short v15 = pDest.getXvel();
                short v17 = pDest.getYvel();
                pDest.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 2);
                pDest.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 2);
                Enemy.MoveCreature(nDest);
                pDest.setXvel(v15);
                pDest.setYvel(v17);
                break;
            }
            case 3: {
                if (statnum <= 107 && statnum != 98) {
                    pDest.setHitag(pDest.getHitag() + 1);
                    if (pDest.getHitag() == 15) {
                        Bullet.IgniteSprite(nDest);
                    }
                    if (Random.RandomSize(2) == 0) {
                        Anim.BuildAnim(-1, pBulletInfo.inf_C, 0, x, y, z, sectnum, 40, pBulletInfo.flags);
                        return;
                    }
                }
                return;
            }
        }
        int damage = pBulletInfo.force;
        if (pBullet.bull_13 > 1) {
            damage *= 2;
        }
        Sprites.DamageEnemy(nDest, nSource, damage);
        if (statnum > 90 && statnum < 199) {
            switch (statnum) {
                case 97: {
                    return;
                }
                case 98: 
                case 102: 
                case 141: 
                case 152: {
                    Anim.BuildAnim(-1, 12, 0, x, y, z, sectnum, 40, 0);
                    return;
                }
            }
            Anim.BuildAnim(-1, 39, 0, x, y, z, sectnum, 40, 0);
            if (pBullet.type <= 2) {
                return;
            }
            Anim.BuildAnim(-1, pBulletInfo.inf_C, 0, x, y, z, sectnum, 40, pBulletInfo.flags);
            return;
        }
        Anim.BuildAnim(-1, pBulletInfo.inf_C, 0, x, y, z, sectnum, 40, pBulletInfo.flags);
    }

    public static Vector2 BackUpBullet(int a1, int a2, int a3) {
        return tmpVec.set(a1 -= EngineUtils.sin(a3 + 512 & 0x7FF) >> 11, a2 -= EngineUtils.sin(a3 & 0x7FF) >> 11);
    }

    public static void SetBulletEnemy(int a1, int a2) {
        if (a1 >= 0) {
            Bullet.nBulletEnemy[a1] = a2;
        }
    }

    public static BulletStruct.BulletResult BuildBullet(int nSprite, int nType, int wz, int a6, int zAngle, int a8) {
        Sector sec;
        int spr;
        Sprite pSprite2;
        int v88;
        Sprite v11;
        BulletInfo pBullet = BulletInfo[nType];
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return bulletResult.setResult(-1, -1);
        }
        if (pBullet.inf_4 > 30000 && zAngle >= 10000 && (v11 = Main.boardService.getSprite(v88 = zAngle - 10000)) != null) {
            int i;
            Sprite spr2;
            if ((v11.getCstat() & 0x101) != 0 && Main.boardService.isValidSector(v11.getSectnum()) && (spr2 = Main.boardService.getSprite(i = Main.engine.insertsprite(pSprite.getSectnum(), 200))) != null) {
                spr2.setAng(a6);
                Bullet.tmpBullet.nSprite = i;
                Bullet.tmpBullet.type = nType;
                Bullet.tmpBullet.bull_13 = (byte)a8;
                Bullet.BulletHitsSprite(tmpBullet, nSprite, v88, v11.getX(), v11.getY(), v11.getZ() - (Sprites.GetSpriteHeight(v88) >> 1), v11.getSectnum());
                Main.engine.mydeletesprite(i);
                return bulletResult.setResult(-1, -1);
            }
            zAngle = v11.getCstat() & 0x101;
        }
        if (nBulletsFree == 0) {
            return bulletResult.setResult(-1, -1);
        }
        int v19 = pSprite.getSectnum();
        if (pSprite.getStatnum() == 100) {
            v19 = Globals.nPlayerViewSect[Player.GetPlayerFromSprite(nSprite)];
        }
        if ((pSprite2 = Main.boardService.getSprite(spr = Main.engine.insertsprite(v19, 200))) == null) {
            throw new AssertException("spr>=0 && spr<MAXSPRITES");
        }
        int v21 = Sprites.GetSpriteHeight(nSprite);
        if (wz == -1) {
            wz = -(v21 - (v21 >> 2));
        }
        pSprite2.setX(pSprite.getX());
        pSprite2.setY(pSprite.getY());
        pSprite2.setZ(pSprite.getZ());
        int nBullet = Bullet.GrabBullet();
        BulletStruct v35 = BulletList[nBullet];
        Bullet.nBulletEnemy[nBullet] = -1;
        pSprite2.setCstat(0);
        pSprite2.setShade(-64);
        if ((pBullet.flags & 4) != 0) {
            pSprite2.setPal(4);
        } else {
            pSprite2.setPal(0);
        }
        pSprite2.setClipdist(25);
        int v31 = pBullet.inf_12;
        if (v31 < 0) {
            v31 = 30;
        }
        pSprite2.setXrepeat(v31);
        pSprite2.setYrepeat(v31);
        pSprite2.setXoffset(0);
        pSprite2.setYoffset(0);
        pSprite2.setAng(a6);
        pSprite2.setXvel(0);
        pSprite2.setYvel(0);
        pSprite2.setZvel(0);
        pSprite2.setOwner(nSprite);
        pSprite2.setLotag(RunList.HeadRun() + 1);
        pSprite2.setExtra(-1);
        pSprite2.setHitag(0);
        v35.bull_10 = 0;
        v35.bull_E = pBullet.inf_2;
        v35.frmOffset = 0;
        if (pBullet.inf_8 == -1) {
            v35.bull_12 = 1;
            v35.baseSeq = pBullet.inf_A;
        } else {
            v35.bull_12 = 0;
            v35.baseSeq = pBullet.inf_8;
        }
        pSprite2.setPicnum(Seq.GetSeqPicnum(v35.baseSeq, 0, 0));
        if (v35.baseSeq == 31) {
            pSprite2.setCstat(pSprite2.getCstat() | 0x8000);
        }
        v35.zang = zAngle;
        v35.type = nType;
        v35.nSprite = spr;
        v35.bull_6 = RunList.AddRunRec(pSprite2.getLotag() - 1, 0xB0000 | nBullet);
        v35.bull_8 = RunList.AddRunRec(RunList.NewRun, 0xB0000 | nBullet);
        v35.bull_13 = (byte)a8;
        pSprite2.setZ(pSprite2.getZ() + wz);
        int sect = pSprite2.getSectnum();
        while ((sec = Main.boardService.getSector(sect)) != null && pSprite2.getZ() < sec.getCeilingz()) {
            if (Globals.SectAbove[sect] == -1) {
                pSprite2.setZ(sec.getCeilingz());
                break;
            }
            Main.engine.mychangespritesect(spr, Globals.SectAbove[sect]);
            sect = Globals.SectAbove[sect];
        }
        int zvec = 0;
        if (zAngle >= 10000) {
            int v89 = zAngle - 10000;
            if (pBullet.inf_4 > 30000) {
                Bullet.nBulletEnemy[nBullet] = v89;
            } else {
                int dy;
                int dx;
                int v51 = Sprites.GetSpriteHeight(v89);
                Sprite pSprite89 = Main.boardService.getSprite(v89);
                if (pSprite89 == null) {
                    return bulletResult.setResult(-1, nBullet);
                }
                int v53 = pSprite89.getStatnum() == 100 ? v51 >> 2 : v51 >> 1;
                int dz = pSprite89.getZ() - (v51 - v53);
                if (nSprite == -1 || pSprite.getStatnum() == 100) {
                    dx = pSprite89.getX() - pSprite2.getX();
                    dy = pSprite89.getY() - pSprite2.getY();
                } else {
                    int sx = pSprite89.getX();
                    int sy = pSprite89.getY();
                    if (pSprite89.getStatnum() == 100) {
                        int plr = Player.GetPlayerFromSprite(v89);
                        if (plr > -1) {
                            int pxvel = 15 * Globals.nPlayerDX[plr];
                            int pyvel = 15 * Globals.nPlayerDY[plr];
                            if (!Globals.isOriginal()) {
                                pxvel = Gameutils.BClipRange(pxvel, -1000, 1000);
                                pyvel = Gameutils.BClipRange(pyvel, -1000, 1000);
                            }
                            sx += pxvel;
                            sy += pyvel;
                        }
                    } else {
                        sx += 20 * pSprite89.getXvel() >> 6;
                        sy += 20 * pSprite89.getYvel() >> 6;
                    }
                    dy = sy - pSprite2.getY();
                    dx = sx - pSprite2.getX();
                    a6 = Main.engine.GetMyAngle(dx, dy);
                    pSprite.setAng(a6);
                }
                int v67 = EngineUtils.sqrt(dx * dx + dy * dy);
                if (v67 != 0) {
                    zvec = (dz - pSprite2.getZ()) * pBullet.inf_4 / v67;
                }
            }
        } else {
            zvec = Globals.isOriginal() ? pBullet.inf_4 * -EngineUtils.sin(zAngle & 0x7FF) >> 11 : -(zAngle / 32) * pBullet.inf_4;
        }
        int dist = 4 * pSprite.getClipdist();
        v35.xvec = dist * EngineUtils.sin(a6 + 512 & 0x7FF);
        v35.yvec = dist * EngineUtils.sin(a6 & 0x7FF);
        v35.zvec = 0;
        Bullet.nBulletEnemy[nBullet] = -1;
        if (Bullet.MoveBullet(nBullet)) {
            return bulletResult.setResult(-1, nBullet);
        }
        v35.bull_10 = pBullet.inf_4;
        v35.xvec = pBullet.inf_4 * (EngineUtils.sin(a6 + 512 & 0x7FF) >> 3);
        v35.yvec = pBullet.inf_4 * (EngineUtils.sin(a6 & 0x7FF) >> 3);
        v35.zvec = zvec >> 3;
        return bulletResult.setResult(spr, nBullet);
    }

    private static boolean MoveBullet(int nBullet) {
        Sector nextSector;
        Wall pHit;
        Sprite pEnemy;
        BulletStruct pBullet = BulletList[nBullet];
        int type = pBullet.type;
        BulletInfo pBulletInfo = BulletInfo[type];
        int nSprite = pBullet.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null || !Main.boardService.isValidSector(pSprite.getSectnum())) {
            return false;
        }
        int nSectFlag = Globals.SectFlag[pSprite.getSectnum()];
        int hitsec = -1;
        int hitwall = -1;
        int hitspr = -1;
        int hitx = 0;
        int hity = 0;
        int hitz = 0;
        if ((pBullet.bull_10 & 0xFFFF) >= 30000) {
            if (nBulletEnemy[nBullet] == -1) {
                int zvel = Globals.isOriginal() ? -8 * EngineUtils.sin(pBullet.zang & 0x7FF) : -16 * pBullet.zang * 32;
                Main.engine.hitscan(pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF), EngineUtils.sin(pSprite.getAng()), zvel, Engine.pHitInfo, 0x1000040);
                hitx = Engine.pHitInfo.hitx;
                hity = Engine.pHitInfo.hity;
                hitz = Engine.pHitInfo.hitz;
                hitsec = Engine.pHitInfo.hitsect;
                hitwall = Engine.pHitInfo.hitwall;
                hitspr = Engine.pHitInfo.hitsprite;
            } else {
                int nEnemy = nBulletEnemy[nBullet];
                pEnemy = Main.boardService.getSprite(nEnemy);
                if (pEnemy != null) {
                    hitx = pEnemy.getX();
                    hity = pEnemy.getY();
                    hitz = pEnemy.getZ() - (Sprites.GetSpriteHeight(nEnemy) >> 1);
                    hitsec = pEnemy.getSectnum();
                    hitspr = nEnemy;
                }
            }
            lasthitx = hitx;
            lasthity = hity;
            lasthitz = hitz;
            lasthitsect = hitsec;
            lasthitwall = hitwall;
            lasthitsprite = hitspr;
        } else {
            boolean out;
            int moveHit;
            int v9 = nBulletEnemy[nBullet];
            pEnemy = Main.boardService.getSprite(v9);
            if (pEnemy == null || (pEnemy.getCstat() & 0x101) == 0) {
                Bullet.nBulletEnemy[nBullet] = -1;
                if (type == 3) {
                    if (pBullet.bull_E >= 8) {
                        pSprite.setXrepeat(pSprite.getXrepeat() + 4);
                        pSprite.setYrepeat(pSprite.getYrepeat() + 4);
                    } else {
                        pSprite.setXrepeat(pSprite.getXrepeat() - 1);
                        pSprite.setYrepeat(pSprite.getYrepeat() + 8);
                        pBullet.zvec -= 200;
                        if (pSprite.getShade() < 90) {
                            pSprite.setShade(pSprite.getShade() + 35);
                        }
                        if (pBullet.bull_E == 3) {
                            pBullet.baseSeq = 45;
                            pBullet.frmOffset = 0;
                            pSprite.setXrepeat(40);
                            pSprite.setYrepeat(40);
                            pSprite.setShade(0);
                            pSprite.setZ(pSprite.getZ() + 512);
                        }
                    }
                }
                moveHit = Main.engine.movesprite(nSprite, pBullet.xvec, pBullet.yvec, pBullet.zvec, pSprite.getClipdist() >> 1, pSprite.getClipdist() >> 1, 1);
            } else {
                moveHit = Sprites.AngleChase(nSprite, v9, pBullet.bull_10 & 0xFFFF, 0, 16);
            }
            boolean bl = out = moveHit != 0;
            if (out) {
                hitx = pSprite.getX();
                hity = pSprite.getY();
                hitz = pSprite.getZ();
                hitsec = pSprite.getSectnum();
                if ((moveHit & 0x30000) != 0 || (moveHit & 0xE000) == 32768) {
                    hitwall = moveHit & 0x1FFF;
                } else if ((moveHit & 0xE000) == 49152) {
                    hitspr = moveHit & 0x1FFF;
                }
            }
            if (hitwall == -1 && hitspr == -1) {
                if (((nSectFlag ^ Globals.SectFlag[pSprite.getSectnum()]) >> 8 & 0x20) != 0) {
                    Bullet.DestroyBullet(nBullet);
                    out = true;
                }
                if (!out && type != 15 && type != 3) {
                    Light.AddFlash(pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 0);
                    if (pSprite.getPal() != 5) {
                        pSprite.setPal(1);
                    }
                }
                return out;
            }
        }
        if (hitspr != -1) {
            Sprite pHit2 = Main.boardService.getSprite(hitspr);
            if (pHit2 != null) {
                if (pSprite.getPal() != 5 || pHit2.getStatnum() != 100) {
                    Bullet.BulletHitsSprite(pBullet, pSprite.getOwner(), hitspr, hitx, hity, hitz, hitsec);
                } else {
                    int plr = Player.GetPlayerFromSprite(hitspr);
                    if (Globals.PlayerList[plr].mummified == 0) {
                        Globals.PlayerList[plr].mummified = 1;
                        Weapons.SetNewWeapon(plr, 7);
                    }
                }
            }
        } else if (hitwall != -1 && (pHit = Main.boardService.getWall(hitwall)) != null && pHit.getPicnum() == 3604 && (nextSector = Main.boardService.getSector(pHit.getNextsector())) != null) {
            int v31 = Bullet.BulletInfo[pBullet.type].force;
            if (pBullet.bull_13 > 1) {
                v31 *= 2;
            }
            Sprites.DamageEnemy(nextSector.getExtra(), Main.engine.GetWallNormal(hitwall) & 0x7FF, v31);
        }
        if (hitsec != -1) {
            if (hitwall != -1 || hitspr != -1) {
                if (hitwall == -1) {
                    pSprite.setX(hitx);
                    pSprite.setY(hity);
                    pSprite.setZ(hitz);
                    Main.engine.mychangespritesect(nSprite, hitsec);
                } else {
                    Vector2 vec = Bullet.BackUpBullet(hitx, hity, pSprite.getAng());
                    hitx = (int)vec.x;
                    hity = (int)vec.y;
                    if (type != 3 || Random.RandomSize(2) == 0) {
                        int v38 = Random.RandomSize(8);
                        int v37 = Random.RandomBit();
                        int v39 = 8 * v38;
                        if (v37 == 0) {
                            v39 = -v39;
                        }
                        Anim.BuildAnim(-1, pBulletInfo.inf_C, 0, hitx, hity, hitz + v39, hitsec, 40, pBulletInfo.flags);
                    }
                }
                if (pBulletInfo.inf_10 != 0) {
                    Globals.nRadialBullet = type;
                    Sprites.RadialDamageEnemy(nSprite, pBulletInfo.force, pBulletInfo.inf_10);
                    Globals.nRadialBullet = -1;
                    Light.AddFlash(pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 128);
                }
            } else if (Globals.SectBelow[hitsec] >= 0 && (Globals.SectFlag[Globals.SectBelow[hitsec]] & 0x2000) != 0 || Globals.SectDepth[hitsec] != 0) {
                pSprite.setX(hitx);
                pSprite.setY(hity);
                pSprite.setZ(hitz);
                Sprites.BuildSplash(pSprite, hitsec);
            } else {
                Anim.BuildAnim(-1, pBulletInfo.inf_C, 0, hitx, hity, hitz, hitsec, 40, pBulletInfo.flags);
            }
        }
        Bullet.DestroyBullet(nBullet);
        return true;
    }

    public static void FuncBullet(int nStack, int ignored, int RunPtr) {
        int nBullet = RunList.RunData[RunPtr].getObject();
        if (nBullet < 0 || nBullet >= 500) {
            throw new AssertException("nBullet>=0 && nBullet<MAX_BULLETS");
        }
        BulletStruct pBullet = BulletList[nBullet];
        int nSprite = pBullet.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        if ((nStack & 0x7F0000) == 131072) {
            int v17 = Seq.SeqOffsets[pBullet.baseSeq];
            int v8 = pBullet.frmOffset;
            Seq.MoveSequence(nSprite, v17, v8);
            if ((Seq.FrameFlag[v8 + Seq.SeqBase[v17]] & 0x80) != 0) {
                Anim.BuildAnim(-1, 45, 0, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), pSprite.getXrepeat(), 0);
            }
            ++pBullet.frmOffset;
            if (pBullet.frmOffset >= Seq.SeqSize[v17]) {
                if (pBullet.bull_12 == 0) {
                    pBullet.baseSeq = Bullet.BulletInfo[pBullet.type].inf_A;
                    pBullet.bull_12 = (byte)(pBullet.bull_12 + 1);
                }
                pBullet.frmOffset = 0;
            }
            if (pBullet.bull_E == -1 || --pBullet.bull_E != 0) {
                Bullet.MoveBullet(nBullet);
            } else {
                Bullet.DestroyBullet(nBullet);
            }
        } else if ((nStack & 0x7F0000) == 589824) {
            short spr = (short)(nStack & 0xFFFF);
            Renderer renderer = Main.game.getRenderer();
            RenderedSpriteList renderedSpriteList = renderer.getRenderedSprites();
            TSprite tsp = (TSprite)renderedSpriteList.get(spr);
            tsp.setStatnum(1000);
            if (pBullet.type == 15) {
                Seq.PlotArrowSequence(tsp, Seq.SeqOffsets[pBullet.baseSeq], pBullet.frmOffset);
            } else {
                Seq.PlotSequence(tsp, Seq.SeqOffsets[pBullet.baseSeq], pBullet.frmOffset, 0);
                tsp.setOwner(-1);
            }
        }
    }

    static {
        tmpVec = new Vector2();
        tmpBullet = new BulletStruct();
        bulletResult = new BulletStruct.BulletResult();
        BulletFree = new int[500];
        nBulletEnemy = new int[500];
        BulletList = new BulletStruct[500];
    }
}

