/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Rat {
    public static final int MAX_RAT = 50;
    private static final short[][] ActionSeq_X_14 = new short[][]{{0, 1}, {1, 0}, {1, 0}, {9, 1}, {0, 1}};
    private static int nRatCount;
    private static int nMinChunk;
    private static int nMaxChunk;
    private static final Enemy.EnemyStruct[] RatList;

    public static void InitRats() {
        nRatCount = 0;
        nMinChunk = 9999;
        nMaxChunk = -1;
        for (int i = 122; i <= 131; ++i) {
            int pic = Seq.GetSeqPicnum(25, i, 0);
            if (pic < nMinChunk) {
                nMinChunk = pic;
            }
            if (pic <= nMaxChunk) continue;
            nMaxChunk = pic;
        }
        Globals.nPlayerPic = Seq.GetSeqPicnum(25, 120, 0);
    }

    public static void saveRat(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, nRatCount);
        for (int i = 0; i < nRatCount; ++i) {
            RatList[i].save(os);
        }
        StreamUtils.writeInt(os, nMinChunk);
        StreamUtils.writeInt(os, nMaxChunk);
        StreamUtils.writeInt(os, Globals.nPlayerPic);
    }

    public static void loadRat(SafeLoader loader) {
        nRatCount = loader.nRatCount;
        for (int i = 0; i < loader.nRatCount; ++i) {
            if (RatList[i] == null) {
                Rat.RatList[i] = new Enemy.EnemyStruct();
            }
            RatList[i].copy(loader.RatList[i]);
        }
        nMinChunk = loader.nMinChunk;
        nMaxChunk = loader.nMaxChunk;
        Globals.nPlayerPic = loader.nPlayerPic;
    }

    public static void loadRat(SafeLoader loader, InputStream is) throws IOException {
        loader.nRatCount = StreamUtils.readShort(is);
        for (int i = 0; i < loader.nRatCount; ++i) {
            if (loader.RatList[i] == null) {
                loader.RatList[i] = new Enemy.EnemyStruct();
            }
            loader.RatList[i].load(is);
        }
        loader.nMinChunk = StreamUtils.readInt(is);
        loader.nMaxChunk = StreamUtils.readInt(is);
        loader.nPlayerPic = StreamUtils.readInt(is);
    }

    public static void SetRatVel(int nSprite) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite != null) {
            pSprite.setXvel(EngineUtils.cos(pSprite.getAng() & 0x7FF) >> 2);
            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 2);
        }
    }

    public static void BuildRat(int spr, int x, int y, int z, int sectnum, int ang) {
        Sector sec;
        if (nRatCount >= 50) {
            return;
        }
        int count = nRatCount++;
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            spr = Main.engine.insertsprite(sectnum, 108);
            pSprite = Main.boardService.getSprite(spr);
            if (pSprite == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
        } else {
            x = pSprite.getX();
            y = pSprite.getY();
            z = pSprite.getZ();
            ang = pSprite.getAng();
            Main.engine.changespritestat(spr, 108);
        }
        if ((sec = Main.boardService.getSector(pSprite.getSectnum())) == null) {
            return;
        }
        pSprite.setX(x);
        pSprite.setY(y);
        pSprite.setZ(z);
        pSprite.setShade(-12);
        pSprite.setCstat(257);
        pSprite.setClipdist(30);
        pSprite.setXrepeat(50);
        pSprite.setYrepeat(50);
        pSprite.setPal(sec.getCeilingpal());
        pSprite.setXoffset(0);
        pSprite.setYoffset(0);
        pSprite.setPicnum(1);
        pSprite.setAng(ang);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setHitag(0);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setExtra(-1);
        if (RatList[count] == null) {
            Rat.RatList[count] = new Enemy.EnemyStruct();
        }
        Rat.RatList[count].nState = ang >= 0 ? 2 : 4;
        Rat.RatList[count].nSeq = 0;
        Rat.RatList[count].nSprite = spr;
        Rat.RatList[count].nTarget = -1;
        Rat.RatList[count].field_A = Random.RandomSize(5);
        Rat.RatList[count].field_C = Random.RandomSize(3);
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0x240000 | count));
        Rat.RatList[count].nFunc = RunList.AddRunRec(RunList.NewRun, 0x240000 | count);
    }

    public static int FindFood(int spr) {
        int bodySpriteIndex;
        int bodySpriteId;
        Sprite bodySprite;
        int chunkSpriteIndex;
        int chunkSpriteId;
        Sprite chunkSprite;
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            return -1;
        }
        Sector sec = Main.boardService.getSector(pSprite.getSectnum());
        if (sec == null) {
            return -1;
        }
        short sectnum = pSprite.getSectnum();
        int sx = pSprite.getX();
        int sy = pSprite.getY();
        int sz = (sec.getCeilingz() + pSprite.getZ()) / 2;
        if (Sprites.nChunkTotal != 0 && (chunkSprite = Main.boardService.getSprite(chunkSpriteId = Sprites.nChunkSprite[chunkSpriteIndex = Random.RandomSize(7) % Sprites.nChunkTotal])) != null && Main.engine.cansee(sx, sy, sz, sectnum, chunkSprite.getX(), chunkSprite.getY(), chunkSprite.getZ(), chunkSprite.getSectnum())) {
            return chunkSpriteId;
        }
        if (Sprites.nBodyTotal != 0 && (bodySprite = Main.boardService.getSprite(bodySpriteId = Sprites.nBodySprite[bodySpriteIndex = Random.RandomSize(7) % Sprites.nBodyTotal])) != null && Globals.nPlayerPic == bodySprite.getPicnum() && Main.engine.cansee(sx, sy, pSprite.getZ(), pSprite.getSectnum(), bodySprite.getX(), bodySprite.getY(), bodySprite.getZ(), bodySprite.getSectnum())) {
            return bodySpriteId;
        }
        return -1;
    }

    public static void FuncRat(int nStack, int a2, int RunPtr) {
        int nRat = RunList.RunData[RunPtr].getObject();
        int nSprite = Rat.RatList[nRat].nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int nState = Rat.RatList[nRat].nState;
        short plr = (short)(nStack & 0xFFFF);
        int damage = a2;
        switch (nStack & 0x7F0000) {
            case 131072: {
                boolean v51 = false;
                int v10 = ActionSeq_X_14[nState][0] + Seq.SeqOffsets[77];
                int v13 = Rat.RatList[nRat].nSeq++;
                pSprite.setPicnum(Seq.GetSeqPicnum2(v10, v13));
                Seq.MoveSequence(nSprite, v10, v13);
                if (Rat.RatList[nRat].nSeq >= Seq.SeqSize[v10]) {
                    Rat.RatList[nRat].nSeq = 0;
                    v51 = true;
                }
                Sprites.Gravity(nSprite);
                switch (nState) {
                    case 2: {
                        if ((pSprite.getYvel() | pSprite.getXvel() | pSprite.getZvel()) != 0) {
                            if (Globals.isOriginal()) {
                                Enemy.MoveCreature(nSprite);
                            } else {
                                Enemy.MoveCreatureWithCaution(nSprite);
                            }
                        }
                        --Rat.RatList[nRat].field_A;
                        if (Rat.RatList[nRat].field_A > 0) break;
                        Rat.RatList[nRat].nTarget = Rat.FindFood(nSprite);
                        Sprite pTarget = Main.boardService.getSprite(Rat.RatList[nRat].nTarget);
                        if (pTarget != null) {
                            Enemy.PlotCourseToSprite(nSprite, Rat.RatList[nRat].nTarget);
                            Rat.SetRatVel(nSprite);
                            Rat.RatList[nRat].nState = 1;
                            Rat.RatList[nRat].field_C = 900;
                            Rat.RatList[nRat].nSeq = 0;
                            break;
                        }
                        Rat.RatList[nRat].field_A = Random.RandomSize(6);
                        if ((pSprite.getXvel() | pSprite.getYvel()) != 0) {
                            pSprite.setXvel(0);
                            pSprite.setYvel(0);
                            break;
                        }
                        pSprite.setAng(Random.RandomSize(11));
                        Rat.SetRatVel(nSprite);
                        break;
                    }
                    case 1: {
                        if (--Rat.RatList[nRat].field_C <= 0) {
                            Rat.RatList[nRat].nState = 2;
                            Rat.RatList[nRat].nSeq = 0;
                            Rat.RatList[nRat].nTarget = -1;
                            pSprite.setXvel(0);
                            pSprite.setYvel(0);
                        }
                        if (Globals.isOriginal()) {
                            Enemy.MoveCreature(nSprite);
                        } else {
                            Enemy.MoveCreatureWithCaution(nSprite);
                        }
                        Sprite pTarget = Main.boardService.getSprite(Rat.RatList[nRat].nTarget);
                        if (pTarget != null && (Pragmas.klabs(pSprite.getX() - pTarget.getX()) >= 50 || Pragmas.klabs(pSprite.getY() - pTarget.getY()) >= 50)) {
                            if (--Rat.RatList[nRat].field_A >= 0) break;
                            Enemy.PlotCourseToSprite(nSprite, Rat.RatList[nRat].nTarget);
                            Rat.SetRatVel(nSprite);
                            Rat.RatList[nRat].field_A = 32;
                            break;
                        }
                        Rat.RatList[nRat].nState = 0;
                        Rat.RatList[nRat].nSeq = 0;
                        Rat.RatList[nRat].field_C = Random.RandomSize(3);
                        pSprite.setXvel(0);
                        pSprite.setYvel(0);
                        break;
                    }
                    case 0: {
                        if (--Rat.RatList[nRat].field_A > 0) break;
                        Sprite pTarget = Main.boardService.getSprite(Rat.RatList[nRat].nTarget);
                        if (pTarget != null && Pragmas.klabs(pSprite.getX() - pTarget.getX()) <= 50 && Pragmas.klabs(pSprite.getY() - pTarget.getY()) <= 50) {
                            int v44;
                            Rat.RatList[nRat].nSeq ^= 1;
                            Rat.RatList[nRat].field_A = Random.RandomSize(5) + 4;
                            if (--Rat.RatList[nRat].field_C > 0 || (v44 = Rat.FindFood(nSprite)) == -1) break;
                            Rat.RatList[nRat].nTarget = v44;
                            Enemy.PlotCourseToSprite(nSprite, v44);
                            Rat.SetRatVel(nSprite);
                            Rat.RatList[nRat].nState = 1;
                            Rat.RatList[nRat].field_C = 900;
                            Rat.RatList[nRat].nSeq = 0;
                            break;
                        }
                        Rat.RatList[nRat].nState = 2;
                        Rat.RatList[nRat].nSeq = 0;
                        Rat.RatList[nRat].nTarget = -1;
                        pSprite.setXvel(0);
                        pSprite.setYvel(0);
                        break;
                    }
                    case 3: {
                        if (!v51) break;
                        RunList.DoSubRunRec(pSprite.getOwner());
                        RunList.FreeRun(pSprite.getLotag() - 1);
                        RunList.SubRunRec(Rat.RatList[nRat].nFunc);
                        pSprite.setCstat(32768);
                        Main.engine.mydeletesprite(nSprite);
                    }
                }
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get(plr);
                Seq.PlotSequence(tsp, ActionSeq_X_14[nState][0] + Seq.SeqOffsets[77], Rat.RatList[nRat].nSeq, ActionSeq_X_14[nState][1]);
                return;
            }
            case 655360: {
                damage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (damage == 0) break;
                pSprite.setCstat(0);
                pSprite.setXvel(0);
                pSprite.setYvel(0);
                Rat.RatList[nRat].nSeq = 0;
                Rat.RatList[nRat].nState = 3;
            }
        }
    }

    static {
        RatList = new Enemy.EnemyStruct[50];
    }
}

