/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Rex {
    public static final int MAX_REX = 50;
    private static final int[][] ActionSeq_X_8 = new int[][]{{29, 0}, {0, 0}, {0, 0}, {37, 0}, {9, 0}, {18, 0}, {27, 1}, {28, 1}};
    private static int RexCount;
    private static final Enemy.EnemyStruct[] RexList;
    private static final int[] RexChan;

    public static void InitRexs() {
        RexCount = 50;
    }

    public static void saveRex(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, RexCount);
        for (i = RexCount; i < 50; ++i) {
            RexList[i].save(os);
        }
        for (i = 0; i < 50; ++i) {
            StreamUtils.writeShort(os, RexChan[i]);
        }
    }

    public static void loadRex(SafeLoader loader) {
        RexCount = loader.RexCount;
        for (int i = loader.RexCount; i < 50; ++i) {
            if (RexList[i] == null) {
                Rex.RexList[i] = new Enemy.EnemyStruct();
            }
            RexList[i].copy(loader.RexList[i]);
        }
        System.arraycopy(loader.RexChan, 0, RexChan, 0, 50);
    }

    public static void loadRex(SafeLoader loader, InputStream is) throws IOException {
        int i;
        for (i = loader.RexCount = (int)StreamUtils.readShort(is); i < 50; ++i) {
            if (loader.RexList[i] == null) {
                loader.RexList[i] = new Enemy.EnemyStruct();
            }
            loader.RexList[i].load(is);
        }
        for (i = 0; i < 50; ++i) {
            loader.RexChan[i] = StreamUtils.readShort(is);
        }
    }

    public static void BuildRex(int spr, int x, int y, int z, int sectnum, int ang, int channel) {
        Sector sec;
        int count;
        if ((count = --RexCount) < 0) {
            return;
        }
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            spr = Main.engine.insertsprite(sectnum, 119);
            pSprite = Main.boardService.getSprite(spr);
            if (pSprite == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
        } else {
            sec = Main.boardService.getSector(pSprite.getSectnum());
            if (sec != null) {
                x = pSprite.getX();
                y = pSprite.getY();
                z = sec.getFloorz();
            }
            ang = pSprite.getAng();
            Main.engine.changespritestat(spr, 119);
        }
        if ((sec = Main.boardService.getSector(pSprite.getSectnum())) == null) {
            return;
        }
        pSprite.setX(x);
        pSprite.setY(y);
        pSprite.setZ(z);
        pSprite.setCstat(257);
        pSprite.setXoffset(0);
        pSprite.setShade(-12);
        pSprite.setYoffset(0);
        pSprite.setPicnum(1);
        pSprite.setPal(sec.getCeilingpal());
        pSprite.setClipdist(80);
        pSprite.setAng(ang);
        pSprite.setXrepeat(64);
        pSprite.setYrepeat(64);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setHitag(0);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setExtra(-1);
        if (RexList[count] == null) {
            Rex.RexList[count] = new Enemy.EnemyStruct();
        }
        Rex.RexList[count].nState = 0;
        Rex.RexList[count].nHealth = 4000;
        Rex.RexList[count].nSeq = 0;
        Rex.RexList[count].nSprite = spr;
        Rex.RexList[count].nTarget = -1;
        Rex.RexList[count].field_A = 0;
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0x180000 | count));
        RunList.AddRunRec(RunList.NewRun, 0x180000 | count);
        Rex.RexChan[count] = channel;
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void FuncRex(int nStack, int nDamage, int RunPtr) {
        int nRex = RunList.RunData[RunPtr].getObject();
        if (nRex < 0 || nRex >= 50) {
            throw new AssertException("rex>=0 && rex<MAX_REX");
        }
        Enemy.EnemyStruct pRex = RexList[nRex];
        int nSprite = pRex.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int nState = pRex.nState;
        boolean v67 = false;
        short nObject = (short)(nStack & 0xFFFF);
        switch (nStack & 0x7F0000) {
            case 131072: {
                Sprites.Gravity(nSprite);
                int nSeq = ActionSeq_X_8[nState][0] + Seq.SeqOffsets[47];
                pSprite.setPicnum(Seq.GetSeqPicnum2(nSeq, pRex.nSeq));
                int loops = 1;
                if (nState == 2) {
                    loops = 2;
                }
                for (int i = 0; i < loops; ++i) {
                    Seq.MoveSequence(nSprite, nSeq, pRex.nSeq);
                    if (++pRex.nSeq < Seq.SeqSize[nSeq]) continue;
                    pRex.nSeq = 0;
                    v67 = true;
                }
                int nFlags = Seq.FrameFlag[pRex.nSeq + Seq.SeqBase[nSeq]];
                block6 : switch (nState) {
                    case 0: {
                        if (pRex.field_A != 0) {
                            if (--pRex.field_A <= 0) {
                                pRex.nState = 1;
                                pRex.nSeq = 0;
                                pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 2);
                                pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 2);
                                Sound.D3PlayFX(Sound.StaticSound[48], nSprite);
                                pRex.field_A = 30;
                            }
                        } else if ((nRex & 0x1F) == (Globals.totalmoves & 0x1F)) {
                            Sprite pTarget = Main.boardService.getSprite(pRex.nTarget);
                            if (pTarget != null) {
                                pRex.field_A = 60;
                            } else {
                                short v17 = pSprite.getAng();
                                pRex.nTarget = Enemy.FindPlayer(nSprite, 60);
                                pSprite.setAng(v17);
                            }
                        }
                        return;
                    }
                    case 2: {
                        if (--pRex.field_A > 0) {
                            Enemy.PlotCourseToSprite(nSprite, pRex.nTarget);
                            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 1);
                            pSprite.setYvel(EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 1);
                            int hitMove = Enemy.MoveCreatureWithCaution(nSprite);
                            switch (hitMove & 0xE000) {
                                case 32768: {
                                    Object.SetQuake(nSprite, 25);
                                    pRex.field_A = 60;
                                    break block6;
                                }
                                case 49152: {
                                    pRex.nState = 3;
                                    pRex.nSeq = 0;
                                    int spr = hitMove & 0x1FFF;
                                    Sprite hitSpr = Main.boardService.getSprite(spr);
                                    if (hitSpr != null && hitSpr.getStatnum() != 0 && hitSpr.getStatnum() < 107) {
                                        Sprites.DamageEnemy(spr, nSprite, 15);
                                        int xvel = 15 * EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF);
                                        int yvel = 15 * EngineUtils.sin(pSprite.getAng() & 0x7FF);
                                        if (hitSpr.getStatnum() == 100) {
                                            int v32;
                                            int n = v32 = Player.GetPlayerFromSprite(spr);
                                            Globals.nXDamage[n] = Globals.nXDamage[n] + 16 * xvel;
                                            int n2 = v32;
                                            Globals.nYDamage[n2] = Globals.nYDamage[n2] + 16 * yvel;
                                            hitSpr.setZvel(-3584);
                                        } else {
                                            hitSpr.setXvel(hitSpr.getXvel() + (xvel >> 3));
                                            hitSpr.setYvel(hitSpr.getYvel() + (yvel >> 3));
                                            hitSpr.setZvel(-2880);
                                        }
                                    }
                                    pRex.field_A >>= 2;
                                    return;
                                }
                            }
                            return;
                        }
                        pRex.nState = 1;
                        pRex.nSeq = 0;
                        pRex.field_A = 90;
                        return;
                    }
                    case 3: {
                        if (v67) {
                            pRex.nState = 2;
                        }
                        return;
                    }
                    case 1: {
                        if (pRex.field_A > 0) {
                            --pRex.field_A;
                        }
                        if ((Globals.totalmoves & 0xF) == (nRex & 0xF)) {
                            if (Random.RandomSize(1) == 0) {
                                pRex.nState = 5;
                                pRex.nSeq = 0;
                                pSprite.setXvel(0);
                                pSprite.setYvel(0);
                                return;
                            }
                            if (Enemy.PlotCourseToSprite(nSprite, pRex.nTarget) >> 8 < 60 && pRex.field_A <= 0) {
                                pRex.nState = 2;
                                pRex.field_A = 240;
                                Sound.D3PlayFX(Sound.StaticSound[48], nSprite);
                                pRex.nSeq = 0;
                                return;
                            }
                            pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 2);
                            pSprite.setYvel(EngineUtils.sin(pSprite.getAng()) >> 2);
                        }
                        int hitMove = Enemy.MoveCreatureWithCaution(nSprite);
                        switch (hitMove & 0xE000) {
                            case 32768: {
                                break block6;
                            }
                            case 49152: {
                                if ((hitMove & 0x1FFF) != pRex.nTarget) break block6;
                                Enemy.PlotCourseToSprite(nSprite, pRex.nTarget);
                                pRex.nState = 4;
                                pRex.nSeq = 0;
                                Rex.checkTarget(pRex, nState);
                                return;
                            }
                            default: {
                                Rex.checkTarget(pRex, nState);
                                return;
                            }
                        }
                    }
                    case 5: {
                        if (v67) {
                            pRex.nState = 1;
                            pRex.field_A = 15;
                        }
                        return;
                    }
                    case 4: {
                        if (pRex.nTarget == -1 || Enemy.PlotCourseToSprite(nSprite, pRex.nTarget) >= 768) {
                            pRex.nState = 1;
                        } else if ((nFlags & 0x80) != 0) {
                            Sprites.DamageEnemy(pRex.nTarget, nSprite, 15);
                        }
                        Rex.checkTarget(pRex, nState);
                        return;
                    }
                    case 6: {
                        if (v67) {
                            pRex.nState = 7;
                            RunList.ChangeChannel(RexChan[nRex], 1);
                        }
                        return;
                    }
                    case 7: {
                        pSprite.setCstat(pSprite.getCstat() & 0xFEFE);
                        return;
                    }
                    default: {
                        return;
                    }
                }
                pSprite.setAng(pSprite.getAng() + 256 & 0x7FF);
                pSprite.setXvel(EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 2);
                pSprite.setYvel(EngineUtils.sin(pSprite.getAng()) >> 2);
                pRex.nState = 1;
                nState = 1;
                pRex.nSeq = 0;
                break;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get(nObject);
                Seq.PlotSequence(tsp, ActionSeq_X_8[nState][0] + Seq.SeqOffsets[47], pRex.nSeq, ActionSeq_X_8[nState][1]);
                return;
            }
            case 655360: {
                if (nState == 5) {
                    nDamage = Sprites.CheckRadialDamage(nSprite);
                }
            }
            case 524288: {
                if (nDamage != 0 && pRex.nState == 5 && pRex.nHealth > 0) {
                    pRex.nHealth -= nDamage;
                    if (pRex.nHealth <= 0) {
                        pSprite.setXvel(0);
                        pSprite.setYvel(0);
                        pSprite.setZvel(0);
                        pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                        pRex.nHealth = 0;
                        --Globals.nCreaturesLeft;
                        if (pRex.nState < 6) {
                            pRex.nState = 6;
                            pRex.nSeq = 0;
                        }
                    }
                }
                return;
            }
        }
        Rex.checkTarget(pRex, nState);
    }

    private static void checkTarget(Enemy.EnemyStruct pRex, int nState) {
        Sprite pTarget = Main.boardService.getSprite(pRex.nTarget);
        int nSprite = pRex.nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        if (nState > 0 && pTarget != null && (pTarget.getCstat() & 0x101) == 0) {
            pRex.nState = 0;
            pRex.nSeq = 0;
            pRex.field_A = 0;
            pRex.nTarget = -1;
            pSprite.setXvel(0);
            pSprite.setYvel(0);
        }
    }

    static {
        RexList = new Enemy.EnemyStruct[50];
        RexChan = new int[50];
    }
}

